/* Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @file  ap_config_layout.h
 * @brief Apache Config Layout
 */

#ifndef AP_CONFIG_LAYOUT_H
#define AP_CONFIG_LAYOUT_H

/* Configured Apache directory layout */
#define DEFAULT_PREFIX "/2022Q2"
#define DEFAULT_EXP_EXEC_PREFIX "/2022Q2"
#define DEFAULT_REL_EXEC_PREFIX ""
#define DEFAULT_EXP_BINDIR "/2022Q2/bin"
#define DEFAULT_REL_BINDIR "bin"
#define DEFAULT_EXP_SBINDIR "/2022Q2/sbin"
#define DEFAULT_REL_SBINDIR "sbin"
#define DEFAULT_EXP_LIBEXECDIR "/2022Q2/lib/httpd"
#define DEFAULT_REL_LIBEXECDIR "lib/httpd"
#define DEFAULT_EXP_MANDIR "/2022Q2/man"
#define DEFAULT_REL_MANDIR "man"
#define DEFAULT_EXP_SYSCONFDIR "/2022Q2/etc/httpd"
#define DEFAULT_REL_SYSCONFDIR "etc/httpd"
#define DEFAULT_EXP_DATADIR "/2022Q2/share/httpd"
#define DEFAULT_REL_DATADIR "share/httpd"
#define DEFAULT_EXP_INSTALLBUILDDIR "/2022Q2/share/httpd/build"
#define DEFAULT_REL_INSTALLBUILDDIR "share/httpd/build"
#define DEFAULT_EXP_ERRORDIR "/2022Q2/share/httpd/error"
#define DEFAULT_REL_ERRORDIR "share/httpd/error"
#define DEFAULT_EXP_ICONSDIR "/2022Q2/share/httpd/icons"
#define DEFAULT_REL_ICONSDIR "share/httpd/icons"
#define DEFAULT_EXP_HTDOCSDIR "/2022Q2/share/httpd/htdocs"
#define DEFAULT_REL_HTDOCSDIR "share/httpd/htdocs"
#define DEFAULT_EXP_MANUALDIR "/2022Q2/share/httpd/manual"
#define DEFAULT_REL_MANUALDIR "share/httpd/manual"
#define DEFAULT_EXP_CGIDIR "/2022Q2/libexec/cgi-bin"
#define DEFAULT_REL_CGIDIR "libexec/cgi-bin"
#define DEFAULT_EXP_INCLUDEDIR "/2022Q2/include/httpd"
#define DEFAULT_REL_INCLUDEDIR "include/httpd"
#define DEFAULT_EXP_LOCALSTATEDIR "/2022Q2/var"
#define DEFAULT_REL_LOCALSTATEDIR "var"
#define DEFAULT_EXP_RUNTIMEDIR "/2022Q2/var/run"
#define DEFAULT_REL_RUNTIMEDIR "var/run"
#define DEFAULT_EXP_LOGFILEDIR "/2022Q2/var/log/httpd"
#define DEFAULT_REL_LOGFILEDIR "var/log/httpd"
#define DEFAULT_EXP_PROXYCACHEDIR "/2022Q2/var/db/httpd/proxy"
#define DEFAULT_REL_PROXYCACHEDIR "var/db/httpd/proxy"

#endif /* AP_CONFIG_LAYOUT_H */
