/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtp;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sf.gogui.gtp.GtpCommand;
import net.sf.gogui.gtp.GtpEngine;
import net.sf.gogui.util.StringUtil;

class ReadThread
extends Thread {
    private boolean m_endOfFile;
    private final boolean m_log;
    private boolean m_waitCommand;
    private final BufferedReader m_in;
    private GtpCommand m_command;
    private final GtpEngine m_server;

    public ReadThread(GtpEngine server, InputStream in, boolean log) {
        this.m_in = new BufferedReader(new InputStreamReader(in));
        this.m_server = server;
        this.m_log = log;
    }

    public synchronized boolean endOfFile() {
        return this.m_endOfFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GtpCommand getCommand() {
        ReadThread readThread = this;
        synchronized (readThread) {
            assert (!this.m_waitCommand);
            this.m_waitCommand = true;
            this.notifyAll();
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                System.err.println("Interrupted");
            }
            assert (this.m_endOfFile || !this.m_waitCommand);
            GtpCommand result = this.m_command;
            this.m_command = null;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                ReadThread readThread;
                String line;
                if ((line = this.m_in.readLine()) == null) {
                    readThread = this;
                    synchronized (readThread) {
                        this.m_endOfFile = true;
                    }
                } else {
                    if (this.m_log) {
                        this.m_server.log(line);
                    }
                    if ((line = line.trim()).equals("# interrupt")) {
                        this.m_server.interruptCommand();
                    }
                    if (line.equals("") || line.charAt(0) == '#') continue;
                }
                readThread = this;
                synchronized (readThread) {
                    while (!this.m_waitCommand) {
                        this.wait();
                    }
                    this.m_command = line == null ? null : new GtpCommand(line);
                    this.notifyAll();
                    this.m_waitCommand = false;
                    if (this.m_command == null || this.m_command.isQuit()) {
                        return;
                    }
                }
            }
        }
        catch (Throwable e) {
            StringUtil.printException(e);
            return;
        }
    }
}

