/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.game;

import java.text.DecimalFormat;
import java.util.Calendar;
import net.sf.gogui.game.ConstGameInfo;
import net.sf.gogui.game.ConstGameTree;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.GameInfo;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.NodeUtil;
import net.sf.gogui.game.StringInfo;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.Komi;

public class GameTree
implements ConstGameTree {
    private final int m_boardSize;
    private final Node m_root;

    public GameTree() {
        this.m_boardSize = 19;
        this.m_root = new Node();
        this.m_root.createGameInfo();
        this.setDate();
    }

    public GameTree(int boardSize, Komi komi, ConstPointList handicap, String rules, TimeSettings timeSettings) {
        this.m_boardSize = boardSize;
        this.m_root = new Node();
        GameInfo info = this.m_root.createGameInfo();
        this.setDate();
        info.setKomi(komi);
        info.set(StringInfo.RULES, rules);
        if (timeSettings != null) {
            info.setTimeSettings(timeSettings);
        }
        if (handicap != null) {
            info.setHandicap(handicap.size());
            if (handicap.size() > 0) {
                this.m_root.addStones(GoColor.BLACK, handicap);
                this.m_root.setPlayer(GoColor.WHITE);
            }
        }
    }

    public GameTree(int boardSize, Node root) {
        this.m_boardSize = boardSize;
        root.createGameInfo();
        this.m_root = root;
    }

    public int getBoardSize() {
        return this.m_boardSize;
    }

    public GameInfo getGameInfo(ConstNode node) {
        assert (NodeUtil.getRoot(node) == this.getRoot());
        return this.getGameInfoNode(node).getGameInfo();
    }

    public Node getGameInfoNode(ConstNode node) {
        assert (NodeUtil.getRoot(node) == this.getRoot());
        while (node.getGameInfoConst() == null) {
            node = node.getFatherConst();
        }
        return (Node)node;
    }

    public ConstGameInfo getGameInfoConst(ConstNode node) {
        return this.getGameInfo((Node)node);
    }

    public Node getNode(ConstNode node) {
        assert (NodeUtil.getRoot(node) == this.getRoot());
        return (Node)node;
    }

    public Node getRoot() {
        return this.m_root;
    }

    public ConstNode getRootConst() {
        return this.m_root;
    }

    public boolean hasVariations() {
        for (ConstNode node = this.m_root; node != null; node = node.getChildConst()) {
            if (node.getNumberChildren() <= 1) continue;
            return true;
        }
        return false;
    }

    public void keepOnlyMainVariation() {
        for (Node node = this.m_root; node != null; node = node.getChild()) {
            node.removeVariations();
        }
    }

    private void setDate() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        DecimalFormat format = new DecimalFormat("00");
        GameInfo info = this.m_root.getGameInfo();
        info.set(StringInfo.DATE, Integer.toString(year) + "-" + format.format(month) + "-" + format.format(day));
    }
}

