/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.boardpainter;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class RadialGradientContext
implements PaintContext {
    private final int m_red1;
    private final int m_redDiff;
    private final int m_green1;
    private final int m_greenDiff;
    private final int m_blue1;
    private final int m_blueDiff;
    private final int m_alpha1;
    private final int m_alphaDiff;
    private int m_x;
    private int m_y;
    private int m_height;
    private int m_width;
    private final double m_length1;
    private final double m_length2;
    private final double m_focus;
    private final Point2D m_center;
    private final Point2D m_radius1;
    private final Point2D m_radius2;
    private WritableRaster m_raster;

    public RadialGradientContext(Point2D center, Point2D radius1, Point2D radius2, double focus, Color color1, Color color2) {
        this.m_center = center;
        this.m_radius1 = radius1;
        this.m_radius2 = radius2;
        this.m_length1 = radius1.distance(0.0, 0.0);
        this.m_length2 = radius2.distance(0.0, 0.0);
        this.m_focus = focus;
        this.m_red1 = color1.getRed();
        this.m_green1 = color1.getGreen();
        this.m_blue1 = color1.getBlue();
        this.m_alpha1 = color1.getAlpha();
        this.m_redDiff = color2.getRed() - this.m_red1;
        this.m_greenDiff = color2.getGreen() - this.m_green1;
        this.m_blueDiff = color2.getBlue() - this.m_blue1;
        this.m_alphaDiff = color2.getAlpha() - this.m_alpha1;
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public Raster getRaster(int x, int y, int width, int height) {
        if (this.m_raster != null && x == this.m_x && y == this.m_y && width == this.m_width && height == this.m_height) {
            return this.m_raster;
        }
        this.m_x = x;
        this.m_y = y;
        this.m_height = height;
        this.m_width = width;
        ColorModel colorModel = this.getColorModel();
        this.m_raster = colorModel.createCompatibleWritableRaster(width, height);
        int[] data = new int[width * height * 4];
        int index = -1;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                Point2D.Double p = new Point2D.Double(x + i, y + j);
                Point2D d = RadialGradientContext.getDifference(p, this.m_center);
                double distance1 = RadialGradientContext.getScalarProduct(d, this.m_radius1) / this.m_length1;
                double ratio1 = Math.abs(distance1) / this.m_length1;
                double distance2 = RadialGradientContext.getScalarProduct(d, this.m_radius2) / this.m_length2;
                double ratio2 = distance2 / this.m_length2;
                ratio2 = ratio2 > this.m_focus ? (ratio2 - this.m_focus) / (1.0 - this.m_focus) : (ratio2 - this.m_focus) / (-1.0 - this.m_focus);
                double ratio = Math.sqrt(ratio1 * ratio1 + ratio2 * ratio2);
                ratio = Math.min(ratio, 1.0);
                data[++index] = (int)((double)this.m_red1 + ratio * (double)this.m_redDiff);
                data[++index] = (int)((double)this.m_green1 + ratio * (double)this.m_greenDiff);
                data[++index] = (int)((double)this.m_blue1 + ratio * (double)this.m_blueDiff);
                data[++index] = (int)((double)this.m_alpha1 + ratio * (double)this.m_alphaDiff);
            }
        }
        this.m_raster.setPixels(0, 0, width, height, data);
        return this.m_raster;
    }

    private static Point2D getDifference(Point2D p1, Point2D p2) {
        return new Point2D.Double(p1.getX() - p2.getX(), p1.getY() - p2.getY());
    }

    private static double getScalarProduct(Point2D p1, Point2D p2) {
        return p1.getX() * p2.getX() + p1.getY() * p2.getY();
    }
}

