/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gamefile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.gamefile.GameFile;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.util.ErrorMessage;
import net.sf.gogui.util.FileUtil;
import net.sf.gogui.util.ProgressShow;
import net.sf.gogui.xml.XmlReader;

public class GameReader {
    private GameFile m_gameFile = new GameFile();
    private String m_warnings;
    private GameTree m_tree;

    public GameReader(File file, ProgressShow progressShow) throws ErrorMessage {
        FileInputStream in;
        GameFile.Format format = GameReader.detectFormat(file);
        this.m_gameFile.m_file = file;
        this.m_gameFile.m_format = format;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ErrorMessage("File \"" + file + "\" not found");
        }
        switch (format) {
            case XML: {
                XmlReader reader = new XmlReader(in, progressShow, file.length());
                this.m_tree = reader.getTree();
                this.m_warnings = reader.getWarnings();
                break;
            }
            case SGF: {
                SgfReader reader = new SgfReader(in, file, progressShow, file.length());
                this.m_tree = reader.getTree();
                this.m_warnings = reader.getWarnings();
            }
        }
    }

    public GameReader(File file) throws ErrorMessage {
        this(file, null);
    }

    public GameFile getFile() {
        return this.m_gameFile;
    }

    public GameTree getTree() {
        return this.m_tree;
    }

    public String getWarnings() {
        return this.m_warnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GameFile.Format detectFormat(File file) {
        String extension = FileUtil.getExtension(file);
        if (extension != null) {
            if ((extension = extension.toLowerCase(Locale.ENGLISH)).equals("sgf")) {
                return GameFile.Format.SGF;
            }
            if (extension.equals("xml")) {
                return GameFile.Format.XML;
            }
        }
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            char[] buffer = new char[5];
            int n = reader.read(buffer, 0, 5);
            if (n == 5 && new String(buffer).equals("<?xml")) {
                GameFile.Format format = GameFile.Format.XML;
                return format;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return GameFile.Format.SGF;
    }
}

