/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import net.sf.gogui.util.ErrorMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table {
    private boolean m_propertiesRead;
    private int m_lineNumber;
    private int m_numberColumns;
    private final Map<String, String> m_properties = new TreeMap<String, String>();
    private final ArrayList<String> m_columnTitles;
    private ArrayList<String> m_lastRow;
    private final ArrayList<ArrayList<String>> m_rows = new ArrayList();

    public Table() {
        this.m_columnTitles = new ArrayList();
        this.m_numberColumns = 0;
    }

    public Table(ArrayList<String> columnTitles) {
        this.m_columnTitles = columnTitles;
        this.m_numberColumns = columnTitles.size();
    }

    public String get(int column, int row) {
        return this.getRow(row).get(column);
    }

    public String get(String columnTitle, int row) throws InvalidLocation {
        return this.get(this.getColumnIndex(columnTitle), row);
    }

    public double getDouble(int column, int row) throws InvalidLocation, InvalidElement {
        try {
            String s = this.get(column, row);
            if (s == null) {
                s = "";
            }
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new InvalidElement("Expected floating point number in table (column=" + column + ", row=" + row + ")");
        }
    }

    public double getDouble(String columnTitle, int row) throws InvalidLocation, InvalidElement {
        return this.getDouble(this.getColumnIndex(columnTitle), row);
    }

    public int getInt(int column, int row) throws InvalidElement {
        try {
            String s = this.get(column, row);
            if (s == null) {
                s = "";
            }
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new InvalidElement("Expected integer in table (column=" + column + ", row=" + row + ")");
        }
    }

    public int getInt(String columnTitle, int row) throws InvalidLocation, InvalidElement {
        return this.getInt(this.getColumnIndex(columnTitle), row);
    }

    public int getColumnIndex(String column) throws InvalidLocation {
        for (int i = 0; i < this.m_numberColumns; ++i) {
            String title = this.getColumnTitle(i);
            if (!title.equals(column)) continue;
            return i;
        }
        throw new InvalidLocation("No such column in table: " + column);
    }

    public String getColumnTitle(int index) {
        return this.m_columnTitles.get(index);
    }

    public ArrayList<String> getColumnTitles() {
        return (ArrayList)this.m_columnTitles.clone();
    }

    public int getNumberColumns() {
        return this.m_columnTitles.size();
    }

    public int getNumberRows() {
        return this.m_rows.size();
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String def) {
        if (!this.hasProperty(key)) {
            return def;
        }
        return this.m_properties.get(key);
    }

    public boolean hasProperty(String key) {
        return this.m_properties.containsKey(key);
    }

    public void read(File file) throws FileNotFoundException, IOException, InvalidFormat {
        this.read(new FileReader(file));
    }

    public void read(Reader reader) throws IOException, InvalidFormat {
        BufferedReader bufferedReader = new BufferedReader(reader);
        this.m_lineNumber = 0;
        this.m_propertiesRead = false;
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            ++this.m_lineNumber;
            this.handleLine(line);
        }
        bufferedReader.close();
    }

    public void save(File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        try {
            this.save(writer);
        }
        finally {
            writer.close();
        }
    }

    public void save(Writer out) throws IOException {
        this.save(out, true);
    }

    public void save(Writer out, boolean withHeader) throws IOException {
        int i;
        String value;
        if (withHeader) {
            for (Map.Entry<String, String> entry : this.m_properties.entrySet()) {
                String key = entry.getKey();
                value = entry.getValue();
                out.write("# " + key + ": " + value + "\n");
            }
            out.write("#\n#");
            for (i = 0; i < this.m_numberColumns; ++i) {
                out.write(this.getColumnTitle(i));
                if (i < this.m_numberColumns - 1) {
                    out.write(9);
                    continue;
                }
                out.write(10);
            }
        }
        for (i = 0; i < this.m_rows.size(); ++i) {
            ArrayList<String> row = this.m_rows.get(i);
            for (int j = 0; j < this.m_numberColumns; ++j) {
                value = row.get(j);
                if (value != null) {
                    out.write(value);
                }
                if (j < this.m_numberColumns - 1) {
                    out.write(9);
                    continue;
                }
                out.write(10);
            }
        }
    }

    public void set(int column, String value) {
        assert (this.m_lastRow.get(column) == null);
        assert (value == null || value.indexOf("\n") < 0);
        assert (value == null || value.indexOf("\t") < 0);
        this.m_lastRow.set(column, value);
    }

    public void set(String column, int value) throws InvalidLocation {
        this.set(column, Integer.toString(value));
    }

    public void set(String column, double value) throws InvalidLocation {
        this.set(column, Double.toString(value));
    }

    public void set(String column, String value) throws InvalidLocation {
        this.set(this.getColumnIndex(column), value);
    }

    public Object setProperty(String key, String value) {
        return this.m_properties.put(key, value);
    }

    public void startRow() {
        ArrayList<Object> row = new ArrayList<Object>(this.m_numberColumns);
        for (int i = 0; i < this.m_numberColumns; ++i) {
            row.add(null);
        }
        this.m_rows.add(row);
        this.m_lastRow = row;
    }

    public void sortByIntColumn(int column, int rowBegin, int rowEnd) throws InvalidElement {
        for (int row1 = rowBegin; row1 < rowEnd - 1; ++row1) {
            for (int row2 = row1 + 1; row2 < rowEnd; ++row2) {
                if (this.getInt(column, row2) >= this.getInt(column, row1)) continue;
                ArrayList<String> tmp = this.m_rows.get(row1);
                this.m_rows.set(row1, this.m_rows.get(row2));
                this.m_rows.set(row2, tmp);
            }
        }
    }

    public void sortByIntColumn(String columnTitle, int rowBegin, int rowEnd) throws InvalidElement, InvalidLocation {
        this.sortByIntColumn(this.getColumnIndex(columnTitle), rowBegin, rowEnd);
    }

    private void addColumnTitle(String columnTitle) {
        this.m_columnTitles.add(columnTitle);
        ++this.m_numberColumns;
    }

    private ArrayList<String> getRow(int index) {
        return this.m_rows.get(index);
    }

    private void handleComment(String comment) {
        comment = comment.trim();
        if (this.m_propertiesRead) {
            String[] array = comment.split("\\t");
            for (int i = 0; i < array.length; ++i) {
                this.addColumnTitle(array[i]);
            }
            return;
        }
        if (comment.equals("")) {
            this.m_propertiesRead = true;
            return;
        }
        int pos = comment.indexOf(58);
        if (pos < 0) {
            System.err.println("Invalid line " + this.m_lineNumber + ": " + comment);
            return;
        }
        String key = comment.substring(0, pos).trim();
        String value = comment.substring(pos + 1).trim();
        this.setProperty(key, value);
    }

    private void handleLine(String line) throws InvalidFormat {
        if ((line = line.trim()).startsWith("#")) {
            this.handleComment(line.substring(1));
            return;
        }
        String[] array = line.split("\\t");
        if (array.length > this.getNumberColumns()) {
            throw new InvalidFormat("Invalid line " + this.m_lineNumber + ": " + line);
        }
        this.startRow();
        for (int i = 0; i < array.length; ++i) {
            this.set(i, array[i]);
        }
    }

    public static class InvalidElement
    extends ErrorMessage {
        public InvalidElement(String message) {
            super(message);
        }
    }

    public static class InvalidFormat
    extends ErrorMessage {
        public InvalidFormat(String message) {
            super(message);
        }
    }

    public static class InvalidLocation
    extends ErrorMessage {
        public InvalidLocation(String message) {
            super(message);
        }
    }
}

