/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.go;

import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;

public final class Move {
    private static Move s_passBlack = new Move(GoColor.BLACK, null, "B PASS");
    private static Move s_passWhite = new Move(GoColor.WHITE, null, "W PASS");
    private static Move[][] s_movesBlack = Move.init(GoColor.BLACK);
    private static Move[][] s_movesWhite = Move.init(GoColor.WHITE);
    private final GoColor m_color;
    private final GoPoint m_point;
    private final String m_string;

    public static Move get(GoColor color, int x, int y) {
        return Move.get(color, GoPoint.get(x, y));
    }

    public static Move get(GoColor color, GoPoint point) {
        assert (color.isBlackWhite());
        if (point == null) {
            if (color == GoColor.BLACK) {
                return s_passBlack;
            }
            return s_passWhite;
        }
        int x = point.getX();
        int y = point.getY();
        if (color == GoColor.BLACK) {
            return s_movesBlack[x][y];
        }
        return s_movesWhite[x][y];
    }

    public static Move getPass(GoColor c) {
        assert (c.isBlackWhite());
        return Move.get(c, null);
    }

    public GoColor getColor() {
        return this.m_color;
    }

    public GoPoint getPoint() {
        return this.m_point;
    }

    public String toString() {
        return this.m_string;
    }

    private static Move[][] init(GoColor color) {
        Move[][] result = new Move[25][25];
        StringBuilder buffer = new StringBuilder(8);
        String colorString = color.getUppercaseLetter();
        for (int x = 0; x < 25; ++x) {
            for (int y = 0; y < 25; ++y) {
                GoPoint p = GoPoint.get(x, y);
                buffer.setLength(0);
                buffer.append(colorString);
                buffer.append(' ');
                buffer.append(p);
                result[x][y] = new Move(color, p, buffer.toString());
            }
        }
        return result;
    }

    private Move(GoColor color, GoPoint point, String string) {
        this.m_point = point;
        this.m_color = color;
        this.m_string = string;
    }
}

