/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sf.gogui.game.MarkType;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.gui.I18n;

public class ContextMenu
extends JPopupMenu {
    private final ActionListener m_actionListener;
    private final GoPoint m_point;
    private final JCheckBoxMenuItem m_mark;
    private final JCheckBoxMenuItem m_markCircle;
    private final JCheckBoxMenuItem m_markSquare;
    private final JCheckBoxMenuItem m_markTriangle;
    private final Listener m_listener;

    public ContextMenu(GoPoint point, boolean mark, boolean markCircle, boolean markSquare, boolean markTriangle, Listener listener) {
        this.m_point = point;
        this.m_listener = listener;
        this.m_actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Listener listener = ContextMenu.this.m_listener;
                if (listener == null) {
                    return;
                }
                String actionCommand = event.getActionCommand();
                if (actionCommand.equals("cancel")) {
                    ContextMenu.this.setVisible(false);
                } else if (actionCommand.equals("mark")) {
                    boolean mark = ContextMenu.this.m_mark.isSelected();
                    listener.actionMark(ContextMenu.this.m_point, MarkType.MARK, mark);
                } else if (actionCommand.equals("mark-circle")) {
                    boolean mark = ContextMenu.this.m_markCircle.isSelected();
                    listener.actionMark(ContextMenu.this.m_point, MarkType.CIRCLE, mark);
                } else if (actionCommand.equals("mark-square")) {
                    boolean mark = ContextMenu.this.m_markSquare.isSelected();
                    listener.actionMark(ContextMenu.this.m_point, MarkType.SQUARE, mark);
                } else if (actionCommand.equals("mark-triangle")) {
                    boolean mark = ContextMenu.this.m_markTriangle.isSelected();
                    listener.actionMark(ContextMenu.this.m_point, MarkType.TRIANGLE, mark);
                } else if (actionCommand.equals("edit-label")) {
                    listener.actionEditLabel(ContextMenu.this.m_point);
                }
            }
        };
        this.setLabel(MessageFormat.format(I18n.i18n("LB_CONTEXTMENU_POINT"), point));
        this.m_mark = this.createCheckBox("MN_CONTEXTMENU_MARK", "mark");
        this.m_mark.setSelected(mark);
        this.add(this.m_mark);
        this.m_markCircle = this.createCheckBox("MN_CONTEXTMENU_MARK_CIRCLE", "mark-circle");
        this.m_markCircle.setSelected(markCircle);
        this.add(this.m_markCircle);
        this.m_markSquare = this.createCheckBox("MN_CONTEXTMENU_MARK_SQUARE", "mark-square");
        this.m_markSquare.setSelected(markSquare);
        this.add(this.m_markSquare);
        this.m_markTriangle = this.createCheckBox("MN_CONTEXTMENU_MARK_TRIANGLE", "mark-triangle");
        this.m_markTriangle.setSelected(markTriangle);
        this.add(this.m_markTriangle);
        this.add(this.createItem("MN_CONTEXTMENU_EDIT_LABEL", "edit-label"));
        this.addSeparator();
        this.add(this.createItem("LB_CANCEL", "cancel"));
    }

    public GoPoint getPointArg() {
        return this.m_point;
    }

    private JCheckBoxMenuItem createCheckBox(String label, String actionCommand) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(I18n.i18n(label));
        item.addActionListener(this.m_actionListener);
        item.setActionCommand(actionCommand);
        return item;
    }

    private JMenuItem createItem(String label, String actionCommand) {
        JMenuItem item = new JMenuItem(I18n.i18n(label));
        item.addActionListener(this.m_actionListener);
        item.setActionCommand(actionCommand);
        return item;
    }

    public static interface Listener {
        public void actionEditLabel(GoPoint var1);

        public void actionMark(GoPoint var1, MarkType var2, boolean var3);
    }
}

