/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.boardpainter;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.net.URL;
import net.sf.gogui.boardpainter.ConstField;
import net.sf.gogui.boardpainter.Field;
import net.sf.gogui.go.BoardConstants;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;

public class BoardPainter {
    private static final double BORDER_SIZE = 0.6;
    private static final double BORDER_SIZE_NOGRID = 0.2;
    private int m_fieldSize;
    private int m_fieldOffset;
    private int m_size;
    private int m_width;
    private static int s_cachedFontFieldSize;
    private static final AlphaComposite COMPOSITE_3;
    private BoardConstants m_constants;
    private final Color m_gridLabelColor = new Color(96, 96, 96);
    private final Color m_gridColor = new Color(80, 80, 80);
    private static Font s_cachedFont;
    private final Image m_image;

    public BoardPainter() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL url = classLoader.getResource("net/sf/gogui/images/wood.png");
        this.m_image = url == null ? null : BoardPainter.loadImage(url);
    }

    public void draw(Graphics graphics, ConstField[][] field, int width, boolean showGrid) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.m_width = width;
        this.m_size = field.length;
        if (this.m_constants == null || this.m_constants.getSize() != this.m_size) {
            this.m_constants = BoardConstants.get(this.m_size);
        }
        assert (this.m_size <= 25);
        double borderSize = showGrid ? 0.6 : 0.2;
        this.m_fieldSize = Math.round((float)Math.floor((double)width / ((double)this.m_size + 2.0 * borderSize)));
        this.m_fieldOffset = (width - this.m_size * this.m_fieldSize) / 2;
        this.drawBackground(graphics);
        this.drawGrid(graphics);
        if (showGrid) {
            this.drawGridLabels(graphics);
        }
        this.drawShadows(graphics, field);
        this.drawFields(graphics, field);
    }

    public Point getCenter(int x, int y) {
        Point point = this.getLocation(x, y);
        point.x += this.m_fieldSize / 2;
        point.y += this.m_fieldSize / 2;
        return point;
    }

    public int getFieldSize() {
        return this.m_fieldSize;
    }

    public Point getLocation(int x, int y) {
        Point point = new Point();
        point.x = this.m_fieldOffset + x * this.m_fieldSize;
        point.y = this.m_fieldOffset + (this.m_size - y - 1) * this.m_fieldSize;
        return point;
    }

    public GoPoint getPoint(Point point) {
        if (this.m_fieldSize == 0) {
            return null;
        }
        int x = ((int)point.getX() - this.m_fieldOffset) / this.m_fieldSize;
        int y = ((int)point.getY() - this.m_fieldOffset) / this.m_fieldSize;
        y = this.m_size - y - 1;
        if (x >= 0 && x < this.m_size && y >= 0 && y < this.m_size) {
            return GoPoint.get(x, y);
        }
        return null;
    }

    public static Dimension getPreferredSize(int preferredFieldSize, int boardSize, boolean showGrid) {
        double borderSize = showGrid ? 0.6 * (double)preferredFieldSize : 0.2 * (double)preferredFieldSize;
        int preferredSize = preferredFieldSize * boardSize + 2 * Math.round((float)Math.ceil(borderSize));
        return new Dimension(preferredSize, preferredSize);
    }

    public int getShadowOffset() {
        return (this.m_fieldSize - 2 * Field.getStoneMargin(this.m_fieldSize)) / 12;
    }

    private void drawBackground(Graphics graphics) {
        if (this.m_image == null) {
            graphics.setColor(new Color(212, 167, 102));
            graphics.fillRect(0, 0, this.m_width, this.m_width);
        } else {
            graphics.drawImage(this.m_image, 0, 0, this.m_width, this.m_width, null);
        }
    }

    private void drawFields(Graphics graphics, ConstField[][] field) {
        assert (field.length == this.m_size);
        for (int x = 0; x < this.m_size; ++x) {
            assert (field[x].length == this.m_size);
            for (int y = 0; y < this.m_size; ++y) {
                Point location = this.getLocation(x, y);
                field[x][y].draw(graphics, this.m_fieldSize, location.x, location.y, this.m_image, this.m_width);
            }
        }
    }

    private void drawGrid(Graphics graphics) {
        if (this.m_fieldSize < 2) {
            return;
        }
        graphics.setColor(Color.darkGray);
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        for (int y = 0; y < this.m_size; ++y) {
            if (y == 0 || y == this.m_size - 1) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(this.m_gridColor);
            }
            Point left = this.getCenter(0, y);
            Point right = this.getCenter(this.m_size - 1, y);
            graphics.drawLine(left.x, left.y, right.x, right.y);
        }
        for (int x = 0; x < this.m_size; ++x) {
            if (x == 0 || x == this.m_size - 1) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(this.m_gridColor);
            }
            Point top = this.getCenter(x, 0);
            Point bottom = this.getCenter(x, this.m_size - 1);
            graphics.drawLine(top.x, top.y, bottom.x, bottom.y);
        }
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.m_fieldSize <= 7) {
            return;
        }
        int r = this.m_fieldSize <= 33 ? 1 : (this.m_fieldSize <= 60 ? 2 : 3);
        for (int x = 0; x < this.m_size; ++x) {
            if (!this.m_constants.isHandicapLine(x)) continue;
            for (int y = 0; y < this.m_size; ++y) {
                if (!this.m_constants.isHandicapLine(y)) continue;
                Point point = this.getCenter(x, y);
                graphics.fillOval(point.x - r, point.y - r, 2 * r + 1, 2 * r + 1);
            }
        }
    }

    private void drawGridLabels(Graphics graphics) {
        Point point;
        String string;
        if (this.m_fieldSize < 15) {
            return;
        }
        graphics.setColor(this.m_gridLabelColor);
        BoardPainter.setFont(graphics, this.m_fieldSize);
        int offset = (this.m_fieldSize + this.m_fieldOffset) / 2;
        char c = 'A';
        for (int x = 0; x < this.m_size; ++x) {
            string = Character.toString(c);
            point = this.getLocation(x, 0);
            point.y += offset;
            this.drawLabel(graphics, point, string);
            point = this.getLocation(x, this.m_size - 1);
            point.y -= offset;
            this.drawLabel(graphics, point, string);
            c = (char)(c + '\u0001');
            if (c != 73) continue;
            c = (char)(c + '\u0001');
        }
        for (int y = 0; y < this.m_size; ++y) {
            string = Integer.toString(y + 1);
            point = this.getLocation(0, y);
            point.x -= offset;
            this.drawLabel(graphics, point, string);
            point = this.getLocation(this.m_size - 1, y);
            point.x += offset;
            this.drawLabel(graphics, point, string);
        }
    }

    private void drawShadows(Graphics graphics, ConstField[][] field) {
        Graphics2D graphics2D;
        if (this.m_fieldSize <= 5) {
            return;
        }
        Graphics2D graphics2D2 = graphics2D = graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        if (graphics2D == null) {
            return;
        }
        graphics2D.setComposite(COMPOSITE_3);
        int size = this.m_fieldSize - 2 * Field.getStoneMargin(this.m_fieldSize);
        int offsetX = this.getShadowOffset() / 2;
        int offsetY = this.getShadowOffset();
        for (int x = 0; x < this.m_size; ++x) {
            for (int y = 0; y < this.m_size; ++y) {
                if (field[x][y].getColor() == GoColor.EMPTY) continue;
                Point location = this.getCenter(x, y);
                graphics.setColor(Color.black);
                graphics.fillOval(location.x - size / 2 + offsetX, location.y - size / 2 + offsetY, size, size);
            }
        }
        graphics.setPaintMode();
    }

    private void drawLabel(Graphics graphics, Point location, String string) {
        FontMetrics metrics = graphics.getFontMetrics();
        int stringWidth = metrics.stringWidth(string);
        int stringHeight = metrics.getAscent();
        int x = Math.max((this.m_fieldSize - stringWidth) / 2, 0);
        int y = stringHeight + (this.m_fieldSize - stringHeight) / 2;
        graphics.drawString(string, location.x + x, location.y + y);
    }

    private static Image loadImage(URL url) {
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        MediaTracker mediaTracker = new MediaTracker(new Container());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException e) {
            return null;
        }
        return image;
    }

    private static void setFont(Graphics graphics, int fieldSize) {
        if (s_cachedFont != null && s_cachedFontFieldSize == fieldSize) {
            graphics.setFont(s_cachedFont);
            return;
        }
        int fontSize = fieldSize < 29 ? (int)(0.33 * (double)fieldSize) : (fieldSize < 40 ? 10 : (int)(10.0 + 0.1 * (double)(fieldSize - 40)));
        s_cachedFont = new Font("SansSerif", 0, fontSize);
        s_cachedFontFieldSize = fieldSize;
        graphics.setFont(s_cachedFont);
    }

    static {
        COMPOSITE_3 = AlphaComposite.getInstance(3, 0.3f);
    }
}

