/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gogui;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import net.sf.gogui.boardpainter.BoardPainter;
import net.sf.gogui.boardpainter.BoardPainterUtil;
import net.sf.gogui.boardpainter.ConstField;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.gogui.I18n;
import net.sf.gogui.gui.ConstGuiBoard;
import net.sf.gogui.gui.FileDialogs;
import net.sf.gogui.gui.MessageDialogs;

public final class ExportPng {
    public static void run(Component parent, ConstGuiBoard guiBoard, Preferences prefs, MessageDialogs messageDialogs) {
        String value = Integer.toString(guiBoard.getWidth());
        boolean done = false;
        int width = 0;
        while (!done) {
            value = (String)JOptionPane.showInputDialog(parent, I18n.i18n("TIT_EXPORTPNG_WIDTH"), I18n.i18n("LB_EXPORTPNG_WIDTH"), -1, null, null, value);
            if (value == null) {
                return;
            }
            try {
                width = Integer.parseInt(value);
                if (width > 0) {
                    done = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (done) continue;
            messageDialogs.showError(parent, I18n.i18n("MSG_EXPORTPNG_INVALID_WIDTH"), I18n.i18n("MSG_EXPORTPNG_INVALID_WIDTH_2"), false);
        }
        File file = FileDialogs.showSave(parent, I18n.i18n("TIT_EXPORTPNG_FILE"), messageDialogs);
        if (file == null) {
            return;
        }
        BoardPainter painter = new BoardPainter();
        int size = guiBoard.getBoardSize();
        ConstField[][] fields = new ConstField[size][size];
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                fields[x][y] = guiBoard.getFieldConst(GoPoint.get(x, y));
            }
        }
        BufferedImage image = BoardPainterUtil.getImage(painter, fields, width, width);
        try {
            BoardPainterUtil.writeImage(image, file, null);
        }
        catch (IOException e) {
            messageDialogs.showError(parent, I18n.i18n("MSG_EXPORTPNG_WRITE_FAIL"), e.getMessage());
        }
    }

    private ExportPng() {
    }
}

