/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gogui;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import net.sf.gogui.game.ConstClock;
import net.sf.gogui.game.ConstGame;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.NodeUtil;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.gogui.GoGui;
import net.sf.gogui.gogui.I18n;
import net.sf.gogui.gui.ConstGuiBoard;
import net.sf.gogui.gui.GameTreePanel;
import net.sf.gogui.gui.GuiAction;
import net.sf.gogui.util.Platform;

public class GoGuiActions {
    public final GuiAction m_actionAbout = new GuiAction(I18n.i18n("ACT_ABOUT")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionAbout();
        }
    };
    public final GuiAction m_actionAddBookmark = new GuiAction(I18n.i18n("ACT_ADD_BOOKMARK"), null, 66){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionAddBookmark();
        }
    };
    public final GuiAction m_actionBackToMainVariation = new GuiAction(I18n.i18n("ACT_BACK_TO_MAIN_VARIATION"), null, 77){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionBackToMainVariation();
        }
    };
    public final GuiAction m_actionBackward = new GuiAction(I18n.i18n("ACT_BACKWARD"), I18n.i18n("TT_BACKWARD"), 37, "gogui-previous"){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionBackward(1);
        }
    };
    public final GuiAction m_actionBackwardTen = new GuiAction(I18n.i18n("ACT_BACKWARD_TEN"), I18n.i18n("TT_BACKWARD_TEN"), 37, SHORTCUT | 1, "gogui-previous-10"){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionBackward(10);
        }
    };
    public final GuiAction m_actionBeginning = new GuiAction(I18n.i18n("ACT_BEGINNING"), I18n.i18n("TT_BEGINNING"), 36, "gogui-first"){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionBeginning();
        }
    };
    public final GuiAction m_actionBoardSize9 = new GuiAction(I18n.i18n("ACT_BOARDSIZE_9")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionBoardSize(9);
        }
    };
    public final GuiAction m_actionBoardSize11 = new GuiAction(I18n.i18n("ACT_BOARDSIZE_11")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionBoardSize(11);
        }
    };
    public final GuiAction m_actionBoardSize13 = new GuiAction(I18n.i18n("ACT_BOARDSIZE_13")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionBoardSize(13);
        }
    };
    public final GuiAction m_actionBoardSize15 = new GuiAction(I18n.i18n("ACT_BOARDSIZE_15")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionBoardSize(15);
        }
    };
    public final GuiAction m_actionBoardSize17 = new GuiAction(I18n.i18n("ACT_BOARDSIZE_17")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionBoardSize(17);
        }
    };
    public final GuiAction m_actionBoardSize19 = new GuiAction(I18n.i18n("ACT_BOARDSIZE_19")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionBoardSize(19);
        }
    };
    public final GuiAction m_actionBoardSizeOther = new GuiAction(I18n.i18n("ACT_BOARDSIZE_OTHER")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionBoardSizeOther();
        }
    };
    public final GuiAction m_actionClockHalt = new GuiAction(I18n.i18n("ACT_CLOCK_HALT")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionClockHalt();
        }
    };
    public final GuiAction m_actionClockResume = new GuiAction(I18n.i18n("ACT_CLOCK_RESUME")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionClockResume();
        }
    };
    public final GuiAction m_actionClockStart = new GuiAction(I18n.i18n("ACT_CLOCK_START")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionClockStart();
        }
    };
    public final GuiAction m_actionComputerBlack = new GuiAction(I18n.i18n("ACT_COMPUTER_BLACK")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionComputerColor(true, false);
        }
    };
    public final GuiAction m_actionComputerBoth = new GuiAction(I18n.i18n("ACT_COMPUTER_BOTH")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionComputerColor(true, true);
        }
    };
    public final GuiAction m_actionComputerNone = new GuiAction(I18n.i18n("ACT_COMPUTER_NONE")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionComputerColor(false, false);
        }
    };
    public final GuiAction m_actionComputerWhite = new GuiAction(I18n.i18n("ACT_COMPUTER_WHITE")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionComputerColor(false, true);
        }
    };
    public final GuiAction m_actionEditBookmarks = new GuiAction(I18n.i18n("ACT_EDIT_BOOKMARKS")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionEditBookmarks();
        }
    };
    public final GuiAction m_actionEditPrograms = new GuiAction(I18n.i18n("ACT_EDIT_PROGRAMS")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionEditPrograms();
        }
    };
    public final GuiAction m_actionGotoMove = new GuiAction(I18n.i18n("ACT_GOTO_MOVE"), null, 71){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionGotoMove();
        }
    };
    public final GuiAction m_actionGotoVariation = new GuiAction(I18n.i18n("ACT_GOTO_VARIATION")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionGotoVariation();
        }
    };
    public final GuiAction m_actionDeleteSideVariations = new GuiAction(I18n.i18n("ACT_DELETE_SIDE_VARIATIONS")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionDeleteSideVariations();
        }
    };
    public final GuiAction m_actionDetachProgram = new GuiAction(I18n.i18n("ACT_DETACH_PROGRAM")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionDetachProgram();
        }
    };
    public final GuiAction m_actionEnd = new GuiAction(I18n.i18n("ACT_END"), I18n.i18n("TT_END"), 35, "gogui-last"){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionEnd();
        }
    };
    public final GuiAction m_actionExportSgfPosition = new GuiAction(I18n.i18n("ACT_EXPORT_SGF_POSITION")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionExportSgfPosition();
        }
    };
    public final GuiAction m_actionExportLatexMainVariation = new GuiAction(I18n.i18n("ACT_EXPORT_LATEX_MAIN_VARIATION")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionExportLatexMainVariation();
        }
    };
    public final GuiAction m_actionExportLatexPosition = new GuiAction(I18n.i18n("ACT_EXPORT_LATEX_POSITION")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionExportLatexPosition();
        }
    };
    public final GuiAction m_actionExportPng = new GuiAction(I18n.i18n("ACT_EXPORT_PNG")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionExportPng();
        }
    };
    public final GuiAction m_actionExportTextPosition = new GuiAction(I18n.i18n("ACT_EXPORT_TEXT_POSITION")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionExportTextPosition();
        }
    };
    public final GuiAction m_actionExportTextPositionToClipboard = new GuiAction(I18n.i18n("ACT_EXPORT_TEXT_POSITION_TO_CLIPBOARD")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionExportTextPositionToClipboard();
        }
    };
    public final GuiAction m_actionFind = new GuiAction(I18n.i18n("ACT_FIND"), null, 70){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionFind();
        }
    };
    public final GuiAction m_actionFindNext = new GuiAction(I18n.i18n("ACT_FIND_NEXT"), null, 114, FUNCTION_KEY){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionFindNext();
        }
    };
    public final GuiAction m_actionFindNextComment = new GuiAction(I18n.i18n("ACT_FIND_NEXT_COMMENT"), null, 115, FUNCTION_KEY){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionFindNextComment();
        }
    };
    public final GuiAction m_actionForward = new GuiAction(I18n.i18n("ACT_FORWARD"), I18n.i18n("TT_FORWARD"), 39, "gogui-next"){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionForward(1);
        }
    };
    public final GuiAction m_actionForwardTen = new GuiAction(I18n.i18n("ACT_FORWARD_TEN"), I18n.i18n("TT_FORWARD_TEN"), 39, SHORTCUT | 1, "gogui-next-10"){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionForward(10);
        }
    };
    public final GuiAction m_actionGameInfo = new GuiAction(I18n.i18n("ACT_GAME_INFO"), null, 73){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionGameInfo();
        }
    };
    public final GuiAction m_actionHandicapNone = new GuiAction(I18n.i18n("ACT_HANDICAP_NONE")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionHandicap(0);
        }
    };
    public final GuiAction m_actionHandicap2 = new GuiAction(I18n.i18n("ACT_HANDICAP_2")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionHandicap(2);
        }
    };
    public final GuiAction m_actionHandicap3 = new GuiAction(I18n.i18n("ACT_HANDICAP_3")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionHandicap(3);
        }
    };
    public final GuiAction m_actionHandicap4 = new GuiAction(I18n.i18n("ACT_HANDICAP_4")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionHandicap(4);
        }
    };
    public final GuiAction m_actionHandicap5 = new GuiAction(I18n.i18n("ACT_HANDICAP_5")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionHandicap(5);
        }
    };
    public final GuiAction m_actionHandicap6 = new GuiAction(I18n.i18n("ACT_HANDICAP_6")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionHandicap(6);
        }
    };
    public final GuiAction m_actionHandicap7 = new GuiAction(I18n.i18n("ACT_HANDICAP_7")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionHandicap(7);
        }
    };
    public final GuiAction m_actionHandicap8 = new GuiAction(I18n.i18n("ACT_HANDICAP_8")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionHandicap(8);
        }
    };
    public final GuiAction m_actionHandicap9 = new GuiAction(I18n.i18n("ACT_HANDICAP_9")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionHandicap(9);
        }
    };
    public final GuiAction m_actionHelp = new GuiAction(I18n.i18n("ACT_HELP"), null, 112, FUNCTION_KEY){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionHelp();
        }
    };
    public final GuiAction m_actionImportTextPosition = new GuiAction(I18n.i18n("ACT_IMPORT_TEXT_POSITION")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionImportTextPosition();
        }
    };
    public final GuiAction m_actionImportTextPositionFromClipboard = new GuiAction(I18n.i18n("ACT_IMPORT_TEXT_POSITION_FROM_CLIPBOARD")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionImportTextPositionFromClipboard();
        }
    };
    public final GuiAction m_actionImportSgfFromClipboard = new GuiAction(I18n.i18n("ACT_IMPORT_SGF_FROM_CLIPBOARD")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionImportSgfFromClipboard();
        }
    };
    public final GuiAction m_actionInterrupt = Platform.isMac() ? new GuiAction(I18n.i18n("ACT_INTERRUPT")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionInterrupt();
        }
    } : new GuiAction(I18n.i18n("ACT_INTERRUPT"), null, 27, 0){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionInterrupt();
        }
    };
    public final GuiAction m_actionKeepOnlyPosition = new GuiAction(I18n.i18n("ACT_KEEP_ONLY_POSITION")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionKeepOnlyPosition();
        }
    };
    public final GuiAction m_actionMainWindowActivate = new GuiAction(I18n.i18n("ACT_MAIN_WINDOW_ACTIVATE"), null, 117, FUNCTION_KEY){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionMainWindowActivate();
        }
    };
    public final GuiAction m_actionMakeMainVariation = new GuiAction(I18n.i18n("ACT_MAKE_MAIN_VARIATION")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionMakeMainVariation();
        }
    };
    public final GuiAction m_actionNextEarlierVariation = new GuiAction(I18n.i18n("ACT_NEXT_EARLIER_VARIATION"), null, 40, SHORTCUT | 1){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionNextEarlierVariation();
        }
    };
    public final GuiAction m_actionNextVariation = new GuiAction(I18n.i18n("ACT_NEXT_VARIATION"), I18n.i18n("TT_NEXT_VARIATION"), 40, "gogui-down"){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionNextVariation();
        }
    };
    public final GuiAction m_actionNewGame = new GuiAction(I18n.i18n("ACT_NEW_GAME"), I18n.i18n("TT_NEW_GAME"), "gogui-newgame"){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionNewGame();
        }
    };
    public final GuiAction m_actionNewProgram = new GuiAction(I18n.i18n("ACT_NEW_PROGRAM")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionNewProgram();
        }
    };
    public final GuiAction m_actionOpen = new GuiAction(I18n.i18n("ACT_OPEN"), I18n.i18n("TT_OPEN"), 79, "document-open"){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionOpen();
        }
    };
    public final GuiAction m_actionPass = new GuiAction(I18n.i18n("ACT_PASS"), I18n.i18n("TT_PASS"), 113, FUNCTION_KEY, "gogui-pass"){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionPass();
        }
    };
    public final GuiAction m_actionPlay = new GuiAction(I18n.i18n("ACT_PLAY"), I18n.i18n("TT_PLAY"), 116, FUNCTION_KEY, "gogui-play"){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionPlay(false);
        }
    };
    public final GuiAction m_actionPlaySingleMove = new GuiAction(I18n.i18n("ACT_PLAY_SINGLE_MOVE"), null, 116, FUNCTION_KEY | 1){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionPlay(true);
        }
    };
    public final GuiAction m_actionPreviousEarlierVariation = new GuiAction(I18n.i18n("ACT_PREVIOUS_EARLIER_VARIATION"), null, 38, SHORTCUT | 1){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionPreviousEarlierVariation();
        }
    };
    public final GuiAction m_actionPreviousVariation = new GuiAction(I18n.i18n("ACT_PREVIOUS_VARIATION"), I18n.i18n("TT_PREVIOUS_VARIATION"), 38, "gogui-up"){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionPreviousVariation();
        }
    };
    public final GuiAction m_actionPrint = new GuiAction(I18n.i18n("ACT_PRINT"), null, 80, null){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionPrint();
        }
    };
    public final GuiAction m_actionReattachProgram = new GuiAction(I18n.i18n("ACT_REATTACH_PROGRAM"), null, 84){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionReattachProgram();
        }
    };
    public final GuiAction m_actionReattachWithParameters = new GuiAction(I18n.i18n("ACT_REATTACH_WITH_PARAMETERS"), null, 84, SHORTCUT | 1){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionReattachWithParameters();
        }
    };
    public final GuiAction m_actionRestoreParameters = new GuiAction(I18n.i18n("ACT_RESTORE_PARAMETERS")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionRestoreParameters();
        }
    };
    public final GuiAction m_actionSave = new GuiAction(I18n.i18n("ACT_SAVE"), I18n.i18n("TT_SAVE"), 83, "document-save"){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionSave();
        }
    };
    public final GuiAction m_actionSaveAs = new GuiAction(I18n.i18n("ACT_SAVE_AS"), I18n.i18n("TT_SAVE_AS")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionSaveAs();
        }
    };
    public final GuiAction m_actionSaveCommands = new GuiAction(I18n.i18n("ACT_SAVE_COMMANDS")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionSaveCommands();
        }
    };
    public final GuiAction m_actionSaveLog = new GuiAction(I18n.i18n("ACT_SAVE_LOG")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionSaveLog();
        }
    };
    public final GuiAction m_actionSaveParameters = new GuiAction(I18n.i18n("ACT_SAVE_PARAMETERS")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionSaveParameters();
        }
    };
    public final GuiAction m_actionScore = new GuiAction(I18n.i18n("ACT_SCORE")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionScore();
        }
    };
    public final GuiAction m_actionSendFile = new GuiAction(I18n.i18n("ACT_SEND_FILE")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionSendFile();
        }
    };
    public final GuiAction m_actionSetTimeLeft = new GuiAction(I18n.i18n("ACT_SET_TIME_LEFT"), null){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionSetTimeLeft();
        }
    };
    public final GuiAction m_actionSetupBlack = new GuiAction(I18n.i18n("ACT_SETUP_BLACK"), I18n.i18n("TT_SETUP_BLACK"), "gogui-setup-black"){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionSetup(GoColor.BLACK);
        }
    };
    public final GuiAction m_actionSetupWhite = new GuiAction(I18n.i18n("ACT_SETUP_WHITE"), I18n.i18n("TT_SETUP_WHITE"), "gogui-setup-white"){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionSetup(GoColor.WHITE);
        }
    };
    public final GuiAction m_actionShowAnalyzeDialog = new GuiAction(I18n.i18n("ACT_ANALYZE_COMMANDS"), null, 119, FUNCTION_KEY){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionShowAnalyzeDialog();
        }
    };
    public final GuiAction m_actionShowShell = new GuiAction(I18n.i18n("ACT_GTP_SHELL"), null, 120, FUNCTION_KEY){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionShowShell();
        }
    };
    public final GuiAction m_actionShowTree = new GuiAction(I18n.i18n("ACT_TREE_VIEWER"), null, 118, FUNCTION_KEY){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionShowTree();
        }
    };
    public final GuiAction m_actionShowVariationsChildren = new GuiAction(I18n.i18n("ACT_VARIATION_LABELS_CHILDREN")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionSetShowVariations(GoGui.ShowVariations.CHILDREN);
        }
    };
    public final GuiAction m_actionShowVariationsSiblings = new GuiAction(I18n.i18n("ACT_VARIATION_LABELS_SIBLINGS")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionSetShowVariations(GoGui.ShowVariations.SIBLINGS);
        }
    };
    public final GuiAction m_actionShowVariationsNone = new GuiAction(I18n.i18n("ACT_VARIATION_LABELS_NONE")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionSetShowVariations(GoGui.ShowVariations.NONE);
        }
    };
    public final GuiAction m_actionSnapshotParameters = new GuiAction(I18n.i18n("ACT_SNAPSHOT_PARAMETERS")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionSnapshotParameters();
        }
    };
    public final GuiAction m_actionToggleAutoNumber = new GuiAction(I18n.i18n("ACT_AUTO_NUMBER")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionToggleAutoNumber();
        }
    };
    public final GuiAction m_actionToggleBeepAfterMove = new GuiAction(I18n.i18n("ACT_PLAY_SOUND")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionToggleBeepAfterMove();
        }
    };
    public final GuiAction m_actionToggleCompletion = new GuiAction(I18n.i18n("ACT_POPUP_COMPLETIONS")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionToggleCompletion();
        }
    };
    public final GuiAction m_actionToggleCommentMonoFont = new GuiAction(I18n.i18n("ACT_MONOSPACE_COMMENT_FONT")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionToggleCommentMonoFont();
        }
    };
    public final GuiAction m_actionToggleShowCursor = new GuiAction(I18n.i18n("ACT_CURSOR")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionToggleShowCursor();
        }
    };
    public final GuiAction m_actionToggleShowGrid = new GuiAction(I18n.i18n("ACT_GRID_LABELS")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionToggleShowGrid();
        }
    };
    public final GuiAction m_actionToggleShowInfoPanel = new GuiAction(I18n.i18n("ACT_INFO_PANEL")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionToggleShowInfoPanel();
        }
    };
    public final GuiAction m_actionToggleShowLastMove = new GuiAction(I18n.i18n("ACT_LAST_MOVE")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionToggleShowLastMove();
        }
    };
    public final GuiAction m_actionToggleShowMoveNumbers = new GuiAction(I18n.i18n("ACT_MOVE_NUMBERS")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionToggleShowMoveNumbers();
        }
    };
    public final GuiAction m_actionToggleShowSubtreeSizes = new GuiAction(I18n.i18n("ACT_SUBTREE_SIZES")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionToggleShowSubtreeSizes();
        }
    };
    public final GuiAction m_actionToggleShowToolbar = new GuiAction(I18n.i18n("ACT_TOOLBAR")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionToggleShowToolbar();
        }
    };
    public final GuiAction m_actionToggleTimeStamp = new GuiAction(I18n.i18n("ACT_TIMESTAMP")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionToggleTimeStamp();
        }
    };
    public final GuiAction m_actionTreeLabelsNumber = new GuiAction(I18n.i18n("ACT_TREE_LABELS_MOVE_NUMBER")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionTreeLabels(GameTreePanel.Label.NUMBER);
        }
    };
    public final GuiAction m_actionTreeLabelsMove = new GuiAction(I18n.i18n("ACT_TREE_LABELS_MOVE")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionTreeLabels(GameTreePanel.Label.MOVE);
        }
    };
    public final GuiAction m_actionTreeLabelsNone = new GuiAction(I18n.i18n("ACT_TREE_LABELS_NONE")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionTreeLabels(GameTreePanel.Label.NONE);
        }
    };
    public final GuiAction m_actionTreeSizeLarge = new GuiAction(I18n.i18n("ACT_TREE_SIZE_LARGE")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionTreeSize(GameTreePanel.Size.LARGE);
        }
    };
    public final GuiAction m_actionTreeSizeNormal = new GuiAction(I18n.i18n("ACT_TREE_SIZE_NORMAL")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionTreeSize(GameTreePanel.Size.NORMAL);
        }
    };
    public final GuiAction m_actionTreeSizeSmall = new GuiAction(I18n.i18n("ACT_TREE_SIZE_SMALL")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionTreeSize(GameTreePanel.Size.SMALL);
        }
    };
    public final GuiAction m_actionTreeSizeTiny = new GuiAction(I18n.i18n("ACT_TREE_SIZE_TINY")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionTreeSize(GameTreePanel.Size.TINY);
        }
    };
    public final GuiAction m_actionTruncate = new GuiAction(I18n.i18n("ACT_TRUNCATE")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionTruncate();
        }
    };
    public final GuiAction m_actionTruncateChildren = new GuiAction(I18n.i18n("ACT_TRUNCATE_CHILDREN")){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionTruncateChildren();
        }
    };
    public final GuiAction m_actionQuit = new GuiAction(I18n.i18n("ACT_QUIT"), null, 81, null){

        public void actionPerformed(ActionEvent e) {
            GoGuiActions.this.m_goGui.actionQuit();
        }
    };
    private final GoGui m_goGui;
    private static final int SHORTCUT = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final int FUNCTION_KEY = Platform.isMac() ? SHORTCUT : 0;

    public GoGuiActions(GoGui goGui) {
        this.m_goGui = goGui;
    }

    public void update() {
        ConstGame game = this.m_goGui.getGame();
        int handicap = this.m_goGui.getHandicapDefault();
        boolean setupMode = this.m_goGui.isInSetupMode();
        GoColor setupColor = this.m_goGui.getSetupColor();
        File file = this.m_goGui.getFile();
        boolean isModified = this.m_goGui.isModified();
        ConstGuiBoard guiBoard = this.m_goGui.getGuiBoard();
        String name = this.m_goGui.getProgramName();
        ConstNode node = game.getCurrentNode();
        boolean hasFather = node.getFatherConst() != null;
        boolean hasChildren = node.hasChildren();
        boolean hasNextVariation = NodeUtil.getNextVariation(node) != null;
        boolean hasPreviousVariation = NodeUtil.getPreviousVariation(node) != null;
        boolean hasNextEarlierVariation = NodeUtil.getNextEarlierVariation(node) != null;
        boolean hasPrevEarlierVariation = NodeUtil.getPreviousEarlierVariation(node) != null;
        boolean isInMain = NodeUtil.isInMainVariation(node);
        boolean treeHasVariations = game.getTree().hasVariations();
        boolean isCommandInProgress = this.m_goGui.isCommandInProgress();
        boolean isProgramAttached = this.m_goGui.isProgramAttached();
        boolean isProgramDead = this.m_goGui.isProgramDead();
        boolean isInterruptSupported = this.m_goGui.isInterruptSupported();
        boolean computerBlack = this.m_goGui.isComputerColor(GoColor.BLACK);
        boolean computerWhite = this.m_goGui.isComputerColor(GoColor.WHITE);
        boolean computerBoth = computerBlack && computerWhite;
        boolean hasPattern = this.m_goGui.getPattern() != null;
        boolean hasParameterSnapshot = this.m_goGui.hasParameterSnapshot();
        int numberPrograms = this.m_goGui.getNumberPrograms();
        boolean hasParameterCommands = this.m_goGui.hasParameterCommands();
        ConstClock clock = game.getClock();
        int boardSize = game.getSize();
        GoColor toMove = game.getToMove();
        this.m_actionBackToMainVariation.setEnabled(!isInMain);
        this.m_actionBackward.setEnabled(hasFather);
        this.m_actionBackwardTen.setEnabled(hasFather);
        this.m_actionBeginning.setEnabled(hasFather);
        this.m_actionBoardSize9.setSelected(boardSize == 9);
        this.m_actionBoardSize11.setSelected(boardSize == 11);
        this.m_actionBoardSize13.setSelected(boardSize == 13);
        this.m_actionBoardSize15.setSelected(boardSize == 15);
        this.m_actionBoardSize17.setSelected(boardSize == 17);
        this.m_actionBoardSize19.setSelected(boardSize == 19);
        this.m_actionBoardSizeOther.setSelected(boardSize < 9 || boardSize > 19 || boardSize % 2 == 0);
        this.m_actionClockHalt.setEnabled(clock.isRunning());
        this.updateClockResume(clock);
        this.updateClockStart(clock);
        this.updateSetTimeLeft(clock);
        this.m_actionComputerBlack.setEnabled(isProgramAttached);
        this.m_actionComputerBlack.setSelected(computerBlack && !computerWhite);
        this.m_actionComputerBoth.setEnabled(isProgramAttached);
        this.m_actionComputerBoth.setSelected(computerBoth);
        this.m_actionComputerNone.setEnabled(isProgramAttached);
        this.m_actionComputerNone.setSelected(!computerBlack && !computerWhite);
        this.m_actionComputerWhite.setEnabled(isProgramAttached);
        this.m_actionComputerWhite.setSelected(!computerBlack && computerWhite);
        this.m_actionDeleteSideVariations.setEnabled(isInMain && treeHasVariations);
        this.updateDetachProgram(isProgramAttached, name);
        this.m_actionEditPrograms.setEnabled(numberPrograms > 0);
        this.m_actionEnd.setEnabled(hasChildren);
        this.m_actionFindNext.setEnabled(hasPattern);
        this.m_actionForward.setEnabled(hasChildren);
        this.m_actionForwardTen.setEnabled(hasChildren);
        this.m_actionGotoMove.setEnabled(hasFather || hasChildren);
        this.m_actionGotoVariation.setEnabled(hasFather || hasChildren);
        this.m_actionHandicapNone.setSelected(handicap == 0);
        this.m_actionHandicap2.setSelected(handicap == 2);
        this.m_actionHandicap3.setSelected(handicap == 3);
        this.m_actionHandicap4.setSelected(handicap == 4);
        this.m_actionHandicap5.setSelected(handicap == 5);
        this.m_actionHandicap6.setSelected(handicap == 6);
        this.m_actionHandicap7.setSelected(handicap == 7);
        this.m_actionHandicap8.setSelected(handicap == 8);
        this.m_actionHandicap9.setSelected(handicap == 9);
        this.updateInterrupt(isProgramAttached, isInterruptSupported, isCommandInProgress, name);
        this.m_actionKeepOnlyPosition.setEnabled(hasFather || hasChildren);
        this.m_actionMakeMainVariation.setEnabled(!isInMain);
        this.m_actionNextEarlierVariation.setEnabled(hasNextEarlierVariation);
        this.m_actionNextVariation.setEnabled(hasNextVariation);
        this.updatePass(toMove);
        this.updatePlay(toMove, isProgramAttached, computerBoth, name);
        this.m_actionPlaySingleMove.setEnabled(isProgramAttached);
        this.m_actionPreviousVariation.setEnabled(hasPreviousVariation);
        this.m_actionPreviousEarlierVariation.setEnabled(hasPrevEarlierVariation);
        this.m_actionReattachProgram.setEnabled(isProgramAttached);
        this.m_actionReattachWithParameters.setEnabled(isProgramAttached && hasParameterCommands && (!isProgramDead || hasParameterSnapshot));
        this.m_actionSnapshotParameters.setEnabled(isProgramAttached && !isProgramDead && hasParameterCommands);
        this.m_actionRestoreParameters.setEnabled(isProgramAttached && !isProgramDead && hasParameterCommands && hasParameterSnapshot);
        this.updateSave(file, isModified);
        this.m_actionSetupBlack.setSelected(setupMode && setupColor == GoColor.BLACK);
        this.m_actionSetupWhite.setSelected(setupMode && setupColor == GoColor.WHITE);
        this.m_actionSaveCommands.setEnabled(isProgramAttached);
        this.m_actionSaveLog.setEnabled(isProgramAttached);
        this.m_actionSaveParameters.setEnabled(isProgramAttached && !isProgramDead && hasParameterCommands);
        this.m_actionSendFile.setEnabled(isProgramAttached);
        this.m_actionShowAnalyzeDialog.setEnabled(isProgramAttached);
        this.m_actionShowShell.setEnabled(isProgramAttached);
        this.m_actionToggleAutoNumber.setSelected(this.m_goGui.getAutoNumber());
        this.m_actionToggleBeepAfterMove.setEnabled(isProgramAttached);
        this.m_actionToggleBeepAfterMove.setSelected(this.m_goGui.getBeepAfterMove());
        boolean commentMonoFont = this.m_goGui.getCommentMonoFont();
        this.m_actionToggleCommentMonoFont.setSelected(commentMonoFont);
        this.m_actionToggleCompletion.setSelected(this.m_goGui.getCompletion());
        this.m_actionToggleShowCursor.setSelected(guiBoard.getShowCursor());
        this.m_actionToggleShowGrid.setSelected(guiBoard.getShowGrid());
        this.m_actionToggleShowInfoPanel.setSelected(this.m_goGui.isInfoPanelShown());
        this.m_actionToggleShowLastMove.setSelected(this.m_goGui.getShowLastMove());
        this.m_actionToggleShowMoveNumbers.setSelected(this.m_goGui.getShowMoveNumbers());
        boolean showSubtreeSizes = this.m_goGui.getShowSubtreeSizes();
        this.m_actionToggleShowSubtreeSizes.setSelected(showSubtreeSizes);
        this.m_actionToggleShowToolbar.setSelected(this.m_goGui.isToolbarShown());
        this.m_actionShowVariationsChildren.setSelected(this.m_goGui.getShowVariations() == GoGui.ShowVariations.CHILDREN);
        this.m_actionShowVariationsSiblings.setSelected(this.m_goGui.getShowVariations() == GoGui.ShowVariations.SIBLINGS);
        this.m_actionShowVariationsNone.setSelected(this.m_goGui.getShowVariations() == GoGui.ShowVariations.NONE);
        this.m_actionToggleTimeStamp.setSelected(this.m_goGui.getTimeStamp());
        this.m_actionTreeLabelsNumber.setSelected(this.m_goGui.getTreeLabels() == GameTreePanel.Label.NUMBER);
        this.m_actionTreeLabelsMove.setSelected(this.m_goGui.getTreeLabels() == GameTreePanel.Label.MOVE);
        this.m_actionTreeLabelsNone.setSelected(this.m_goGui.getTreeLabels() == GameTreePanel.Label.NONE);
        this.m_actionTreeSizeLarge.setSelected(this.m_goGui.getTreeSize() == GameTreePanel.Size.LARGE);
        this.m_actionTreeSizeNormal.setSelected(this.m_goGui.getTreeSize() == GameTreePanel.Size.NORMAL);
        this.m_actionTreeSizeSmall.setSelected(this.m_goGui.getTreeSize() == GameTreePanel.Size.SMALL);
        this.m_actionTreeSizeTiny.setSelected(this.m_goGui.getTreeSize() == GameTreePanel.Size.TINY);
        this.m_actionTruncate.setEnabled(hasFather);
        this.m_actionTruncateChildren.setEnabled(hasChildren);
    }

    private void updateClockResume(ConstClock clock) {
        boolean enabled = false;
        Object desc = null;
        if (!clock.isRunning() && clock.getToMove() != null) {
            this.m_actionClockResume.setEnabled(true);
            this.m_actionClockResume.setDescription(I18n.i18n("TT_CLOCK_RESUME"), clock.getTimeString(GoColor.BLACK), clock.getTimeString(GoColor.WHITE));
        } else {
            this.m_actionClockResume.setEnabled(false);
            this.m_actionClockResume.setDescription(null);
        }
    }

    private void updateClockStart(ConstClock clock) {
        if (!clock.isRunning() && clock.getToMove() == null) {
            this.m_actionClockStart.setEnabled(true);
            this.m_actionClockStart.setDescription(I18n.i18n("TT_CLOCK_START"), clock.getTimeString(GoColor.BLACK), clock.getTimeString(GoColor.WHITE));
        } else {
            this.m_actionClockStart.setEnabled(false);
            this.m_actionClockStart.setDescription(null);
        }
    }

    private void updateDetachProgram(boolean isProgramAttached, String name) {
        this.m_actionDetachProgram.setEnabled(isProgramAttached);
    }

    private void updateInterrupt(boolean isProgramAttached, boolean isInterruptSupported, boolean isCommandInProgress, String name) {
        if (isProgramAttached) {
            if (!isInterruptSupported) {
                if (name == null) {
                    this.m_actionInterrupt.setDescription(I18n.i18n("TT_INTERRUPT_UNSUPPORTED_UNKNOWN"));
                } else {
                    this.m_actionInterrupt.setDescription(I18n.i18n("TT_INTERRUPT_UNSUPPORTED_NAME"), name);
                }
            } else if (!isCommandInProgress) {
                if (name == null) {
                    this.m_actionInterrupt.setDescription(I18n.i18n("TT_INTERRUPT_NOCOMMAND_UNKNOWN"));
                } else {
                    this.m_actionInterrupt.setDescription(I18n.i18n("TT_INTERRUPT_NOCOMMAND_NAME"), name);
                }
            } else if (name == null) {
                this.m_actionInterrupt.setDescription(I18n.i18n("TT_INTERRUPT_UNKNOWN"));
            } else {
                this.m_actionInterrupt.setDescription(I18n.i18n("TT_INTERRUPT_NAME"), name);
            }
        } else {
            this.m_actionInterrupt.setDescription(I18n.i18n("TT_INTERRUPT_NOPROGRAM"));
        }
        this.m_actionInterrupt.setEnabled(isProgramAttached && isInterruptSupported);
    }

    private void updatePass(GoColor toMove) {
        assert (toMove.isBlackWhite());
        if (toMove == GoColor.BLACK) {
            this.m_actionPass.setDescription(I18n.i18n("TT_PASS_BLACK"));
        } else {
            this.m_actionPass.setDescription(I18n.i18n("TT_PASS_WHITE"));
        }
    }

    private void updatePlay(GoColor toMove, boolean isProgramAttached, boolean computerBoth, String name) {
        this.m_actionPlay.setEnabled(isProgramAttached);
        if (!isProgramAttached) {
            this.m_actionPlay.setDescription(I18n.i18n("TT_PLAY_NOPROGRAM"));
        } else if (computerBoth) {
            if (name == null) {
                this.m_actionPlay.setDescription(I18n.i18n("TT_PLAY_BOTH_UNKNOWN"));
            } else {
                this.m_actionPlay.setDescription(I18n.i18n("TT_PLAY_BOTH_NAME"), name);
            }
        } else if (name == null) {
            if (toMove == GoColor.BLACK) {
                this.m_actionPlay.setDescription(I18n.i18n("TT_PLAY_BLACK_UNKNOWN"));
            } else {
                this.m_actionPlay.setDescription(I18n.i18n("TT_PLAY_WHITE_UNKNOWN"));
            }
        } else if (toMove == GoColor.BLACK) {
            this.m_actionPlay.setDescription(I18n.i18n("TT_PLAY_BLACK_NAME"), name);
        } else {
            this.m_actionPlay.setDescription(I18n.i18n("TT_PLAY_WHITE_NAME"), name);
        }
    }

    private void updateSave(File file, boolean isModified) {
        this.m_actionSave.setEnabled(isModified);
        this.m_actionSaveAs.setEnabled(file != null);
        if (file == null) {
            this.m_actionSave.setDescription(I18n.i18n("TT_SAVE"));
        } else if (isModified) {
            this.m_actionSave.setDescription(I18n.i18n("TT_SAVE_FILE"), file);
        } else {
            this.m_actionSave.setDescription(I18n.i18n("TT_SAVE_FILE_NOTMODIFIED"), file);
        }
    }

    private void updateSetTimeLeft(ConstClock clock) {
        this.m_actionSetTimeLeft.setEnabled(clock.isInitialized());
    }
}

