/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gogui;

import java.awt.Frame;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.PointList;
import net.sf.gogui.gtp.AnalyzeType;
import net.sf.gogui.gtp.GtpUtil;
import net.sf.gogui.gui.GuiBoard;
import net.sf.gogui.gui.GuiBoardUtil;
import net.sf.gogui.gui.TextViewer;

public final class ShowAnalyzeText {
    private Frame m_owner;
    private GuiBoard m_guiBoard;
    private TextViewer m_textViewer;

    public ShowAnalyzeText(Frame owner, GuiBoard guiBoard) {
        this.m_owner = owner;
        this.m_guiBoard = guiBoard;
    }

    public void show(AnalyzeType type, GoPoint pointArg, String title, String response, boolean reuseWindow) {
        boolean highlight = type == AnalyzeType.HSTRING || type == AnalyzeType.HPSTRING;
        PointSelectionMarker listener = null;
        if (type == AnalyzeType.PSTRING || type == AnalyzeType.HPSTRING) {
            listener = new PointSelectionMarker(this.m_guiBoard);
        }
        response = response.replaceAll("\\A *\n", "");
        if (reuseWindow && this.m_textViewer != null) {
            this.m_textViewer.setText(title, response, highlight);
        } else {
            this.m_textViewer = new TextViewer(this.m_owner, title, response, highlight, (TextViewer.Listener)listener);
            this.m_textViewer.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    ShowAnalyzeText.this.m_textViewer = null;
                }
            });
            if (pointArg == null) {
                this.m_textViewer.setLocationByPlatform(true);
            } else {
                Point location = this.m_guiBoard.getLocationOnScreen(pointArg);
                this.m_textViewer.setLocation(location);
            }
            this.m_textViewer.setVisible(true);
        }
    }

    private static class PointSelectionMarker
    implements TextViewer.Listener {
        private final GuiBoard m_guiBoard;

        public PointSelectionMarker(GuiBoard guiBoard) {
            this.m_guiBoard = guiBoard;
        }

        public void textSelected(String text) {
            if (!this.m_guiBoard.isShowing()) {
                return;
            }
            PointList points = GtpUtil.parsePointString(text);
            GuiBoardUtil.showPointList(this.m_guiBoard, points);
        }
    }
}

