/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tex;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Locale;
import net.sf.gogui.game.ConstGameTree;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.NodeUtil;
import net.sf.gogui.go.ConstBoard;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.util.StringUtil;

public class TexWriter {
    private final PrintStream m_out;

    public TexWriter(String title, OutputStream out, ConstBoard board, String[][] markLabel, boolean[][] mark, boolean[][] markTriangle, boolean[][] markCircle, boolean[][] markSquare, boolean[][] markSelect) {
        this.m_out = new PrintStream(out);
        this.printBeginDocument();
        if (!StringUtil.isEmpty(title)) {
            this.m_out.println("\\section*{" + this.escape(title) + "}");
        }
        this.printBeginPSGo(board.getSize());
        this.printPosition(board, markLabel, mark, markTriangle, markCircle, markSquare, markSelect);
        this.printEndPSGo();
        this.m_out.println("\\\\");
        this.m_out.print(board.getToMove().getCapitalizedName());
        this.m_out.println(" to play");
        this.printEndDocument();
        this.m_out.close();
    }

    public TexWriter(String title, OutputStream out, ConstGameTree tree) {
        this.m_out = new PrintStream(out);
        this.printBeginDocument();
        if (!StringUtil.isEmpty(title)) {
            this.m_out.println("\\section*{" + this.escape(title) + "}");
        }
        this.printBeginPSGo(tree.getBoardSize());
        String comment = this.printTree(tree);
        this.printEndPSGo();
        if (!comment.equals("")) {
            this.m_out.println("\\\\");
            this.m_out.println(comment);
        }
        this.printEndDocument();
        this.m_out.close();
    }

    private String escape(String text) {
        text = text.replaceAll("\\#", "\\\\#");
        text = text.replaceAll("\\$", "\\\\\\$");
        text = text.replaceAll("%", "\\\\%");
        text = text.replaceAll("\\&", "\\\\&");
        text = text.replaceAll("~", "\\\\~{}");
        text = text.replaceAll("_", "\\\\_");
        text = text.replaceAll("\\^", "\\\\^{}");
        text = text.replaceAll("\\\\", "\\$\\\\backslash\\$");
        text = text.replaceAll("\\{", "\\\\{");
        text = text.replaceAll("\\}", "\\\\}");
        return text;
    }

    private String getStoneInTextString(int moveNumber, GoColor color) {
        return "\\stone[" + moveNumber + "]{" + (color == GoColor.BLACK ? "black" : "white") + "}";
    }

    private void printBeginDocument() {
        this.m_out.println("\\documentclass{article}");
        this.m_out.println("\\usepackage{psgo} % version 0.14 or newer");
        this.m_out.println("\\pagestyle{empty}");
        this.m_out.println("\\begin{document}");
        this.m_out.println();
    }

    private void printBeginPSGo(int size) {
        this.m_out.println("\\begin{psgoboard}[" + size + "]");
    }

    private void printColor(GoColor color) {
        if (color == GoColor.BLACK) {
            this.m_out.print("{black}");
        } else {
            assert (color == GoColor.WHITE);
            this.m_out.print("{white}");
        }
    }

    private void printCoordinates(GoPoint point) {
        assert (point != null);
        String s = point.toString();
        this.m_out.print("{" + s.substring(0, 1).toLowerCase(Locale.ENGLISH) + "}{" + s.substring(1) + "}");
    }

    private void printEndDocument() {
        this.m_out.println();
        this.m_out.println("\\end{document}");
    }

    private void printEndPSGo() {
        this.m_out.println("\\end{psgoboard}");
    }

    private String printTree(ConstGameTree tree) {
        StringBuilder comment = new StringBuilder();
        int size = tree.getBoardSize();
        ConstNode[][] firstMoveAtPoint = new ConstNode[size][size];
        ArrayList<ConstNode> needsComment = new ArrayList<ConstNode>();
        boolean blackToMove = true;
        this.m_out.println("\\setcounter{gomove}{0}");
        ConstNode node = tree.getRootConst();
        while (node != null) {
            boolean isPass;
            for (GoColor c : GoColor.BLACK_WHITE) {
                for (GoPoint stone : node.getSetup(c)) {
                    this.printStone(c, stone, null);
                }
            }
            Move move = node.getMove();
            if (move == null) {
                node = node.getChildConst();
                continue;
            }
            GoPoint point = move.getPoint();
            GoColor color = move.getColor();
            int moveNumber = NodeUtil.getMoveNumber(node);
            boolean isColorUnexpected = blackToMove && color != GoColor.BLACK || !blackToMove && color != GoColor.WHITE;
            boolean bl = isPass = point == null;
            if (isPass || firstMoveAtPoint[point.getX()][point.getY()] != null) {
                needsComment.add(node);
                this.m_out.print("\\pass");
                if (!isPass) {
                    this.m_out.print(" % \\move");
                    this.printCoordinates(point);
                }
                this.m_out.println(" % " + (blackToMove ? "B " : "W ") + moveNumber);
            } else {
                if (isColorUnexpected) {
                    this.m_out.println("\\toggleblackmove");
                    blackToMove = !blackToMove;
                }
                this.m_out.print("\\move");
                this.printCoordinates(point);
                this.m_out.println(" % " + (blackToMove ? "B " : "W ") + moveNumber);
                firstMoveAtPoint[point.getX()][point.getY()] = node;
            }
            blackToMove = !blackToMove;
            node = node.getChildConst();
        }
        for (int i = 0; i < needsComment.size(); ++i) {
            node = (ConstNode)needsComment.get(i);
            int moveNumber = NodeUtil.getMoveNumber(node);
            Move move = node.getMove();
            GoPoint point = move.getPoint();
            GoColor color = move.getColor();
            if (comment.length() > 0) {
                comment.append(" \\enspace\n");
            }
            comment.append(this.getStoneInTextString(moveNumber, color));
            if (point == null) {
                comment.append("~pass");
                continue;
            }
            int x = point.getX();
            int y = point.getY();
            comment.append("~at~");
            ConstNode first = firstMoveAtPoint[x][y];
            GoColor firstMoveColor = first.getMove().getColor();
            int firstMoveNumber = NodeUtil.getMoveNumber(first);
            comment.append(this.getStoneInTextString(firstMoveNumber, firstMoveColor));
        }
        return comment.toString();
    }

    private void printPosition(ConstBoard board, String[][] markLabel, boolean[][] mark, boolean[][] markTriangle, boolean[][] markCircle, boolean[][] markSquare, boolean[][] markSelect) {
        for (GoPoint p : board) {
            GoColor color = board.getColor(p);
            int x = p.getX();
            int y = p.getY();
            StringBuilder buffer = new StringBuilder(128);
            if (mark != null && mark[x][y]) {
                buffer.append("\\markma");
            }
            if (markTriangle != null && markTriangle[x][y]) {
                buffer.append("\\marktr");
            }
            if (markCircle != null && markCircle[x][y]) {
                buffer.append("\\markcr");
            }
            if (markSquare != null && markSquare[x][y]) {
                buffer.append("\\marksq");
            }
            if (markLabel != null && !StringUtil.isEmpty(markLabel[x][y])) {
                buffer.append("\\marklb{");
                buffer.append(markLabel[x][y]);
                buffer.append('}');
            }
            if (markSelect != null && markSelect[x][y]) {
                buffer.append("\\marksl");
            }
            String markup = null;
            if (buffer.length() > 0) {
                markup = buffer.toString();
            }
            if (color == GoColor.EMPTY) {
                if (markup == null) continue;
                this.m_out.print("\\markpos{" + markup + "}");
                this.printCoordinates(p);
                this.m_out.print("\n");
                continue;
            }
            this.printStone(color, p, markup);
        }
    }

    private void printStone(GoColor color, GoPoint point, String markup) {
        this.m_out.print("\\stone");
        if (markup != null) {
            this.m_out.print("[" + markup + "]");
        }
        this.printColor(color);
        this.printCoordinates(point);
        this.m_out.print("\n");
    }
}

