/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.PointList;
import net.sf.gogui.text.ParseError;

public class TextParser {
    private int m_width;
    private Character m_charBlack;
    private Character m_charWhite;
    private Board m_board;
    private BufferedReader m_reader;

    public Board getBoard() {
        return this.m_board;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Reader reader) throws ParseError {
        try {
            String line;
            this.m_reader = new BufferedReader(reader);
            this.m_charBlack = null;
            this.m_charWhite = null;
            do {
                if ((line = this.readLine()) != null) continue;
                throw new ParseError("could not find position");
            } while (!this.isBoardRow(line, true));
            this.m_board = new Board(this.m_width);
            this.checkToPlay(line);
            this.parseBoardRow(line, this.m_board.getSize() - 1);
            int i = 2;
            while ((line = this.readLine()) != null) {
                this.checkToPlay(line);
                if (!this.isBoardRow(line, false) && (line = this.readLine()) != null) {
                    this.checkToPlay(line);
                }
                if (line == null || !this.isBoardRow(line, false)) break;
                if (this.m_board.getSize() - i < 0) {
                    this.increaseBoardSize();
                }
                this.parseBoardRow(line, this.m_board.getSize() - i);
                ++i;
            }
            if (i != this.m_board.getSize() + 1) {
                this.shiftBoardDown(this.m_board.getSize() + 1 - i);
            }
        }
        finally {
            try {
                this.m_reader.close();
            }
            catch (IOException iOException) {}
            this.m_reader = null;
        }
    }

    private void checkToPlay(String line) {
        if ((line = line.toLowerCase()).contains("black to play") || line.contains("b to play") || line.contains("black to move") || line.contains("b to move")) {
            this.m_board.setToMove(GoColor.BLACK);
        }
        if (line.contains("white to play") || line.contains("w to play") || line.contains("white to move") || line.contains("w to move")) {
            this.m_board.setToMove(GoColor.WHITE);
        }
    }

    private int ignoreBeginning(String line) {
        char c;
        int i;
        for (i = 0; i < line.length() && (Character.isSpaceChar(c = line.charAt(i)) || Character.isDigit(c) || c == '$' || c == '|' || c == '>'); ++i) {
        }
        return i;
    }

    private void increaseBoardSize() {
        int newSize = this.m_board.getSize() + 1;
        Board newBoard = new Board(newSize);
        PointList black = new PointList();
        PointList white = new PointList();
        for (GoPoint p : this.m_board) {
            GoColor c = this.m_board.getColor(p);
            p = p.up(newSize);
            if (c == GoColor.BLACK) {
                black.add(p);
                continue;
            }
            if (c != GoColor.WHITE) continue;
            white.add(p);
        }
        newBoard.setup(black, white, this.m_board.getToMove());
        this.m_board = newBoard;
    }

    private boolean isBlack(char c) {
        if (this.m_charBlack != null) {
            return c == this.m_charBlack.charValue();
        }
        if (c == 'X' || c == '@' || c == '#' || c == 'x') {
            this.m_charBlack = Character.valueOf(c);
            return true;
        }
        return false;
    }

    private static boolean isEmpty(char c) {
        return c == '.' || c == ',' || c == '+';
    }

    private boolean isWhite(char c) {
        if (this.m_charWhite != null) {
            return c == this.m_charWhite.charValue();
        }
        if (c == 'o' || c == 'O') {
            this.m_charWhite = Character.valueOf(c);
            return true;
        }
        return false;
    }

    private boolean isBoardRow(String line, boolean initSize) throws ParseError {
        int size = 0;
        for (int i = this.ignoreBeginning(line); i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isSpaceChar(c)) continue;
            if (!this.isBlack(c) && !this.isWhite(c) && !TextParser.isEmpty(c)) break;
            ++size;
        }
        if (size < 3 || size > 25) {
            return false;
        }
        if (initSize) {
            this.m_width = size;
        }
        return true;
    }

    private void parseBoardRow(String line, int y) throws ParseError {
        int x = 0;
        for (int i = this.ignoreBeginning(line); i < line.length(); ++i) {
            PointList white;
            PointList black;
            char c = line.charAt(i);
            if (Character.isSpaceChar(c)) continue;
            if (this.isBlack(c)) {
                if (x >= this.m_board.getSize()) {
                    this.increaseBoardSize();
                }
                black = new PointList(this.m_board.getSetup(GoColor.BLACK));
                white = new PointList(this.m_board.getSetup(GoColor.WHITE));
                black.add(GoPoint.get(x, y));
                this.m_board.setup(black, white, this.m_board.getToMove());
                ++x;
                continue;
            }
            if (this.isWhite(c)) {
                if (x >= this.m_board.getSize()) {
                    this.increaseBoardSize();
                }
                black = new PointList(this.m_board.getSetup(GoColor.BLACK));
                white = new PointList(this.m_board.getSetup(GoColor.WHITE));
                white.add(GoPoint.get(x, y));
                this.m_board.setup(black, white, this.m_board.getToMove());
                ++x;
                continue;
            }
            if (!TextParser.isEmpty(c)) break;
            if (x >= this.m_board.getSize()) {
                this.increaseBoardSize();
            }
            ++x;
        }
    }

    private String readLine() throws ParseError {
        try {
            return this.m_reader.readLine();
        }
        catch (IOException e) {
            return null;
        }
    }

    private void shiftBoardDown(int deltaY) {
        int size = this.m_board.getSize();
        Board newBoard = new Board(size);
        PointList black = new PointList();
        PointList white = new PointList();
        for (int y = 0; y < size - deltaY; ++y) {
            for (int x = 0; x < size; ++x) {
                GoColor c = this.m_board.getColor(GoPoint.get(x, y + deltaY));
                GoPoint p = GoPoint.get(x, y);
                if (c == GoColor.BLACK) {
                    black.add(p);
                    continue;
                }
                if (c != GoColor.WHITE) continue;
                white.add(p);
            }
        }
        newBoard.setup(black, white, this.m_board.getToMove());
        this.m_board = newBoard;
    }
}

