/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.go;

import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.PointList;

public final class BoardConstants {
    private static BoardConstants[] s_boardConstants = new BoardConstants[26];
    private final int m_size;
    private final int m_handicapLine1;
    private final int m_handicapLine2;
    private final int m_handicapLine3;
    private final PointList m_allPoints;
    private final ConstPointList[] m_adjacent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BoardConstants get(int boardSize) {
        BoardConstants[] boardConstantsArray = s_boardConstants;
        synchronized (s_boardConstants) {
            if (s_boardConstants[boardSize] == null) {
                BoardConstants.s_boardConstants[boardSize] = new BoardConstants(boardSize);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return s_boardConstants[boardSize];
        }
    }

    public ConstPointList getAdjacent(GoPoint p) {
        return this.m_adjacent[p.getIndex()];
    }

    public ConstPointList getHandicapStones(int n) {
        PointList result = new PointList(9);
        if (n == 0) {
            return result;
        }
        int line1 = this.m_handicapLine1;
        int line2 = this.m_handicapLine2;
        int line3 = this.m_handicapLine3;
        if (line1 < 0) {
            return null;
        }
        if (n == 1 || n > 9 || n > 4 && line2 < 0) {
            return null;
        }
        if (n >= 1) {
            result.add(GoPoint.get(line1, line1));
        }
        if (n >= 2) {
            result.add(GoPoint.get(line3, line3));
        }
        if (n >= 3) {
            result.add(GoPoint.get(line1, line3));
        }
        if (n >= 4) {
            result.add(GoPoint.get(line3, line1));
        }
        if (n >= 5 && n % 2 != 0) {
            result.add(GoPoint.get(line2, line2));
            --n;
        }
        if (n >= 5) {
            result.add(GoPoint.get(line1, line2));
        }
        if (n >= 6) {
            result.add(GoPoint.get(line3, line2));
        }
        if (n >= 7) {
            result.add(GoPoint.get(line2, line1));
        }
        if (n >= 8) {
            result.add(GoPoint.get(line2, line3));
        }
        return result;
    }

    public ConstPointList getPoints() {
        return this.m_allPoints;
    }

    public int getSize() {
        return this.m_size;
    }

    public boolean isEdgeLine(int i) {
        return i == 0 || i == this.m_size - 1;
    }

    public boolean isHandicapLine(int i) {
        return i == this.m_handicapLine1 || i == this.m_handicapLine2 || i == this.m_handicapLine3;
    }

    public boolean isHandicap(GoPoint p) {
        int x = p.getX();
        int y = p.getY();
        return this.isHandicapLine(x) && this.isHandicapLine(y);
    }

    private BoardConstants(int size) {
        this.m_size = size;
        if (size >= 13) {
            this.m_handicapLine1 = 3;
            this.m_handicapLine3 = size - 4;
        } else if (size >= 7) {
            this.m_handicapLine1 = 2;
            this.m_handicapLine3 = size - 3;
        } else {
            this.m_handicapLine1 = -1;
            this.m_handicapLine3 = -1;
        }
        this.m_handicapLine2 = size >= 9 && size % 2 != 0 ? size / 2 : -1;
        this.m_allPoints = new PointList();
        this.m_adjacent = new ConstPointList[625];
        for (int x = 0; x < this.m_size; ++x) {
            for (int y = 0; y < this.m_size; ++y) {
                GoPoint p = GoPoint.get(x, y);
                this.m_allPoints.add(p);
                PointList adjacent = new PointList();
                if (x > 0) {
                    adjacent.add(GoPoint.get(x - 1, y));
                }
                if (x < this.m_size - 1) {
                    adjacent.add(GoPoint.get(x + 1, y));
                }
                if (y > 0) {
                    adjacent.add(GoPoint.get(x, y - 1));
                }
                if (y < this.m_size - 1) {
                    adjacent.add(GoPoint.get(x, y + 1));
                }
                this.m_adjacent[p.getIndex()] = adjacent;
            }
        }
    }
}

