/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.sf.gogui.gui.GuiAction;
import net.sf.gogui.gui.GuiCheckBoxMenuItem;
import net.sf.gogui.gui.GuiRadioButtonMenuItem;
import net.sf.gogui.gui.GuiUtil;

public class GuiMenu
extends JMenu {
    private final ArrayList<Integer> m_mnemonics = new ArrayList();

    public GuiMenu(String text) {
        GuiUtil.setTextAndMnemonic(this, text);
    }

    public JMenuItem add(JMenuItem item) {
        super.add(item);
        item.setToolTipText(null);
        item.setIcon(null);
        int mnemonic = item.getMnemonic();
        if (mnemonic > 0) {
            if (this.m_mnemonics.contains(mnemonic)) {
                System.err.println("Warning: duplicate mnemonic item: " + item.getText());
            }
            this.m_mnemonics.add(mnemonic);
        }
        return item;
    }

    public JMenuItem add(GuiAction action) {
        JMenuItem item = new JMenuItem(action);
        GuiUtil.setTextAndMnemonic(item, action.getNameWithMnemonic());
        return this.add(item);
    }

    public JMenuItem addRadioItem(ButtonGroup group, GuiAction action) {
        GuiRadioButtonMenuItem item = new GuiRadioButtonMenuItem(action);
        item.setIcon(null);
        group.add(item);
        return this.add(item);
    }

    public JMenuItem addCheckBoxItem(GuiAction action) {
        return this.add(new GuiCheckBoxMenuItem(action));
    }

    public void remove(JMenuItem item) {
        int mnemonic = item.getMnemonic();
        if (mnemonic > 0) {
            this.m_mnemonics.remove((Object)mnemonic);
        }
        super.remove(item);
    }
}

