/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import javax.swing.SwingUtilities;

public class LiveGfx {
    private boolean m_duringMultiLineResponse;
    private Listener m_listener;
    private final StringBuilder m_response = new StringBuilder(1024);

    public LiveGfx(Listener listener) {
        this.m_listener = listener;
        this.m_duringMultiLineResponse = false;
    }

    public boolean handleLine(String s) {
        s = s.trim();
        if (this.m_duringMultiLineResponse) {
            if (s.equals("")) {
                this.showGfx(this.m_response.toString());
                this.m_duringMultiLineResponse = false;
            } else {
                this.m_response.append(s);
                this.m_response.append('\n');
            }
            return true;
        }
        if ((s = s.trim()).startsWith("gogui-gfx:")) {
            int pos = s.indexOf(58);
            String response = s.substring(pos + 1);
            if (response.trim().equals("")) {
                this.m_response.setLength(0);
                this.m_duringMultiLineResponse = true;
            } else {
                this.showGfx(response);
            }
            return true;
        }
        return false;
    }

    private void showGfx(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LiveGfx.this.m_listener.showLiveGfx(text);
            }
        });
    }

    public static interface Listener {
        public void showLiveGfx(String var1);
    }
}

