/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.statistics;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.sf.gogui.game.GameInfo;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.StringInfo;
import net.sf.gogui.game.StringInfoColor;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.tools.statistics.CommandStatistics;
import net.sf.gogui.tools.statistics.Plot;
import net.sf.gogui.tools.statistics.PositionStatistics;
import net.sf.gogui.util.ErrorMessage;
import net.sf.gogui.util.FileUtil;
import net.sf.gogui.util.Histogram;
import net.sf.gogui.util.HtmlUtil;
import net.sf.gogui.util.StringUtil;
import net.sf.gogui.util.Table;
import net.sf.gogui.util.TableUtil;

public class Analyze {
    private static final Color[] PLOT_COLOR = new Color[]{Color.decode("#ff0000"), Color.decode("#ff9800"), Color.decode("#009800"), Color.decode("#00c0c0"), Color.decode("#0000ff"), Color.decode("#980098")};
    private static final int IMAGE_HEIGHT = 100;
    private int m_maxMove;
    private int m_movePrintInterval;
    private final int m_precision;
    private static final String COLOR_HEADER = "#b5c8f0";
    private static final String COLOR_INFO = "#e0e0e0";
    private final String m_output;
    private final Table m_table;
    private Table m_tableFinal;
    private final ArrayList<CommandStatistics> m_commandStatistics;
    private final ArrayList<String> m_commands;
    private ArrayList<GameGlobalCommand> m_gameGlobalCommands;
    private ArrayList<GameData> m_gameData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Analyze(String fileName, String output, int precision) throws Exception {
        if (output.equals("")) {
            this.m_output = FileUtil.removeExtension(new File(fileName), "dat");
        } else if (new File(output).isDirectory()) {
            File name = new File(new File(fileName).getName());
            this.m_output = output + File.separator + FileUtil.removeExtension(name, "dat");
        } else {
            this.m_output = output;
        }
        this.m_precision = precision;
        this.m_table = new Table();
        this.m_table.read(new File(fileName));
        if (this.m_table.getNumberColumns() < 2 || !this.m_table.getColumnTitle(0).equals("File") || !this.m_table.getColumnTitle(1).equals("Move")) {
            throw new ErrorMessage("Invalid table format");
        }
        this.m_commands = new ArrayList();
        for (int i = 2; i < this.m_table.getNumberColumns(); ++i) {
            this.m_commands.add(this.m_table.getColumnTitle(i));
        }
        this.m_commandStatistics = new ArrayList(this.m_commands.size());
        File file = new File(this.m_output + ".html");
        this.initGameData();
        this.findGameGlobalCommands();
        PrintStream out = new PrintStream(file);
        this.startHtml(out, "Statistics Summary");
        this.startInfo(out, "Statistics Summary");
        this.writeInfo(out);
        this.endInfo(out);
        out.print("<table border=\"0\">\n<tr><td>\n");
        this.writePlot(out, "<small>positions</small>", this.getCountFile().getName(), "<a href=\"" + this.getCountDataFile().getName() + "\"><small>data</small></a>");
        out.print("</td></tr>\n");
        for (int i = 0; i < this.m_commands.size(); ++i) {
            CommandStatistics commandStatistics = this.computeCommandStatistics(i);
            this.m_commandStatistics.add(commandStatistics);
            if (commandStatistics.getCount() <= 0 || commandStatistics.m_isBeginCommand) continue;
            String command = this.getCommand(i);
            Table table = commandStatistics.m_tableAtMove;
            Plot plot = this.generatePlotMove(this.getImgWidth(this.m_maxMove), this.getColor(command));
            plot.setFormatY(commandStatistics.m_format);
            File pngFile = this.getAvgPlotFile(i);
            File dataFile = this.getAvgDataFile(i);
            plot.setPlotStyleNoLines();
            plot.plot(pngFile, table, "Move", "Mean", "Error");
            FileWriter writer = new FileWriter(dataFile);
            try {
                table.save(writer, false);
            }
            finally {
                writer.close();
            }
            out.print("<tr><td>\n");
            this.writePlot(out, this.getCommandLink(i), pngFile.getName(), "<a href=\"" + dataFile.getName() + "\"><small>data</small></a>");
            out.print("</td></tr>\n");
        }
        out.print("</table>\n<hr>\n<table border=\"0\" cellpadding=\"0\">\n<tr>\n");
        int n = 0;
        for (int i = 0; i < this.m_commands.size(); ++i) {
            CommandStatistics commandStatistics = this.getCommandStatistics(i);
            if (commandStatistics.getCount() == 0) continue;
            out.print("<td valign=\"bottom\" bgcolor=\"#b5c8f0\">\n");
            this.writePlot(out, this.getCommandLink(i), this.getHistoFile(i).getName(), "");
            out.print("</td>\n");
            if (++n % 5 != 0) continue;
            out.print("</tr><tr>\n");
        }
        out.print("</tr>\n</table>\n<hr>\n");
        this.writeCommandsTable(out);
        out.print("<hr>\n");
        this.writeGameTable(out);
        this.finishHtml(out);
        out.close();
    }

    private void endInfo(PrintStream out) {
        out.print("</table></td></tr>\n</table>\n<hr>\n");
    }

    private void findGameGlobalCommands() throws Table.InvalidLocation {
        this.m_gameGlobalCommands = new ArrayList();
        for (int i = 0; i < this.m_commands.size(); ++i) {
            String command = this.getCommand(i);
            boolean isGameGlobal = true;
            ArrayList<String> gameResult = new ArrayList<String>();
            for (int j = 0; j < this.m_gameData.size(); ++j) {
                GameData data = this.m_gameData.get(j);
                Table table = TableUtil.select(this.m_table, "File", data.m_file, command);
                ArrayList<String> notEmpty = TableUtil.getColumnNotEmpty(table, command);
                if (notEmpty.size() > 1) {
                    isGameGlobal = false;
                    break;
                }
                if (notEmpty.size() == 1) {
                    gameResult.add(notEmpty.get(0));
                    continue;
                }
                gameResult.add("");
            }
            if (!isGameGlobal) continue;
            GameGlobalCommand gameGlobalCommand = new GameGlobalCommand(command, gameResult);
            this.m_gameGlobalCommands.add(gameGlobalCommand);
        }
    }

    private void finishHtml(PrintStream out) {
        out.print(HtmlUtil.getFooter("gogui-statistics") + "</body>\n</html>\n");
    }

    private File getAvgDataFile(int commandIndex) {
        return new File(this.m_output + ".command-" + commandIndex + ".avg.dat");
    }

    private File getAvgPlotFile(int commandIndex) {
        return new File(this.m_output + ".command-" + commandIndex + ".avg.png");
    }

    private String getCommand(int index) {
        return this.m_commands.get(index);
    }

    private File getCommandFile(int commandIndex) {
        return new File(this.m_output + ".command-" + commandIndex + ".html");
    }

    private CommandStatistics getCommandStatistics(int commandIndex) {
        return this.m_commandStatistics.get(commandIndex);
    }

    private File getCountFile() {
        return new File(this.m_output + ".count.png");
    }

    private File getCountDataFile() {
        return new File(this.m_output + ".count.dat");
    }

    private File getGameFile(int gameIndex) {
        return new File(this.m_output + ".game-" + gameIndex + ".html");
    }

    private GameGlobalCommand getGameGlobalCommand(int index) {
        return this.m_gameGlobalCommands.get(index);
    }

    private File getHistoFile(int commandIndex) {
        return new File(this.m_output + ".command-" + commandIndex + ".histo.png");
    }

    private File getHistoFile(int commandIndex, int moveIntervalIndex) {
        return new File(this.m_output + ".command-" + commandIndex + ".interval-" + moveIntervalIndex + ".histo.png");
    }

    private File getHistoFinalFile(int commandIndex) {
        return new File(this.m_output + ".command-" + commandIndex + ".final.png");
    }

    private File getPlotFile(int gameIndex, int commandIndex) {
        return new File(this.m_output + ".game-" + gameIndex + ".command-" + commandIndex + ".png");
    }

    private String getCommandLink(int commandIndex) {
        String link = "<small>" + this.getCommand(commandIndex) + "</small>";
        CommandStatistics statistics = this.getCommandStatistics(commandIndex);
        if (statistics.getCount() == 0 || statistics.m_isBeginCommand) {
            return link;
        }
        return "<a href=\"" + this.getCommandFile(commandIndex).getName() + "\">" + link + "</a>";
    }

    private CommandStatistics computeCommandStatistics(int index) throws Exception {
        String command = this.getCommand(index);
        return new CommandStatistics(command, this.m_table, this.m_tableFinal, this.getHistoFile(index), this.getHistoFinalFile(index), this.getColor(command), this.m_precision);
    }

    private Plot generatePlotMove(int width, Color color) {
        Plot plot = new Plot(width, 100, color, this.m_precision);
        plot.setSolidLineInterval(10.0);
        plot.setXMin(0.0);
        plot.setXMax(this.m_maxMove);
        plot.setXTics(5.0);
        plot.setXLabelPerTic(2);
        return plot;
    }

    private void generatePlot(int commandIndex, DecimalFormat format, int gameIndex, String gameFile) throws Exception {
        String command = this.getCommand(commandIndex);
        Table table = TableUtil.select(this.m_table, "File", gameFile, "Move", command);
        File file = this.getPlotFile(gameIndex, commandIndex);
        Plot plot = this.generatePlotMove(this.getImgWidth(this.m_maxMove), this.getColor(command));
        plot.setFormatY(format);
        plot.plot(file, table, "Move", command, null);
    }

    private Color getColor(String command) throws Table.InvalidLocation {
        int index = this.m_table.getColumnIndex(command);
        return PLOT_COLOR[(index - 2) % PLOT_COLOR.length];
    }

    private String getGameLink(File fromFile, int gameNumber, boolean shortName) {
        GameData data = this.m_gameData.get(gameNumber);
        File gameFile = new File(data.m_file);
        if (!gameFile.exists()) {
            return shortName ? gameFile.getName() : gameFile.toString();
        }
        String path = FileUtil.getRelativeURI(fromFile, gameFile);
        return "<a href=\"" + path + "\">" + (shortName ? gameFile.getName() : path) + "</a>";
    }

    private int getImgWidth(int numberMoves) {
        return Math.max(10, Math.min(numberMoves * 9, 1040));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGameData() throws Table.InvalidLocation, IOException {
        String file;
        this.m_gameData = new ArrayList();
        String last = null;
        GameData data = null;
        this.m_maxMove = 0;
        int[] count = new int[]{};
        for (int row = 0; row < this.m_table.getNumberRows(); ++row) {
            file = this.m_table.get("File", row);
            int move = Integer.parseInt(this.m_table.get("Move", row));
            if (move >= count.length) {
                int[] newCount = new int[move + 1];
                for (int i = 0; i < count.length; ++i) {
                    newCount[i] = count[i];
                }
                count = newCount;
            }
            int n = move;
            count[n] = count[n] + 1;
            this.m_maxMove = Math.max(this.m_maxMove, move);
            if (last == null || !file.equals(last)) {
                if (data != null) {
                    this.m_gameData.add(data);
                }
                data = new GameData();
                data.m_file = file;
                data.m_name = new File(file).getName();
            }
            ++data.m_numberPositions;
            data.m_finalPosition = move;
            last = file;
        }
        this.m_movePrintInterval = 1;
        while (this.m_movePrintInterval < this.m_maxMove / 30) {
            this.m_movePrintInterval *= 5;
            if (this.m_movePrintInterval >= this.m_maxMove / 30) break;
            this.m_movePrintInterval *= 2;
        }
        this.m_gameData.add(data);
        this.m_tableFinal = new Table(this.m_table.getColumnTitles());
        for (int i = 0; i < this.m_gameData.size(); ++i) {
            data = this.m_gameData.get(i);
            file = data.m_file;
            String finalPosition = Integer.toString(data.m_finalPosition);
            int row = TableUtil.findRow(this.m_table, "File", file, "Move", finalPosition);
            TableUtil.appendRow(this.m_tableFinal, this.m_table, row);
        }
        ArrayList<String> columnTitles = new ArrayList<String>();
        columnTitles.add("Move");
        columnTitles.add("Count");
        Table table = new Table(columnTitles);
        for (int i = 0; i < count.length; ++i) {
            if (count[i] == 0) continue;
            table.startRow();
            table.set("Move", i);
            table.set("Count", count[i]);
        }
        Plot plot = this.generatePlotMove(this.getImgWidth(this.m_maxMove), Color.DARK_GRAY);
        plot.setNoPlotYZero();
        plot.plot(this.getCountFile(), table, "Move", "Count", null);
        FileWriter writer = new FileWriter(this.getCountDataFile());
        try {
            table.save(writer, false);
        }
        finally {
            writer.close();
        }
    }

    private boolean isGameGlobalCommand(String command) {
        for (int i = 0; i < this.m_gameGlobalCommands.size(); ++i) {
            if (!this.getGameGlobalCommand(i).getName().equals(command)) continue;
            return true;
        }
        return false;
    }

    private void startHtml(PrintStream out, String title) {
        String charset = StringUtil.getDefaultEncoding();
        out.print("<html>\n<head>\n<title>" + title + "</title>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + charset + "\">\n" + HtmlUtil.getMeta("gogui-statistics") + "<style type=\"text/css\">\n<!--\na:link { color:#0000ee }\na:visited { color:#551a8b }\n.smalltable { font-size:80%; }\n.smalltable td { background-color:" + COLOR_INFO + "; text-align:center; }\n.smalltable th { background-color:" + COLOR_HEADER + ";  vertical-align:top; }\n.smalltable table { border:0; cellpadding:0; }\n-->\n</style>\n</head>\n<body bgcolor=\"white\" text=\"black\">\n");
    }

    private void startInfo(PrintStream out, String title) {
        out.print("<table border=\"0\" width=\"100%\" bgcolor=\"#b5c8f0\">\n<tr><td>\n<h1>" + title + "</h1>\n</td></tr>\n</table>\n<table width=\"100%\" bgcolor=\"" + COLOR_INFO + "\" >\n<tr><td><table style=\"font-size:80%\" cellpadding=\"0\">\n");
    }

    private void writeCommandPage(int commandIndex) throws Exception {
        String command = this.getCommand(commandIndex);
        CommandStatistics commandStatistics = this.getCommandStatistics(commandIndex);
        File file = this.getCommandFile(commandIndex);
        PrintStream out = new PrintStream(file);
        this.startHtml(out, command);
        this.startInfo(out, command);
        this.writeInfoBasics(out);
        this.writeHtmlRow(out, "Command Index", commandIndex);
        this.endInfo(out);
        if (!commandStatistics.m_isBeginCommand) {
            out.print("<p><img src=\"" + this.getAvgPlotFile(commandIndex).getName() + "\"></p>\n");
        }
        this.writeCommandStatistics(out, commandIndex);
        out.print("<hr>\n");
        out.print("<table border=\"0\" cellspacing=\"0\" cellpadding=\"5\">\n");
        out.print("<tr><td><small>All</small><br><img src=\"" + this.getHistoFile(commandIndex).getName() + "\"></td>\n");
        if (commandStatistics.m_statisticsFinal.getCount() > 0) {
            out.print("<td><small>Final</small><br><img src=\"" + this.getHistoFinalFile(commandIndex).getName() + "\"></td>");
        }
        out.print("</tr>\n</table>\n");
        for (int i = 0; i < this.m_maxMove; i += this.m_movePrintInterval) {
            Histogram histogram = commandStatistics.getStatistics((int)i).m_histogram;
            if (commandStatistics.getStatistics(i).getCount() == 0) continue;
            Table histoTable = TableUtil.fromHistogram(histogram, command);
            File histoFile = this.getHistoFile(commandIndex, i);
            Color color = this.getColor(command);
            Plot plot = new Plot(180, 135, color, this.m_precision);
            commandStatistics.setHistogramProperties(plot);
            plot.plot(histoFile, histoTable, command, "Count", null);
            out.print("<table align=\"left\" border=\"0\"><tr><td align=\"center\"><small>" + i + "</small><br><img src=\"" + this.getHistoFile(commandIndex, i).getName() + "\"></td></tr></table>\n");
        }
        out.print("<br clear=\"left\">\n<hr>\n");
        this.writeGamePlots(out, commandIndex);
        this.finishHtml(out);
        out.close();
    }

    private void writeCommandStatistics(PrintStream out, int commandIndex) throws Exception {
        CommandStatistics commandStatistics = this.getCommandStatistics(commandIndex);
        String command = this.getCommand(commandIndex);
        PositionStatistics statisticsAll = commandStatistics.m_statisticsAll;
        PositionStatistics finalStatistics = commandStatistics.m_statisticsFinal;
        out.print("<table class=\"smalltable\">\n");
        out.print("<tr>");
        out.print("<th>Move</th>");
        this.writeStatisticsTableHeader(out);
        out.print("</tr>\n");
        DecimalFormat format = commandStatistics.m_format;
        for (int i = 0; i < this.m_maxMove; i += this.m_movePrintInterval) {
            PositionStatistics statisticsAtMove = commandStatistics.getStatistics(i);
            out.print("<tr><td>" + i + "</td>");
            this.writeStatisticsTableData(out, statisticsAtMove, format, false);
            out.print("</tr>\n");
        }
        out.print("<tr style=\"font-weight:bold\"><td>Final</td>");
        this.writeStatisticsTableData(out, finalStatistics, format, false);
        out.print("</tr>\n");
        out.print("<tr style=\"font-weight:bold\"><td>All</td>");
        this.writeStatisticsTableData(out, statisticsAll, format, !this.isGameGlobalCommand(command));
        out.print("</tr>\n");
        out.print("</table>\n");
    }

    private void writeCommandsTable(PrintStream out) throws Exception {
        out.print("<table class=\"smalltable\">\n<thead><tr><th>Command</th>");
        this.writeStatisticsTableHeader(out);
        out.print("</tr></thead>\n");
        for (int i = 0; i < this.m_commands.size(); ++i) {
            CommandStatistics commandStatistics = this.getCommandStatistics(i);
            int count = commandStatistics.getCount();
            if (count > 0 && !commandStatistics.m_isBeginCommand) {
                this.writeCommandPage(i);
            }
            PositionStatistics statisticsAll = commandStatistics.m_statisticsAll;
            out.print("<tr><td style=\"background-color:#b5c8f0\">" + this.getCommandLink(i) + "</td>");
            this.writeStatisticsTableData(out, statisticsAll, commandStatistics.m_format, !this.isGameGlobalCommand(this.getCommand(i)));
            out.print("</tr>\n");
        }
        out.print("</table>\n");
    }

    private void writeGamePage(String game, String name, int gameNumber) throws Exception {
        int i;
        File file = this.getGameFile(gameNumber);
        PrintStream out = new PrintStream(file);
        String title = "Game " + (gameNumber + 1) + " (" + name + ")";
        this.startHtml(out, title);
        this.startInfo(out, title);
        this.writeInfoBasics(out);
        this.writeHtmlRow(out, "Game Index", gameNumber);
        this.writeHtmlRow(out, "File", this.getGameLink(file, gameNumber, false));
        try {
            String result;
            String playerWhite;
            FileInputStream in = new FileInputStream(new File(game));
            SgfReader reader = new SgfReader(in, new File(game), null, 0L);
            GameTree tree = reader.getTree();
            GameInfo info = tree.getGameInfo(tree.getRoot());
            String playerBlack = info.get(StringInfoColor.NAME, GoColor.BLACK);
            if (playerBlack == null) {
                playerBlack = "?";
            }
            if ((playerWhite = info.get(StringInfoColor.NAME, GoColor.WHITE)) == null) {
                playerWhite = "?";
            }
            if ((result = info.get(StringInfo.RESULT)) == null) {
                result = "?";
            }
            this.writeHtmlRow(out, "Black", playerBlack);
            this.writeHtmlRow(out, "White", playerWhite);
            this.writeHtmlRow(out, "Result", result);
            ((InputStream)in).close();
        }
        catch (Exception e) {
            StringUtil.printException(e);
        }
        this.endInfo(out);
        out.print("<table border=\"0\">\n");
        for (int i2 = 0; i2 < this.m_commands.size(); ++i2) {
            CommandStatistics commandStatistics = this.getCommandStatistics(i2);
            if (commandStatistics.getCount() <= 0 || commandStatistics.m_isBeginCommand) continue;
            this.generatePlot(i2, commandStatistics.m_format, gameNumber, game);
            out.print("<tr><td align=\"center\">" + this.getCommandLink(i2) + "<br><img src=\"" + this.getPlotFile(gameNumber, i2).getName() + "\"></td></tr>\n");
        }
        out.print("</table>\n<hr>\n");
        Table table = TableUtil.select(this.m_table, "File", game);
        out.print("<table class=\"smalltable\">\n<thead><tr>");
        for (i = 1; i < table.getNumberColumns(); ++i) {
            String command = table.getColumnTitle(i);
            if (TableUtil.allEmpty(table, command)) continue;
            out.print("<th>" + command + "</th>");
        }
        out.print("</tr></thead>\n");
        for (i = 0; i < table.getNumberRows(); ++i) {
            out.print("<tr>");
            for (int j = 1; j < table.getNumberColumns(); ++j) {
                String command = table.getColumnTitle(j);
                if (TableUtil.allEmpty(table, command)) continue;
                String value = table.get(command, i);
                if (value == null) {
                    value = "";
                }
                out.print("<td>" + value + "</td>");
            }
            out.print("</tr>\n");
        }
        out.print("</table>\n");
        this.finishHtml(out);
        out.close();
    }

    private void writeGamePlots(PrintStream out, int commandIndex) throws Exception {
        out.print("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n");
        for (int i = 0; i < this.m_gameData.size(); ++i) {
            String plotFile = this.getPlotFile(i, commandIndex).getName();
            File file = this.getGameFile(i);
            out.print("<tr><td align=\"left\"><small><a href=\"" + file.getName() + "\">Game " + (i + 1) + "</a> (" + this.getGameLink(file, i, true) + "):</small><br>\n<img src=\"" + plotFile + "\"></td></tr>\n");
        }
        out.print("</table>\n");
    }

    private void writeGameTable(PrintStream out) throws Exception {
        int i;
        out.print("<table class=\"smalltable\">\n<thead><tr><th>Game</th><th>File</th><th>Positions</th>");
        for (i = 0; i < this.m_gameGlobalCommands.size(); ++i) {
            if (this.getGameGlobalCommand(i).allEmpty()) continue;
            out.print("<th>" + this.getGameGlobalCommand(i).m_name + "</th>");
        }
        out.print("</tr></thead>\n");
        for (i = 0; i < this.m_gameData.size(); ++i) {
            GameData data = this.m_gameData.get(i);
            String file = this.getGameFile(i).getName();
            out.print("<tr><td style=\"background-color:#b5c8f0\"><a href=\"" + file + "\">Game " + (i + 1) + "</a></td><td>" + data.m_name + "</td><td>" + data.m_numberPositions + "</td>");
            for (int j = 0; j < this.m_gameGlobalCommands.size(); ++j) {
                if (this.getGameGlobalCommand(j).allEmpty()) continue;
                out.print("<td>" + this.getGameGlobalCommand(j).getResult(i) + "</td>");
            }
            out.print("</tr>\n");
            this.writeGamePage(data.m_file, data.m_name, i);
        }
        out.print("</table>\n");
    }

    private void writeHtmlRow(PrintStream out, String label, String value) throws Exception {
        out.print("<tr><th align=\"left\">" + label + ":</th><td align=\"left\">" + value + "</td></tr>\n");
    }

    private void writeHtmlRow(PrintStream out, String label, int value) throws Exception {
        this.writeHtmlRow(out, label, Integer.toString(value));
    }

    private void writeInfoBasics(PrintStream out) throws Exception {
        this.writeTableProperty(out, "Name");
        this.writeTableProperty(out, "Version");
        this.writeTableProperty(out, "Date");
        this.writeTableProperty(out, "Host");
        this.writeTableProperty(out, "Program");
    }

    private void writeInfo(PrintStream out) throws Exception {
        this.writeInfoBasics(out);
        this.writeTableProperty(out, "Size");
        this.writeTableProperty(out, "Games");
        this.writeHtmlRow(out, "Positions", this.m_table.getNumberRows());
        this.writeTableProperty(out, "Backward");
    }

    private void writePlot(PrintStream out, String title, String file, String info) {
        out.print("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n<tr><td><table width=\"100%\" border=\"0\" cellpadding=\"0\" bgcolor=\"#b5c8f0\">\n<tr><td");
        if (!info.equals("")) {
            out.print(" width=\"90%\"");
        }
        out.print(" align=\"center\">\n" + title + "\n</td>");
        if (!info.equals("")) {
            out.print("<td align=\"right\">\n" + info + "\n</td>");
        }
        out.print("</tr></table></td></tr>\n<tr><td bgcolor=\"#e0e0e0\">\n<img src=\"" + file + "\"></td></tr>\n</table>\n");
    }

    private void writeStatisticsTableData(PrintStream out, PositionStatistics statistics, DecimalFormat format, boolean withMaxError) {
        boolean empty = statistics.getCount() == 0;
        boolean greaterOne = statistics.getCount() > 1;
        out.print("<td>");
        if (!empty) {
            out.print(format.format(statistics.getMean()));
        }
        out.print("</td><td>");
        if (greaterOne) {
            out.print(format.format(statistics.getDeviation()));
        } else if (!empty) {
            out.print("");
        }
        out.print("</td><td>");
        if (greaterOne) {
            out.print(format.format(statistics.getError()));
        } else if (!empty) {
            out.print("");
        }
        out.print("</td><td>");
        if (greaterOne && withMaxError) {
            int movesPerGame = this.m_table.getNumberRows() / this.m_gameData.size();
            out.print(format.format(statistics.getMaxError(movesPerGame)));
        } else if (!empty) {
            out.print("");
        }
        out.print("</td><td>");
        if (greaterOne) {
            out.print(format.format(statistics.getMin()));
        } else if (!empty) {
            out.print("");
        }
        out.print("</td><td>");
        if (greaterOne) {
            out.print(format.format(statistics.getMax()));
        } else if (!empty) {
            out.print("");
        }
        out.print("</td><td>");
        if (greaterOne) {
            out.print(format.format(statistics.getSum()));
        } else if (!empty) {
            out.print("");
        }
        out.print("</td><td>");
        out.print(statistics.getCount());
        out.print("</td><td>");
        out.print(statistics.m_numberNoResult);
        out.print("</td>");
    }

    private void writeStatisticsTableHeader(PrintStream out) {
        out.print("<th>Mean</th><th>Deviation</th><th>Error</th><th>MaxError</th><th>Min</th><th>Max</th><th>Sum</th><th>Count</th><th>Unknown</th>");
    }

    private void writeTableProperty(PrintStream out, String key) throws Exception {
        this.writeHtmlRow(out, key, this.m_table.getProperty(key, "?"));
    }

    private static class GameData {
        public String m_file;
        public String m_name;
        public int m_finalPosition;
        public int m_numberPositions;

        private GameData() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GameGlobalCommand {
        private boolean m_allEmpty;
        private final String m_name;
        private final ArrayList<String> m_results;

        public GameGlobalCommand(String name, ArrayList<String> results) {
            this.m_name = name;
            this.m_results = results;
            this.initAllEmpty();
        }

        public boolean allEmpty() {
            return this.m_allEmpty;
        }

        public String getName() {
            return this.m_name;
        }

        public String getResult(int game) {
            return this.m_results.get(game);
        }

        private void initAllEmpty() {
            this.m_allEmpty = false;
            for (int game = 0; game < this.m_results.size(); ++game) {
                String result = this.getResult(game);
                if (StringUtil.isEmpty(result)) continue;
                return;
            }
            this.m_allEmpty = true;
        }
    }
}

