/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.game;

import net.sf.gogui.game.BoardUpdater;
import net.sf.gogui.game.Clock;
import net.sf.gogui.game.ConstClock;
import net.sf.gogui.game.ConstGame;
import net.sf.gogui.game.ConstGameInfo;
import net.sf.gogui.game.ConstGameTree;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.GameInfo;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.MarkType;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.NodeUtil;
import net.sf.gogui.game.StringInfo;
import net.sf.gogui.game.StringInfoColor;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.ConstBoard;
import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Komi;
import net.sf.gogui.go.Move;
import net.sf.gogui.util.ObjectUtil;

public class Game
implements ConstGame {
    private boolean m_modified;
    private final Board m_board;
    private final BoardUpdater m_boardUpdater = new BoardUpdater();
    private GameTree m_tree;
    private Node m_current;
    private ConstNode m_clockNode;
    private final Clock m_clock;

    public Game(int boardSize) {
        this(boardSize, null, null, "", null);
    }

    public Game(int boardSize, Komi komi, ConstPointList handicap, String rules, TimeSettings timeSettings) {
        this.m_board = new Board(boardSize);
        this.m_clock = new Clock();
        this.init(boardSize, komi, handicap, rules, timeSettings);
    }

    public Game(GameTree tree) {
        int boardSize = tree.getBoardSize();
        this.m_board = new Board(boardSize);
        this.m_clock = new Clock();
        this.init(tree);
    }

    public void addMarked(GoPoint point, MarkType type) {
        this.m_current.addMarked(point, type);
        this.setModified();
    }

    public void clearModified() {
        this.m_modified = false;
    }

    public void createNewChild() {
        Node node = new Node();
        this.m_current.append(node);
        this.m_current = node;
        this.setModified();
    }

    public ConstBoard getBoard() {
        return this.m_board;
    }

    public ConstClock getClock() {
        return this.m_clock;
    }

    public ConstNode getCurrentNode() {
        return this.m_current;
    }

    public ConstGameInfo getGameInfo(ConstNode node) {
        return this.m_tree.getGameInfoConst(node);
    }

    public ConstNode getGameInfoNode() {
        return this.m_tree.getGameInfoNode(this.m_current);
    }

    public ConstNode getGameInfoNode(ConstNode node) {
        return this.m_tree.getGameInfoNode(node);
    }

    public int getMoveNumber() {
        return NodeUtil.getMoveNumber(this.getCurrentNode());
    }

    public ConstNode getRoot() {
        return this.m_tree.getRoot();
    }

    public int getSize() {
        return this.m_board.getSize();
    }

    public GoColor getToMove() {
        return this.m_board.getToMove();
    }

    public ConstGameTree getTree() {
        return this.m_tree;
    }

    public void gotoNode(ConstNode node) {
        assert (node != null);
        assert (NodeUtil.getRoot(node) == this.getRoot());
        this.m_current = (Node)node;
        this.updateBoard();
    }

    public void haltClock() {
        this.m_clock.halt();
    }

    public ConstNode getClockNode() {
        return this.m_clockNode;
    }

    public final void init(int boardSize, Komi komi, ConstPointList handicap, String rules, TimeSettings timeSettings) {
        this.init(new GameTree(boardSize, komi, handicap, rules, timeSettings));
    }

    public final void init(GameTree tree) {
        this.m_tree = tree;
        this.m_current = this.m_tree.getRoot();
        this.updateBoard();
        this.updateClock();
        this.m_clock.reset();
        this.m_clock.halt();
        this.m_modified = false;
        this.m_clockNode = null;
    }

    public boolean isModified() {
        return this.m_modified;
    }

    public void keepOnlyMainVariation() {
        this.m_tree.keepOnlyMainVariation();
        this.setModified();
    }

    public void keepOnlyPosition() {
        ConstGameInfo info = this.getGameInfo(this.m_current);
        this.m_tree = NodeUtil.makeTreeFromPosition(info, this.m_board);
        this.m_board.init(this.m_board.getSize());
        this.m_current = this.m_tree.getRoot();
        this.updateBoard();
        this.setModified();
    }

    public void makeMainVariation() {
        NodeUtil.makeMainVariation(this.m_current);
        this.setModified();
    }

    public void play(Move move) {
        this.m_clock.stopMove();
        Node node = new Node(move);
        GoColor color = move.getColor();
        if (this.m_clock.isInitialized() && NodeUtil.isTimeLeftKnown(this.m_current, color)) {
            assert (!this.m_clock.isRunning());
            long timeLeft = this.m_clock.getTimeLeft(color) / 1000L;
            node.setTimeLeft(color, timeLeft);
            if (this.m_clock.isInByoyomi(color)) {
                node.setMovesLeft(color, this.m_clock.getMovesLeft(color));
            }
        }
        this.m_current.append(node);
        this.m_current = node;
        this.updateBoard();
        this.setModified();
        this.m_clock.startMove(this.getToMove());
    }

    public void removeMarked(GoPoint point, MarkType type) {
        this.m_current.removeMarked(point, type);
        this.setModified();
    }

    public void resetClock() {
        this.m_clock.reset();
    }

    public void restoreClock() {
        if (!this.m_clock.isInitialized()) {
            return;
        }
        NodeUtil.restoreClock(this.getCurrentNode(), this.m_clock);
    }

    public void resumeClock() {
        this.m_clock.resume();
    }

    public void setClockListener(Clock.Listener listener) {
        this.m_clock.setListener(listener);
    }

    public void setComment(String comment) {
        this.setComment(comment, this.m_current);
    }

    public void setComment(String comment, ConstNode node) {
        assert (NodeUtil.getRoot(node) == this.getRoot());
        if (!ObjectUtil.equals((Object)comment, (Object)node.getComment())) {
            this.setModified();
        }
        ((Node)node).setComment(comment);
    }

    public void setGameInfo(ConstGameInfo info, ConstNode node) {
        assert (NodeUtil.getRoot(node) == this.getRoot());
        ((Node)node).createGameInfo();
        if (!((Node)node).getGameInfo().equals(info)) {
            ((Node)node).getGameInfo().copyFrom(info);
            this.updateClock();
            this.setModified();
        }
    }

    public void setKomi(Komi komi) {
        Node node = this.m_tree.getGameInfoNode(this.m_current);
        GameInfo info = node.getGameInfo();
        info.setKomi(komi);
        this.setGameInfo(info, node);
    }

    public void setLabel(GoPoint point, String value) {
        if (!ObjectUtil.equals((Object)value, (Object)this.m_current.getLabel(point))) {
            this.setModified();
        }
        this.m_current.setLabel(point, value);
    }

    public void setPlayer(GoColor c, String name) {
        Node node = this.m_tree.getGameInfoNode(this.m_current);
        GameInfo info = node.getGameInfo();
        info.set(StringInfoColor.NAME, c, name);
        this.setGameInfo(info, node);
    }

    public void setResult(String result) {
        Node node = this.m_tree.getGameInfoNode(this.m_current);
        GameInfo info = node.getGameInfo();
        info.set(StringInfo.RESULT, result);
        this.setGameInfo(info, node);
    }

    public void setToMove(GoColor color) {
        assert (color != null);
        assert (!color.equals((Object)GoColor.EMPTY));
        if (!ObjectUtil.equals((Object)((Object)color), (Object)((Object)this.m_current.getPlayer())) || color.equals((Object)this.m_board.getToMove())) {
            this.setModified();
        }
        this.m_current.setPlayer(color);
        this.updateBoard();
    }

    public void setTimeSettings(TimeSettings timeSettings) {
        Node node = this.m_tree.getGameInfoNode(this.m_current);
        GameInfo info = node.getGameInfo();
        info.setTimeSettings(timeSettings);
        this.setGameInfo(info, node);
        this.m_clock.setTimeSettings(timeSettings);
        if (this.m_current == node) {
            this.m_clock.reset();
        }
    }

    public void setTimeLeft(GoColor c, double seconds) {
        this.setTimeLeft(this.getCurrentNode(), c, seconds);
    }

    public void setTimeLeft(ConstNode node, GoColor c, double seconds) {
        ((Node)node).setTimeLeft(c, seconds);
    }

    public void setMovesLeft(GoColor c, int moves) {
        this.setMovesLeft(this.getCurrentNode(), c, moves);
    }

    public void setMovesLeft(ConstNode node, GoColor c, int moves) {
        ((Node)node).setMovesLeft(c, moves);
    }

    public void setup(GoPoint p, GoColor c) {
        assert (p != null);
        this.m_current.removeSetup(p);
        Node father = this.m_current.getFather();
        if (father != null) {
            this.m_boardUpdater.update(this.getTree(), father, this.m_board);
            GoColor oldColor = this.m_board.getColor(p);
            if (oldColor == c) {
                this.updateBoard();
                return;
            }
        }
        if (c != GoColor.EMPTY || father != null) {
            this.m_current.addStone(c, p);
        }
        this.setModified();
        this.updateBoard();
    }

    public void startClock() {
        this.m_clock.startMove(this.getToMove());
        this.m_clockNode = this.m_current;
    }

    public void truncate() {
        Node father = this.m_current.getFather();
        assert (father != null);
        Node oldCurrentNode = this.m_current;
        this.m_current = father;
        this.m_current.removeChild(oldCurrentNode);
        this.setModified();
    }

    public void truncateChildren() {
        NodeUtil.truncateChildren(this.m_current);
        this.setModified();
    }

    private void setModified() {
        this.m_modified = true;
    }

    private void updateBoard() {
        this.m_boardUpdater.update(this.m_tree, this.m_current, this.m_board);
    }

    private void updateClock() {
        ConstNode node = this.getGameInfoNode();
        ConstGameInfo info = node.getGameInfoConst();
        if (info != null) {
            this.m_clock.setTimeSettings(info.getTimeSettings());
        }
    }
}

