/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.sgf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.gogui.game.TimeSettings;

public final class SgfUtil {
    public static String getOvertime(TimeSettings timeSettings) {
        if (!timeSettings.getUseByoyomi()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int byoyomiMoves = timeSettings.getByoyomiMoves();
        long byoyomi = timeSettings.getByoyomi();
        result.append(byoyomiMoves);
        result.append(" moves / ");
        if (byoyomi % 60000L == 0L) {
            result.append(byoyomi / 60000L);
            result.append(" min");
        } else {
            result.append(byoyomi / 1000L);
            result.append(" sec");
        }
        return result.toString();
    }

    public static Overtime parseOvertime(String value) {
        value = value.trim();
        Overtime result = null;
        result = SgfUtil.parseOvertime(value, "(\\d+)\\s*moves\\s*/\\s*(\\d+)\\s*sec", true, 1000L);
        if (result != null) {
            return result;
        }
        result = SgfUtil.parseOvertime(value, "(\\d+)\\s*moves\\s*/\\s*(\\d+)\\s*min", true, 60000L);
        if (result != null) {
            return result;
        }
        result = SgfUtil.parseOvertime(value, "(\\d+)/(\\d+)\\s*canadian", true, 1000L);
        if (result != null) {
            return result;
        }
        return result;
    }

    public static long parseTime(String value) {
        value = value.trim();
        try {
            return (long)(Double.parseDouble(value) * 1000.0);
        }
        catch (NumberFormatException numberFormatException) {
            block12: {
                try {
                    Pattern pattern = Pattern.compile("(\\d{1,2}):(\\d{2})");
                    Matcher matcher = pattern.matcher(value);
                    if (matcher.matches()) {
                        assert (matcher.groupCount() == 2);
                        return (long)Integer.parseInt(matcher.group(1)) * 60000L + (long)Integer.parseInt(matcher.group(2)) * 1000L;
                    }
                    pattern = Pattern.compile("(\\d+):(\\d{2}):(\\d{2})");
                    matcher = pattern.matcher(value);
                    if (matcher.matches()) {
                        assert (matcher.groupCount() == 3);
                        return (long)Integer.parseInt(matcher.group(1)) * 3600000L + (long)Integer.parseInt(matcher.group(2)) * 60000L + (long)Integer.parseInt(matcher.group(3)) * 1000L;
                    }
                    pattern = Pattern.compile("(\\d+)\\s*(?:h|hr|hrs|hours|hours)(?:\\s+each)?+");
                    matcher = pattern.matcher(value);
                    if (matcher.matches()) {
                        assert (matcher.groupCount() == 1);
                        return (long)Integer.parseInt(matcher.group(1)) * 3600000L;
                    }
                    pattern = Pattern.compile("(\\d+)\\s*(?:m|min)");
                    matcher = pattern.matcher(value);
                    if (matcher.matches()) {
                        assert (matcher.groupCount() == 1);
                        return (long)Integer.parseInt(matcher.group(1)) * 60000L;
                    }
                }
                catch (NumberFormatException e2) {
                    if ($assertionsDisabled) break block12;
                    throw new AssertionError();
                }
            }
            return -1L;
        }
    }

    private SgfUtil() {
    }

    private static Overtime parseOvertime(String value, String regex, boolean byoyomiMovesFirst, long timeUnitFactor) {
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            assert (matcher.groupCount() == 2);
            try {
                String group2;
                String group1;
                if (byoyomiMovesFirst) {
                    group1 = matcher.group(1);
                    group2 = matcher.group(2);
                } else {
                    group1 = matcher.group(2);
                    group2 = matcher.group(1);
                }
                Overtime overtime = new Overtime();
                overtime.m_byoyomiMoves = Integer.parseInt(group1);
                overtime.m_byoyomi = (long)(Double.parseDouble(group2) * (double)timeUnitFactor);
                return overtime;
            }
            catch (NumberFormatException e) {
                assert (false);
                return null;
            }
        }
        return null;
    }

    public static final class Overtime {
        public long m_byoyomi;
        public int m_byoyomiMoves;
    }
}

