/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtp;

import java.util.ArrayList;
import java.util.List;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.ConstBoard;
import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Komi;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpClientBase;
import net.sf.gogui.gtp.GtpClientUtil;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpUtil;
import net.sf.gogui.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GtpSynchronizer {
    private boolean m_fillPasses;
    private boolean m_isOutOfSync;
    private boolean m_isSupportedHandicap;
    private boolean m_isSupportedPlaySequence;
    private boolean m_isSupportedSetupPlayer;
    private boolean m_isSupportedGGUndo;
    private boolean m_isSupportedUndo;
    private boolean m_isSupportedSetup;
    private Komi m_komi;
    private TimeSettings m_timeSettings;
    private final Listener m_listener;
    private GtpClientBase m_gtp;
    private Board m_engineState;

    public GtpSynchronizer(GtpClientBase gtp) {
        this(gtp, null, false);
    }

    public GtpSynchronizer(GtpClientBase gtp, Listener listener, boolean fillPasses) {
        this.m_fillPasses = fillPasses;
        this.m_gtp = gtp;
        this.m_listener = listener;
        this.m_isOutOfSync = true;
        this.m_komi = null;
        this.m_timeSettings = null;
    }

    public boolean isOutOfSync() {
        return this.m_isOutOfSync;
    }

    public void init(ConstBoard board, Komi komi, TimeSettings timeSettings) throws GtpError {
        this.initSupportedCommands();
        this.m_isOutOfSync = true;
        int size = board.getSize();
        this.m_engineState = null;
        this.m_gtp.sendBoardsize(size);
        this.m_engineState = new Board(size);
        this.m_gtp.sendClearBoard(size);
        this.sendGameInfo(komi, timeSettings);
        Board targetState = this.computeTargetState(board);
        this.setup(targetState);
        ArrayList<Move> moves = new ArrayList<Move>();
        for (int i = 0; i < targetState.getNumberMoves(); ++i) {
            moves.add(targetState.getMove(i));
        }
        this.play(moves);
        this.m_isOutOfSync = false;
    }

    public void synchronize(ConstBoard board, Komi komi, TimeSettings timeSettings) throws GtpError {
        int size = board.getSize();
        Board targetState = this.computeTargetState(board);
        if (this.m_engineState == null || size != this.m_engineState.getSize() || this.isSetupDifferent(targetState)) {
            this.init(board, komi, timeSettings);
            return;
        }
        this.m_isOutOfSync = true;
        ArrayList<Move> moves = new ArrayList<Move>();
        int numberUndo = this.computeToPlay(moves, targetState);
        if (numberUndo == 0 || this.m_isSupportedUndo || this.m_isSupportedGGUndo) {
            try {
                this.undo(numberUndo);
            }
            catch (GtpError e) {
                this.init(board, komi, timeSettings);
                return;
            }
            this.sendGameInfo(komi, timeSettings);
            this.play(moves);
            this.m_isOutOfSync = false;
        } else {
            this.init(board, komi, timeSettings);
        }
    }

    public void updateHumanMove(ConstBoard board, Move move) throws GtpError {
        Board targetState = this.computeTargetState(board);
        assert (this.findNumberCommonMoves(targetState) == targetState.getNumberMoves());
        if (this.m_fillPasses && this.m_engineState.getNumberMoves() > 0) {
            Move lastMove = this.m_engineState.getLastMove();
            GoColor c = move.getColor();
            if (lastMove.getColor() == c) {
                this.play(Move.getPass(c.otherColor()));
            }
        }
        this.play(move);
    }

    public void updateAfterGenmove(ConstBoard board) {
        block4: {
            Move move = board.getLastMove();
            assert (move != null);
            this.m_engineState.play(move);
            try {
                Board targetState = this.computeTargetState(board);
                assert (this.findNumberCommonMoves(targetState) == targetState.getNumberMoves());
            }
            catch (GtpError e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    private Board computeTargetState(ConstBoard board) throws GtpError {
        int size = board.getSize();
        Board targetState = new Board(size);
        ConstPointList setupBlack = board.getSetup(GoColor.BLACK);
        ConstPointList setupWhite = board.getSetup(GoColor.WHITE);
        GoColor setupPlayer = board.getSetupPlayer();
        if (setupBlack.size() > 0 || setupWhite.size() > 0) {
            targetState.clear();
            boolean isHandicap = board.isSetupHandicap();
            if (isHandicap && this.m_isSupportedHandicap) {
                targetState.setupHandicap(setupBlack);
            } else if (this.m_isSupportedSetup) {
                targetState.setup(setupBlack, setupWhite, setupPlayer);
            } else {
                List<GoColor> colors = setupPlayer == GoColor.BLACK ? GoColor.BLACK_WHITE : GoColor.WHITE_BLACK;
                for (GoColor c : colors) {
                    for (GoPoint p : board.getSetup(c)) {
                        if (targetState.isCaptureOrSuicide(c, p)) {
                            String message = "cannot transmit setup as move if stones are captured";
                            throw new GtpError(message);
                        }
                        targetState.play(Move.get(c, p));
                    }
                }
            }
        }
        for (int i = 0; i < board.getNumberMoves(); ++i) {
            Move move = board.getMove(i);
            GoColor toMove = targetState.getToMove();
            if (this.m_fillPasses && move.getColor() != toMove) {
                targetState.play(Move.getPass(toMove));
            }
            targetState.play(move);
        }
        return targetState;
    }

    private int computeToPlay(ArrayList<Move> moves, ConstBoard targetState) throws GtpError {
        int numberCommonMoves = this.findNumberCommonMoves(targetState);
        int numberUndo = this.m_engineState.getNumberMoves() - numberCommonMoves;
        moves.clear();
        for (int i = numberCommonMoves; i < targetState.getNumberMoves(); ++i) {
            moves.add(targetState.getMove(i));
        }
        return numberUndo;
    }

    private int findNumberCommonMoves(ConstBoard targetState) {
        Move move;
        int i;
        for (i = 0; i < targetState.getNumberMoves() && i < this.m_engineState.getNumberMoves() && (move = targetState.getMove(i)).equals(this.m_engineState.getMove(i)); ++i) {
        }
        return i;
    }

    private boolean isSetupDifferent(ConstBoard targetState) {
        if (this.m_engineState.isSetupHandicap() != targetState.isSetupHandicap()) {
            return true;
        }
        if (!ObjectUtil.equals((Object)this.m_engineState.getSetupPlayer(), (Object)targetState.getSetupPlayer())) {
            return true;
        }
        for (GoColor c : GoColor.BLACK_WHITE) {
            if (this.m_engineState.getSetup(c).equals(targetState.getSetup(c))) continue;
            return true;
        }
        return false;
    }

    private void initSupportedCommands() {
        this.m_isSupportedPlaySequence = GtpClientUtil.isPlaySequenceSupported(this.m_gtp);
        this.m_isSupportedUndo = this.isSupported("undo");
        this.m_isSupportedGGUndo = this.isSupported("gg-undo");
        this.m_isSupportedSetup = this.isSupported("gogui-setup");
        this.m_isSupportedSetupPlayer = this.isSupported("gogui-setup_player");
        this.m_isSupportedHandicap = this.isSupported("set_free_handicap");
    }

    private boolean isSupported(String command) {
        return this.m_gtp.isSupported(command);
    }

    private void play(Move move) throws GtpError {
        this.m_gtp.sendPlay(move);
        this.m_engineState.play(move);
    }

    private void play(ArrayList<Move> moves) throws GtpError {
        if (moves.isEmpty()) {
            return;
        }
        if (moves.size() > 1 && this.m_isSupportedPlaySequence) {
            String cmd = GtpClientUtil.getPlaySequenceCommand(this.m_gtp, moves);
            this.m_gtp.send(cmd);
            for (int i = 0; i < moves.size(); ++i) {
                this.m_engineState.play(moves.get(i));
            }
        } else {
            for (int i = 0; i < moves.size(); ++i) {
                this.play(moves.get(i));
                this.updateListener();
            }
        }
    }

    private void sendGameInfo(Komi komi, TimeSettings timeSettings) {
        if (!ObjectUtil.equals(komi, this.m_komi)) {
            this.m_komi = komi;
            if (this.m_gtp.isSupported("komi")) {
                try {
                    this.m_gtp.send("komi " + Komi.toString(komi));
                }
                catch (GtpError gtpError) {
                    // empty catch block
                }
            }
        }
        if (!ObjectUtil.equals(timeSettings, this.m_timeSettings)) {
            this.m_timeSettings = timeSettings;
            if (this.m_gtp.isSupported("time_settings")) {
                try {
                    this.m_gtp.send(GtpUtil.getTimeSettingsCommand(timeSettings));
                }
                catch (GtpError gtpError) {
                    // empty catch block
                }
            }
        }
    }

    private void setup(ConstBoard targetState) throws GtpError {
        ConstPointList setupBlack = targetState.getSetup(GoColor.BLACK);
        ConstPointList setupWhite = targetState.getSetup(GoColor.WHITE);
        GoColor setupPlayer = targetState.getSetupPlayer();
        if (setupBlack.size() == 0 && setupWhite.size() == 0) {
            return;
        }
        if (targetState.isSetupHandicap()) {
            StringBuilder command = new StringBuilder(128);
            command.append("set_free_handicap");
            for (GoPoint p : setupBlack) {
                command.append(' ');
                command.append(p);
            }
            this.m_gtp.send(command.toString());
            this.m_engineState.setupHandicap(setupBlack);
        } else {
            StringBuilder command = new StringBuilder(128);
            command.append("gogui-setup");
            for (GoColor c : GoColor.BLACK_WHITE) {
                for (GoPoint p : targetState.getSetup(c)) {
                    command.append(' ');
                    command.append(Move.get(c, p));
                }
            }
            this.m_gtp.send(command.toString());
            this.m_engineState.setup(setupBlack, setupWhite, setupPlayer);
            if (setupPlayer != null && this.m_isSupportedSetupPlayer) {
                this.m_gtp.send("gogui-setup_player " + setupPlayer.getUppercaseLetter());
            }
        }
    }

    private void undo(int n) throws GtpError {
        if (n == 0) {
            return;
        }
        if (this.m_isSupportedGGUndo && (n > 1 || !this.m_isSupportedUndo)) {
            this.m_gtp.send("gg-undo " + n);
            this.m_engineState.undo(n);
        } else {
            assert (this.m_isSupportedUndo);
            for (int i = 0; i < n; ++i) {
                this.m_gtp.send("undo");
                this.m_engineState.undo();
                this.updateListener();
            }
        }
    }

    private void updateListener() {
        if (this.m_listener != null) {
            this.m_listener.moveNumberChanged(this.m_engineState.getNumberMoves());
        }
    }

    public static interface Listener {
        public void moveNumberChanged(int var1);
    }
}

