/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.client;

import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import net.sf.gogui.tools.client.SocketOutputCopy;
import net.sf.gogui.util.Options;
import net.sf.gogui.util.StreamCopy;
import net.sf.gogui.util.StringUtil;
import net.sf.gogui.version.Version;

public final class Main {
    private static Socket connect(String hostname, int port, int timeout) throws IOException {
        int totalTime = 0;
        while (true) {
            try {
                return new Socket(hostname, port);
            }
            catch (ConnectException connectException) {
                if (totalTime >= timeout) {
                    throw connectException;
                }
                String text = "Connect failed; retrying in 5 sec...";
                System.err.println(text);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                totalTime += 5;
                continue;
            }
            break;
        }
    }

    public Main(String hostname, int port, int timeout) throws Exception {
        Socket socket = Main.connect(hostname, port, timeout);
        Thread fromNet = new Thread(new StreamCopy(false, socket.getInputStream(), System.out, false));
        SocketOutputCopy toNet = new SocketOutputCopy(socket);
        fromNet.start();
        toNet.start();
        fromNet.join();
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            String[] options = new String[]{"config:", "help", "timeout:", "version"};
            Options opt = Options.parse(args, options);
            if (opt.contains("help")) {
                Main.printUsage(System.out);
                System.exit(0);
            }
            if (opt.contains("version")) {
                System.out.println("gogui-client " + Version.get());
                System.exit(0);
            }
            int timeout = opt.getInteger("timeout", 10, 0);
            ArrayList<String> arguments = opt.getArguments();
            if (arguments.size() != 2) {
                Main.printUsage(System.err);
                System.exit(1);
            }
            String hostname = arguments.get(0);
            int port = Integer.parseInt(arguments.get(1));
            new Main(hostname, port, timeout);
        }
        catch (Throwable t) {
            StringUtil.printException(t);
            System.exit(1);
        }
    }

    private static void printUsage(PrintStream out) {
        String text = "Usage: gogui-client [options] hostname port\n\n-config  config file\n-help    display this help and exit\n-timeout stop trying to connect after n seconds (default 10)\n-version print version and exit\n";
        out.print(text);
    }
}

