# Error Handling
use strict;
use warnings;
our (%gui);

my %err = (auth          => ['Failed to Authenticate',
                             'Login credentials are incorrect or the web service is mis-configured.'],
           connect       => ['Failed to Connect',
                             'Your credentials may be incorrect or the vbox web service is not running at the specified URL.'],
           createguest   => ['Failed to Create Guest.',
                             'This is usually due to a guest already existing with the same name.'],
           ctrallocated  => ['Controller Already Allocated',
                             'The guest already has a storage controller of this type assigned to it.'],
           ctrinuse      => ['Controller in Use',
                             'The controller still has media attached. Remove media before removing controller.'],
           ctrfull       => ['Controller Full',
                             'The selected controller is full. No more media can be attached.'],
           deleteguest   => ['Unable to Delete Guest',
                             'This guest cannot be deleted until its lock is released by the process' .
                             ' which set it. The guest may be running or being edited by another user.'],
           delguestwsnap => ['Unable to Delete Guest',
                             'This guest has snapshots associated with it and therefore cannot be deleted. ' .
                             'Please delete all associated snapshots first, then try again.'],
           deletemedium  => ['Unable to Delete Medium',
                             'The selected medium is in a state which does not permit deletion. It' .
                             ' may be locked by another process.'],
           emptynamepath => ['Invalid Name or Path',
                             'You cannot specify an empty name or path.'],
           guiexception  => ['A GUI Exception Occurred',
                             ''],
           mediuminuse   => ['Medium In Use',
                             'The selected medium could not be released from at least one guest. This is because the guest is' .
                             ' running or is being edited by another user.'],
           remotedisplay => ['Remote Display Not Enabled',
                             'The remote display server for this guest has not been enabled or is not running.'],
           restorefail   => ['Restore Failed',
                             'The machine is in use or powered on.'],
           savedesc      => ['Unable to Save Description',
                             'The description of this guest cannot be changed until its lock is released by the process which' .
                             ' set it. The guest may be running or being edited by another user.'],
           sessionopen   => ['Session In Use',
                             'This guest already has an open session associated with it, either from RemoteBox or another program.' .
                             ' Please close that session and try again.'],
           settings      => ['Unable to Edit Settings',
                             'The settings of this guest cannot be changed until its lock is released by the process which set it.' .
                             ' The guest may be running or being edited by another user.'],
           snapshotfail  => ['Snapshot Failed',
                             'A session to the guest could not be obtained.'],
           snapdelete    => ['Deleting Snapshot Failed',
                             'The snapshot could not be deleted because a session to the guest could not be obtained.'],
           startguest    => ['Failed to Start Guest',
                             ''],
           vboxose       => ['OSE Version Detected',
                             'The OSE version of VirtualBox is not yet officially supported by RemoteBox. RemoteBox will continue' .
                             ' but you may experience failures and loss of functionality.'],
           vboxver       => ['Unsupported VirtualBox Version',
                             'This version of RemoteBox is not intended for use with the version of VirtualBox running on the' .
                             ' server. RemoteBox will continue, but you may experience failures and loss of functionality. The' .
                             ' recommended version is: VirtualBox 3.2.x'],
           webservice    => ['VirtualBox Returned an Error',
                             '']);

sub show_err_msg() {
    my ($key, $dialog, $append) = @_;
    my ($title, $body) = @{ $err{$key} };
    $body .= $append if ($append);
    &log_msg("$title :: $body");
    $dialog->set_markup("<big><b>$title</b></big>");
    $dialog->format_secondary_markup($body);
    $dialog->run;
    $dialog->hide;
}

1;