# Edit Audio Settings of a Guest
use strict;
use warnings;
our (%gui, %signal, %hostspec, %bool, %EAudDrv, %EAudCtr, %vmc);

sub setup_edit_dialog_audio() {
    &busy_window($gui{dialogEdit}, 0, 'watch');
    $gui{comboboxEditAudioDriver}->signal_handler_block($signal{audiodrv});
    $gui{comboboxEditAudioCtr}->signal_handler_block($signal{audioctr});
    $gui{liststoreEditAudioDriver}->clear();
    $gui{liststoreEditAudioCtr}->clear();
    $gui{checkbuttonEditAudioEnable}->set_active($bool{IAudioAdapter_getEnabled($vmc{IAudioAdapter})});
    $gui{tableEditAudio}->set_sensitive($gui{checkbuttonEditAudioEnable}->get_active()); # Ghost/Unghost other widgets based on audio enabled

    foreach my $driver (sort(keys %EAudDrv)) {
        if ($hostspec{os} =~ m/${EAudDrv{$driver}{os}}/ or $EAudDrv{$driver}{os} eq 'All') {
            my $iter = $gui{liststoreEditAudioDriver}->append();
            $gui{liststoreEditAudioDriver}->set($iter, 0, $EAudDrv{$driver}{desc}, 1, $driver);
            $gui{comboboxEditAudioDriver}->set_active_iter($iter) if ($driver eq IAudioAdapter_getAudioDriver($vmc{IAudioAdapter}));
        }
    }

    foreach my $ctr (sort(keys %EAudCtr)) {
        my $iter = $gui{liststoreEditAudioCtr}->append();
        $gui{liststoreEditAudioCtr}->set($iter, 0, $EAudCtr{$ctr}, 1, $ctr);
        $gui{comboboxEditAudioCtr}->set_active_iter($iter) if ($ctr eq IAudioAdapter_getAudioController($vmc{IAudioAdapter}));
    }

    $gui{comboboxEditAudioDriver}->signal_handler_unblock($signal{audiodrv});
    $gui{comboboxEditAudioCtr}->signal_handler_unblock($signal{audioctr});
    &busy_window($gui{dialogEdit}, 1, undef);
}

sub audio_toggle() {
    my $state = $gui{checkbuttonEditAudioEnable}->get_active();
    IAudioAdapter_setEnabled($vmc{IAudioAdapter}, $state);
    $gui{tableEditAudio}->set_sensitive($state);
}

sub audio_ctr() {
    my $controller = &getsel_combo($gui{comboboxEditAudioCtr}, 1);
    IAudioAdapter_setAudioController($vmc{IAudioAdapter}, $controller);
}

sub audio_driver() {
    my $driver = &getsel_combo($gui{comboboxEditAudioDriver}, 1);
    IAudioAdapter_setAudioDriver($vmc{IAudioAdapter}, $driver);
}

1;