# Editing Settings of a Guest
use strict;
use warnings;
require 'rbox_gui_edit_general.pl';
require 'rbox_gui_edit_system.pl';
require 'rbox_gui_edit_display.pl';
require 'rbox_gui_edit_storage.pl';
require 'rbox_gui_edit_audio.pl';
require 'rbox_gui_edit_network.pl';
require 'rbox_gui_edit_ioports.pl';
require 'rbox_gui_edit_usb.pl';
require 'rbox_gui_edit_shared.pl';
our (%gui, %vmc);


sub show_edit_dialog() {
    undef(%vmc);
    &busy_window($gui{windowMain}, 0, 'watch');
    my $gref = &getsel_list_guest();
    my ($ISession, $IMachineM) = &get_mutable_session($$gref{IMachine});

    if ($ISession) {
        &addrow_log("Retrieving master settings for $$gref{Name}...");
        $gui{dialogEdit}->set_title("Edit Settings - $$gref{Name}");
        $vmc{IMachine} = $IMachineM;
        $vmc{IBIOSSettings} = IMachine_getBIOSSettings($IMachineM);
        $vmc{IAudioAdapter} = IMachine_getAudioAdapter($IMachineM);
        $vmc{IVRDEServer} = IMachine_getVRDEServer($IMachineM);
        $vmc{IUSBController} = IMachine_getUSBController($IMachineM);
        $vmc{IParallelPort} = IMachine_getParallelPort($IMachineM, 0);
        $vmc{IHost} = IVirtualBox_getHost($gui{websn});
        $vmc{Name} = $$gref{Name};
        $vmc{SessionType} = ISession_getType($ISession);
        edit_tabchanged($gui{notebookEdit}, 0, $gui{notebookEdit}->get_current_page()); # Setup initial tab
        &addrow_log("Master settings for $$gref{Name} retrieved.");
        &busy_window($gui{windowMain}, 0);
        my $response = $gui{dialogEdit}->run;
        $gui{dialogEdit}->hide;

        if ($response eq 'ok') {
            IMachine_saveSettings($IMachineM);
            &addrow_log("Saved all settings for $$gref{Name}.");
            &fill_list_guest();
        }
        else {
            IMachine_discardSettings($IMachineM);
            &addrow_log("Discarded changed settings for $$gref{Name}.");
        }

        ISession_unlockMachine($ISession);
        undef(%vmc);
        &edit_tabchanged(); # Flush the page cache
        $gui{menuitemAttachFloppy} = undef; # These must be freed
        $gui{menuitemAttachDVD} = undef;
        $gui{menuitemAttachHD} = undef;
        $gui{menuAttachFloppy} = undef;
        $gui{menuAttachDVD} = undef;
        $gui{menuAttachHD} = undef;
        $gui{menuAttachAdd} = undef;
        $gui{menuUSB} = undef;
    }
    else { &show_err_msg('settings', $gui{messagedialogWarning}); }
}

# Routine only retrieves the settings for a tab when the user clicks on it.
# Helps reduce time it takes to open window. Results are cached until window closed
{
    my %pagecache;

    sub edit_tabchanged() {
        my ($widget, $focus, $page) = @_;
        # Flush the cache if we have not been called by a widget
        if (!$widget) { undef %pagecache; }
        else {
            if ($pagecache{$page}) { } # Do Nothing, Page is Cache
            elsif ($page == 0) { &setup_edit_dialog_general(); }
            elsif ($page == 1) { &setup_edit_dialog_system(); }
            elsif ($page == 2) { &setup_edit_dialog_display(); }
            elsif ($page == 3) { &setup_edit_dialog_storage(); }
            elsif ($page == 4) { &setup_edit_dialog_audio(); }
            elsif ($page == 5) { &setup_edit_dialog_network(); }
            elsif ($page == 6) { &setup_edit_dialog_ioports(); }
            elsif ($page == 7) { &setup_edit_dialog_usb(); }
            elsif ($page == 8) { &setup_edit_dialog_shared(); }
            $pagecache{$page} = 1;
        }
    }
};

1;