# Edit Audio Settings of a Guest
use strict;
use warnings;
our (%gui, %signal, %hostspec, %bool, %vmc);

sub setup_edit_dialog_audio() {
    &addrow_log("Retrieving audio settings for $vmc{Name}...");
    &busy_pointer($gui{dialogEdit}, 1);
    $gui{comboboxEditAudioDriver}->signal_handler_block($signal{audiodrv});
    $gui{comboboxEditAudioCtr}->signal_handler_block($signal{audioctr});
    $gui{checkbuttonEditAudioEnable}->set_active($bool{IAudioAdapter_getEnabled($vmc{IAudioAdapter})});
    $gui{tableEditAudio}->set_sensitive($gui{checkbuttonEditAudioEnable}->get_active()); # Ghost/Unghost other widgets based on audio enabled

    if ($hostspec{os} =~ m/Linux/i) { $gui{comboboxEditAudioDriver}->set_model($gui{liststoreEditAudioDriverLin}); }
    elsif ($hostspec{os} =~ m/Windows/i) { $gui{comboboxEditAudioDriver}->set_model($gui{liststoreEditAudioDriverWin}); }
    elsif ($hostspec{os} =~ m/SunOS/i) { $gui{comboboxEditAudioDriver}->set_model($gui{liststoreEditAudioDriverSol}); }
    elsif ($hostspec{os} =~ m/Darwin/i) { $gui{comboboxEditAudioDriver}->set_model($gui{liststoreEditAudioDriverMac}); }
    else { $gui{comboboxEditAudioDriver}->set_model($gui{liststoreEditAudioDriverOther}); }

    &combobox_set_active_text($gui{comboboxEditAudioDriver}, IAudioAdapter_getAudioDriver($vmc{IAudioAdapter}));
    &combobox_set_active_text($gui{comboboxEditAudioCtr}, IAudioAdapter_getAudioController($vmc{IAudioAdapter}));
    $gui{comboboxEditAudioDriver}->signal_handler_unblock($signal{audiodrv});
    $gui{comboboxEditAudioCtr}->signal_handler_unblock($signal{audioctr});
    &busy_pointer($gui{dialogEdit}, 0);
    &addrow_log("Audio settings for $vmc{Name} retrieved.");
}

sub audio_toggle() {
    my $state = $gui{checkbuttonEditAudioEnable}->get_active();
    IAudioAdapter_setEnabled($vmc{IAudioAdapter}, $state);
    $gui{tableEditAudio}->set_sensitive($state);
}

sub audio_ctr() {
    my $controller = &getsel_combo($gui{comboboxEditAudioCtr}, 0);
    IAudioAdapter_setAudioController($vmc{IAudioAdapter}, $controller);
}

sub audio_driver() {
    my $driver = &getsel_combo($gui{comboboxEditAudioDriver}, 0);
    IAudioAdapter_setAudioDriver($vmc{IAudioAdapter}, $driver);
}

1;