# Edit General Settings of a Guest
use strict;
use warnings;
our (%gui, %signal, %osversion, %osfamily, %vmc);

sub setup_edit_dialog_general() {
    &addrow_log("Retrieving general settings for $vmc{Name}...");
    &busy_pointer($gui{dialogEdit}, 1);
    my $Name = IMachine_getName($vmc{IMachine});
    my $Osid = IMachine_getOSTypeId($vmc{IMachine});
    $gui{comboboxEditGenOSFam}->signal_handler_block($signal{famedit});
    $gui{comboboxEditGenOSVer}->signal_handler_block($signal{veredit});
    $gui{liststoreEditGenOSFam}->clear();
    $gui{liststoreEditGenOSVer}->clear();
    my $IGuestOSType = IVirtualBox_getGuestOSType($gui{websn}, $Osid);
    $gui{entryEditGenName}->set_text($Name);

    foreach (sort(keys %osfamily)) {
        my $iter = $gui{liststoreEditGenOSFam}->append();
        $gui{liststoreEditGenOSFam}->set($iter, 0, $osfamily{$_}{description}, 1, $_, 2, $osfamily{$_}{icon});
        $gui{comboboxEditGenOSFam}->set_active_iter($iter) if ($_ eq $$IGuestOSType{familyId});
    }

    foreach (sort(@{ $osfamily{$$IGuestOSType{familyId}}{verids} })) {
        my $iter = $gui{liststoreEditGenOSVer}->append();
        $gui{liststoreEditGenOSVer}->set($iter, 0, $osversion{$_}{description}, 1, $_, 2, $osversion{$_}{icon});
        $gui{comboboxEditGenOSVer}->set_active_iter($iter) if ($_ eq $$IGuestOSType{id});
    }

    &combobox_set_active_text($gui{comboboxEditGenClip}, IMachine_getClipboardMode($vmc{IMachine}));
    $gui{comboboxEditGenOSFam}->signal_handler_unblock($signal{famedit});
    $gui{comboboxEditGenOSVer}->signal_handler_unblock($signal{veredit});
    $gui{textbufferEditGenDescription}->set_text(IMachine_getDescription($vmc{IMachine}));
    &busy_pointer($gui{dialogEdit}, 0);
    &addrow_log("General settings for $vmc{Name} retrieved.");
}

sub gen_name() {
    my $name = $gui{entryEditGenName}->get_text();
    IMachine_setName($vmc{IMachine}, $name) if ($name);
}

sub gen_osfam() {
    my ($combofam, $combover) = @_;
    my $fam = &getsel_combo($combofam, 1);
    $combofam->signal_handler_block($signal{famedit}); # Block to avoid signal emission when changing
    $combover->signal_handler_block($signal{veredit});
    $gui{liststoreEditGenOSVer}->clear();

    foreach (sort(@{ $osfamily{$fam}{verids} })) {
        my $iter = $gui{liststoreEditGenOSVer}->append();
        $gui{liststoreEditGenOSVer}->set($iter, 0, $osversion{$_}{description}, 1, $_, 2, $osversion{$_}{icon});
        $combover->set_active_iter($iter) if ($_ eq 'WindowsXP' | $_ eq 'Ubuntu' | $_ eq 'Solaris');
    }

    $combover->set_active(0) if ($combover->get_active() == -1);
    $combofam->signal_handler_unblock($signal{famedit});
    $combover->signal_handler_unblock($signal{veredit});
    $combover->signal_emit('changed'); # Force update of other fields based on OS
}

sub gen_osver() {
    my ($combover) = @_;
    my $ver = &getsel_combo($combover, 1);
    IMachine_setOSTypeId($vmc{IMachine}, $ver);
}

sub gen_clip() { IMachine_setClipboardMode($vmc{IMachine}, &getsel_combo($gui{comboboxEditGenClip}, 0)); }

sub gen_description() {
    my $iter_s = $gui{textbufferEditGenDescription}->get_start_iter();
    my $iter_e = $gui{textbufferEditGenDescription}->get_end_iter();
    IMachine_setDescription($vmc{IMachine}, $gui{textbufferEditGenDescription}->get_text($iter_s, $iter_e, 0));
}

1;