# Edit Shared Folder Settings of a Guest
use strict;
use warnings;
our (%gui, %vmc);

sub setup_edit_dialog_shared() {
    &addrow_log("Retrieving shared folder settings for $vmc{Name}...");
    &busy_pointer($gui{dialogEdit}, 1);
    &fill_list_editshared($vmc{IMachine});
    &busy_pointer($gui{dialogEdit}, 0);
    &addrow_log("Shared folder settings for $vmc{Name} retrieved.");
}

sub show_dialog_shared() {
    my ($widget) = @_;

    if ($widget eq $gui{buttonEditSharedEdit}) {
        my $sref = &getsel_list_editshared();
        $gui{entrySharedFolderPath}->set_text($$sref{Folder});
        $gui{entrySharedFolderName}->set_text($$sref{Name});

        if ($$sref{Access} eq 'Read-Only') { $gui{checkbuttonSharedFolderRO}->set_active(1); }
        else { $gui{checkbuttonSharedFolderRO}->set_active(0); }

        if ($$sref{Mount} eq 'Yes') { $gui{checkbuttonSharedFolderMount}->set_active(1); }
        else { $gui{checkbuttonSharedFolderMount}->set_active(0); }
    }

    my $response = $gui{dialogShared}->run;
    $gui{dialogShared}->hide;

    if ($response eq 'ok') {
        my $path = $gui{entrySharedFolderPath}->get_text();
        my $name = $gui{entrySharedFolderName}->get_text();
        if (!$path or !$name) { &show_err_msg('emptynamepath', $gui{messagedialogError}); }
        else {
            &shared_remove($widget, $gui{treeviewEditShared}) if ($widget eq $gui{buttonEditSharedEdit});
            IMachine_createSharedFolder($vmc{IMachine}, $name, $path, !$gui{checkbuttonSharedFolderRO}->get_active(), $gui{checkbuttonSharedFolderMount}->get_active());
            &fill_list_editshared($vmc{IMachine});
        }
    }
}

sub shared_remove() {
    my $sref = &getsel_list_editshared();
    IMachine_removeSharedFolder($vmc{IMachine}, $$sref{Name});
    &fill_list_editshared($vmc{IMachine});
}

# Set sensitivity when a shared folder is selected
sub sens_shared() {
    $gui{buttonEditSharedRemove}->set_sensitive(1);
    $gui{buttonEditSharedEdit}->set_sensitive(1);
}

1;