# Edit USB Settings of a Guest
use strict;
use warnings;
our (%gui, %bool, %vmc);

sub setup_edit_dialog_usb() {
    &addrow_log("Retrieving USB settings for $vmc{Name}...");
    &busy_pointer($gui{dialogEdit}, 1);
    my @IHostUSBDevices = IHost_getUSBDevices($vmc{IHost});
    my $state = $bool{IUSBController_getEnabled($vmc{IUSBController})};
    &sens_usb_enabled($state);
    $gui{checkbuttonEditUSBEnable}->set_active($state);
    $gui{checkbuttonEditUSBEHCI}->set_active($bool{IUSBController_getEnabledEHCI($vmc{IUSBController})});
    &fill_list_usbfilters($vmc{IUSBController});
    $gui{menuUSB} = Gtk2::Menu->new();

    foreach my $usb (@IHostUSBDevices) {
        my $label = &usb_makelabel(IUSBDevice_getManufacturer($usb),
                                   IUSBDevice_getProduct($usb),
                                   sprintf('%04x', IUSBDevice_getRevision($usb)));

        my $item = Gtk2::MenuItem->new_with_label($label);
        $gui{menuUSB}->append($item);
        $item->show();
        my $usbid = IUSBDevice_getId($usb);
        $item->signal_connect(activate => \&usb_addfilter, $usbid);
    }

    &busy_pointer($gui{dialogEdit}, 0);
    &addrow_log("USB settings for $vmc{Name} retrieved.");
}

sub show_dialog_usbfilter() {
    my $filref = &getsel_list_usbfilters;
    $gui{entryUSBFilterName}->set_text(IUSBDeviceFilter_getName($$filref{IUSBDeviceFilter}));
    $gui{entryUSBFilterVendorID}->set_text(IUSBDeviceFilter_getVendorId($$filref{IUSBDeviceFilter}));
    $gui{entryUSBFilterProductID}->set_text(IUSBDeviceFilter_getProductId($$filref{IUSBDeviceFilter}));
    $gui{entryUSBFilterRevision}->set_text(IUSBDeviceFilter_getRevision($$filref{IUSBDeviceFilter}));
    $gui{entryUSBFilterManufacturer}->set_text(IUSBDeviceFilter_getManufacturer($$filref{IUSBDeviceFilter}));
    $gui{entryUSBFilterProduct}->set_text(IUSBDeviceFilter_getProduct($$filref{IUSBDeviceFilter}));
    $gui{entryUSBFilterSerial}->set_text(IUSBDeviceFilter_getSerialNumber($$filref{IUSBDeviceFilter}));
    $gui{entryUSBFilterPort}->set_text(IUSBDeviceFilter_getPort($$filref{IUSBDeviceFilter}));
    my $remote = IUSBDeviceFilter_getRemote($$filref{IUSBDeviceFilter});

    if ($remote eq 'yes') { $gui{comboboxUSBFilterRemote}->set_active(1); }
    elsif ($remote eq 'no') { $gui{comboboxUSBFilterRemote}->set_active(2); }
    else { $gui{comboboxUSBFilterRemote}->set_active(0); }

    my $response = $gui{dialogUSBFilter}->run;
    $gui{dialogUSBFilter}->hide;

    if ($response eq 'ok') {
        IUSBController_removeDeviceFilter($vmc{IUSBController}, $$filref{Position}); # Remove the original filter
        # Create the new filter based on the old
        my $newfilter = IUSBController_createDeviceFilter($vmc{IUSBController}, $gui{entryUSBFilterName}->get_text());
        IUSBDeviceFilter_setActive($newfilter, $$filref{Enabled});
        IUSBDeviceFilter_setVendorId($newfilter, $gui{entryUSBFilterVendorID}->get_text());
        IUSBDeviceFilter_setProductId($newfilter, $gui{entryUSBFilterProductID}->get_text());
        IUSBDeviceFilter_setRevision($newfilter, $gui{entryUSBFilterRevision}->get_text());
        IUSBDeviceFilter_setManufacturer($newfilter, $gui{entryUSBFilterManufacturer}->get_text());
        IUSBDeviceFilter_setProduct($newfilter, $gui{entryUSBFilterProduct}->get_text());
        IUSBDeviceFilter_setSerialNumber($newfilter, $gui{entryUSBFilterSerial}->get_text());
        IUSBDeviceFilter_setPort($newfilter, $gui{entryUSBFilterPort}->get_text());
        IUSBController_insertDeviceFilter($vmc{IUSBController}, $$filref{Position}, $newfilter);
        my $remote = $gui{comboboxUSBFilterRemote}->get_active();

        if ($remote == 1) { IUSBDeviceFilter_setRemote($newfilter, 'yes'); }
        elsif ($remote == 2) { IUSBDeviceFilter_setRemote($newfilter, 'no'); }
        else { IUSBDeviceFilter_setRemote($newfilter, ''); }

        &fill_list_usbfilters($vmc{IUSBController});
    }
}

# Toggles whether USB is enabled or not
sub usb_toggle() {
    my $state = $gui{checkbuttonEditUSBEnable}->get_active();
    IUSBController_setEnabled($vmc{IUSBController}, $state);
    &sens_usb_enabled($state);
}

# Handles the enabling/disabling of USB EHCI
sub usb_toggleehci() { IUSBController_setEnabledEHCI($vmc{IUSBController}, $gui{checkbuttonEditUSBEHCI}->get_active()); }

sub usb_addzerofilter() {
    my $filref = &getsel_list_usbfilters();
    my $pos = 0;

    # Determine position for new filter, based on whether one is selected or not
    $pos = $$filref{Position} + 1 if ($$filref{Position});
    my $IUSBDeviceFilter = IUSBController_createDeviceFilter($vmc{IUSBController}, 'New Filter' . int(rand(9999)));
    IUSBDeviceFilter_setActive($IUSBDeviceFilter, 1);
    IUSBController_insertDeviceFilter($vmc{IUSBController}, $pos, $IUSBDeviceFilter);
    &fill_list_usbfilters($vmc{IUSBController});
}

sub usb_addfilter() {
    my ($widget, $usbid) = @_;
    my $filref = &getsel_list_usbfilters();
    my $pos = 0;
    # Determine position for new filter, based on whether one is selected or not
    $pos = $$filref{Position} + 1 if ($$filref{Position});
    my $IHostUSBDevice = IHost_findUSBDeviceById($vmc{IHost}, $usbid);
    my %usbdevice = (vendorId     => sprintf('%04X', IUSBDevice_getVendorId($IHostUSBDevice)),
                     productId    => sprintf('%04x', IUSBDevice_getProductId($IHostUSBDevice)),
                     revision     => sprintf('%04x', IUSBDevice_getRevision($IHostUSBDevice)),
                     manufacturer => IUSBDevice_getManufacturer($IHostUSBDevice),
                     product      => IUSBDevice_getProduct($IHostUSBDevice),
                     serial       => IUSBDevice_getSerialNumber($IHostUSBDevice));

    my $label = &usb_makelabel($usbdevice{manufacturer}, $usbdevice{product}, $usbdevice{revision});
    my $IUSBDeviceFilter = IUSBController_createDeviceFilter($vmc{IUSBController}, $label);
    IUSBDeviceFilter_setActive($IUSBDeviceFilter, 1);
    IUSBDeviceFilter_setVendorId($IUSBDeviceFilter, $usbdevice{vendorId});
    IUSBDeviceFilter_setProductId($IUSBDeviceFilter, $usbdevice{productId});
    IUSBDeviceFilter_setRevision($IUSBDeviceFilter, $usbdevice{revision});
    IUSBDeviceFilter_setManufacturer($IUSBDeviceFilter, $usbdevice{manufacturer});
    IUSBDeviceFilter_setProduct($IUSBDeviceFilter, $usbdevice{product});
    IUSBDeviceFilter_setSerialNumber($IUSBDeviceFilter, $usbdevice{serial});
    IUSBController_insertDeviceFilter($vmc{IUSBController}, $pos, $IUSBDeviceFilter);
    &fill_list_usbfilters($vmc{IUSBController});
    return 0;
}

sub usb_makelabel() {
    my ($manu, $prod, $rev) = @_;
    my $label;
    $label = "$manu " if ($manu);
    $label .= "$prod " if ($prod);
    $label .= "[$rev]" if ($rev);
    return $label;
}

sub usb_removefilter() {
    my $filref = &getsel_list_usbfilters();
    IUSBController_removeDeviceFilter($vmc{IUSBController}, $$filref{Position});
    &fill_list_usbfilters($vmc{IUSBController});
}

sub usb_movefilter() {
    my ($widget) = @_;
    my $pos = 0;
    my $filref = &getsel_list_usbfilters();

    if ($widget eq $gui{buttonEditUSBUp} and $$filref{Position} > 0) { $pos = -1; }
    elsif ($widget eq $gui{buttonEditUSBDown}) { $pos = 1; }

    my $IUSBDeviceFilter = IUSBController_removeDeviceFilter($vmc{IUSBController}, $$filref{Position});
    IUSBController_insertDeviceFilter($vmc{IUSBController}, $$filref{Position} + $pos, $IUSBDeviceFilter);
    &fill_list_usbfilters($vmc{IUSBController});
}

# Can't use getsel_list_usbfilters in here due to the way the signals are propagated
sub usb_togglefilter() {
    my ($widget, $path_str, $model) = @_;
    my $iter = $model->get_iter(Gtk2::TreePath->new_from_string($path_str));
    my $val = $model->get($iter, 0);
    my $IUSBDeviceFilter = $model->get($iter, 1);
    IUSBDeviceFilter_setActive($IUSBDeviceFilter, !$val); # Always set to the opposite
    &fill_list_usbfilters($vmc{IUSBController});
}

sub show_usb_menu() {
    my ($widget, $event) = @_;
    $gui{menuUSB}->popup(undef, undef, undef, undef, 0, $event->time) if ($event->button == 1);
    return 0;
}

sub sens_usb_filters() {
    $gui{buttonEditUSBEdit}->set_sensitive(1);
    $gui{buttonEditUSBRemove}->set_sensitive(1);
    $gui{buttonEditUSBUp}->set_sensitive(1);
    $gui{buttonEditUSBDown}->set_sensitive(1);
}

# Sets the sensitivity depending on whether a USB controller is enabled
sub sens_usb_enabled() {
    my ($state) = @_;
    $gui{checkbuttonEditUSBEHCI}->set_sensitive($state);
    $gui{treeviewEditUSBFilters}->set_sensitive($state);
    $gui{vbuttonboxEditUSB}->set_sensitive($state);
}

1;