#
# Sample makefile for bash loadable builtin development
#
# Copyright (C) 2015 Free Software Foundation, Inc.     

#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

PACKAGE = bash
VERSION = 5.1-release

PACKAGE_NAME = bash
PACKAGE_VERSION = 5.1-release

# Include some boilerplate Gnu makefile definitions.
prefix = /2022Q3

exec_prefix = ${prefix}
bindir = ${exec_prefix}/bin
libdir = ${exec_prefix}/lib
infodir = /2022Q3/info
includedir = ${prefix}/include

datarootdir = ${prefix}/share

loadablesdir = ${libdir}/bash
headersdir = $(includedir)/$(PACKAGE_NAME)

topdir = ../..
BUILD_DIR = /sda3/jails/current/pkglinux-pkgsrc.2022Q3/shells/bash/work/bash-5.1
srcdir = .


# Support an alternate destination root directory for package building
DESTDIR =

INSTALL = /bin/install -c -o root -g root
INSTALL_PROGRAM = /bin/install -c -s -o root -g root -m 755
INSTALL_SCRIPT = /bin/install -c -o root -g root -m 755
INSTALL_DATA = /bin/install -c -o root -g root -m 644
INSTALLMODE= -m 0755


CC = cc
RM = rm -f

SHELL = /bin/sh

host_os = linux-gnu
host_cpu = x86_64
host_vendor = unknown

CFLAGS = -O2 -D_FORTIFY_SOURCE=2 -I/usr/include -I/2022Q3/include/ncurses 
LOCAL_CFLAGS = 
DEFS = -DHAVE_CONFIG_H
LOCAL_DEFS = -DSHELL

CPPFLAGS = -DDEFAULT_PATH_VALUE="\"/sbin:/usr/sbin:/usr/bin:/bin:/2022Q3/sbin:/2022Q3/bin:/usr/local/sbin:/usr/local/bin\"" -I/usr/include -I/2022Q3/include/ncurses

BASHINCDIR = ${topdir}/include

SUPPORT_SRC = $(topdir)/support/

LIBBUILD = ${BUILD_DIR}/lib

INTL_LIBSRC = ${topdir}/lib/intl
INTL_BUILDDIR = ${LIBBUILD}/intl
INTL_INC = 
LIBINTL_H = 

CCFLAGS = $(DEFS) $(LOCAL_DEFS) $(LOCAL_CFLAGS) $(CFLAGS)

#
# These values are generated for configure by ${topdir}/support/shobj-conf.
# If your system is not supported by that script, but includes facilities for
# dynamic loading of shared objects, please update the script and send the
# changes to bash-maintainers@gnu.org.
#
SHOBJ_CC = cc
SHOBJ_CFLAGS = -fPIC
SHOBJ_LD = ${CC}
SHOBJ_LDFLAGS = -shared -Wl,-soname,$@ -Wl,-zrelro -L/2022Q3/lib -Wl,-R/2022Q3/lib
SHOBJ_XLDFLAGS = 
SHOBJ_LIBS = 
SHOBJ_STATUS = supported

INC = -I$(headersdir) -I$(headersdir)/include -I$(headersdir)/builtins

.c.o:
	$(SHOBJ_CC) $(SHOBJ_CFLAGS) $(CCFLAGS) $(INC) -c -o $@ $<

all:	example

example:	example.o
	$(SHOBJ_LD) $(SHOBJ_LDFLAGS) $(SHOBJ_XLDFLAGS) -o $@ example.o $(SHOBJ_LIBS)

example.o: example.c
