# AkonadiConfig.cmake is generated by CMake from akonadi/AkonadiConfig.cmake.in.
# Any changed value in this file will be overwritten by CMake.


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was AkonadiConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# set the akonadi version number
set(AKONADI_VERSION_MAJOR 1)
set(AKONADI_VERSION_MINOR 13)
set(AKONADI_VERSION_PATCH 0)
set(AKONADI_VERSION 1.13.0)
set(AKONADI_VERSION_STRING "1.13.0")

# set AKONADI_DEFINITIONS
set(AKONADI_USE_STRIGI_SEARCH FALSE) # backward compat, remove eventually
set(AKONADI_DEFINITIONS "")

# set the directories
if(NOT AKONADI_INSTALL_DIR)
   set(AKONADI_INSTALL_DIR "/2022Q2")
endif(NOT AKONADI_INSTALL_DIR)

set_and_check(AKONADI_BIN_DIR              "${PACKAGE_PREFIX_DIR}/bin")
set_and_check(AKONADI_CONFIG_DIR           "${PACKAGE_PREFIX_DIR}/share/config")
set_and_check(AKONADI_DBUS_INTERFACES_DIR  "${PACKAGE_PREFIX_DIR}/share/dbus-1/interfaces")
set_and_check(AKONADI_DBUS_SERVICES_DIR    "${PACKAGE_PREFIX_DIR}/share/dbus-1/services")
set_and_check(AKONADI_INCLUDE_DIR          "${PACKAGE_PREFIX_DIR}/include")
set_and_check(AKONADI_LIB_DIR              "${PACKAGE_PREFIX_DIR}/lib")
set_and_check(AKONADI_SHARE_DIR            "${PACKAGE_PREFIX_DIR}/share")
set_and_check(AKONADI_XDG_MIME_INSTALL_DIR "${PACKAGE_PREFIX_DIR}/share/mime/packages")

# the exports file exports
set(AKONADI_TARGET_PREFIX Akonadi__)

# Load the exported targets.
if(NOT TARGET Akonadi__akonadiprotocolinternals)
  get_filename_component(_currentDir "${CMAKE_CURRENT_LIST_FILE}" PATH)
  include("${_currentDir}/AkonadiTargetsWithPrefix.cmake")
endif()

macro(_akonadi_Set_Lib_Vars _prefix _lib)
  set(AKONADI_${_prefix}_LIBRARIES    ${AKONADI_TARGET_PREFIX}${_lib})
endmacro()

_akonadi_set_lib_vars(COMMON akonadiprotocolinternals)
