/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gogui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import net.sf.gogui.game.ConstClock;
import net.sf.gogui.game.ConstGame;
import net.sf.gogui.game.ConstGameInfo;
import net.sf.gogui.game.ConstGameTree;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.Game;
import net.sf.gogui.game.GameInfo;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.MarkType;
import net.sf.gogui.game.NodeUtil;
import net.sf.gogui.game.StringInfo;
import net.sf.gogui.game.StringInfoColor;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.gamefile.GameFile;
import net.sf.gogui.gamefile.GameReader;
import net.sf.gogui.gamefile.GameWriter;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.BoardUtil;
import net.sf.gogui.go.ConstBoard;
import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.CountScore;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.InvalidKomiException;
import net.sf.gogui.go.Komi;
import net.sf.gogui.go.Move;
import net.sf.gogui.go.PointList;
import net.sf.gogui.go.Score;
import net.sf.gogui.gogui.AboutDialog;
import net.sf.gogui.gogui.ExportPng;
import net.sf.gogui.gogui.GoGuiActions;
import net.sf.gogui.gogui.GoGuiMenuBar;
import net.sf.gogui.gogui.GoGuiToolBar;
import net.sf.gogui.gogui.GoGuiUtil;
import net.sf.gogui.gogui.GotoVariationDialog;
import net.sf.gogui.gogui.I18n;
import net.sf.gogui.gogui.Interrupt;
import net.sf.gogui.gogui.MoveNumberDialog;
import net.sf.gogui.gogui.Print;
import net.sf.gogui.gogui.ShowAnalyzeText;
import net.sf.gogui.gtp.AnalyzeCommand;
import net.sf.gogui.gtp.AnalyzeDefinition;
import net.sf.gogui.gtp.AnalyzeType;
import net.sf.gogui.gtp.AnalyzeUtil;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpClientUtil;
import net.sf.gogui.gtp.GtpCommand;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpResponseFormatError;
import net.sf.gogui.gtp.GtpSynchronizer;
import net.sf.gogui.gtp.GtpUtil;
import net.sf.gogui.gui.AnalyzeDialog;
import net.sf.gogui.gui.AnalyzeShow;
import net.sf.gogui.gui.BoardSizeDialog;
import net.sf.gogui.gui.Bookmark;
import net.sf.gogui.gui.BookmarkEditor;
import net.sf.gogui.gui.Comment;
import net.sf.gogui.gui.ConstGuiBoard;
import net.sf.gogui.gui.ContextMenu;
import net.sf.gogui.gui.FileDialogs;
import net.sf.gogui.gui.FindDialog;
import net.sf.gogui.gui.GameInfoDialog;
import net.sf.gogui.gui.GameInfoPanel;
import net.sf.gogui.gui.GameTreePanel;
import net.sf.gogui.gui.GameTreeViewer;
import net.sf.gogui.gui.GtpShell;
import net.sf.gogui.gui.GuiAction;
import net.sf.gogui.gui.GuiBoard;
import net.sf.gogui.gui.GuiBoardUtil;
import net.sf.gogui.gui.GuiGtpClient;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.Help;
import net.sf.gogui.gui.LiveGfx;
import net.sf.gogui.gui.MessageDialogs;
import net.sf.gogui.gui.ObjectListEditor;
import net.sf.gogui.gui.ParameterDialog;
import net.sf.gogui.gui.Program;
import net.sf.gogui.gui.ProgramEditor;
import net.sf.gogui.gui.RecentFileMenu;
import net.sf.gogui.gui.ScoreDialog;
import net.sf.gogui.gui.Session;
import net.sf.gogui.gui.StatusBar;
import net.sf.gogui.gui.TimeLeftDialog;
import net.sf.gogui.sgf.SgfError;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.sgf.SgfWriter;
import net.sf.gogui.tex.TexWriter;
import net.sf.gogui.text.ParseError;
import net.sf.gogui.text.TextParser;
import net.sf.gogui.thumbnail.ThumbnailCreator;
import net.sf.gogui.thumbnail.ThumbnailPlatform;
import net.sf.gogui.util.ErrorMessage;
import net.sf.gogui.util.FileUtil;
import net.sf.gogui.util.LineReader;
import net.sf.gogui.util.ObjectUtil;
import net.sf.gogui.util.Platform;
import net.sf.gogui.util.ProgressShow;
import net.sf.gogui.util.StringUtil;
import net.sf.gogui.version.Version;

public class GoGui
extends JFrame
implements AnalyzeDialog.Listener,
GuiBoard.Listener,
GameTreeViewer.Listener,
GtpShell.Listener,
ScoreDialog.Listener,
GoGuiMenuBar.Listener,
ContextMenu.Listener,
LiveGfx.Listener {
    private boolean m_analyzeAutoRun;
    private boolean m_analyzeClearBoard;
    private boolean m_analyzeOneRunOnly;
    private boolean m_analyzeReuseTextWindow;
    private boolean m_autoNumber;
    private boolean m_commandCompletion;
    private final boolean m_register;
    private boolean m_timeStamp;
    private final boolean m_auto;
    private boolean m_beepAfterMove;
    private boolean m_computerBlack;
    private boolean m_computerWhite;
    private boolean m_interruptComputerBoth;
    private boolean m_isSingleMove;
    private boolean m_lostOnTimeShown;
    private boolean m_resigned;
    private boolean m_scoreMode;
    private boolean m_setupMode;
    private boolean m_showInfoPanel;
    private boolean m_showLastMove;
    private boolean m_showMoveNumbers;
    private boolean m_showSubtreeSizes;
    private boolean m_showToolbar;
    private ShowVariations m_showVariations;
    private boolean m_setupNodeCreated;
    private final boolean m_verbose;
    private int m_handicap;
    private final int m_move;
    private GameTreePanel.Label m_treeLabels;
    private GameTreePanel.Size m_treeSize;
    private final GuiBoard m_guiBoard;
    private GuiGtpClient m_gtp;
    private final Comment m_comment;
    private final Interrupt m_interrupt = new Interrupt();
    private GameFile m_gameFile;
    private File m_initialFile;
    private final GameInfoPanel m_gameInfoPanel;
    private GtpShell m_shell;
    private GameTreeViewer m_gameTreeViewer;
    private Help m_help;
    private final JPanel m_infoPanel;
    private final JPanel m_innerPanel;
    private final JSplitPane m_splitPane;
    private final GoGuiMenuBar m_menuBar;
    private final Game m_game;
    private GoColor m_setupColor;
    private final MessageDialogs m_messageDialogs = new MessageDialogs();
    private Pattern m_pattern;
    private final File m_analyzeCommandsFile;
    private AnalyzeCommand m_analyzeCommand;
    private final Session m_session = new Session("net/sf/gogui/gogui/session");
    private final CountScore m_countScore = new CountScore();
    private final StatusBar m_statusBar;
    private final String m_gtpCommand;
    private final String m_gtpFile;
    private String m_lastAnalyzeCommand;
    private String m_programCommand;
    private String m_titleFromProgram;
    private String m_version = "";
    private AnalyzeDialog m_analyzeDialog;
    private final Preferences m_prefs = Preferences.userNodeForPackage(this.getClass());
    private ScoreDialog m_scoreDialog;
    private ArrayList<AnalyzeDefinition> m_analyzeCommands;
    private Program m_program;
    private Program m_newProgram;
    private final ThumbnailCreator m_thumbnailCreator = new ThumbnailCreator(false);
    private TimeSettings m_timeSettings;
    private final GoGuiActions m_actions = new GoGuiActions(this);
    private final GoGuiToolBar m_toolBar;
    private ArrayList<Bookmark> m_bookmarks;
    private ArrayList<Program> m_programs;
    private ShowAnalyzeText m_showAnalyzeText;
    private File m_parameterSnapshot;

    public GoGui(String program, File file, int move, String time, boolean verbose, boolean initComputerColor, boolean computerBlack, boolean computerWhite, boolean auto, boolean register, String gtpFile, String gtpCommand, File analyzeCommandsFile) throws GtpError, ErrorMessage {
        int boardSize = this.m_prefs.getInt("boardsize", 19);
        this.m_beepAfterMove = this.m_prefs.getBoolean("beep-after-move", true);
        this.m_initialFile = file;
        this.m_gtpFile = gtpFile;
        this.m_gtpCommand = gtpCommand;
        this.m_analyzeCommandsFile = analyzeCommandsFile;
        this.m_move = move;
        this.m_register = register;
        if (initComputerColor) {
            this.m_computerBlack = computerBlack;
            this.m_computerWhite = computerWhite;
        } else if (this.m_prefs.getBoolean("computer-none", false)) {
            this.m_computerBlack = false;
            this.m_computerWhite = false;
        } else {
            this.m_computerBlack = false;
            this.m_computerWhite = true;
        }
        this.m_auto = auto;
        this.m_verbose = verbose;
        this.m_showInfoPanel = true;
        this.m_showToolbar = false;
        Container contentPane = this.getContentPane();
        this.m_innerPanel = new JPanel(new BorderLayout());
        contentPane.add((Component)this.m_innerPanel, "Center");
        this.m_toolBar = new GoGuiToolBar(this);
        this.m_infoPanel = new JPanel(new BorderLayout());
        this.m_game = new Game(boardSize);
        this.m_gameInfoPanel = new GameInfoPanel(this.m_game);
        this.m_gameInfoPanel.setBorder(GuiUtil.createSmallEmptyBorder());
        this.m_infoPanel.add((Component)this.m_gameInfoPanel, "North");
        this.m_guiBoard = new GuiBoard(boardSize);
        this.m_showAnalyzeText = new ShowAnalyzeText(this, this.m_guiBoard);
        this.m_statusBar = new StatusBar();
        this.m_innerPanel.add((Component)this.m_statusBar, "South");
        Comment.Listener commentListener = new Comment.Listener(){

            public void changed(String comment) {
                GoGui.this.m_game.setComment(comment);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GoGui.this.updateViews(false);
                    }
                });
            }

            public void textSelected(String text) {
                GoGui.this.textSelected(text);
            }
        };
        this.m_comment = new Comment(commentListener);
        boolean monoFont = this.m_prefs.getBoolean("comment-font-fixed", false);
        this.m_comment.setMonoFont(monoFont);
        this.m_infoPanel.add((Component)this.m_comment, "Center");
        this.m_splitPane = new JSplitPane(1, this.m_guiBoard, this.m_infoPanel);
        this.m_splitPane.setResizeWeight(1.0);
        this.m_innerPanel.add((Component)this.m_splitPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                GoGui.this.m_guiBoard.requestFocusInWindow();
            }

            public void windowClosing(WindowEvent event) {
                GoGui.this.close();
            }
        });
        this.setDefaultCloseOperation(0);
        GuiUtil.setGoIcon(this);
        RecentFileMenu.Listener recentListener = new RecentFileMenu.Listener(){

            public void fileSelected(String label, File file) {
                GoGui.this.actionOpenFile(file);
            }
        };
        RecentFileMenu.Listener recentGtp = new RecentFileMenu.Listener(){

            public void fileSelected(String label, File file) {
                GoGui.this.actionSendFile(file);
            }
        };
        this.m_menuBar = new GoGuiMenuBar(this.m_actions, recentListener, recentGtp, this);
        try {
            this.m_treeLabels = GameTreePanel.Label.values()[this.m_prefs.getInt("gametree-labels", GameTreePanel.Label.NUMBER.ordinal())];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.m_treeLabels = GameTreePanel.Label.NUMBER;
        }
        try {
            this.m_treeSize = GameTreePanel.Size.values()[this.m_prefs.getInt("gametree-size", GameTreePanel.Size.NORMAL.ordinal())];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.m_treeSize = GameTreePanel.Size.NORMAL;
        }
        try {
            this.m_showVariations = ShowVariations.values()[this.m_prefs.getInt("show-variations", ShowVariations.CHILDREN.ordinal())];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.m_showVariations = ShowVariations.CHILDREN;
        }
        this.m_showSubtreeSizes = this.m_prefs.getBoolean("gametree-show-subtree-sizes", false);
        this.m_autoNumber = this.m_prefs.getBoolean("gtpshell-autonumber", false);
        this.m_commandCompletion = !this.m_prefs.getBoolean("gtpshell-disable-completions", false);
        this.m_timeStamp = this.m_prefs.getBoolean("gtpshell-timestamp", false);
        this.m_showLastMove = this.m_prefs.getBoolean("show-last-move", true);
        this.m_showMoveNumbers = this.m_prefs.getBoolean("show-move-numbers", false);
        boolean showCursor = this.m_prefs.getBoolean("show-cursor", false);
        boolean showGrid = this.m_prefs.getBoolean("show-grid", false);
        this.m_guiBoard.setShowCursor(showCursor);
        this.m_guiBoard.setShowGrid(showGrid);
        this.setJMenuBar(this.m_menuBar);
        this.setMinimumSize();
        this.m_programCommand = program;
        if (this.m_programCommand != null && this.m_programCommand.trim().equals("")) {
            this.m_programCommand = null;
        }
        if (time != null) {
            this.m_timeSettings = TimeSettings.parse(time);
        }
        this.protectGui();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GoGui.this.initialize();
            }
        });
    }

    public void actionAbout() {
        String command = null;
        if (this.m_gtp != null) {
            command = this.m_gtp.getProgramCommand();
        }
        AboutDialog.show(this, this.getProgramLabel(), this.m_version, command, this.m_messageDialogs);
    }

    public void actionAddBookmark() {
        if (this.m_gameFile == null) {
            this.showError(I18n.i18n("MSG_CANNOT_SET_BOOKMARK_NO_FILE"), I18n.i18n("MSG_CANNOT_SET_BOOKMARK_NO_FILE_2"), false);
            return;
        }
        if (this.isModified()) {
            this.showError(I18n.i18n("MSG_CANNOT_SET_BOOKMARK_MODIFIED"), I18n.i18n("MSG_CANNOT_SET_BOOKMARK_MODIFIED_2"), false);
            return;
        }
        if (this.getCurrentNode().getFatherConst() != null && this.getCurrentNode().getMove() == null) {
            this.showError(I18n.i18n("MSG_CANNOT_SET_BOOKMARK_NODE"), I18n.i18n("MSG_CANNOT_SET_BOOKMARK_NODE_2"), false);
            return;
        }
        String variation = NodeUtil.getVariationString(this.getCurrentNode());
        int move = NodeUtil.getMoveNumber(this.getCurrentNode());
        Bookmark bookmark = new Bookmark(this.m_gameFile.m_file, move, variation);
        BookmarkEditor editor = new BookmarkEditor();
        bookmark = editor.editItem(this, I18n.i18n("TIT_ADD_BOOKMARK"), bookmark, true, this.m_messageDialogs);
        if (bookmark == null) {
            return;
        }
        this.m_bookmarks.add(bookmark);
        this.m_menuBar.setBookmarks(this.m_bookmarks);
        Bookmark.save(this.m_bookmarks);
    }

    public void actionAttachProgram(int index) {
        this.m_prefs.putInt("program", index);
        this.actionAttachProgram(this.m_programs.get(index));
    }

    public void actionAttachProgram(final Program program) {
        if (!this.checkCommandInProgress()) {
            return;
        }
        this.protectGui();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    GoGui.this.attachNewProgram(program.m_command, program);
                }
                finally {
                    GoGui.this.unprotectGui();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void actionBackToMainVariation() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        ConstNode node = NodeUtil.getBackToMainVariation(this.getCurrentNode());
        this.actionGotoNode(node);
    }

    public void actionBackward(int n) {
        if (!this.checkStateChangePossible()) {
            return;
        }
        boolean protectGui = this.m_gtp != null && (n > 1 || !this.m_gtp.isSupported("undo"));
        this.actionGotoNode(NodeUtil.backward(this.getCurrentNode(), n), protectGui);
    }

    public void actionBeginning() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        this.actionBackward(NodeUtil.getDepth(this.getCurrentNode()));
    }

    public void actionBoardSize(int size) {
        if (!this.checkCommandInProgress()) {
            return;
        }
        this.actionNewGame(size);
        this.m_prefs.putInt("boardsize", size);
    }

    public void actionBoardSizeOther() {
        if (!this.checkCommandInProgress()) {
            return;
        }
        int size = BoardSizeDialog.show(this, this.getBoardSize(), this.m_messageDialogs);
        if (size < 1 || size > 25) {
            return;
        }
        this.actionBoardSize(size);
    }

    public void actionClearAnalyzeCommand() {
        if (!this.checkCommandInProgress()) {
            return;
        }
        this.clearAnalyzeCommand();
    }

    public void actionClockHalt() {
        if (!this.getClock().isRunning()) {
            return;
        }
        this.m_game.haltClock();
        this.updateViews(false);
    }

    public void actionClockResume() {
        if (this.getClock().isRunning()) {
            return;
        }
        this.m_game.resumeClock();
        this.updateViews(false);
    }

    public void actionClockStart() {
        if (this.getClock().isRunning()) {
            return;
        }
        this.m_game.startClock();
        this.updateViews(false);
    }

    public void actionComputerColor(boolean isBlack, boolean isWhite) {
        boolean computerNone = !isBlack && !isWhite;
        this.m_prefs.putBoolean("computer-none", computerNone);
        this.m_computerBlack = isBlack;
        this.m_computerWhite = isWhite;
        if (!this.isCommandInProgress()) {
            this.checkComputerMove();
        }
        this.updateViews(false);
    }

    public void actionDeleteSideVariations() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        if (!NodeUtil.isInMainVariation(this.getCurrentNode())) {
            return;
        }
        String disableKey = "net.sf.gogui.gogui.GoGui.delete-side-variations";
        if (!this.m_messageDialogs.showQuestion(disableKey, this, I18n.i18n("MSG_DELETE_VARIATIONS"), I18n.i18n("MSG_DELETE_VARIATIONS_2"), I18n.i18n("LB_DELETE"), false)) {
            return;
        }
        this.m_game.keepOnlyMainVariation();
        this.boardChangedBegin(false, true);
    }

    public void actionDetachProgram() {
        if (this.m_gtp == null) {
            return;
        }
        if (this.isCommandInProgress() && !this.showQuestion(MessageFormat.format(I18n.i18n("MSG_TERMINATE_COMMAND_IN_PROGRESS"), this.getProgramLabel()), I18n.i18n("MSG_TERMINATE_COMMAND_IN_PROGRESS_2"), I18n.i18n("LB_TERMINATE"), true)) {
            return;
        }
        this.m_prefs.putInt("program", -1);
        this.protectGui();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    GoGui.this.saveSession();
                    GoGui.this.detachProgram();
                    GoGui.this.updateViews(false);
                }
                finally {
                    GoGui.this.unprotectGui();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void actionDisposeAnalyzeDialog() {
        if (this.m_analyzeDialog != null) {
            this.clearAnalyzeCommand();
            this.saveSession();
            this.m_analyzeDialog.dispose();
            this.m_analyzeDialog = null;
        }
    }

    public void actionDisposeTree() {
        if (this.m_gameTreeViewer != null) {
            this.saveSession();
            this.m_gameTreeViewer.dispose();
            this.m_gameTreeViewer = null;
            this.updateViews(false);
        }
    }

    public void actionHelp() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL url = classLoader.getResource("net/sf/gogui/doc/index.html");
        if (url == null) {
            this.showError(I18n.i18n("MSG_HELP_NOT_FOUND"), "");
            return;
        }
        if (this.m_help == null) {
            this.m_help = new Help(url, this.m_messageDialogs, I18n.i18n("TIT_HELP") + " - " + I18n.i18n("LB_GOGUI"));
            this.m_session.restoreSize(this.m_help.getWindow(), "help");
        }
        this.m_help.getWindow().setVisible(true);
        this.m_help.getWindow().toFront();
    }

    public void actionEditBookmarks() {
        BookmarkEditor editor = new BookmarkEditor();
        ObjectListEditor<Bookmark> listEditor = new ObjectListEditor<Bookmark>();
        if (!listEditor.edit(this, I18n.i18n("TIT_EDIT_BOOKMARKS"), this.m_bookmarks, editor, this.m_messageDialogs)) {
            return;
        }
        this.m_menuBar.setBookmarks(this.m_bookmarks);
        Bookmark.save(this.m_bookmarks);
    }

    public void actionEditLabel(GoPoint point) {
        String value = this.getCurrentNode().getLabel(point);
        String message = MessageFormat.format(I18n.i18n("MSG_EDIT_LABEL"), point);
        value = (String)JOptionPane.showInputDialog(this, message, I18n.i18n("TIT_EDIT_LABEL"), -1, null, null, value);
        if (value == null) {
            return;
        }
        this.m_game.setLabel(point, value);
        this.m_guiBoard.setLabel(point, value);
        this.updateViews(false);
    }

    public void actionEditPrograms() {
        ProgramEditor editor = new ProgramEditor();
        ObjectListEditor<Program> listEditor = new ObjectListEditor<Program>();
        if (!listEditor.edit(this, I18n.i18n("TIT_EDIT_PROGRAMS"), this.m_programs, editor, this.m_messageDialogs)) {
            return;
        }
        this.m_menuBar.setPrograms(this.m_programs);
        this.m_prefs.putInt("program", -1);
        Program.save(this.m_programs);
    }

    public void actionEnd() {
        this.actionForward(NodeUtil.getNodesLeft(this.getCurrentNode()));
    }

    public void actionExportLatexMainVariation() {
        File file = this.showSave(I18n.i18n("TIT_EXPORT_LATEX"));
        if (file == null) {
            return;
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            String title = FileUtil.removeExtension(new File(file.getName()), "tex");
            new TexWriter(title, out, this.getTree());
        }
        catch (FileNotFoundException e) {
            this.showError(I18n.i18n("MSG_EXPORT_FAILED"), e);
        }
    }

    public void actionExportLatexPosition() {
        File file = this.showSave(I18n.i18n("TIT_EXPORT_LATEX_POSITION"));
        if (file == null) {
            return;
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            String title = FileUtil.removeExtension(new File(file.getName()), "tex");
            new TexWriter(title, out, this.getBoard(), GuiBoardUtil.getLabels(this.m_guiBoard), GuiBoardUtil.getMark(this.m_guiBoard), GuiBoardUtil.getMarkTriangle(this.m_guiBoard), GuiBoardUtil.getMarkCircle(this.m_guiBoard), GuiBoardUtil.getMarkSquare(this.m_guiBoard), GuiBoardUtil.getSelects(this.m_guiBoard));
        }
        catch (FileNotFoundException e) {
            this.showError(I18n.i18n("MSG_EXPORT_FAILED"), e);
        }
    }

    public void actionExportSgfPosition() {
        File file = FileDialogs.showSaveSgf(this, this.m_messageDialogs);
        if (file == null) {
            return;
        }
        try {
            this.savePosition(file);
        }
        catch (FileNotFoundException e) {
            this.showError(I18n.i18n("MSG_EXPORT_FAILED"), e);
        }
    }

    public void actionExportTextPosition() {
        File file = this.showSave(I18n.i18n("MSG_EXPORT_TEXT"));
        if (file == null) {
            return;
        }
        try {
            String text = BoardUtil.toString(this.getBoard(), false, false);
            PrintStream out = new PrintStream(file);
            out.print(text);
            out.close();
        }
        catch (FileNotFoundException e) {
            this.showError(I18n.i18n("MSG_EXPORT_FAILED"), e);
        }
    }

    public void actionExportPng() {
        ExportPng.run(this, this.m_guiBoard, this.m_prefs, this.m_messageDialogs);
    }

    public void actionExportTextPositionToClipboard() {
        GuiUtil.copyToClipboard(BoardUtil.toString(this.getBoard(), false, false));
    }

    public void actionFind() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        Pattern pattern = FindDialog.run(this, this.m_comment.getSelectedText(), this.m_messageDialogs);
        if (pattern == null) {
            return;
        }
        this.m_pattern = pattern;
        if (NodeUtil.commentContains(this.getCurrentNode(), this.m_pattern)) {
            this.m_comment.markAll(this.m_pattern);
        } else {
            this.actionFindNext();
        }
    }

    public void actionFindNext() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        if (this.m_pattern == null) {
            return;
        }
        this.protectGui();
        this.showStatus(I18n.i18n("STAT_FIND_SEARCHING_COMMENTS"));
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ConstNode root = GoGui.this.getTree().getRootConst();
                    ConstNode currentNode = GoGui.this.getCurrentNode();
                    ConstNode node = NodeUtil.findInComments(currentNode, GoGui.this.m_pattern);
                    boolean cancel = false;
                    if (node == null && GoGui.this.getCurrentNode() != root) {
                        GoGui.this.unprotectGui();
                        if (GoGui.this.showQuestion(I18n.i18n("MSG_FIND_CONTINUE"), I18n.i18n("MSG_FIND_CONTINUE_2"), I18n.i18n("LB_FIND_CONTINUE"), false)) {
                            GoGui.this.protectGui();
                            node = root;
                            if (!NodeUtil.commentContains(node, GoGui.this.m_pattern)) {
                                node = NodeUtil.findInComments(node, GoGui.this.m_pattern);
                            }
                        } else {
                            cancel = true;
                        }
                    }
                    if (!cancel) {
                        if (node == null) {
                            GoGui.this.unprotectGui();
                            GoGui.this.showInfo(I18n.i18n("MSG_FIND_NOT_FOUND"), MessageFormat.format(I18n.i18n("MSG_FIND_NOT_FOUND_2"), GoGui.this.m_pattern), false);
                            GoGui.this.m_pattern = null;
                        } else {
                            GoGui.this.gotoNode(node);
                            GoGui.this.boardChangedBegin(false, false);
                            GoGui.this.m_comment.markAll(GoGui.this.m_pattern);
                        }
                    }
                }
                finally {
                    GoGui.this.unprotectGui();
                    GoGui.this.clearStatus();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void actionFindNextComment() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        this.protectGui();
        this.showStatus(I18n.i18n("STAT_FIND_SEARCHING_COMMENTS"));
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ConstNode root = GoGui.this.getTree().getRootConst();
                    ConstNode currentNode = GoGui.this.getCurrentNode();
                    ConstNode node = NodeUtil.findNextComment(currentNode);
                    boolean cancel = false;
                    if (node == null && GoGui.this.getCurrentNode() != root) {
                        GoGui.this.unprotectGui();
                        if (GoGui.this.showQuestion(I18n.i18n("MSG_FIND_CONTINUE"), I18n.i18n("MSG_FIND_CONTINUE_2"), I18n.i18n("LB_FIND_CONTINUE"), false)) {
                            GoGui.this.protectGui();
                            node = root;
                            if (!node.hasComment()) {
                                node = NodeUtil.findNextComment(node);
                            }
                        } else {
                            cancel = true;
                        }
                    }
                    if (!cancel) {
                        if (node == null) {
                            GoGui.this.unprotectGui();
                            GoGui.this.showInfo(I18n.i18n("MSG_FIND_NO_COMMENT_FOUND"), null, false);
                        } else {
                            GoGui.this.gotoNode(node);
                            GoGui.this.boardChangedBegin(false, false);
                        }
                    }
                }
                finally {
                    GoGui.this.unprotectGui();
                    GoGui.this.clearStatus();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void actionForward(int n) {
        if (!this.checkStateChangePossible()) {
            return;
        }
        boolean protectGui = this.m_gtp != null && n > 1;
        this.actionGotoNode(NodeUtil.forward(this.getCurrentNode(), n), protectGui);
    }

    public void actionGameInfo() {
        if (!this.checkCommandInProgress()) {
            return;
        }
        ConstNode node = this.m_game.getGameInfoNode();
        GameInfo info = new GameInfo(node.getGameInfoConst());
        GameInfoDialog.show(this, info, this.m_messageDialogs);
        this.m_game.setGameInfo(info, node);
        this.currentNodeChanged();
        Komi prefsKomi = this.getPrefsKomi();
        Komi komi = info.getKomi();
        if (komi != null && !komi.equals(prefsKomi) && info.getHandicap() == 0) {
            this.m_prefs.put("komi", komi.toString());
        }
        if (info.getTimeSettings() != null && !info.getTimeSettings().equals(this.m_timeSettings)) {
            TimeSettings timeSettings = info.getTimeSettings();
            this.m_game.setTimeSettings(timeSettings);
            this.m_timeSettings = timeSettings;
        }
        this.setTitle();
        this.updateViews(false);
    }

    public void actionGotoBookmark(int i) {
        if (!this.checkStateChangePossible()) {
            return;
        }
        if (!this.checkSaveGame()) {
            return;
        }
        if (i < 0 || i >= this.m_bookmarks.size()) {
            return;
        }
        Bookmark bookmark = this.m_bookmarks.get(i);
        if (!this.loadFile(bookmark.m_file, -1)) {
            return;
        }
        this.updateViews(true);
        String variation = bookmark.m_variation;
        ConstNode node = this.getTree().getRootConst();
        if (!variation.equals("") && (node = NodeUtil.findByVariation(node, variation)) == null) {
            this.showError(I18n.i18n("MSG_BOOKMARK_INVALID_VARIATION"), "");
            return;
        }
        if ((node = NodeUtil.findByMoveNumber(node, bookmark.m_move)) == null) {
            this.showError(I18n.i18n("MSG_BOOKMARK_INVALID_MOVE_NUMBER"), "");
            return;
        }
        this.actionGotoNode(node);
    }

    public void actionGotoMove() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        ConstNode node = MoveNumberDialog.show(this, this.getCurrentNode(), this.m_messageDialogs);
        if (node == null) {
            return;
        }
        this.actionGotoNode(node);
    }

    public void actionGotoNode(ConstNode node) {
        boolean protectGui = this.m_gtp != null;
        this.actionGotoNode(node, protectGui);
    }

    private void actionGotoNode(final ConstNode node, final boolean protectGui) {
        if (!this.checkStateChangePossible()) {
            return;
        }
        if (protectGui) {
            this.protectGui();
        }
        Runnable runnable = new Runnable(){

            public void run() {
                GoGui.this.gotoNode(node);
                GoGui.this.boardChangedBegin(false, false);
                if (protectGui) {
                    GoGui.this.unprotectGui();
                }
            }
        };
        if (protectGui) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    public void actionGotoVariation() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        ConstNode node = GotoVariationDialog.show(this, this.getTree(), this.getCurrentNode(), this.m_messageDialogs);
        if (node == null) {
            return;
        }
        this.actionGotoNode(node);
    }

    public void actionHandicap(int handicap) {
        if (!this.checkCommandInProgress()) {
            return;
        }
        this.m_handicap = handicap;
        if (this.isModified()) {
            this.showInfo(I18n.i18n("MSG_HANDICAP_NEXT_GAME"), I18n.i18n("MSG_HANDICAP_NEXT_GAME_2"), true);
        } else {
            this.m_computerBlack = false;
            this.m_computerWhite = false;
            this.newGame(this.getBoardSize());
            this.updateViews(true);
        }
    }

    public void actionImportSgfFromClipboard() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        if (!this.checkSaveGame()) {
            return;
        }
        String text = GuiUtil.getClipboardText();
        if (text == null) {
            this.showError(I18n.i18n("MSG_NO_TEXT_IN_CLIPBOARD"), "", false);
            return;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes());
        try {
            SgfReader reader = new SgfReader(in, null, null, 0L);
            GameTree tree = reader.getTree();
            this.m_game.init(tree);
        }
        catch (SgfError e) {
            this.showError(I18n.i18n("MSG_IMPORT_FAILED"), e);
        }
        this.m_guiBoard.initSize(this.getBoard().getSize());
        this.initGtp();
        this.m_computerBlack = false;
        this.m_computerWhite = false;
        this.boardChangedBegin(false, true);
    }

    public void actionImportTextPosition() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        if (!this.checkSaveGame()) {
            return;
        }
        File file = FileDialogs.showOpen(this, I18n.i18n("TIT_IMPORT_TEXT"));
        if (file == null) {
            return;
        }
        try {
            this.importTextPosition(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            this.showError(I18n.i18n("MSG_FILE_NOT_FOUND"), "", false);
        }
    }

    public void actionImportTextPositionFromClipboard() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        if (!this.checkSaveGame()) {
            return;
        }
        String text = GuiUtil.getClipboardText();
        if (text == null) {
            this.showError(I18n.i18n("MSG_NO_TEXT_IN_CLIPBOARD"), "", false);
        } else {
            this.importTextPosition(new StringReader(text));
        }
    }

    public void actionInterrupt() {
        if (this.m_gtp == null || this.m_gtp.isProgramDead() || !this.isCommandInProgress()) {
            return;
        }
        if (this.m_interrupt.run(this, this.m_gtp, this.m_messageDialogs)) {
            this.showStatus(I18n.i18n("STAT_INTERRUPT"));
            this.m_interruptComputerBoth = true;
        }
    }

    public void actionKeepOnlyPosition() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        if (!this.showQuestion(I18n.i18n("MSG_KEEP_ONLY_POSITION"), I18n.i18n("MSG_KEEP_ONLY_POSITION_2"), I18n.i18n("LB_DELETE"), true)) {
            return;
        }
        this.m_game.keepOnlyPosition();
        this.initGtp();
        this.boardChangedBegin(false, true);
    }

    public void actionMainWindowActivate() {
        this.requestFocus();
    }

    public void actionMakeMainVariation() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        String disableKey = "net.sf.gogui.gogui.GoGui.make-main-variation";
        if (!this.m_messageDialogs.showQuestion(disableKey, this, I18n.i18n("MSG_MAKE_MAIN_VAR"), I18n.i18n("MSG_MAKE_MAIN_VAR_2"), I18n.i18n("LB_MAKE_MAIN_VAR"), false)) {
            return;
        }
        this.m_game.makeMainVariation();
        this.boardChangedBegin(false, true);
    }

    public void actionMark(GoPoint point, MarkType type, boolean mark) {
        if (mark) {
            this.m_game.addMarked(point, type);
        } else {
            this.m_game.removeMarked(point, type);
        }
        if (type == MarkType.MARK) {
            this.m_guiBoard.setMark(point, mark);
        } else if (type == MarkType.CIRCLE) {
            this.m_guiBoard.setMarkCircle(point, mark);
        } else if (type == MarkType.SQUARE) {
            this.m_guiBoard.setMarkSquare(point, mark);
        } else if (type == MarkType.TRIANGLE) {
            this.m_guiBoard.setMarkTriangle(point, mark);
        }
        this.updateViews(false);
    }

    public void actionNewGame() {
        this.actionNewGame(this.getBoardSize());
    }

    public void actionNewGame(int size) {
        if (!this.checkStateChangePossible()) {
            return;
        }
        if (!this.checkSaveGame()) {
            return;
        }
        this.setFile(null);
        this.newGame(size);
        if (this.m_gtp != null && !this.m_gtp.isGenmoveSupported()) {
            this.m_computerBlack = false;
            this.m_computerWhite = false;
        } else if (this.m_computerBlack || this.m_computerWhite) {
            if (this.m_handicap == 0) {
                this.m_computerBlack = false;
                this.m_computerWhite = true;
            } else {
                this.m_computerBlack = true;
                this.m_computerWhite = false;
            }
        }
        this.boardChangedBegin(true, true);
    }

    public void actionNewProgram() {
        this.m_newProgram = new Program("", "", "", "", "");
        final ProgramEditor editor = new ProgramEditor();
        this.m_newProgram = editor.editItem(this, I18n.i18n("TIT_NEW_PROGRAM"), this.m_newProgram, true, false, this.m_messageDialogs);
        if (this.m_newProgram == null) {
            return;
        }
        this.protectGui();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GoGui.this.attachNewProgram(((GoGui)GoGui.this).m_newProgram.m_command, GoGui.this.m_newProgram);
                GoGui.this.unprotectGui();
                if (GoGui.this.m_gtp == null || GoGui.this.m_gtp.isProgramDead()) {
                    GoGui.this.m_newProgram = editor.editItem(GoGui.this, I18n.i18n("TIT_NEW_PROGRAM"), GoGui.this.m_newProgram, true, false, GoGui.this.m_messageDialogs);
                    if (GoGui.this.m_newProgram == null) {
                        return;
                    }
                    SwingUtilities.invokeLater(this);
                    return;
                }
                ((GoGui)GoGui.this).m_newProgram.m_name = GoGui.this.m_gtp.getLabel();
                ((GoGui)GoGui.this).m_newProgram.m_version = GoGui.this.m_version;
                GoGui.this.m_newProgram.setUniqueLabel(GoGui.this.m_programs);
                GoGui.this.m_newProgram = editor.editItem(GoGui.this, I18n.i18n("TIT_NEW_PROGRAM"), GoGui.this.m_newProgram, false, true, GoGui.this.m_messageDialogs);
                if (GoGui.this.m_newProgram == null) {
                    GoGui.this.actionDetachProgram();
                    return;
                }
                GoGui.this.m_programs.add(GoGui.this.m_newProgram);
                GoGui.this.m_program = GoGui.this.m_newProgram;
                GoGui.this.m_prefs.putInt("program", GoGui.this.m_programs.size() - 1);
                GoGui.this.m_menuBar.setPrograms(GoGui.this.m_programs);
                Program.save(GoGui.this.m_programs);
                GoGui.this.updateViews(false);
            }
        });
    }

    public void actionNextEarlierVariation() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        ConstNode node = NodeUtil.getNextEarlierVariation(this.getCurrentNode());
        if (node != null) {
            this.actionGotoNode(node);
        }
    }

    public void actionNextVariation() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        ConstNode node = NodeUtil.getNextVariation(this.getCurrentNode());
        if (node != null) {
            this.actionGotoNode(node);
        }
    }

    public void actionOpen() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        if (!this.checkSaveGame()) {
            return;
        }
        File file = FileDialogs.showOpenSgf(this);
        if (file == null) {
            return;
        }
        this.actionOpenFile(file);
    }

    public void actionOpenFile(final File file) {
        boolean protectGui;
        if (file == null) {
            return;
        }
        if (!this.checkStateChangePossible()) {
            return;
        }
        if (!this.checkSaveGame()) {
            return;
        }
        boolean bl = protectGui = this.m_gtp != null;
        if (protectGui) {
            this.protectGui();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GoGui.this.loadFile(file, -1);
                GoGui.this.boardChangedBegin(false, true);
                if (protectGui) {
                    GoGui.this.unprotectGui();
                }
            }
        });
    }

    public void actionPass() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        if (!this.showOptionalQuestion("pass", I18n.i18n("MSG_PASS"), I18n.i18n("MSG_PASS_2"), I18n.i18n("LB_PASS"), false)) {
            return;
        }
        this.humanMoved(Move.getPass(this.getToMove()));
    }

    public void actionPlay(boolean isSingleMove) {
        if (!this.checkStateChangePossible()) {
            return;
        }
        if (!this.synchronizeProgram()) {
            return;
        }
        if (!isSingleMove && !this.isComputerBoth()) {
            this.m_computerBlack = false;
            this.m_computerWhite = false;
            if (this.getToMove() == GoColor.BLACK) {
                this.m_computerBlack = true;
            } else {
                this.m_computerWhite = true;
            }
        }
        this.generateMove(isSingleMove);
        this.m_game.startClock();
    }

    public void actionPreviousEarlierVariation() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        ConstNode node = NodeUtil.getPreviousEarlierVariation(this.getCurrentNode());
        if (node != null) {
            this.actionGotoNode(node);
        }
    }

    public void actionPreviousVariation() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        ConstNode node = NodeUtil.getPreviousVariation(this.getCurrentNode());
        if (node != null) {
            this.actionGotoNode(node);
        }
    }

    public void actionPrint() {
        Print.run(this, this.m_guiBoard, this.m_messageDialogs);
    }

    public void actionReattachProgram() {
        if (this.m_gtp == null) {
            return;
        }
        if (!this.checkCommandInProgress()) {
            return;
        }
        this.protectGui();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    GoGui.this.attachNewProgram(GoGui.this.m_programCommand, GoGui.this.m_program);
                }
                finally {
                    GoGui.this.unprotectGui();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void actionReattachWithParameters() {
        boolean fromSnapshot;
        if (this.m_gtp == null) {
            return;
        }
        if (!this.checkCommandInProgress()) {
            return;
        }
        boolean bl = fromSnapshot = this.isProgramDead() && this.m_parameterSnapshot != null;
        if (!fromSnapshot && !this.checkHasParameterCommands()) {
            return;
        }
        this.protectGui();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    File file;
                    if (fromSnapshot) {
                        file = GoGui.this.m_parameterSnapshot;
                    } else {
                        try {
                            file = File.createTempFile("gogui-param", ".gtp");
                        }
                        catch (IOException e) {
                            GoGui.this.showError(I18n.i18n("MSG_PARAM_TMP_FILE_ERROR"), e);
                            GoGui.this.unprotectGui();
                            return;
                        }
                        if (!GoGui.this.saveParameters(file)) {
                            return;
                        }
                    }
                    if (!GoGui.this.attachNewProgram(GoGui.this.m_programCommand, GoGui.this.m_program)) {
                        return;
                    }
                    GoGui.this.sendGtpFile(file);
                }
                finally {
                    GoGui.this.unprotectGui();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void actionRestoreParameters() {
        if (this.m_gtp == null) {
            return;
        }
        if (!this.checkCommandInProgress()) {
            return;
        }
        if (this.m_parameterSnapshot == null) {
            return;
        }
        this.sendGtpFile(this.m_parameterSnapshot);
    }

    public void actionSave() {
        if (!this.isModified()) {
            return;
        }
        if (this.m_gameFile == null) {
            this.actionSaveAs();
        } else {
            String optionalMessage;
            String mainMessage;
            String disableKey;
            File file = this.m_gameFile.m_file;
            if (file.exists() && !this.m_messageDialogs.showQuestion(disableKey = "net.sf.gogui.GoGui.overwrite", this, mainMessage = MessageFormat.format(I18n.i18n("MSG_REPLACE_FILE"), file.getName()), optionalMessage = I18n.i18n("MSG_REPLACE_FILE_2"), I18n.i18n("LB_REPLACE_FILE"), true)) {
                return;
            }
            this.save(this.m_gameFile);
        }
        this.updateViews(false);
    }

    public void actionSaveAs() {
        this.saveDialog();
        this.updateViews(false);
    }

    public void actionSaveCommands() {
        if (this.m_shell == null) {
            return;
        }
        this.m_shell.saveCommands(this);
    }

    public void actionSaveLog() {
        if (this.m_shell == null) {
            return;
        }
        this.m_shell.saveLog(this);
    }

    public void actionSaveParameters() {
        if (this.m_gtp == null) {
            return;
        }
        if (!this.checkHasParameterCommands()) {
            return;
        }
        File file = this.showSave(I18n.i18n("TIT_SAVE_PARAM"));
        if (file == null) {
            return;
        }
        this.saveParameters(file);
    }

    public void actionSnapshotParameters() {
        if (this.m_gtp == null) {
            return;
        }
        if (!this.checkCommandInProgress()) {
            return;
        }
        if (!this.checkHasParameterCommands()) {
            return;
        }
        if (this.m_parameterSnapshot == null) {
            try {
                this.m_parameterSnapshot = File.createTempFile("gogui-param", ".gtp");
            }
            catch (IOException e) {
                this.showError(I18n.i18n("MSG_PARAM_TMP_FILE_ERROR"), e);
                return;
            }
        }
        this.saveParameters(this.m_parameterSnapshot);
        this.updateViews(false);
    }

    public void actionScore() {
        boolean programReady;
        if (this.m_scoreMode) {
            return;
        }
        if (!this.checkStateChangePossible()) {
            return;
        }
        boolean bl = programReady = this.m_gtp != null && this.synchronizeProgram();
        if (this.m_gtp == null || !programReady) {
            String disableKey = "net.sf.gogui.gogui.GoGui.score-no-program";
            String optionalMessage = this.m_gtp == null ? "MSG_SCORE_NO_PROGRAM" : "MSG_SCORE_CANNOT_USE_PROGRAM";
            this.m_messageDialogs.showInfo(disableKey, this, I18n.i18n("MSG_SCORE_MANUAL"), I18n.i18n(optionalMessage), true);
            this.updateViews(false);
            this.initScore(null);
            return;
        }
        if (this.m_gtp.isSupported("final_status_list")) {
            Runnable callback = new Runnable(){

                public void run() {
                    GoGui.this.scoreContinue();
                }
            };
            this.runLengthyCommand("final_status_list dead", callback);
        } else {
            String disableKey = "net.sf.gogui.gogui.GoGui.score-not-supported";
            String name = this.getProgramName();
            String optionalMessage = MessageFormat.format(I18n.i18n("MSG_SCORE_NO_SUPPORT"), name);
            this.m_messageDialogs.showInfo(disableKey, this, I18n.i18n("MSG_SCORE_MANUAL"), optionalMessage, true);
            this.updateViews(false);
            this.initScore(null);
        }
    }

    public void actionScoreDone(Score score) {
        if (!this.m_scoreMode) {
            return;
        }
        this.scoreDone(score);
        this.updateViews(false);
    }

    public void actionSendCommand(String command, final boolean isCritical, final boolean showError) {
        if (!this.checkCommandInProgress()) {
            return;
        }
        if (GtpUtil.isStateChangingCommand(command)) {
            this.showError(I18n.i18n("MSG_BOARD_CHANGING_COMMAND"), "", false);
            return;
        }
        if (!this.synchronizeProgram()) {
            return;
        }
        Runnable callback = new Runnable(){

            public void run() {
                GoGui.this.endLengthyCommand(isCritical, showError);
            }
        };
        this.m_gtp.send(command, callback);
        this.beginLengthyCommand();
    }

    public void actionSendFile() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        if (this.m_shell == null) {
            return;
        }
        File file = FileDialogs.showOpen(this, I18n.i18n("TIT_CHOOSE_GTP_FILE"));
        if (file == null) {
            return;
        }
        this.actionSendFile(file);
    }

    public void actionSendFile(File file) {
        if (file == null) {
            return;
        }
        if (!this.checkStateChangePossible()) {
            return;
        }
        if (this.m_shell == null) {
            return;
        }
        if (!this.synchronizeProgram()) {
            return;
        }
        this.sendGtpFile(file);
        this.m_menuBar.addRecentGtp(file);
        this.updateViews(false);
    }

    public void actionSetAnalyzeCommand(AnalyzeCommand command) {
        this.actionSetAnalyzeCommand(command, false, true, true, false);
    }

    public void actionSetAnalyzeCommand(AnalyzeCommand command, boolean autoRun, boolean clearBoard, boolean oneRunOnly, boolean reuseTextWindow) {
        if (!this.synchronizeProgram()) {
            return;
        }
        if (!this.checkStateChangePossible()) {
            return;
        }
        this.initAnalyzeCommand(command, autoRun, clearBoard, reuseTextWindow);
        this.m_analyzeOneRunOnly = oneRunOnly;
        boolean needsPointArg = this.m_analyzeCommand.needsPointArg();
        if (needsPointArg && !this.m_analyzeCommand.isPointArgMissing()) {
            this.m_guiBoard.clearAllSelect();
            this.m_guiBoard.setSelect(this.m_analyzeCommand.getPointArg(), true);
        } else if (needsPointArg || this.m_analyzeCommand.needsPointListArg()) {
            this.m_guiBoard.clearAllSelect();
            if (this.m_analyzeCommand.getType() == AnalyzeType.EPLIST) {
                GuiBoardUtil.setSelect(this.m_guiBoard, this.m_analyzeCommand.getPointListArg(), true);
            }
            this.toFront();
            return;
        }
        this.analyzeBegin(false);
    }

    public void actionSetShowVariations(ShowVariations mode) {
        this.m_showVariations = mode;
        this.m_prefs.putInt("show-variations", this.m_showVariations.ordinal());
        this.resetBoard();
        this.updateViews(false);
    }

    public void actionSetTimeLeft() {
        TimeLeftDialog.show(this, this.m_game, this.getCurrentNode(), this.m_messageDialogs);
        this.updateViews(false);
    }

    public void actionSetup(GoColor color) {
        assert (color.isBlackWhite());
        if (!this.checkCommandInProgress()) {
            return;
        }
        if (this.m_scoreMode) {
            this.scoreDone(null);
        }
        ConstNode node = this.getCurrentNode();
        if (this.m_setupMode) {
            if (color == this.m_setupColor) {
                this.setupDone();
                this.boardChangedBegin(false, true);
            } else {
                this.m_setupColor = color;
            }
            this.updateViews(false);
        } else {
            this.resetBoard();
            this.m_setupMode = true;
            this.m_setupColor = color;
            boolean bl = this.m_setupNodeCreated = node.getMove() != null || node.hasChildren();
            if (this.m_setupNodeCreated) {
                this.m_game.createNewChild();
                this.currentNodeChanged();
                this.updateViews(true);
            } else {
                this.updateViews(false);
            }
        }
        if (this.m_setupMode) {
            if (this.m_setupColor == GoColor.BLACK) {
                this.showStatus(I18n.i18n("STAT_SETUP_BLACK"));
            } else {
                this.showStatus(I18n.i18n("STAT_SETUP_WHITE"));
            }
        }
    }

    public void actionShowAnalyzeDialog() {
        if (this.m_gtp == null) {
            return;
        }
        if (this.m_analyzeDialog == null) {
            this.createAnalyzeDialog();
        } else {
            this.m_analyzeDialog.toFront();
        }
    }

    public void actionShowShell() {
        this.showShell();
    }

    public void actionShowTree() {
        if (this.m_gameTreeViewer == null) {
            this.createTree();
            this.updateViews(false);
        } else {
            this.m_gameTreeViewer.toFront();
        }
    }

    public void actionToggleBeepAfterMove() {
        this.m_beepAfterMove = !this.m_beepAfterMove;
        this.m_prefs.putBoolean("beep-after-move", this.m_beepAfterMove);
    }

    public void actionToggleAutoNumber() {
        boolean bl = this.m_autoNumber = !this.m_autoNumber;
        if (this.m_gtp != null) {
            this.m_gtp.setAutoNumber(this.m_autoNumber);
        }
    }

    public void actionToggleCommentMonoFont() {
        boolean monoFont = !this.m_comment.getMonoFont();
        this.m_comment.setMonoFont(monoFont);
        this.m_prefs.putBoolean("comment-font-fixed", monoFont);
    }

    public void actionToggleCompletion() {
        boolean bl = this.m_commandCompletion = !this.m_commandCompletion;
        if (this.m_shell != null) {
            this.m_shell.setCommandCompletion(this.m_commandCompletion);
        }
        this.m_prefs.putBoolean("gtpshell-disable-completions", !this.m_commandCompletion);
    }

    public void actionToggleShowCursor() {
        boolean showCursor = !this.m_guiBoard.getShowCursor();
        this.m_guiBoard.setShowCursor(showCursor);
        this.m_prefs.putBoolean("show-cursor", showCursor);
    }

    public void actionToggleShowGrid() {
        boolean showGrid = !this.m_guiBoard.getShowGrid();
        this.m_guiBoard.setShowGrid(showGrid);
        this.m_prefs.putBoolean("show-grid", showGrid);
    }

    public void actionToggleShowInfoPanel() {
        if (GuiUtil.isNormalSizeMode(this)) {
            if (this.m_showInfoPanel) {
                this.m_comment.setPreferredSize(this.m_comment.getSize());
            }
            this.m_guiBoard.setPreferredFieldSize(this.m_guiBoard.getFieldSize());
        }
        this.showInfoPanel(!this.m_showInfoPanel);
        this.updateViews(false);
    }

    public void actionToggleShowLastMove() {
        this.m_showLastMove = !this.m_showLastMove;
        this.m_prefs.putBoolean("show-last-move", this.m_showLastMove);
        this.updateFromGoBoard();
        this.updateViews(false);
    }

    public void actionToggleShowMoveNumbers() {
        if (this.m_showMoveNumbers) {
            this.m_guiBoard.clearAllLabels();
        }
        this.m_showMoveNumbers = !this.m_showMoveNumbers;
        this.m_prefs.putBoolean("show-move-numbers", this.m_showMoveNumbers);
        this.updateFromGoBoard();
        this.updateViews(false);
    }

    public void actionToggleShowSubtreeSizes() {
        this.m_showSubtreeSizes = !this.m_showSubtreeSizes;
        this.m_prefs.putBoolean("gametree-show-subtree-sizes", this.m_showSubtreeSizes);
        if (this.m_gameTreeViewer == null) {
            this.updateViews(false);
        } else {
            this.m_gameTreeViewer.setShowSubtreeSizes(this.m_showSubtreeSizes);
            this.updateViews(true);
        }
    }

    public void actionToggleShowToolbar() {
        if (GuiUtil.isNormalSizeMode(this)) {
            if (this.m_showInfoPanel) {
                this.m_comment.setPreferredSize(this.m_comment.getSize());
            }
            this.m_guiBoard.setPreferredFieldSize(this.m_guiBoard.getFieldSize());
        }
        this.showToolbar(!this.m_showToolbar);
        this.updateViews(false);
    }

    public void actionToggleTimeStamp() {
        boolean bl = this.m_timeStamp = !this.m_timeStamp;
        if (this.m_shell != null) {
            this.m_shell.setTimeStamp(this.m_timeStamp);
        }
        this.m_prefs.putBoolean("gtpshell-timestamp", this.m_timeStamp);
        this.updateViews(false);
    }

    public void actionTreeLabels(GameTreePanel.Label mode) {
        this.m_treeLabels = mode;
        this.m_prefs.putInt("gametree-labels", mode.ordinal());
        if (this.m_gameTreeViewer == null) {
            this.updateViews(false);
        } else {
            this.m_gameTreeViewer.setLabelMode(mode);
            this.updateViews(true);
        }
    }

    public void actionTreeSize(GameTreePanel.Size mode) {
        this.m_treeSize = mode;
        this.m_prefs.putInt("gametree-size", mode.ordinal());
        if (this.m_gameTreeViewer == null) {
            this.updateViews(false);
        } else {
            this.m_gameTreeViewer.setSizeMode(mode);
            this.updateViews(true);
        }
    }

    public void actionTruncate() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        if (!this.getCurrentNode().hasFather()) {
            return;
        }
        String disableKey = "net.sf.gogui.gogui.GoGui.truncate";
        if (!this.m_messageDialogs.showQuestion(disableKey, this, I18n.i18n("MSG_TRUNCATE"), I18n.i18n("MSG_TRUNCATE_2"), I18n.i18n("LB_TRUNCATE"), false)) {
            return;
        }
        this.m_game.truncate();
        this.actionGotoNode(this.getCurrentNode());
        this.boardChangedBegin(false, true);
    }

    public void actionTruncateChildren() {
        if (!this.checkStateChangePossible()) {
            return;
        }
        int numberChildren = this.getCurrentNode().getNumberChildren();
        if (numberChildren == 0) {
            return;
        }
        String disableKey = "net.sf.gogui.gogui.GoGui.truncate-children";
        if (!this.m_messageDialogs.showQuestion(disableKey, this, I18n.i18n("MSG_TRUNCATE_CHILDREN"), I18n.i18n("MSG_TRUNCATE_CHILDREN_2"), I18n.i18n("LB_TRUNCATE"), false)) {
            return;
        }
        this.m_game.truncateChildren();
        this.boardChangedBegin(false, true);
    }

    public void actionQuit() {
        this.close();
    }

    public boolean getAutoNumber() {
        return this.m_autoNumber;
    }

    public boolean getBeepAfterMove() {
        return this.m_beepAfterMove;
    }

    public boolean getCommentMonoFont() {
        return this.m_comment.getMonoFont();
    }

    public boolean getCompletion() {
        return this.m_commandCompletion;
    }

    public String getProgramName() {
        String name = null;
        if (this.m_gtp != null) {
            name = this.m_gtp.getName();
        }
        if (name == null) {
            name = I18n.i18n("MSG_UNKNOWN_PROGRAM_NAME");
        }
        return name;
    }

    public int getNumberPrograms() {
        return this.m_programs.size();
    }

    public String getProgramLabel() {
        if (this.m_gtp == null) {
            return null;
        }
        if (this.m_program != null && !StringUtil.isEmpty(this.m_program.m_label)) {
            return this.m_program.m_label;
        }
        return this.m_gtp.getLabel();
    }

    public GoColor getSetupColor() {
        return this.m_setupColor;
    }

    public boolean getShowLastMove() {
        return this.m_showLastMove;
    }

    public boolean getShowMoveNumbers() {
        return this.m_showMoveNumbers;
    }

    public boolean getShowSubtreeSizes() {
        return this.m_showSubtreeSizes;
    }

    public ShowVariations getShowVariations() {
        return this.m_showVariations;
    }

    public boolean getTimeStamp() {
        return this.m_timeStamp;
    }

    public GameTreePanel.Label getTreeLabels() {
        return this.m_treeLabels;
    }

    public GameTreePanel.Size getTreeSize() {
        return this.m_treeSize;
    }

    public boolean hasParameterCommands() {
        if (this.m_analyzeCommands == null) {
            return false;
        }
        return AnalyzeUtil.hasParameterCommands(this.m_analyzeCommands);
    }

    public boolean hasParameterSnapshot() {
        return this.m_parameterSnapshot != null;
    }

    public boolean isAnalyzeDialogShown() {
        return this.m_analyzeDialog != null;
    }

    public boolean isCommandInProgress() {
        return this.m_gtp != null && this.m_gtp.isCommandInProgress();
    }

    public boolean isComputerColor(GoColor color) {
        if (color == GoColor.BLACK) {
            return this.m_computerBlack;
        }
        assert (color == GoColor.WHITE);
        return this.m_computerWhite;
    }

    public boolean isInfoPanelShown() {
        return this.m_showInfoPanel;
    }

    public boolean isShellShown() {
        return this.m_shell != null && this.m_shell.isVisible();
    }

    public boolean isToolbarShown() {
        return this.m_showToolbar;
    }

    public boolean isTreeShown() {
        return this.m_gameTreeViewer != null;
    }

    public void contextMenu(GoPoint point, Component invoker, int x, int y) {
        if (this.m_setupMode || this.m_analyzeCommand != null && this.m_analyzeCommand.needsPointListArg()) {
            this.fieldClicked(point, true);
            return;
        }
        ContextMenu contextMenu = this.createContextMenu(point);
        contextMenu.show(invoker, x, y);
    }

    public void fieldClicked(GoPoint p, boolean modifiedSelect) {
        if (this.m_setupMode) {
            if (!this.checkCommandInProgress()) {
                return;
            }
            GoColor color = modifiedSelect ? this.m_setupColor.otherColor() : this.m_setupColor;
            if (this.getBoard().getColor(p) == color) {
                color = GoColor.EMPTY;
            }
            this.setup(p, color);
            this.updateViews(false);
        } else if (this.m_analyzeCommand != null && this.m_analyzeCommand.needsPointArg() && !modifiedSelect) {
            if (!this.checkCommandInProgress()) {
                return;
            }
            this.m_analyzeCommand.setPointArg(p);
            this.m_guiBoard.clearAllSelect();
            this.m_guiBoard.setSelect(p, true);
            this.analyzeBegin(false);
        } else if (this.m_analyzeCommand != null && this.m_analyzeCommand.needsPointListArg()) {
            if (!this.checkCommandInProgress()) {
                return;
            }
            PointList pointListArg = this.m_analyzeCommand.getPointListArg();
            if (pointListArg.contains(p)) {
                pointListArg.remove(p);
                if (modifiedSelect) {
                    pointListArg.add(p);
                }
            } else {
                pointListArg.add(p);
            }
            this.m_guiBoard.clearAllSelect();
            GuiBoardUtil.setSelect(this.m_guiBoard, pointListArg, true);
            if (modifiedSelect && pointListArg.size() > 0) {
                this.analyzeBegin(false);
            }
        } else if (this.m_scoreMode && !modifiedSelect) {
            if (!this.checkCommandInProgress()) {
                return;
            }
            GuiBoardUtil.scoreSetDead(this.m_guiBoard, this.m_countScore, this.getBoard(), p);
            Komi komi = this.getGameInfo().getKomi();
            this.m_scoreDialog.showScore(this.m_countScore, komi);
        } else if (modifiedSelect) {
            this.m_guiBoard.contextMenu(p);
        } else {
            if (this.getBoard().getColor(p) != GoColor.EMPTY) {
                return;
            }
            if (!this.checkCommandInProgress()) {
                return;
            }
            if (this.getBoard().isSuicide(this.getToMove(), p) && !this.showQuestion(I18n.i18n("MSG_SUICIDE"), I18n.i18n("MSG_SUICIDE_2"), I18n.i18n("LB_SUICIDE"), false)) {
                return;
            }
            if (this.getBoard().isKo(p) && !this.showQuestion(I18n.i18n("MSG_ILLEGAL_KO"), I18n.i18n("MSG_ILLEGAL_KO_2"), I18n.i18n("LB_ILLEGAL_KO"), false)) {
                return;
            }
            Move move = Move.get(this.getToMove(), p);
            this.humanMoved(move);
        }
    }

    public GoGuiActions getActions() {
        return this.m_actions;
    }

    public File getFile() {
        if (this.m_gameFile == null) {
            return null;
        }
        return this.m_gameFile.m_file;
    }

    public ConstGame getGame() {
        return this.m_game;
    }

    public ConstGuiBoard getGuiBoard() {
        return this.m_guiBoard;
    }

    public int getHandicapDefault() {
        return this.m_handicap;
    }

    public boolean getMonoFont() {
        return this.m_comment.getMonoFont();
    }

    public Pattern getPattern() {
        return this.m_pattern;
    }

    public boolean isInSetupMode() {
        return this.m_setupMode;
    }

    public void textSelected(String text) {
        if (text == null) {
            text = "";
        }
        PointList points = GtpUtil.parsePointString(text, this.getBoardSize());
        GuiBoardUtil.showPointList(this.m_guiBoard, points);
    }

    public void initAnalyzeCommand(AnalyzeCommand command, boolean autoRun, boolean clearBoard, boolean reuseTextWindow) {
        if (!this.synchronizeProgram()) {
            return;
        }
        this.m_analyzeCommand = command;
        this.m_analyzeAutoRun = autoRun;
        this.m_analyzeClearBoard = clearBoard;
        this.m_analyzeReuseTextWindow = reuseTextWindow;
        if (command.needsPointArg()) {
            this.setBoardCursor(12);
            this.showStatusSelectTarget();
        } else if (command.needsPointListArg()) {
            this.setBoardCursor(12);
            this.showStatusSelectPointList();
        }
    }

    public boolean isInterruptSupported() {
        return this.m_gtp != null && this.m_gtp.isInterruptSupported();
    }

    public boolean isModified() {
        return this.m_game.isModified();
    }

    public boolean isProgramAttached() {
        return this.m_gtp != null;
    }

    public boolean isProgramDead() {
        return this.m_gtp != null && this.m_gtp.isProgramDead();
    }

    public void showLiveGfx(String text) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.isCommandInProgress()) {
            return;
        }
        this.m_guiBoard.clearAll();
        GuiBoardUtil.updateFromGoBoard(this.m_guiBoard, this.getBoard(), false, false);
        AnalyzeShow.showGfx(text, this.m_guiBoard, this.m_statusBar, null);
    }

    private void analyzeBegin(boolean checkComputerMove) {
        if (this.m_gtp == null || this.m_analyzeCommand == null || this.m_analyzeCommand.isPointArgMissing() || !this.synchronizeProgram()) {
            return;
        }
        GoColor toMove = this.getToMove();
        this.m_lastAnalyzeCommand = this.m_analyzeCommand.replaceWildCards(toMove);
        this.runLengthyCommand(this.m_lastAnalyzeCommand, new AnalyzeContinue(checkComputerMove));
        this.showStatus(MessageFormat.format(I18n.i18n("STAT_RUNNING"), this.m_analyzeCommand.getResultTitle()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeContinue(boolean checkComputerMove) {
        boolean isCritical;
        if (this.m_analyzeClearBoard) {
            this.resetBoard();
        }
        boolean bl = isCritical = this.m_gtp != null && this.m_gtp.isProgramDead();
        if (!this.endLengthyCommand(isCritical)) {
            return;
        }
        this.clearStatus();
        if (this.m_analyzeCommand == null) {
            this.resetBoard();
            return;
        }
        String title = this.m_analyzeCommand.getResultTitle();
        try {
            PointList list;
            String response = this.m_gtp.getResponse();
            StringBuilder showTextBuffer = new StringBuilder(256);
            AnalyzeShow.show(this.m_analyzeCommand, this.m_guiBoard, this.m_statusBar, this.getBoard(), response, showTextBuffer);
            AnalyzeType type = this.m_analyzeCommand.getType();
            GoPoint pointArg = null;
            if (this.m_analyzeCommand.needsPointArg()) {
                pointArg = this.m_analyzeCommand.getPointArg();
            } else if (this.m_analyzeCommand.needsPointListArg() && (list = this.m_analyzeCommand.getPointListArg()).size() > 0) {
                pointArg = list.get(list.size() - 1);
            }
            if (type == AnalyzeType.PARAM) {
                ParameterDialog.editParameters(this.m_lastAnalyzeCommand, this, title, response, this.m_gtp, this.m_messageDialogs);
            }
            boolean isTextType = this.m_analyzeCommand.isTextType();
            String showText = null;
            if (showTextBuffer.length() > 0) {
                showText = showTextBuffer.toString();
            } else if (isTextType) {
                showText = response;
            }
            if (showText != null) {
                if (showText.indexOf("\n") < 0) {
                    if (isTextType && showText.trim().equals("")) {
                        showText = I18n.i18n("STAT_ANALYZE_TEXT_EMPTY_RESPONSE");
                    }
                    this.showStatus(MessageFormat.format(I18n.i18n("STAT_ANALYZE_TEXT_RESPONSE"), title, showText));
                } else {
                    this.m_showAnalyzeText.show(type, pointArg, title, showText, this.m_analyzeReuseTextWindow);
                }
            }
            if ("".equals(this.m_statusBar.getText()) && type != AnalyzeType.PARAM) {
                this.showStatus(title);
            }
            if (checkComputerMove) {
                this.checkComputerMove();
            }
        }
        catch (GtpResponseFormatError e) {
            this.showStatus(title);
            this.showError(e);
        }
        finally {
            if (this.m_analyzeOneRunOnly) {
                this.clearAnalyzeCommand(false);
            }
        }
    }

    private boolean attachNewProgram(String command, Program program) {
        if (this.m_gtp != null) {
            this.saveSession();
            this.detachProgram();
        }
        if (!this.attachProgram(command, program, false)) {
            this.m_prefs.putInt("program", -1);
            if ((this.m_gtp == null || this.m_gtp.isProgramDead()) && !this.m_shell.isVisible() && this.m_shell.isLastTextNonGTP()) {
                this.showShell();
            }
            this.updateViews(false);
            return false;
        }
        if (this.m_shell != null && this.m_session.isVisible("shell")) {
            this.m_shell.setVisible(true);
        }
        if (this.m_session.isVisible("analyze")) {
            this.createAnalyzeDialog();
        }
        this.toFrontLater();
        this.updateViews(false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attachProgram(String programCommand, Program program, boolean register) {
        if ((programCommand = programCommand.trim()).equals("")) {
            return false;
        }
        this.m_program = program;
        this.m_programCommand = programCommand;
        if (this.m_shell != null) {
            this.m_shell.dispose();
            this.m_shell = null;
        }
        this.m_shell = new GtpShell((Frame)this, this, this.m_messageDialogs);
        GuiAction.registerAll(this.m_shell.getLayeredPane());
        this.m_shell.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                GoGui.this.saveSession();
                GoGui.this.hideShell();
            }
        });
        this.restoreSize(this.m_shell, "shell");
        this.m_shell.setProgramCommand(programCommand);
        this.m_shell.setTimeStamp(this.m_timeStamp);
        this.m_shell.setCommandCompletion(this.m_commandCompletion);
        GtpClient.InvalidResponseCallback invalidResponseCallback = new GtpClient.InvalidResponseCallback(){

            public void show(String line) {
                ShowInvalidResponse runnable = new ShowInvalidResponse(line);
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    GuiUtil.invokeAndWait(runnable);
                }
            }
        };
        GtpClient.IOCallback ioCallback = new GtpClient.IOCallback(){
            private final LineReader m_lineReader = new LineReader();
            private LiveGfx m_liveGfx = new LiveGfx(GoGui.this);

            public void receivedInvalidResponse(String s) {
                if (GoGui.this.m_shell == null) {
                    return;
                }
                boolean invokeLater = true;
                GoGui.this.m_shell.receivedInvalidResponse(s, invokeLater);
            }

            public void receivedResponse(boolean error, String s) {
                if (GoGui.this.m_shell == null) {
                    return;
                }
                boolean invokeLater = true;
                GoGui.this.m_shell.receivedResponse(error, s, invokeLater);
            }

            public void receivedStdErr(String s) {
                if (GoGui.this.m_shell == null) {
                    return;
                }
                this.m_lineReader.add(s);
                while (this.m_lineReader.hasLines()) {
                    String line = this.m_lineReader.getLine();
                    boolean isLiveGfx = this.m_liveGfx.handleLine(line);
                    boolean isWarning = line.startsWith("warning:") || line.startsWith("Warning:") || line.startsWith("WARNING:");
                    boolean invokeLater = true;
                    GoGui.this.m_shell.receivedStdErr(line, invokeLater, isLiveGfx, isWarning);
                }
            }

            public void sentCommand(String s) {
                if (GoGui.this.m_shell != null) {
                    GoGui.this.m_shell.sentCommand(s);
                }
            }
        };
        GtpSynchronizer.Listener synchronizerCallback = new GtpSynchronizer.Listener(){

            public void moveNumberChanged(int moveNumber) {
                String text = "[" + moveNumber + "]";
                GoGui.this.m_statusBar.immediatelyPaintMoveText(text);
            }
        };
        try {
            this.showStatusImmediately(I18n.i18n("STAT_ATTACHING_PROGRAM"));
            File workingDirectory = null;
            if (program != null && !StringUtil.isEmpty(program.m_workingDirectory)) {
                workingDirectory = new File(program.m_workingDirectory);
            }
            GtpClient gtp = new GtpClient(this.m_programCommand, workingDirectory, this.m_verbose, ioCallback);
            gtp.setInvalidResponseCallback(invalidResponseCallback);
            gtp.setAutoNumber(this.m_autoNumber);
            this.m_gtp = new GuiGtpClient(gtp, this, synchronizerCallback, this.m_messageDialogs);
            this.m_gtp.queryName();
            this.m_gtp.queryProtocolVersion();
            try {
                this.m_version = this.m_gtp.queryVersion();
                this.m_shell.setProgramVersion(this.m_version);
                this.m_gtp.querySupportedCommands();
                this.m_gtp.queryInterruptSupport();
                if (this.m_program == null) {
                    this.m_program = Program.findProgram(this.m_programs, programCommand);
                    if (this.m_program == null && this.m_register) {
                        this.m_program = new Program("", this.m_gtp.getName(), this.m_version, programCommand, "");
                        this.m_program.setUniqueLabel(this.m_programs);
                        this.m_programs.add(this.m_program);
                        this.m_menuBar.setPrograms(this.m_programs);
                        Program.save(this.m_programs);
                    }
                }
            }
            catch (GtpError gtpError) {
                // empty catch block
            }
            if (this.m_program != null && this.m_program.updateInfo(this.getProgramName(), this.m_version)) {
                Program.save(this.m_programs);
                this.m_menuBar.setPrograms(this.m_programs);
            }
            try {
                String programAnalyzeCommands = GtpClientUtil.getAnalyzeCommands(this.m_gtp);
                this.m_analyzeCommands = AnalyzeDefinition.read(this.m_gtp.getSupportedCommands(), this.m_analyzeCommandsFile, programAnalyzeCommands);
            }
            catch (ErrorMessage e) {
                this.showError(I18n.i18n("MSG_COULD_NOT_READ_ANALYZE_CONFIGURATION"), e);
            }
            this.restoreSize(this.m_shell, "shell");
            this.m_shell.setProgramName(this.getProgramLabel());
            ArrayList<String> supportedCommands = this.m_gtp.getSupportedCommands();
            this.m_shell.setInitialCompletions(supportedCommands);
            if (!this.m_gtp.isGenmoveSupported()) {
                this.m_computerBlack = false;
                this.m_computerWhite = false;
            }
            this.initGtp();
            if (!this.m_gtpFile.equals("")) {
                this.sendGtpFile(new File(this.m_gtpFile));
            }
            if (!this.m_gtpCommand.equals("")) {
                this.sendGtpString(this.m_gtpCommand);
            }
            this.setTitle();
        }
        catch (GtpError e) {
            this.showError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.clearStatus();
        }
        this.currentNodeChanged();
        return true;
    }

    private void beginLengthyCommand() {
        this.setBoardCursor(3);
        this.m_shell.setCommandInProgess(true);
        this.showStatus(MessageFormat.format(I18n.i18n("STAT_THINKING"), this.getProgramName()));
        this.updateViews(false);
    }

    private void boardChangedBegin(boolean doCheckComputerMove, boolean gameTreeChanged) {
        this.updateFromGoBoard();
        this.updateViews(gameTreeChanged);
        if (this.m_analyzeDialog != null) {
            this.m_analyzeDialog.setSelectedColor(this.getToMove());
        }
        if (this.m_gtp != null && !this.isOutOfSync() && this.m_analyzeCommand != null && this.m_analyzeAutoRun && !this.m_analyzeCommand.isPointArgMissing()) {
            this.analyzeBegin(doCheckComputerMove);
        } else {
            this.resetBoard();
            this.clearStatus();
            if (doCheckComputerMove) {
                this.checkComputerMove();
            }
        }
    }

    private boolean checkCommandInProgress() {
        if (this.isCommandInProgress()) {
            this.showError(I18n.i18n("MSG_CANNOT_EXECUTE_WHILE_THINKING"), I18n.i18n("MSG_CANNOT_EXECUTE_WHILE_THINKING_2"), false);
            return false;
        }
        return true;
    }

    private void checkComputerMove() {
        boolean gameFinished;
        if (this.m_gtp == null || this.isOutOfSync() || this.m_gtp.isProgramDead()) {
            return;
        }
        int moveNumber = NodeUtil.getMoveNumber(this.getCurrentNode());
        boolean bothPassed = moveNumber >= 2 && this.getBoard().bothPassed();
        boolean bl = gameFinished = bothPassed || this.m_resigned;
        if (this.isComputerBoth()) {
            if (gameFinished) {
                if (this.m_auto) {
                    this.newGame(this.getBoardSize());
                    this.updateViews(true, true);
                    this.checkComputerMove();
                    return;
                }
                this.m_game.haltClock();
                this.showGameFinished();
                return;
            }
            this.generateMove(false);
        } else {
            if (gameFinished) {
                this.m_game.haltClock();
                this.showGameFinished();
                return;
            }
            if (this.computerToMove()) {
                this.generateMove(false);
            }
        }
    }

    private boolean checkHasParameterCommands() {
        if (!AnalyzeUtil.hasParameterCommands(this.m_analyzeCommands)) {
            String optionalMessage = MessageFormat.format(I18n.i18n("MSG_NO_PARAM_COMMANDS_2"), this.getProgramName());
            this.showError(I18n.i18n("MSG_NO_PARAM_COMMANDS"), optionalMessage);
            return false;
        }
        return true;
    }

    private void checkLostOnTime(GoColor color) {
        if (this.getClock().lostOnTime(color) && !this.getClock().lostOnTime(color.otherColor()) && !this.m_lostOnTimeShown) {
            String optionalMessage;
            String mainMessage;
            String result = color.otherColor().getUppercaseLetter() + "+Time";
            if (color == GoColor.BLACK) {
                mainMessage = I18n.i18n("MSG_LOST_ON_TIME_BLACK");
                optionalMessage = MessageFormat.format(I18n.i18n("MSG_LOST_ON_TIME_BLACK_2"), result);
            } else {
                mainMessage = I18n.i18n("MSG_LOST_ON_TIME_WHITE");
                optionalMessage = MessageFormat.format(I18n.i18n("MSG_LOST_ON_TIME_WHITE_2"), result);
            }
            this.showInfo(mainMessage, optionalMessage, false);
            this.setResult(result);
            this.m_lostOnTimeShown = true;
        }
    }

    private boolean checkSaveGame() {
        return this.checkSaveGame(false);
    }

    private boolean checkSaveGame(boolean isProgramTerminating) {
        if (!this.isModified()) {
            return true;
        }
        String mainMessage = I18n.i18n("MSG_SAVE_CURRENT");
        String optionalMessage = I18n.i18n("MSG_SAVE_CURRENT_2");
        String disableKey = null;
        if (!isProgramTerminating) {
            disableKey = "net.sf.gogui.gogui.GoGui.save";
        }
        int result = this.m_messageDialogs.showYesNoCancelQuestion(disableKey, this, mainMessage, optionalMessage, I18n.i18n("LB_DONT_SAVE"), I18n.i18n("LB_SAVE"));
        switch (result) {
            case 0: {
                this.m_game.clearModified();
                return true;
            }
            case 1: {
                if (this.m_gameFile == null) {
                    return this.saveDialog();
                }
                return this.save(this.m_gameFile);
            }
            case 2: {
                return false;
            }
        }
        assert (false);
        return true;
    }

    private boolean checkStateChangePossible() {
        if (!this.checkCommandInProgress()) {
            return false;
        }
        if (this.m_setupMode) {
            this.setupDone();
        }
        if (this.m_scoreMode) {
            this.scoreDone(null);
        }
        return true;
    }

    private void clearAnalyzeCommand() {
        this.clearAnalyzeCommand(true);
    }

    private void clearAnalyzeCommand(boolean resetBoard) {
        if (this.m_analyzeCommand != null) {
            this.m_analyzeCommand = null;
            this.setBoardCursorDefault();
        }
        if (resetBoard) {
            this.resetBoard();
            this.clearStatus();
        }
    }

    private void clearStatus() {
        this.m_statusBar.clear();
    }

    private void close() {
        if (!this.checkSaveGame(true)) {
            return;
        }
        this.saveSession();
        this.setVisible(false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (GoGui.this.m_gtp != null) {
                    GoGui.this.m_analyzeCommand = null;
                    GoGui.this.detachProgram();
                }
                GoGui.this.dispose();
                System.exit(0);
            }
        });
    }

    private void computerMoved() {
        if (!this.endLengthyCommand()) {
            return;
        }
        if (this.m_beepAfterMove) {
            Toolkit.getDefaultToolkit().beep();
        }
        GoColor toMove = this.getToMove();
        try {
            String response = this.m_gtp.getResponse();
            this.checkLostOnTime(toMove);
            boolean gameTreeChanged = false;
            String name = this.getProgramName();
            if (response.equalsIgnoreCase("resign")) {
                String result = toMove.otherColor().getUppercaseLetter() + "+Resign";
                if (!this.m_auto) {
                    String mainMessage = MessageFormat.format(I18n.i18n("MSG_RESIGN"), name);
                    String optionalMessage = MessageFormat.format(I18n.i18n("MSG_RESIGN_2"), result);
                    this.showInfo(mainMessage, optionalMessage, false);
                }
                this.m_resigned = true;
                this.setResult(result);
            } else {
                GoPoint point = GtpUtil.parsePoint(response, this.getBoardSize());
                ConstBoard board = this.getBoard();
                if (point != null) {
                    String mainMessage;
                    if (board.getColor(point) != GoColor.EMPTY) {
                        mainMessage = MessageFormat.format(I18n.i18n("MSG_NONEMPTY"), name);
                        String optionalMessage = MessageFormat.format(I18n.i18n("MSG_NONEMPTY_2"), name);
                        this.showWarning(mainMessage, optionalMessage, true);
                        this.m_computerBlack = false;
                        this.m_computerWhite = false;
                    } else if (board.isKo(point)) {
                        mainMessage = MessageFormat.format(I18n.i18n("MSG_VIOLATE_KO"), name);
                        this.showWarning(mainMessage, I18n.i18n("MSG_VIOLATE_KO_2"), true);
                        this.m_computerBlack = false;
                        this.m_computerWhite = false;
                    }
                }
                Move move = Move.get(toMove, point);
                this.m_game.play(move);
                this.m_gtp.updateAfterGenmove(this.getBoard());
                if (point == null && !this.isComputerBoth()) {
                    String disableKey = "net.sf.gogui.gogui.GoGui.computer-passed";
                    String mainMessage = MessageFormat.format(I18n.i18n("MSG_PROGRAM_PASS"), name);
                    String optionalMessage = MessageFormat.format(I18n.i18n("MSG_PROGRAM_PASS_2"), name);
                    this.m_messageDialogs.showInfo(disableKey, this, mainMessage, optionalMessage, false);
                }
                this.m_resigned = false;
                gameTreeChanged = true;
                ConstNode currentNode = this.getCurrentNode();
                if (currentNode.getFatherConst().getNumberChildren() == 1) {
                    if (this.m_gameTreeViewer != null) {
                        this.m_gameTreeViewer.addNewSingleChild(currentNode);
                    }
                    gameTreeChanged = false;
                }
            }
            boolean doCheckComputerMove = !this.m_isSingleMove && (!this.isComputerBoth() || !this.m_interruptComputerBoth);
            this.boardChangedBegin(doCheckComputerMove, gameTreeChanged);
        }
        catch (GtpResponseFormatError e) {
            this.showError(e);
            this.clearStatus();
        }
    }

    private boolean computerToMove() {
        if (this.getToMove() == GoColor.BLACK) {
            return this.m_computerBlack;
        }
        return this.m_computerWhite;
    }

    private void createAnalyzeDialog() {
        this.m_analyzeDialog = new AnalyzeDialog(this, this, this.m_analyzeCommands, this.m_gtp, this.m_messageDialogs);
        this.m_analyzeDialog.setReuseTextWindow(this.m_prefs.getBoolean("analyze-reuse-text-window", false));
        GuiAction.registerAll(this.m_analyzeDialog.getLayeredPane());
        this.m_analyzeDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                GoGui.this.actionDisposeAnalyzeDialog();
            }
        });
        this.m_analyzeDialog.setBoardSize(this.getBoardSize());
        this.m_analyzeDialog.setSelectedColor(this.getToMove());
        this.restoreSize(this.m_analyzeDialog, "analyze");
        this.m_analyzeDialog.setVisible(true);
    }

    private ContextMenu createContextMenu(GoPoint point) {
        boolean noProgram = this.m_gtp == null;
        return new ContextMenu(point, this.m_guiBoard.getMark(point), this.m_guiBoard.getMarkCircle(point), this.m_guiBoard.getMarkSquare(point), this.m_guiBoard.getMarkTriangle(point), this);
    }

    private void createTree() {
        this.m_gameTreeViewer = new GameTreeViewer((Frame)this, this, this.m_messageDialogs);
        this.m_gameTreeViewer.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                GoGui.this.actionDisposeTree();
            }
        });
        GuiAction.registerAll(this.m_gameTreeViewer.getLayeredPane());
        this.m_gameTreeViewer.setLabelMode(this.m_treeLabels);
        this.m_gameTreeViewer.setSizeMode(this.m_treeSize);
        this.m_gameTreeViewer.setShowSubtreeSizes(this.m_showSubtreeSizes);
        this.restoreSize(this.m_gameTreeViewer, "tree");
        this.m_gameTreeViewer.update(this.getTree(), this.getCurrentNode());
        this.m_gameTreeViewer.setVisible(true);
    }

    private void createThumbnail(File file) {
        if (!ThumbnailPlatform.checkThumbnailSupport()) {
            return;
        }
        String path = file.getAbsolutePath();
        if (!path.startsWith("/tmp") && !path.startsWith("/var/tmp")) {
            try {
                this.m_thumbnailCreator.create(file);
            }
            catch (ErrorMessage errorMessage) {
                // empty catch block
            }
        }
    }

    private void currentNodeChanged() {
        this.updateFromGoBoard();
    }

    private void detachProgram() {
        if (this.m_gtp != null) {
            this.showStatusImmediately(I18n.i18n("STAT_DETACHING"));
        }
        if (this.isCommandInProgress()) {
            this.m_gtp.destroyGtp();
            this.m_gtp.close();
        } else if (this.m_gtp != null && !this.m_gtp.isProgramDead()) {
            try {
                if (this.m_gtp.isSupported("quit")) {
                    this.m_gtp.send("quit");
                }
            }
            catch (GtpError gtpError) {
                // empty catch block
            }
            this.m_gtp.close();
        }
        this.m_gtp = null;
        if (this.m_analyzeCommand != null) {
            this.clearAnalyzeCommand();
        }
        this.m_version = null;
        this.m_shell.dispose();
        this.m_shell = null;
        if (this.m_analyzeDialog != null) {
            this.m_analyzeDialog.saveRecent();
            this.m_analyzeDialog.dispose();
            this.m_analyzeDialog = null;
        }
        this.resetBoard();
        this.clearStatus();
        this.setTitle();
    }

    private boolean endLengthyCommand() {
        return this.endLengthyCommand(true, true);
    }

    private boolean endLengthyCommand(boolean isCritical) {
        return this.endLengthyCommand(isCritical, true);
    }

    private boolean endLengthyCommand(boolean isCritical, boolean showError) {
        this.restoreBoardCursor();
        this.clearStatus();
        if (this.m_shell != null) {
            this.m_shell.setCommandInProgess(false);
        }
        if (this.m_gtp == null) {
            return false;
        }
        GtpError error = this.m_gtp.getException();
        this.updateViews(false);
        if (error != null && showError) {
            this.showError(error, isCritical);
            return false;
        }
        return true;
    }

    private String formatCommand(String command) {
        if (command.length() < 20) {
            return command;
        }
        GtpCommand cmd = new GtpCommand(command);
        return cmd.getCommand() + " [...]";
    }

    private void generateMove(boolean isSingleMove) {
        String command;
        if (!this.synchronizeProgram()) {
            return;
        }
        GoColor toMove = this.getToMove();
        ConstNode node = this.getCurrentNode();
        ConstNode father = node.getFatherConst();
        ConstGameInfo info = this.getGameInfo();
        String playerToMove = info.get(StringInfoColor.NAME, toMove);
        String playerOther = info.get(StringInfoColor.NAME, toMove.otherColor());
        String name = this.getProgramLabel();
        if (!(isSingleMove || this.m_gameFile != null || playerToMove != null || father != null && (father.hasFather() || playerOther != null && !playerOther.equals(name)))) {
            this.m_game.setPlayer(toMove, name);
            this.updateViews(false);
        }
        if (NodeUtil.isInCleanup(this.getCurrentNode()) && this.m_gtp.isSupported("kgs-genmove_cleanup")) {
            command = "kgs-genmove_cleanup";
            if (toMove == GoColor.BLACK) {
                command = command + " b";
            } else if (toMove == GoColor.WHITE) {
                command = command + " w";
            } else assert (false);
        } else {
            command = this.m_gtp.getCommandGenmove(toMove);
        }
        this.m_isSingleMove = isSingleMove;
        this.m_interruptComputerBoth = false;
        Runnable callback = new Runnable(){

            public void run() {
                GoGui.this.computerMoved();
            }
        };
        if (this.getClock().isInitialized() && NodeUtil.isTimeLeftKnown(this.getCurrentNode(), toMove)) {
            GtpUtil.sendTimeLeft(this.m_gtp, this.getClock(), toMove);
        }
        this.m_game.startClock();
        this.runLengthyCommand(command, callback);
    }

    private ConstBoard getBoard() {
        return this.m_game.getBoard();
    }

    private int getBoardSize() {
        return this.m_game.getSize();
    }

    private ConstClock getClock() {
        return this.m_game.getClock();
    }

    private ConstNode getCurrentNode() {
        return this.m_game.getCurrentNode();
    }

    private ConstGameInfo getGameInfo() {
        return this.m_game.getGameInfo(this.getCurrentNode());
    }

    private Komi getPrefsKomi() {
        try {
            String s = this.m_prefs.get("komi", "6.5");
            return Komi.parseKomi(s);
        }
        catch (InvalidKomiException e) {
            return null;
        }
    }

    private GoColor getToMove() {
        return this.m_game.getToMove();
    }

    private ConstGameTree getTree() {
        return this.m_game.getTree();
    }

    private void gotoNode(ConstNode node) {
        if (this.m_scoreMode) {
            return;
        }
        this.m_game.gotoNode(node);
        if (this.getClock().isInitialized()) {
            this.m_game.restoreClock();
        } else {
            this.m_game.haltClock();
        }
        this.currentNodeChanged();
    }

    private void hideShell() {
        if (this.m_shell == null) {
            return;
        }
        this.saveSession();
        this.m_shell.setVisible(false);
    }

    private void humanMoved(Move move) {
        GoPoint p = move.getPoint();
        if (p != null) {
            this.paintImmediately(p, move.getColor(), true);
        }
        if (!(this.m_gtp == null || this.isComputerNone() || this.isOutOfSync() || this.m_gtp.isProgramDead())) {
            this.synchronizeProgram();
            try {
                this.m_gtp.updateHumanMove(this.getBoard(), move);
            }
            catch (GtpError e) {
                this.showError(e);
                this.boardChangedBegin(false, false);
                return;
            }
        }
        boolean newNodeCreated = false;
        ConstNode node = NodeUtil.getChildWithMove(this.getCurrentNode(), move);
        if (node == null) {
            newNodeCreated = true;
            this.m_game.play(move);
        } else {
            this.m_game.haltClock();
            this.m_game.gotoNode(node);
        }
        this.checkLostOnTime(move.getColor());
        this.m_resigned = false;
        boolean gameTreeChanged = newNodeCreated;
        ConstNode currentNode = this.getCurrentNode();
        if (newNodeCreated && currentNode.getFatherConst().getNumberChildren() == 1) {
            if (this.m_gameTreeViewer != null) {
                this.m_gameTreeViewer.addNewSingleChild(currentNode);
            }
            gameTreeChanged = false;
        }
        this.boardChangedBegin(true, gameTreeChanged);
    }

    private void importTextPosition(Reader reader) {
        try {
            TextParser parser = new TextParser();
            parser.parse(reader);
            GameTree tree = NodeUtil.makeTreeFromPosition(null, parser.getBoard());
            this.m_game.init(tree);
        }
        catch (ParseError e) {
            this.showError(I18n.i18n("MSG_IMPORT_FAILED"), e);
        }
        this.m_guiBoard.initSize(this.getBoard().getSize());
        this.initGtp();
        this.m_computerBlack = false;
        this.m_computerWhite = false;
        this.boardChangedBegin(false, true);
    }

    private void initGame(int size) {
        int oldSize = this.getBoardSize();
        if (size != oldSize) {
            this.clearAnalyzeCommand();
            this.saveSession();
            this.m_guiBoard.initSize(size);
            this.restoreMainWindow(size);
            JLayeredPane layeredPane = this.getLayeredPane();
            if (layeredPane.isVisible()) {
                GuiUtil.paintImmediately(layeredPane);
            }
        }
        Komi komi = this.m_handicap == 0 ? this.getPrefsKomi() : new Komi(0.0);
        ConstPointList handicap = Board.getHandicapStones(size, this.m_handicap);
        if (handicap == null) {
            this.showWarning(I18n.i18n("MSG_HANDICAP_UNDEFINED"), MessageFormat.format(I18n.i18n("MSG_HANDICAP_UNDEFINED_2"), this.m_handicap, size), false);
        }
        this.m_game.init(size, komi, handicap, this.m_prefs.get("rules", ""), this.m_timeSettings);
        if (size != oldSize) {
            if (this.m_shell != null) {
                this.restoreSize(this.m_shell, "shell");
            }
            if (this.m_analyzeDialog != null) {
                this.restoreSize(this.m_analyzeDialog, "analyze");
                this.m_analyzeDialog.setBoardSize(size);
            }
            if (this.m_gameTreeViewer != null) {
                this.restoreSize(this.m_gameTreeViewer, "tree");
            }
        }
        this.updateFromGoBoard();
        this.resetBoard();
        this.m_game.resetClock();
        this.m_lostOnTimeShown = false;
        this.m_resigned = false;
        this.m_pattern = null;
    }

    private boolean initGtp() {
        if (this.m_gtp != null) {
            try {
                ConstGameInfo info = this.getGameInfo();
                this.m_gtp.initSynchronize(this.getBoard(), info.getKomi(), info.getTimeSettings());
            }
            catch (GtpError error) {
                this.showError(error);
                return false;
            }
        }
        this.currentNodeChanged();
        return !this.isOutOfSync();
    }

    private void initialize() {
        int index;
        this.m_guiBoard.setListener(this);
        this.m_guiBoard.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                int scale;
                if (GoGui.this.isCommandInProgress()) {
                    return;
                }
                int n = e.getWheelRotation();
                int mod = e.getModifiers();
                int n2 = scale = mod == 1 ? 10 : 1;
                if (n > 0) {
                    GoGui.this.actionForward(scale * n);
                } else {
                    GoGui.this.actionBackward(-scale * n);
                }
            }
        });
        GuiUtil.removeKeyBinding(this.m_splitPane, "F8");
        GuiAction.registerAll(this.getLayeredPane());
        this.m_bookmarks = Bookmark.load();
        this.m_menuBar.setBookmarks(this.m_bookmarks);
        this.m_programs = Program.load();
        this.m_menuBar.setPrograms(this.m_programs);
        if (this.m_programCommand == null && (index = this.m_prefs.getInt("program", -1)) >= 0 && index < this.m_programs.size()) {
            this.m_program = this.m_programs.get(index);
            this.m_programCommand = this.m_program.m_command;
        }
        if (this.m_initialFile == null) {
            this.newGame(this.getBoardSize());
        } else {
            this.newGameFile(this.getBoardSize(), this.m_move);
        }
        if (!this.m_prefs.getBoolean("show-info-panel", true)) {
            this.showInfoPanel(false);
        }
        if (this.m_prefs.getBoolean("show-toolbar", true)) {
            this.showToolbar(true);
        }
        this.restoreMainWindow(this.getBoardSize());
        this.getLayeredPane().setVisible(false);
        this.setVisible(true);
        if (this.m_programCommand != null) {
            this.attachProgram(this.m_programCommand, this.m_program, this.m_register);
            if (this.m_gtp == null || this.m_gtp.isProgramDead()) {
                this.m_prefs.putInt("program", -1);
            }
        }
        this.setTitle();
        this.registerSpecialMacHandler();
        if (this.m_shell != null && this.m_session.isVisible("shell")) {
            this.m_shell.setVisible(true);
        }
        if (this.m_session.isVisible("tree")) {
            this.createTree();
        }
        if (this.m_gtp != null && this.m_session.isVisible("analyze")) {
            this.createAnalyzeDialog();
        }
        this.setTitleFromProgram();
        this.updateViews(true);
        this.getLayeredPane().setVisible(true);
        this.unprotectGui();
        this.toFrontLater();
        this.checkComputerMove();
    }

    private void initScore(ConstPointList deadStones) {
        this.resetBoard();
        GuiBoardUtil.scoreBegin(this.m_guiBoard, this.m_countScore, this.getBoard(), deadStones);
        this.m_scoreMode = true;
        if (this.m_scoreDialog == null) {
            Score.ScoringMethod scoringMethod = this.getGameInfo().parseRules();
            this.m_scoreDialog = new ScoreDialog((Frame)this, this, scoringMethod);
        }
        this.restoreLocation(this.m_scoreDialog, "score");
        Komi komi = this.getGameInfo().getKomi();
        this.m_scoreDialog.showScore(this.m_countScore, komi);
        this.m_scoreDialog.setVisible(true);
        this.showStatus(I18n.i18n("STAT_SCORE"));
    }

    private boolean isComputerBoth() {
        return this.m_computerBlack && this.m_computerWhite;
    }

    private boolean isComputerNone() {
        return !this.m_computerBlack && !this.m_computerWhite;
    }

    private boolean isOutOfSync() {
        return this.m_gtp != null && this.m_gtp.isOutOfSync();
    }

    private boolean loadFile(File file, int move) {
        try {
            ConstNode node;
            LoadFileRunnable runnable = new LoadFileRunnable(file);
            if (file.length() > 500000L) {
                this.newGame(this.getBoardSize());
                GuiUtil.runProgress(this, I18n.i18n("LB_LOADING"), runnable);
            } else {
                runnable.run(null);
            }
            GameTree tree = runnable.getTree();
            this.initGame(tree.getBoardSize());
            this.m_menuBar.addRecent(file);
            this.m_game.init(tree);
            this.initGtp();
            if (move > 0 && (node = NodeUtil.findByMoveNumber(this.getCurrentNode(), move)) != null) {
                this.m_game.gotoNode(node);
            }
            this.setFile(runnable.getGameFile());
            FileDialogs.setLastFile(file);
            String warnings = runnable.getWarnings();
            if (warnings != null) {
                String optionalMessage = I18n.i18n("MSG_FILE_FORMAT_WARNING_2") + "\n(" + warnings.replaceAll("\n\\z", "").replaceAll("\n", ")\n(") + ")";
                this.showWarning(I18n.i18n("MSG_FILE_FORMAT_WARNING"), optionalMessage, true);
            }
            this.m_computerBlack = false;
            this.m_computerWhite = false;
            this.createThumbnail(file);
        }
        catch (FileNotFoundException e) {
            this.showError(I18n.i18n("MSG_FILE_NOT_FOUND"), e);
            return false;
        }
        catch (SgfError e) {
            this.showError(I18n.i18n("MSG_COULD_NOT_READ_FILE"), e);
            return false;
        }
        catch (ErrorMessage e) {
            this.showError(I18n.i18n("MSG_COULD_NOT_READ_FILE"), e);
            return false;
        }
        catch (Throwable t) {
            t.printStackTrace();
            assert (false);
            return false;
        }
        return true;
    }

    private void newGame(int size) {
        this.initGame(size);
        this.initGtp();
        this.updateFromGoBoard();
        this.setTitle();
        this.setTitleFromProgram();
        this.clearStatus();
    }

    private void newGameFile(int size, int move) {
        this.initGame(size);
        if (!this.loadFile(this.m_initialFile, move)) {
            this.m_gameFile = null;
        }
    }

    private void paintImmediately(GoPoint point, GoColor color, boolean isMove) {
        this.m_guiBoard.setColor(point, color);
        if (isMove && this.m_showLastMove) {
            this.m_guiBoard.markLastMove(point);
        }
        this.m_guiBoard.paintImmediately(point);
    }

    private void protectGui() {
        this.getGlassPane().setVisible(true);
        this.setCursor(this.getGlassPane(), 3);
    }

    private void registerSpecialMacHandler() {
        if (!Platform.isMac()) {
            return;
        }
        Platform.SpecialMacHandler handler = new Platform.SpecialMacHandler(){

            public boolean handleAbout() {
                assert (SwingUtilities.isEventDispatchThread());
                GoGui.this.actionAbout();
                return true;
            }

            public boolean handleOpenFile(String filename) {
                assert (SwingUtilities.isEventDispatchThread());
                if (!GoGui.this.checkSaveGame()) {
                    return true;
                }
                GoGui.this.loadFile(new File(filename), -1);
                GoGui.this.boardChangedBegin(false, true);
                return true;
            }

            public boolean handleQuit() {
                assert (SwingUtilities.isEventDispatchThread());
                GoGui.this.close();
                return false;
            }
        };
        Platform.registerSpecialMacHandler(handler);
    }

    private void resetBoard() {
        this.clearStatus();
        this.m_guiBoard.clearAll();
        this.updateFromGoBoard();
        this.updateGuiBoard();
    }

    private void restoreBoardCursor() {
        if (this.m_analyzeCommand != null && (this.m_analyzeCommand.needsPointArg() || this.m_analyzeCommand.needsPointListArg())) {
            this.setBoardCursor(12);
        } else {
            this.setBoardCursorDefault();
        }
    }

    private void restoreLocation(JDialog dialog, String name) {
        this.m_session.restoreLocation(dialog, this, name + "-" + this.getBoardSize());
    }

    private void restoreMainWindow(int size) {
        this.setState(0);
        this.m_session.restoreLocation(this, "main-" + size);
        String path = "windows/main/size-" + size + "/fieldsize";
        int fieldSize = this.m_prefs.getInt(path, -1);
        if (fieldSize > 0) {
            this.m_guiBoard.setPreferredFieldSize(new Dimension(fieldSize, fieldSize));
        }
        path = "windows/main/size-" + size + "/comment";
        int width = this.m_prefs.getInt(path + "/width", -1);
        int height = this.m_prefs.getInt(path + "/height", -1);
        Dimension preferredCommentSize = null;
        if (width > 0 && height > 0) {
            preferredCommentSize = new Dimension(width, height);
            this.m_comment.setPreferredSize(preferredCommentSize);
        } else {
            this.m_comment.setPreferredSize();
        }
        this.m_splitPane.resetToPreferredSizes();
        this.pack();
        if (this.m_infoPanel.getHeight() - this.m_guiBoard.getHeight() < 2 * fieldSize && preferredCommentSize != null && fieldSize > 0) {
            preferredCommentSize.height -= 2 * fieldSize;
            this.m_comment.setPreferredSize(preferredCommentSize);
            this.m_splitPane.resetToPreferredSizes();
            this.pack();
        }
    }

    private void restoreSize(JDialog dialog, String name) {
        this.m_session.restoreSize(dialog, this, name + "-" + this.getBoardSize());
    }

    private void runLengthyCommand(String cmd, Runnable callback) {
        assert (this.m_gtp != null);
        this.m_gtp.send(cmd, callback);
        this.beginLengthyCommand();
    }

    private boolean save(GameFile gameFile) {
        try {
            new GameWriter(gameFile, this.getTree(), I18n.i18n("LB_GOGUI"), Version.get());
        }
        catch (ErrorMessage e) {
            this.showError(I18n.i18n("MSG_SAVING_FAILED"), e);
            return false;
        }
        this.m_menuBar.addRecent(gameFile.m_file);
        this.createThumbnail(gameFile.m_file);
        this.setFile(gameFile);
        this.m_game.clearModified();
        this.updateViews(false);
        return true;
    }

    private boolean saveDialog() {
        File file = FileDialogs.showSaveSgf(this, this.m_messageDialogs);
        if (file == null) {
            return false;
        }
        GameFile gameFile = new GameFile();
        gameFile.m_file = file;
        gameFile.m_format = FileUtil.hasExtension(file, "xml") ? GameFile.Format.XML : GameFile.Format.SGF;
        return this.save(gameFile);
    }

    private boolean saveParameters(File file) {
        try {
            GtpClientUtil.saveParameters(this.m_gtp, this.m_analyzeCommands, file);
        }
        catch (ErrorMessage e) {
            this.showError(I18n.i18n("MSG_COULD_NOT_SAVE_PARAMETERS"), e);
            return false;
        }
        return true;
    }

    private void savePosition(File file) throws FileNotFoundException {
        FileOutputStream out = new FileOutputStream(file);
        new SgfWriter((OutputStream)out, this.getBoard(), I18n.i18n("LB_GOGUI"), Version.get());
        this.m_menuBar.addRecent(file);
        this.updateViews(false);
    }

    private void saveSession() {
        if (this.m_shell != null) {
            this.m_shell.saveHistory();
        }
        if (this.m_analyzeDialog != null) {
            this.m_analyzeDialog.saveRecent();
            this.m_prefs.putBoolean("analyze-reuse-text-window", this.m_analyzeDialog.getReuseTextWindow());
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.m_help != null) {
            this.m_session.saveSize(this.m_help.getWindow(), "help");
        }
        this.saveSizeAndVisible(this.m_gameTreeViewer, "tree");
        if (this.m_gtp != null) {
            this.saveSizeAndVisible(this.m_shell, "shell");
            this.saveSizeAndVisible(this.m_analyzeDialog, "analyze");
        }
        this.m_session.saveLocation(this, "main-" + this.getBoardSize());
        if (GuiUtil.isNormalSizeMode(this)) {
            String name = "windows/main/size-" + this.getBoardSize() + "/fieldsize";
            int fieldSize = this.m_guiBoard.getFieldSize().width;
            if (fieldSize == 0) {
                return;
            }
            this.m_prefs.putInt(name, fieldSize);
            name = "windows/main/size-" + this.getBoardSize() + "/comment/width";
            this.m_prefs.putInt(name, this.m_comment.getWidth());
            name = "windows/main/size-" + this.getBoardSize() + "/comment/height";
            this.m_prefs.putInt(name, this.m_comment.getHeight());
        }
        try {
            this.m_prefs.sync();
        }
        catch (BackingStoreException e) {
            System.err.println(e.getMessage());
        }
    }

    private void saveLocation(JDialog dialog, String name) {
        this.m_session.saveLocation(dialog, this, name + "-" + this.getBoardSize());
    }

    private void saveSizeAndVisible(JDialog dialog, String name) {
        int size = this.getBoardSize();
        if (dialog != null) {
            this.m_session.saveSize(dialog, this, name + "-" + size);
        }
        this.m_session.saveVisible(dialog, name);
    }

    private void scoreContinue() {
        boolean success = this.endLengthyCommand();
        this.clearStatus();
        PointList isDeadStone = null;
        if (success) {
            String response = this.m_gtp.getResponse();
            try {
                isDeadStone = GtpUtil.parsePointList(response, this.getBoardSize());
            }
            catch (GtpResponseFormatError e) {
                this.showError(e);
            }
        }
        this.updateViews(false);
        this.initScore(isDeadStone);
    }

    private void scoreDone(Score score) {
        if (!this.m_scoreMode) {
            return;
        }
        this.m_scoreMode = false;
        this.saveLocation(this.m_scoreDialog, "score");
        this.m_scoreDialog.setVisible(false);
        this.clearStatus();
        this.m_guiBoard.clearAll();
        if (score != null) {
            this.setResult(score.formatResult());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendGtp(Reader reader) {
        if (this.m_gtp == null) {
            return;
        }
        BufferedReader in = new BufferedReader(reader);
        block11: while (true) {
            try {
                while (true) {
                    String line;
                    if ((line = in.readLine()) == null) {
                        return;
                    }
                    if (!GtpUtil.isCommand(line)) continue;
                    if (GtpUtil.isStateChangingCommand(line)) {
                        this.showError(I18n.i18n("MSG_BOARD_CHANGING_COMMAND"), "");
                        return;
                    }
                    try {
                        this.m_gtp.send(line);
                        continue block11;
                    }
                    catch (GtpError e) {
                        this.showError(e);
                        if (this.m_gtp.isProgramDead()) return;
                        if (!this.showQuestion(I18n.i18n("MSG_CONTINUE_SEND"), "", I18n.i18n("LB_CONTINUE_SEND"), false)) return;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                this.showError(I18n.i18n("MSG_COULD_NOT_READ_FILE"), e);
                return;
            }
            continue;
            break;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void sendGtpFile(File file) {
        try {
            this.sendGtp(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            this.showError(I18n.i18n("MSG_FILE_NOT_FOUND"), e);
        }
    }

    private void sendGtpString(String commands) {
        commands = commands.replaceAll("\\\\n", "\n");
        this.sendGtp(new StringReader(commands));
    }

    private void setBoardCursor(int type) {
        this.setCursor(this.m_guiBoard, type);
    }

    private void setBoardCursorDefault() {
        this.setCursorDefault(this.m_guiBoard);
    }

    private void setCursor(Component component, int type) {
        Cursor cursor = Cursor.getPredefinedCursor(type);
        component.setCursor(cursor);
    }

    private void setCursorDefault(Component component) {
        component.setCursor(Cursor.getDefaultCursor());
    }

    private void setFile(GameFile gameFile) {
        this.m_gameFile = gameFile;
        this.setTitle();
    }

    private void setMinimumSize() {
        int width = 128;
        int height = 32;
        Insets rootInsets = this.getRootPane().getInsets();
        int rootInsetsWidth = rootInsets.left + rootInsets.right;
        Dimension menuBarSize = this.getJMenuBar().getPreferredSize();
        width = Math.max(width, (int)menuBarSize.getWidth() + rootInsetsWidth);
        height = Math.max(height, (int)menuBarSize.getHeight());
        if (this.m_showToolbar) {
            Insets contentInsets = this.getContentPane().getInsets();
            int contentInsetsWidth = contentInsets.left + contentInsets.right;
            Dimension toolBarSize = this.m_toolBar.getPreferredSize();
            width = Math.max(width, (int)toolBarSize.getWidth() + rootInsetsWidth + contentInsetsWidth + 5);
            height += (int)toolBarSize.getHeight();
        }
        this.setMinimumSize(new Dimension(width, height += 224));
    }

    private void setResult(String result) {
        String oldResult = this.getGameInfo().get(StringInfo.RESULT);
        if (!(oldResult == null || oldResult.equals("") || oldResult.equals(result) || this.showQuestion(MessageFormat.format(I18n.i18n("MSG_REPLACE_RESULT"), oldResult, result), I18n.i18n("MSG_REPLACE_RESULT_2"), I18n.i18n("LB_REPLACE_RESULT"), false))) {
            return;
        }
        this.m_game.setResult(result);
    }

    private void setTitle() {
        ConstGameInfo info;
        String gameName;
        if (this.m_titleFromProgram != null) {
            this.setTitle(this.m_titleFromProgram);
            return;
        }
        String appName = I18n.i18n("LB_GOGUI");
        if (this.m_gtp != null) {
            appName = this.getProgramLabel();
        }
        String filename = null;
        if (this.m_gameFile != null) {
            filename = this.m_gameFile.m_file.getName();
            if (this.isModified() && !Platform.isMac()) {
                filename = filename + "*";
            }
        }
        if ((gameName = (info = this.getGameInfo()).suggestGameName()) != null) {
            if (filename != null) {
                gameName = filename + "  " + gameName;
            }
        } else if (filename != null) {
            gameName = filename;
        }
        if (gameName == null) {
            this.setTitle(appName);
        } else {
            String name = this.getProgramLabel();
            String nameBlack = info.get(StringInfoColor.NAME, GoColor.BLACK);
            String nameWhite = info.get(StringInfoColor.NAME, GoColor.WHITE);
            if (!appName.equals(I18n.i18n("LB_GOGUI")) && (ObjectUtil.equals(nameBlack, name) || ObjectUtil.equals(nameWhite, name))) {
                this.setTitle(gameName);
            } else {
                this.setTitle(gameName + " - " + appName);
            }
        }
    }

    private void setTitleFromProgram() {
        this.m_titleFromProgram = this.m_gtp == null ? null : GtpClientUtil.getTitle(this.m_gtp);
        if (this.m_titleFromProgram != null) {
            this.setTitle(this.m_titleFromProgram);
        }
    }

    private void setup(GoPoint point, GoColor color) {
        assert (point != null);
        this.m_game.setup(point, color);
    }

    private void setupDone() {
        if (!this.m_setupMode) {
            return;
        }
        this.m_setupMode = false;
        ConstNode currentNode = this.getCurrentNode();
        if (currentNode.hasSetup() || this.m_setupColor != this.getToMove()) {
            this.m_game.setToMove(this.m_setupColor);
        } else if (this.m_setupNodeCreated && currentNode.isEmpty() && currentNode.hasFather()) {
            this.m_game.truncate();
        }
        this.currentNodeChanged();
    }

    private void showError(String message, Exception e) {
        this.showError(message, e, true);
    }

    private void showError(String message, Exception e, boolean isCritical) {
        this.m_messageDialogs.showError((Component)this, message, e, isCritical);
    }

    private void showError(GtpError error) {
        this.showError(error, true);
    }

    private void showError(GtpResponseFormatError e) {
        String name = this.getProgramName();
        String mainMessage = MessageFormat.format(I18n.i18n("MSG_INVALID_RESPONSE"), name);
        String optionalMessage = MessageFormat.format(I18n.i18n("MSG_INVALID_RESPONSE_2"), name, e.getMessage());
        this.showError(mainMessage, optionalMessage, true);
    }

    private void showError(GtpError e, boolean isCritical) {
        String optionalMessage;
        String mainMessage;
        String name = this.getProgramName();
        if (this.m_gtp != null && this.m_gtp.isProgramDead()) {
            mainMessage = this.m_gtp.wasKilled() ? MessageFormat.format(I18n.i18n("MSG_PROGRAM_TERMINATED"), name) : I18n.i18n("MSG_PROGRAM_TERMINATED_UNEXPECTEDLY");
            boolean hasErrorOutput = this.m_shell.isLastTextNonGTP();
            boolean anyResponses = this.m_gtp.getAnyCommandsResponded();
            optionalMessage = hasErrorOutput && !anyResponses ? MessageFormat.format(I18n.i18n("MSG_PROGRAM_TERMINATED_2"), name) : (hasErrorOutput && anyResponses ? MessageFormat.format(I18n.i18n("MSG_PROGRAM_TERMINATED_3"), name) : I18n.i18n("MSG_PROGRAM_TERMINATED_4"));
        } else if (e instanceof GtpClient.ExecFailed) {
            mainMessage = I18n.i18n("MSG_COULD_NOT_EXECUTE");
            optionalMessage = StringUtil.isEmpty(e.getMessage()) ? I18n.i18n("MSG_COULD_NOT_EXECUTE_2") : MessageFormat.format(I18n.i18n("MSG_COULD_NOT_EXECUTE_3"), e.getMessage());
        } else {
            mainMessage = I18n.i18n("MSG_COMMAND_FAILED");
            optionalMessage = e.getMessage().trim().equals("") ? MessageFormat.format(I18n.i18n("MSG_COMMAND_FAILED_2"), e.getCommand()) : MessageFormat.format(I18n.i18n("MSG_COMMAND_FAILED_3"), e.getCommand(), e.getMessage());
        }
        this.showError(mainMessage, optionalMessage, isCritical);
        this.updateViews(false);
    }

    private void showError(String mainMessage, String optionalMessage) {
        this.showError(mainMessage, optionalMessage, true);
    }

    private void showError(String mainMessage, String optionalMessage, boolean isCritical) {
        this.m_messageDialogs.showError((Component)this, mainMessage, optionalMessage, isCritical);
    }

    private void showGameFinished() {
        if (this.m_resigned) {
            return;
        }
        String disableKey = "net.sf.gogui.gogui.GoGui.game-finished";
        this.m_messageDialogs.showInfo(disableKey, this, I18n.i18n("MSG_GAME_FINISHED"), I18n.i18n("MSG_GAME_FINISHED_2"), false);
    }

    private void showInfo(String mainMessage, String optionalMessage, boolean isCritical) {
        this.m_messageDialogs.showInfo(this, mainMessage, optionalMessage, isCritical);
    }

    private void showInfoPanel(boolean enable) {
        if (enable == this.m_showInfoPanel) {
            return;
        }
        this.m_prefs.putBoolean("show-info-panel", enable);
        this.m_showInfoPanel = enable;
        if (enable) {
            this.m_innerPanel.remove(this.m_guiBoard);
            this.m_splitPane.add(this.m_guiBoard);
            this.m_innerPanel.add(this.m_splitPane);
        } else {
            this.m_splitPane.remove(this.m_guiBoard);
            this.m_innerPanel.remove(this.m_splitPane);
            this.m_innerPanel.add(this.m_guiBoard);
        }
        this.m_splitPane.resetToPreferredSizes();
        this.pack();
    }

    private boolean showOptionalQuestion(String id, String mainMessage, String optionalMessage, String destructiveOption, boolean isCritical) {
        String disableKey = "net.sf.gogui.gogui.GoGui" + id;
        return this.m_messageDialogs.showQuestion(disableKey, this, mainMessage, optionalMessage, destructiveOption, isCritical);
    }

    private boolean showQuestion(String mainMessage, String optionalMessage, String destructiveOption, boolean isCritical) {
        return this.m_messageDialogs.showQuestion(this, mainMessage, optionalMessage, destructiveOption, isCritical);
    }

    private File showSave(String title) {
        return FileDialogs.showSave(this, title, this.m_messageDialogs);
    }

    private void showShell() {
        if (this.m_gtp == null) {
            return;
        }
        if (this.m_shell.isVisible()) {
            this.m_shell.toFront();
        } else {
            this.restoreSize(this.m_shell, "shell");
            this.m_shell.setVisible(true);
        }
    }

    private void showStatus(String text) {
        this.m_statusBar.setText(text);
    }

    private void showStatusImmediately(String text) {
        this.m_statusBar.immediatelyPaintText(text);
    }

    private void showStatusSelectPointList() {
        this.showStatus(MessageFormat.format(I18n.i18n("STAT_SELECT_POINTLIST"), this.m_analyzeCommand.getLabel()));
    }

    private void showStatusSelectTarget() {
        this.showStatus(MessageFormat.format(I18n.i18n("STAT_SELECT_TARGET"), this.m_analyzeCommand.getResultTitle()));
    }

    private void showToolbar(boolean enable) {
        if (enable == this.m_showToolbar) {
            return;
        }
        this.m_prefs.putBoolean("show-toolbar", enable);
        this.m_showToolbar = enable;
        if (enable) {
            this.getContentPane().add((Component)this.m_toolBar, "North");
        } else {
            this.getContentPane().remove(this.m_toolBar);
        }
        this.m_splitPane.resetToPreferredSizes();
        this.setMinimumSize();
        this.pack();
    }

    private void showWarning(String mainMessage, String optionalMessage, boolean isCritical) {
        this.m_messageDialogs.showWarning(this, mainMessage, optionalMessage, isCritical);
    }

    private boolean synchronizeProgram() {
        if (this.m_gtp == null) {
            this.showError(I18n.i18n("MSG_NO_PROGRAM_ATTACHED"), "", false);
            return false;
        }
        if (!this.checkCommandInProgress()) {
            return false;
        }
        String name = this.getProgramName();
        if (this.m_gtp.isProgramDead()) {
            String mainMessage = MessageFormat.format(I18n.i18n("MSG_PROGRAM_TERMINATED"), name);
            String optionalMessage = "";
            if (this.m_shell.isLastTextNonGTP()) {
                this.showShell();
                optionalMessage = MessageFormat.format(I18n.i18n("MSG_PROGRAM_TERMINATED_CHECK_GTP"), name);
            } else {
                this.showShell();
                optionalMessage = MessageFormat.format(I18n.i18n("MSG_PROGRAM_TERMINATED_REATTACH"), name);
            }
            this.showError(mainMessage, optionalMessage, false);
            this.updateViews(false);
            return false;
        }
        boolean wasOutOfSync = this.isOutOfSync();
        try {
            ConstGameInfo info = this.getGameInfo();
            this.m_gtp.synchronize(this.getBoard(), info.getKomi(), info.getTimeSettings());
        }
        catch (GtpError e) {
            if (wasOutOfSync) {
                String mainMessage = MessageFormat.format(I18n.i18n("MSG_OUT_OF_SYNC"), name);
                String optionalMessage = MessageFormat.format(I18n.i18n("MSG_OUT_OF_SYNC_2"), name);
                this.showError(mainMessage, optionalMessage, false);
            } else {
                String mainMessage = MessageFormat.format(I18n.i18n("MSG_NOSYNC"), name);
                String command = null;
                if (e.getCommand() != null) {
                    command = this.formatCommand(e.getCommand());
                }
                String message = e.getMessage();
                String response = null;
                if (!message.trim().equals("")) {
                    response = message;
                }
                String optionalMessage = command == null ? MessageFormat.format(I18n.i18n("MSG_NOSYNC_ERROR"), name, message) : (response == null ? MessageFormat.format(I18n.i18n("MSG_NOSYNC_FAILURE"), command, name) : MessageFormat.format(I18n.i18n("MSG_NOSYNC_FAILURE_RESPONSE"), command, name, response));
                this.showWarning(mainMessage, optionalMessage, true);
                this.updateViews(false);
            }
            return false;
        }
        return true;
    }

    private void toFrontLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GoGui.this.requestFocus();
                GoGui.this.toFront();
            }
        });
    }

    private void unprotectGui() {
        this.getGlassPane().setVisible(false);
        this.setCursor(this.getGlassPane(), 0);
    }

    private void updateViews(boolean gameTreeChanged) {
        this.updateViews(gameTreeChanged, false);
    }

    private void updateViews(boolean gameTreeChanged, boolean sync) {
        this.m_actions.update();
        this.m_menuBar.update(this.isProgramAttached(), this.isTreeShown(), this.isShellShown());
        this.m_gameInfoPanel.update();
        this.m_comment.setComment(this.getCurrentNode().getComment());
        this.updateFromGoBoard();
        this.updateGuiBoard();
        this.getRootPane().putClientProperty("windowModified", this.isModified());
        this.setTitle();
        GoGuiUtil.updateMoveText(this.m_statusBar, this.getGame());
        this.m_statusBar.setSetupMode(this.m_setupMode);
        if (this.m_setupMode) {
            this.m_statusBar.setToPlay(this.m_setupColor);
        }
        if (this.m_gameTreeViewer != null) {
            if (gameTreeChanged) {
                if (sync) {
                    this.m_gameTreeViewer.update(this.getTree(), this.getCurrentNode());
                } else {
                    this.protectGui();
                    this.showStatus(I18n.i18n("STAT_UPDATING_TREE"));
                    Runnable runnable = new Runnable(){

                        public void run() {
                            try {
                                GoGui.this.m_gameTreeViewer.update(GoGui.this.getTree(), GoGui.this.getCurrentNode());
                            }
                            finally {
                                GoGui.this.unprotectGui();
                                GoGui.this.clearStatus();
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            } else {
                this.m_gameTreeViewer.update(this.getCurrentNode());
            }
        }
    }

    private void updateFromGoBoard() {
        boolean showLastMove = this.m_showLastMove && (this.m_showVariations != ShowVariations.SIBLINGS || !NodeUtil.hasSiblingMoves(this.getCurrentNode()));
        GuiBoardUtil.updateFromGoBoard(this.m_guiBoard, this.getBoard(), this.m_showLastMove, this.m_showMoveNumbers);
        if (!showLastMove || this.getCurrentNode().getMove() == null) {
            this.m_guiBoard.markLastMove(null);
        }
    }

    private void updateGuiBoard() {
        PointList moves;
        ConstNode father;
        if (this.m_showVariations == ShowVariations.CHILDREN) {
            PointList moves2 = NodeUtil.getChildrenMoves(this.getCurrentNode());
            GuiBoardUtil.showMoves(this.m_guiBoard, moves2);
        } else if (this.m_showVariations == ShowVariations.SIBLINGS && NodeUtil.hasSiblingMoves(this.getCurrentNode()) && (father = this.getCurrentNode().getFatherConst()) != null && (moves = NodeUtil.getChildrenMoves(father)).size() > 1) {
            GuiBoardUtil.showMoves(this.m_guiBoard, moves);
        }
        GuiBoardUtil.showMarkup(this.m_guiBoard, this.getCurrentNode());
    }

    private static class LoadFileRunnable
    implements GuiUtil.ProgressRunnable {
        private final File m_file;
        private GameReader m_reader;

        public LoadFileRunnable(File file) {
            this.m_file = file;
        }

        public GameTree getTree() {
            return this.m_reader.getTree();
        }

        public String getWarnings() {
            return this.m_reader.getWarnings();
        }

        public GameFile getGameFile() {
            return this.m_reader.getFile();
        }

        public void run(ProgressShow progressShow) throws Throwable {
            this.m_reader = new GameReader(this.m_file, progressShow);
        }
    }

    private class ShowInvalidResponse
    implements Runnable {
        public ShowInvalidResponse(String line) {
        }

        public void run() {
            String name = GoGui.this.getProgramName();
            String mainMessage = MessageFormat.format(I18n.i18n("MSG_INVALID_RESPONSE"), name);
            String disableKey = "net.sf.gogui.gogui.GoGui.invalid-response";
            String optionalMessage = MessageFormat.format(I18n.i18n("MSG_INVALID_NOSTATUS_RESPONSE"), name);
            GoGui.this.m_messageDialogs.showWarning(disableKey, GoGui.this, mainMessage, optionalMessage, true);
        }
    }

    private class AnalyzeContinue
    implements Runnable {
        private final boolean m_checkComputerMove;

        public AnalyzeContinue(boolean checkComputerMove) {
            this.m_checkComputerMove = checkComputerMove;
        }

        public void run() {
            GoGui.this.analyzeContinue(this.m_checkComputerMove);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShowVariations {
        CHILDREN,
        SIBLINGS,
        NONE;

    }
}

