/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gogui;

import java.io.File;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import net.sf.gogui.util.ErrorMessage;
import net.sf.gogui.util.Options;
import net.sf.gogui.version.Version;

public final class GoGuiSettings {
    public boolean m_auto;
    public boolean m_register;
    public boolean m_initComputerColor;
    public boolean m_computerBlack;
    public boolean m_computerWhite;
    public boolean m_noStartup;
    public boolean m_verbose;
    public int m_move;
    public File m_file;
    public File m_analyzeCommands;
    public String m_gtpCommand;
    public String m_gtpFile;
    public String m_lookAndFeel;
    public String m_program;
    public String m_time;
    private final Preferences m_prefs;

    public GoGuiSettings(String[] args, Class c) throws ErrorMessage {
        this.m_prefs = Preferences.userNodeForPackage(c);
        String[] options = new String[]{"analyze-commands:", "auto", "command:", "computer-black", "computer-both", "computer-none", "computer-white", "config:", "gtpfile:", "help", "komi:", "laf:", "move:", "program:", "register", "size:", "time:", "verbose", "version"};
        Options opt = Options.parse(args, options);
        if (opt.contains("help")) {
            this.printHelp();
            this.m_noStartup = true;
            return;
        }
        if (opt.contains("version")) {
            this.m_noStartup = true;
            System.out.println("GoGui " + Version.get());
            return;
        }
        String analyzeCommandsFilename = opt.get("analyze-commands", null);
        if (analyzeCommandsFilename != null) {
            this.m_analyzeCommands = new File(analyzeCommandsFilename);
        }
        this.m_auto = opt.contains("auto");
        this.m_initComputerColor = false;
        if (opt.contains("computer-none")) {
            this.m_computerBlack = false;
            this.m_computerWhite = false;
            this.m_initComputerColor = true;
        } else if (opt.contains("computer-black")) {
            this.m_computerBlack = true;
            this.m_computerWhite = false;
            this.m_initComputerColor = true;
        } else if (opt.contains("computer-white")) {
            this.m_computerBlack = false;
            this.m_computerWhite = true;
            this.m_initComputerColor = true;
        } else if (opt.contains("computer-both")) {
            this.m_computerBlack = true;
            this.m_computerWhite = true;
            this.m_initComputerColor = true;
        }
        this.m_program = opt.get("program", null);
        this.m_register = opt.contains("register");
        if (this.m_register && this.m_program == null) {
            throw new ErrorMessage("Option -register can be used only with option -program");
        }
        this.m_gtpFile = opt.get("gtpfile", "");
        this.m_gtpCommand = opt.get("command", "");
        if (opt.contains("komi")) {
            this.m_prefs.putDouble("komi", opt.getDouble("komi"));
        }
        this.m_lookAndFeel = opt.get("laf", null);
        this.m_move = opt.getInteger("move", -1);
        if (opt.contains("size")) {
            this.m_prefs.putInt("boardsize", opt.getInteger("size"));
        }
        this.m_time = opt.get("time", null);
        this.m_verbose = opt.contains("verbose");
        ArrayList<String> arguments = opt.getArguments();
        this.m_file = null;
        if (arguments.size() == 1) {
            this.m_file = new File(arguments.get(0));
        } else if (arguments.size() > 1) {
            throw new ErrorMessage("Only one argument allowed");
        }
        this.validate();
    }

    private void printHelp() {
        String helpText = "Usage: gogui [options] [file]\nGraphical user interface for Go programs\nusing the Go Text Protocol.\n\n-analyze          Initialize analyze command\n-analyze-commands Use analyze commands configuration file\n-auto             Auto play games (if computer both)\n-command          Send GTP command at startup\n-computer-black   Computer plays black\n-computer-both    Computer plays both sides\n-computer-none    Computer plays no side\n-computer-white   Computer plays white\n-config           Config file\n-gtpfile          Send GTP file at startup\n-help             Display this help and exit\n-komi             Set komi\n-laf              Set Swing look and feel\n-move             Load SGF file until move number\n-program          Go program to attach\n-size             Set board size\n-time             Set time limits (min[+min/moves])\n-verbose          Print debugging messages\n-version          Print version and exit\n";
        System.out.print(helpText);
    }

    private void validate() throws ErrorMessage {
        int size = this.m_prefs.getInt("boardsize", 19);
        if (size < 1 || size > 25) {
            throw new ErrorMessage("Invalid board size: " + size);
        }
    }
}

