/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.gui.MessageDialogs;
import net.sf.gogui.util.PrefUtil;
import net.sf.gogui.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindDialog
extends JDialog
implements ActionListener {
    private JComboBox m_comboBox;
    private JTextField m_textField;
    private final String m_initialValue;
    private String m_pattern;

    public FindDialog(Frame owner, String initialValue) {
        super(owner, I18n.i18n("TIT_FIND"), true);
        this.m_initialValue = initialValue;
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.createPanel(), "Center");
        contentPane.add((Component)this.createButtons(), "South");
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("cancel")) {
            this.dispose();
        } else if (command.equals("comboBoxEdited") || command.equals("find")) {
            this.m_pattern = this.m_comboBox.getSelectedItem().toString();
            this.m_comboBox.insertItemAt(this.m_pattern, 0);
            this.putHistory();
            this.dispose();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 && !this.m_comboBox.isPopupVisible()) {
            this.dispose();
        }
    }

    public static Pattern run(Frame owner, String initialValue, MessageDialogs messageDialogs) {
        while (true) {
            FindDialog dialog = new FindDialog(owner, initialValue);
            dialog.setLocationByPlatform(true);
            dialog.setVisible(true);
            String regex = dialog.m_pattern;
            if (StringUtil.isEmpty(regex)) {
                return null;
            }
            int flags = 10;
            try {
                return Pattern.compile(regex, flags);
            }
            catch (PatternSyntaxException e) {
                String mainMessage = I18n.i18n("MSG_FINDDIALOG_INVALID_PATTERN");
                String optionalMessage = MessageFormat.format(I18n.i18n("MSG_FINDDIALOG_INVALID_PATTERN_2"), e.getDescription());
                messageDialogs.showError((Component)owner, mainMessage, optionalMessage, false);
                initialValue = regex;
                continue;
            }
            break;
        }
    }

    private JPanel createButtons() {
        JPanel innerPanel = new JPanel(new GridLayout(1, 0, 5, 0));
        innerPanel.setBorder(GuiUtil.createEmptyBorder());
        JButton findButton = new JButton(I18n.i18n("LB_FIND"));
        findButton.setActionCommand("find");
        findButton.addActionListener(this);
        findButton.setMnemonic(70);
        this.getRootPane().setDefaultButton(findButton);
        innerPanel.add(findButton);
        JButton cancelButton = new JButton(I18n.i18n("LB_CANCEL"));
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(this);
        cancelButton.setMnemonic(67);
        innerPanel.add(cancelButton);
        JPanel outerPanel = new JPanel(new FlowLayout(1));
        outerPanel.add(innerPanel);
        return outerPanel;
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        panel.setBorder(GuiUtil.createEmptyBorder());
        JLabel label = new JLabel(I18n.i18n("LB_FIND_SEARCH_PATTERN"));
        label.setHorizontalAlignment(2);
        panel.add(label);
        panel.add(this.createInputPanel());
        return panel;
    }

    private JPanel createInputPanel() {
        JPanel outerPanel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel(new BorderLayout());
        this.m_comboBox = new JComboBox<Object>(this.getHistory().toArray());
        StringBuilder prototype = new StringBuilder(70);
        for (int i = 0; i < 40; ++i) {
            prototype.append('-');
        }
        this.m_comboBox.setPrototypeDisplayValue(prototype.toString());
        this.m_comboBox.setEditable(true);
        ComboBoxEditor editor = this.m_comboBox.getEditor();
        this.m_comboBox.addActionListener(this);
        this.m_textField = (JTextField)editor.getEditorComponent();
        this.m_textField.selectAll();
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int c = e.getKeyCode();
                if (c == 27 && !FindDialog.this.m_comboBox.isPopupVisible()) {
                    FindDialog.this.dispose();
                }
            }
        };
        this.m_textField.addKeyListener(keyListener);
        GuiUtil.setMonospacedFont(this.m_comboBox);
        innerPanel.add((Component)this.m_comboBox, "Center");
        outerPanel.add((Component)innerPanel, "North");
        return outerPanel;
    }

    private void putHistory() {
        ArrayList<String> history = new ArrayList<String>(32);
        int maxHistory = 20;
        int itemCount = this.m_comboBox.getItemCount();
        int n = itemCount;
        if (n > maxHistory) {
            n = maxHistory;
        }
        for (int i = 0; i < n; ++i) {
            String element = this.m_comboBox.getItemAt(i).toString().trim();
            if (history.contains(element)) continue;
            history.add(element);
        }
        PrefUtil.putList("net/sf/gogui/gui/finddialog", history);
    }

    private ArrayList<String> getHistory() {
        ArrayList<String> result = PrefUtil.getList("net/sf/gogui/gui/finddialog");
        if (this.m_initialValue != null) {
            result.add(0, this.m_initialValue);
        }
        return result;
    }
}

