/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.gogui.game.GameInfo;
import net.sf.gogui.game.StringInfo;
import net.sf.gogui.game.StringInfoColor;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.InvalidKomiException;
import net.sf.gogui.go.Komi;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.gui.MessageDialogs;
import net.sf.gogui.gui.TimeField;

public final class GameInfoDialog
extends JOptionPane {
    private TimeField m_byoyomi;
    private JTextField m_byoyomiMoves;
    private final JTextField m_date;
    private final JTextField m_komi;
    private final PlayerInfo m_black;
    private final PlayerInfo m_white;
    private TimeField m_preByoyomi;
    private final JTextField m_result;
    private final JTextField m_rules;

    public static void show(Component parent, GameInfo info, MessageDialogs messageDialogs) {
        GameInfoDialog gameInfo = new GameInfoDialog(info);
        JDialog dialog = gameInfo.createDialog(parent, I18n.i18n("TIT_GAMEINFO"));
        boolean done = false;
        while (!done) {
            dialog.setVisible(true);
            Object value = gameInfo.getValue();
            if (!(value instanceof Integer) || (Integer)value != 0) {
                return;
            }
            done = gameInfo.validate(parent, messageDialogs);
        }
        dialog.dispose();
        gameInfo.updateGameInfo(info);
    }

    private GameInfoDialog(GameInfo info) {
        Box outerBox = Box.createVerticalBox();
        this.m_white = this.createPlayerInfo(GoColor.WHITE, info);
        this.m_white.m_box.setAlignmentX(0.0f);
        outerBox.add(this.m_white.m_box);
        outerBox.add(GuiUtil.createFiller());
        this.m_black = this.createPlayerInfo(GoColor.BLACK, info);
        this.m_black.m_box.setAlignmentX(0.0f);
        outerBox.add(this.m_black.m_box);
        outerBox.add(GuiUtil.createFiller());
        outerBox.add(GuiUtil.createFiller());
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        outerBox.add(box);
        JPanel labels = new JPanel(new GridLayout(0, 1, 0, 5));
        box.add(labels);
        box.add(GuiUtil.createSmallFiller());
        JPanel values = new JPanel(new GridLayout(0, 1, 0, 5));
        box.add(values);
        this.m_result = this.createEntry("LB_GAMEINFO_RESULT", 12, info.get(StringInfo.RESULT), "TT_GAMEINFO_RESULT", labels, values);
        this.m_date = this.createEntry("LB_GAMEINFO_DATE", 12, info.get(StringInfo.DATE), "TT_GAMEINFO_DATE", labels, values);
        this.m_rules = this.createEntry("LB_GAMEINFO_RULES", 12, info.get(StringInfo.RULES), "TT_GAMEINFO_RULES", labels, values);
        String komi = "";
        if (info.getKomi() != null) {
            komi = info.getKomi().toString();
        }
        this.m_komi = this.createEntry("LB_GAMEINFO_KOMI", 12, komi, "TT_GAMEINFO_KOMI", labels, values);
        this.createTime(info.getTimeSettings(), labels, values);
        this.setMessage(outerBox);
        this.setOptionType(2);
    }

    private JTextField createEntry(String labelText, int cols, String text, String toolTipText, JComponent labels, JComponent values) {
        Box boxLabel = Box.createHorizontalBox();
        boxLabel.add(Box.createHorizontalGlue());
        JLabel label = new JLabel(I18n.i18n(labelText));
        label.setAlignmentY(0.5f);
        boxLabel.add(label);
        labels.add(boxLabel);
        JPanel fieldPanel = new JPanel(new FlowLayout(0, 0, 0));
        JTextField field = new JTextField(cols);
        field.setHorizontalAlignment(0);
        field.setToolTipText(I18n.i18n(toolTipText));
        field.setText(text);
        fieldPanel.add(field);
        values.add(fieldPanel);
        return field;
    }

    private void createTime(TimeSettings timeSettings, JComponent labels, JComponent values) {
        Box boxLabel = Box.createHorizontalBox();
        boxLabel.add(Box.createHorizontalGlue());
        JLabel label = new JLabel(I18n.i18n("LB_GAMEINFO_TIME"));
        label.setAlignmentY(0.5f);
        boxLabel.add(label);
        labels.add(boxLabel);
        Box boxValue = Box.createVerticalBox();
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        boxValue.add(Box.createVerticalGlue());
        boxValue.add(panel);
        boxValue.add(Box.createVerticalGlue());
        this.m_preByoyomi = new TimeField(3, "TT_GAMEINFO_TIME_MAIN");
        if (timeSettings != null) {
            this.m_preByoyomi.setTime(timeSettings.getPreByoyomi());
        }
        panel.add(this.m_preByoyomi);
        panel.add(new JLabel(" + "));
        this.m_byoyomi = new TimeField(2, "TT_GAMEINFO_TIME_BYOYOMI");
        if (timeSettings != null && timeSettings.getUseByoyomi()) {
            this.m_byoyomi.setTime(timeSettings.getByoyomi());
        }
        panel.add(this.m_byoyomi);
        panel.add(new JLabel(" / "));
        this.m_byoyomiMoves = new JTextField(2);
        this.m_byoyomiMoves.setToolTipText(I18n.i18n("TT_GAMEINFO_TIME_BYOYOMI_MOVES"));
        this.m_byoyomiMoves.setHorizontalAlignment(4);
        if (timeSettings != null && timeSettings.getUseByoyomi()) {
            int byoyomiMoves = timeSettings.getByoyomiMoves();
            this.m_byoyomiMoves.setText(Integer.toString(byoyomiMoves));
        }
        panel.add(this.m_byoyomiMoves);
        panel.add(new JLabel(" " + I18n.i18n("LB_GAMEINFO_TIME_MOVES")));
        values.add(boxValue);
    }

    private PlayerInfo createPlayerInfo(GoColor c, GameInfo info) {
        assert (c.isBlackWhite());
        PlayerInfo playerInfo = new PlayerInfo();
        Box box = Box.createHorizontalBox();
        JLabel label = c == GoColor.BLACK ? new JLabel(GuiUtil.getIcon("gogui-black-16x16", I18n.i18n("LB_BLACK"))) : new JLabel(GuiUtil.getIcon("gogui-white-16x16", I18n.i18n("LB_WHITE")));
        label.setAlignmentY(0.5f);
        box.add(label);
        box.add(GuiUtil.createFiller());
        playerInfo.m_box = box;
        playerInfo.m_name = new JTextField(18);
        playerInfo.m_name.setText(info.get(StringInfoColor.NAME, c));
        box.add(playerInfo.m_name);
        playerInfo.m_name.setHorizontalAlignment(0);
        if (c == GoColor.BLACK) {
            playerInfo.m_name.setToolTipText(I18n.i18n("TT_GAMEINFO_NAME_BLACK"));
        } else {
            playerInfo.m_name.setToolTipText(I18n.i18n("TT_GAMEINFO_NAME_WHITE"));
        }
        box.add(GuiUtil.createFiller());
        playerInfo.m_rank = new JTextField(5);
        playerInfo.m_rank.setHorizontalAlignment(0);
        if (c == GoColor.BLACK) {
            playerInfo.m_rank.setToolTipText(I18n.i18n("TT_GAMEINFO_RANK_BLACK"));
        } else {
            playerInfo.m_rank.setToolTipText(I18n.i18n("TT_GAMEINFO_RANK_WHITE"));
        }
        box.add(playerInfo.m_rank);
        playerInfo.m_rank.setText(info.get(StringInfoColor.RANK, c));
        box.setAlignmentY(0.5f);
        return playerInfo;
    }

    private static String getTextFieldContent(JTextField textField) {
        return textField.getText().trim();
    }

    private boolean isEmpty(JTextField textField) {
        return GameInfoDialog.getTextFieldContent(textField).equals("");
    }

    private void updateGameInfo(GameInfo info) {
        Komi komi;
        block8: {
            info.set(StringInfoColor.NAME, GoColor.BLACK, GameInfoDialog.getTextFieldContent(this.m_black.m_name));
            info.set(StringInfoColor.NAME, GoColor.WHITE, GameInfoDialog.getTextFieldContent(this.m_white.m_name));
            info.set(StringInfoColor.RANK, GoColor.BLACK, GameInfoDialog.getTextFieldContent(this.m_black.m_rank));
            info.set(StringInfoColor.RANK, GoColor.WHITE, GameInfoDialog.getTextFieldContent(this.m_white.m_rank));
            info.set(StringInfo.RULES, GameInfoDialog.getTextFieldContent(this.m_rules));
            info.set(StringInfo.RESULT, GameInfoDialog.getTextFieldContent(this.m_result));
            info.set(StringInfo.DATE, GameInfoDialog.getTextFieldContent(this.m_date));
            String komiText = GameInfoDialog.getTextFieldContent(this.m_komi);
            komi = null;
            try {
                komi = Komi.parseKomi(komiText);
            }
            catch (InvalidKomiException e) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        info.setKomi(komi);
        if (this.m_preByoyomi.isEmpty() && this.m_byoyomi.isEmpty() && this.isEmpty(this.m_byoyomiMoves)) {
            info.setTimeSettings(null);
        } else {
            long preByoyomi = this.m_preByoyomi.getTime();
            long byoyomi = -1L;
            int byoyomiMoves = -1;
            if (!this.m_byoyomi.isEmpty()) {
                byoyomi = this.m_byoyomi.getTime();
            }
            if (!this.isEmpty(this.m_byoyomiMoves)) {
                byoyomiMoves = Integer.parseInt(GameInfoDialog.getTextFieldContent(this.m_byoyomiMoves));
            }
            if (byoyomi > 0L && byoyomiMoves > 0) {
                TimeSettings settings = new TimeSettings(preByoyomi, byoyomi, byoyomiMoves);
                info.setTimeSettings(settings);
            } else {
                TimeSettings settings = new TimeSettings(preByoyomi);
                info.setTimeSettings(settings);
            }
        }
    }

    private boolean validate(Component parent, MessageDialogs messageDialogs) {
        if (!this.validateKomi(parent, this.m_komi, messageDialogs)) {
            return false;
        }
        if (!this.m_preByoyomi.validateTime(parent, messageDialogs)) {
            return false;
        }
        if (!this.m_byoyomi.validateTime(parent, messageDialogs)) {
            return false;
        }
        if (!this.validatePosIntOrEmpty(parent, this.m_byoyomiMoves, "MSG_GAMEINFO_INVALID_TIME", messageDialogs)) {
            return false;
        }
        if (this.m_byoyomi.isEmpty() != this.isEmpty(this.m_byoyomiMoves)) {
            messageDialogs.showError(parent, I18n.i18n("MSG_GAMEINFO_INVALID_BYOYOMI"), I18n.i18n("MSG_GAMEINFO_INVALID_BYOYOMI_2"), false);
            return false;
        }
        return true;
    }

    private boolean validateKomi(Component parent, JTextField textField, MessageDialogs messageDialogs) {
        String text = GameInfoDialog.getTextFieldContent(textField);
        try {
            Komi.parseKomi(text);
        }
        catch (InvalidKomiException e) {
            messageDialogs.showError(parent, I18n.i18n("MSG_GAMEINFO_INVALID_KOMI"), I18n.i18n("MSG_GAMEINFO_INVALID_KOMI_2"), false);
            return false;
        }
        return true;
    }

    private boolean validatePosIntOrEmpty(Component parent, JTextField textField, String errorMessage, MessageDialogs messageDialogs) {
        try {
            String content = GameInfoDialog.getTextFieldContent(textField);
            if (content.trim().equals("")) {
                return true;
            }
            int value = Integer.parseInt(content);
            if (value <= 0) {
                messageDialogs.showError(parent, I18n.i18n(errorMessage), I18n.i18n("MSG_GAMEINFO_NO_POSITIVE_NUMBER"), false);
                return false;
            }
        }
        catch (NumberFormatException e) {
            messageDialogs.showError(parent, I18n.i18n(errorMessage), I18n.i18n("MSG_GAMEINFO_NO_NUMBER"), false);
            return false;
        }
        return true;
    }

    private static class PlayerInfo {
        public Box m_box;
        public JTextField m_name;
        public JTextField m_rank;

        private PlayerInfo() {
        }
    }
}

