/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import net.sf.gogui.game.Clock;
import net.sf.gogui.gui.GuiUtil;

class GtpShellText
extends JTextPane {
    private boolean m_isLastTextNonGTP;
    private boolean m_timeStamp;
    private final int m_historyMin;
    private final int m_historyMax;
    private int m_lines;
    private int m_truncated;
    private final long m_startTime;

    public GtpShellText(int historyMin, int historyMax, boolean timeStamp) {
        GuiUtil.setMonospacedFont(this);
        this.m_startTime = System.currentTimeMillis();
        this.m_timeStamp = timeStamp;
        this.m_historyMin = historyMin;
        this.m_historyMax = historyMax;
        GuiUtil.addStyle(this, "error", Color.red);
        GuiUtil.addStyle(this, "warning", Color.decode("#ff7000"));
        GuiUtil.addStyle(this, "output", null, null, true);
        GuiUtil.addStyle(this, "log", new Color(0.5f, 0.5f, 0.5f));
        GuiUtil.addStyle(this, "livegfx", Color.decode("#5498B0"));
        GuiUtil.addStyle(this, "time", new Color(0.0f, 0.0f, 0.5f));
        GuiUtil.addStyle(this, "invalid", new Color(1.0f, 0.58f, 0.25f));
        this.setEditable(false);
    }

    public void appendComment(String text) {
        this.m_isLastTextNonGTP = false;
        this.appendText(text, "log");
    }

    public void appendError(String text) {
        this.m_isLastTextNonGTP = false;
        this.appendTimeStamp();
        this.appendText(text, "error");
    }

    public void appendInput(String text) {
        this.m_isLastTextNonGTP = false;
        this.appendTimeStamp();
        this.appendText(text, null);
    }

    public void appendInvalidResponse(String text) {
        this.m_isLastTextNonGTP = true;
        this.appendText(text, "invalid");
    }

    public void appendLog(String text, boolean isLiveGfx, boolean isWarning) {
        this.m_isLastTextNonGTP = true;
        if (isLiveGfx) {
            this.appendText(text, "livegfx");
        } else if (isWarning) {
            this.appendText(text, "warning");
        } else {
            this.appendText(text, "log");
        }
    }

    public void appendOutput(String text) {
        this.m_isLastTextNonGTP = false;
        this.appendTimeStamp();
        this.appendText(text, "output");
    }

    public static int findTruncateIndex(String text, int truncateLines) {
        int indexNewLine = 0;
        int lines = 0;
        while ((indexNewLine = text.indexOf(10, indexNewLine)) != -1) {
            ++indexNewLine;
            if (++lines != truncateLines) continue;
            return indexNewLine;
        }
        return -1;
    }

    public int getLinesTruncated() {
        return this.m_truncated;
    }

    public String getLog() {
        Document doc = this.getDocument();
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            assert (false);
            return "";
        }
    }

    public boolean isLastTextNonGTP() {
        return this.m_isLastTextNonGTP;
    }

    public void setPositionToEnd() {
        int length = this.getDocument().getLength();
        this.setCaretPosition(length);
    }

    public void setTimeStamp(boolean enable) {
        this.m_timeStamp = enable;
    }

    private void appendText(String text, String style) {
        block7: {
            assert (SwingUtilities.isEventDispatchThread());
            if (text.equals("")) {
                return;
            }
            int indexNewLine = 0;
            while ((indexNewLine = text.indexOf(10, indexNewLine)) != -1) {
                ++this.m_lines;
                ++indexNewLine;
            }
            Document doc = this.getDocument();
            Style s = null;
            if (style != null) {
                s = this.getStyle(style);
            }
            try {
                int length = doc.getLength();
                doc.insertString(length, text, s);
                this.setPositionToEnd();
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
        if (this.m_lines > this.m_historyMax) {
            this.truncateHistory();
            this.setPositionToEnd();
        }
    }

    private void appendTimeStamp() {
        if (!this.m_timeStamp) {
            return;
        }
        long timeMillis = System.currentTimeMillis();
        double diff = (float)(timeMillis - this.m_startTime) / 1000.0f;
        this.appendText(Clock.getTimeString(diff, -1) + " ", "time");
    }

    private void truncateHistory() {
        block3: {
            int truncateLines = this.m_lines - this.m_historyMin;
            Document doc = this.getDocument();
            try {
                String text = doc.getText(0, doc.getLength());
                int truncateIndex = GtpShellText.findTruncateIndex(text, truncateLines);
                assert (truncateIndex != -1);
                doc.remove(0, truncateIndex);
                this.m_lines -= truncateLines;
                this.m_truncated += truncateLines;
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }
}

