/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.I18n;
import net.sf.gogui.gui.MessageDialogs;

class TimeField
extends Box {
    private final JTextField m_textField;
    private final JComboBox m_comboBox;

    public TimeField(int cols, String toolTipText) {
        super(1);
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        this.add(Box.createVerticalGlue());
        this.add(panel);
        this.add(Box.createVerticalGlue());
        this.m_textField = new JTextField(cols);
        this.m_textField.setHorizontalAlignment(4);
        this.m_textField.setToolTipText(I18n.i18n(toolTipText));
        panel.add(this.m_textField);
        panel.add(GuiUtil.createSmallFiller());
        String[] units = new String[]{I18n.i18n("LB_GAMEINFO_MIN"), I18n.i18n("LB_GAMEINFO_SEC")};
        this.m_comboBox = new JComboBox<String>(units);
        panel.add(this.m_comboBox);
    }

    public boolean isEmpty() {
        return this.m_textField.getText().trim().equals("");
    }

    public long getTime() {
        try {
            long units = this.m_comboBox.getSelectedIndex() == 0 ? 60000L : 1000L;
            return units * Long.parseLong(this.m_textField.getText().trim());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public void setTime(long millis) {
        long seconds = millis / 1000L;
        if (seconds % 60L == 0L) {
            this.m_textField.setText(Long.toString(seconds / 60L));
            this.m_comboBox.setSelectedIndex(0);
        } else {
            this.m_textField.setText(Long.toString(seconds));
            this.m_comboBox.setSelectedIndex(1);
        }
    }

    public boolean validateTime(Component parent, MessageDialogs messageDialogs) {
        try {
            if (this.isEmpty()) {
                return true;
            }
            int value = Integer.parseInt(this.m_textField.getText().trim());
            if (value < 0) {
                messageDialogs.showError(parent, I18n.i18n("MSG_GAMEINFO_INVALID_TIME"), I18n.i18n("MSG_GAMEINFO_NO_POSITIVE_NUMBER"), false);
                return false;
            }
        }
        catch (NumberFormatException e) {
            messageDialogs.showError(parent, I18n.i18n("MSG_GAMEINFO_INVALID_TIME"), I18n.i18n("MSG_GAMEINFO_NO_NUMBER"), false);
            return false;
        }
        return true;
    }
}

