/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.util;

import java.util.ArrayList;
import net.sf.gogui.util.Histogram;
import net.sf.gogui.util.Statistics;
import net.sf.gogui.util.StringUtil;
import net.sf.gogui.util.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableUtil {
    public static boolean allEmpty(Table table, String column) throws Table.InvalidLocation {
        for (int row = 0; row < table.getNumberRows(); ++row) {
            String value = table.get(column, row);
            if (StringUtil.isEmpty(value)) continue;
            return false;
        }
        return true;
    }

    public static void appendRow(Table to, Table from, int row) {
        assert (to.getNumberColumns() == from.getNumberColumns());
        to.startRow();
        for (int column = 0; column < to.getNumberColumns(); ++column) {
            to.set(column, from.get(column, row));
        }
    }

    public static int findRow(Table table, String compareColumn1, String compareValue1, String compareColumn2, String compareValue2) throws Table.InvalidLocation {
        for (int row = 0; row < table.getNumberRows(); ++row) {
            String value2;
            String value1 = table.get(compareColumn1, row);
            if (value1 == null || !value1.equals(compareValue1) || (value2 = table.get(compareColumn2, row)) == null || !value2.equals(compareValue2)) continue;
            return row;
        }
        return -1;
    }

    public static Table fromHistogram(Histogram histogram, String name) {
        ArrayList<String> columnTitles = new ArrayList<String>(2);
        columnTitles.add(name);
        columnTitles.add("Count");
        Table result = new Table(columnTitles);
        for (int i = 0; i < histogram.getSize(); ++i) {
            int count = histogram.getCount(i);
            if (count == 0) continue;
            result.startRow();
            try {
                result.set(name, histogram.getValue(i));
                result.set("Count", count);
                continue;
            }
            catch (Table.InvalidLocation e) {
                assert (false);
                continue;
            }
        }
        return result;
    }

    public static ArrayList<String> getColumnNotEmpty(Table table, String column) throws Table.InvalidLocation {
        ArrayList<String> result = new ArrayList<String>();
        int col = table.getColumnIndex(column);
        for (int row = 0; row < table.getNumberRows(); ++row) {
            String value = table.get(col, row);
            if (StringUtil.isEmpty(value)) continue;
            result.add(value);
        }
        return result;
    }

    public static ArrayList<String> getColumnUnique(Table table, String column) throws Table.InvalidLocation {
        ArrayList<String> result = new ArrayList<String>();
        int col = table.getColumnIndex(column);
        for (int row = 0; row < table.getNumberRows(); ++row) {
            String value = table.get(col, row);
            if (value == null || value.equals("") || result.contains(value)) continue;
            result.add(value);
        }
        return result;
    }

    public static double getMax(Table table, String column) throws Table.InvalidLocation {
        double max = Double.NEGATIVE_INFINITY;
        int col = table.getColumnIndex(column);
        for (int row = 0; row < table.getNumberRows(); ++row) {
            try {
                double value = Double.parseDouble(table.get(col, row));
                max = Math.max(max, value);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return max;
    }

    public static Statistics getStatistics(Table table, String column) throws Table.InvalidLocation {
        Statistics statistics = new Statistics();
        int col = table.getColumnIndex(column);
        for (int row = 0; row < table.getNumberRows(); ++row) {
            try {
                String value = table.get(col, row);
                if (value == null) continue;
                double doubleValue = Double.parseDouble(value);
                statistics.add(doubleValue);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return statistics;
    }

    public static boolean isNumberValue(String string) {
        if (string == null) {
            return false;
        }
        try {
            Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isBoolValue(String string) {
        return string.equals("0") || string.equals("1");
    }

    public static boolean isIntValue(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static Table select(Table table, String compareColumn, String compareValue) throws Table.InvalidLocation {
        Table result = new Table(table.getColumnTitles());
        int numberColumns = table.getNumberColumns();
        for (int row = 0; row < table.getNumberRows(); ++row) {
            String value = table.get(compareColumn, row);
            if (value == null || !value.equals(compareValue)) continue;
            result.startRow();
            for (int column = 0; column < numberColumns; ++column) {
                result.set(column, table.get(column, row));
            }
        }
        return result;
    }

    public static Table select(Table table, String compareColumn, String compareValue, String selectColumn) throws Table.InvalidLocation {
        ArrayList<String> columnTitles = new ArrayList<String>(1);
        columnTitles.add(selectColumn);
        Table result = new Table(columnTitles);
        for (int row = 0; row < table.getNumberRows(); ++row) {
            String value = table.get(compareColumn, row);
            if (value == null || !value.equals(compareValue)) continue;
            result.startRow();
            result.set(selectColumn, table.get(selectColumn, row));
        }
        return result;
    }

    public static Table select(Table table, String compareColumn, String compareValue, String selectColumn1, String selectColumn2) throws Table.InvalidLocation {
        ArrayList<String> columnTitles = new ArrayList<String>(2);
        columnTitles.add(selectColumn1);
        columnTitles.add(selectColumn2);
        Table result = new Table(columnTitles);
        for (int row = 0; row < table.getNumberRows(); ++row) {
            String value = table.get(compareColumn, row);
            if (value == null || !value.equals(compareValue)) continue;
            result.startRow();
            result.set(selectColumn1, table.get(selectColumn1, row));
            result.set(selectColumn2, table.get(selectColumn2, row));
        }
        return result;
    }

    public static Table selectIntRange(Table table, String compareColumn, int min, int max) throws Table.InvalidLocation {
        Table result = new Table(table.getColumnTitles());
        int numberColumns = table.getNumberColumns();
        for (int row = 0; row < table.getNumberRows(); ++row) {
            String value = table.get(compareColumn, row);
            try {
                int intValue = Integer.parseInt(value);
                if (intValue < min || intValue > max) continue;
                result.startRow();
                for (int column = 0; column < numberColumns; ++column) {
                    result.set(column, table.get(column, row));
                }
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private TableUtil() {
    }
}

