/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.EnumSet;
import java.util.Map;
import net.sf.gogui.game.ConstGameInfo;
import net.sf.gogui.game.ConstGameTree;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.ConstSgfProperties;
import net.sf.gogui.game.MarkType;
import net.sf.gogui.game.NodeUtil;
import net.sf.gogui.game.SgfProperties;
import net.sf.gogui.game.StringInfo;
import net.sf.gogui.game.StringInfoColor;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.sgf.SgfUtil;
import net.sf.gogui.util.XmlUtil;

public class XmlWriter {
    private int m_boardSize;
    private PrintStream m_out;

    public XmlWriter(OutputStream out, ConstGameTree tree, String application) {
        try {
            this.m_out = new PrintStream(out, false, "UTF-8");
            this.m_out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        }
        catch (UnsupportedEncodingException e) {
            assert (false);
            this.m_out = new PrintStream(out, false);
            this.m_out.print("<?xml version='1.0'?>\n");
        }
        ConstNode root = tree.getRootConst();
        ConstGameInfo info = tree.getGameInfoConst(root);
        String gameNameAtt = "";
        ConstSgfProperties sgfProperties = root.getSgfPropertiesConst();
        if (sgfProperties != null && sgfProperties.hasKey("GN") && sgfProperties.getNumberValues("GN") > 0) {
            gameNameAtt = " name=\"" + XmlUtil.escapeAttr(sgfProperties.getValue("GN", 0)) + "\"";
        }
        this.m_out.print("<Go>\n<GoGame" + gameNameAtt + ">\n");
        this.m_boardSize = tree.getBoardSize();
        this.printGameInfo(application, info);
        this.m_out.print("<Nodes>\n");
        this.printNode(root, true);
        this.m_out.print("</Nodes>\n</GoGame>\n</Go>\n");
        this.m_out.close();
    }

    private String getSgfPoint(GoPoint p) {
        if (p == null) {
            return "";
        }
        int x = 97 + p.getX();
        int y = 97 + (this.m_boardSize - p.getY() - 1);
        return "" + (char)x + (char)y;
    }

    private void printElementWithParagraphs(String element, String value) {
        String line;
        if (value == null) {
            return;
        }
        StringReader reader = new StringReader(value);
        this.m_out.print("<" + element + ">\n");
        boolean endsWithNewline = false;
        while (!(line = XmlWriter.readLine(reader)).equals("")) {
            endsWithNewline = line.endsWith("\n");
            if (endsWithNewline) {
                line = line.substring(0, line.length() - 1);
            }
            if (line.equals("")) {
                this.m_out.print("<P/>\n");
                continue;
            }
            this.printElementLine("P", line);
        }
        if (endsWithNewline) {
            this.m_out.print("<P/>\n");
        }
        this.m_out.print("</" + element + ">\n");
    }

    private void printElementLine(String element, String text) {
        this.m_out.print("<" + element + ">" + XmlUtil.escapeText(text) + "</" + element + ">\n");
    }

    private void printGameInfo(String application, ConstGameInfo info) {
        this.m_out.print("<Information>\n");
        if (application != null) {
            this.printElementLine("Application", application);
        }
        this.printElementLine("BoardSize", Integer.toString(this.m_boardSize));
        this.printInfo("WhitePlayer", info.get(StringInfoColor.NAME, GoColor.WHITE));
        this.printInfo("BlackPlayer", info.get(StringInfoColor.NAME, GoColor.BLACK));
        this.printInfo("WhiteRank", info.get(StringInfoColor.RANK, GoColor.WHITE));
        this.printInfo("BlackRank", info.get(StringInfoColor.RANK, GoColor.BLACK));
        this.printInfo("Date", info.get(StringInfo.DATE));
        this.printInfo("Rules", info.get(StringInfo.RULES));
        if (info.getHandicap() > 0) {
            this.printInfo("Handicap", Integer.toString(info.getHandicap()));
        }
        if (info.getKomi() != null) {
            this.printInfo("Komi", info.getKomi().toString());
        }
        if (info.getTimeSettings() != null) {
            long time = info.getTimeSettings().getPreByoyomi() / 1000L;
            this.printInfo("Time", Long.toString(time));
        }
        this.printInfo("Result", info.get(StringInfo.RESULT));
        this.printInfo("WhiteTeam", info.get(StringInfoColor.TEAM, GoColor.WHITE));
        this.printInfo("BlackTeam", info.get(StringInfoColor.TEAM, GoColor.BLACK));
        this.printInfo("User", info.get(StringInfo.USER));
        this.printInfo("Annotation", info.get(StringInfo.ANNOTATION));
        this.printInfo("Source", info.get(StringInfo.SOURCE));
        this.printInfo("Round", info.get(StringInfo.ROUND));
        this.printElementWithParagraphs("Copyright", info.get(StringInfo.COPYRIGHT));
        this.m_out.print("</Information>\n");
    }

    private void printInfo(String element, String value) {
        if (value == null) {
            return;
        }
        this.printElementLine(element, value);
    }

    private void printMarkup(ConstNode node) {
        Map<GoPoint, String> labels;
        this.printMarkup(node, MarkType.MARK, "");
        this.printMarkup(node, MarkType.CIRCLE, " type=\"circle\"");
        this.printMarkup(node, MarkType.SQUARE, " type=\"square\"");
        this.printMarkup(node, MarkType.TRIANGLE, " type=\"triangle\"");
        this.printMarkup(node, MarkType.TERRITORY_BLACK, " territory=\"black\"");
        this.printMarkup(node, MarkType.TERRITORY_WHITE, " territory=\"white\"");
        ConstPointList pointList = node.getMarkedConst(MarkType.SELECT);
        if (pointList != null) {
            for (GoPoint p : pointList) {
                this.m_out.print("<SGF type=\"SL\"><Arg>" + this.getSgfPoint(p) + "</Arg></SGF>\n");
            }
        }
        if ((labels = node.getLabelsUnmodifiable()) != null) {
            for (Map.Entry<GoPoint, String> e : labels.entrySet()) {
                this.m_out.print("<Mark at=\"" + e.getKey() + "\" label=\"" + XmlUtil.escapeAttr(e.getValue()) + "\"/>\n");
            }
        }
    }

    private void printMarkup(ConstNode node, MarkType type, String attributes) {
        ConstPointList pointList = node.getMarkedConst(type);
        if (pointList == null) {
            return;
        }
        for (GoPoint p : pointList) {
            this.m_out.print("<Mark at=\"" + p + "\"" + attributes + "/>\n");
        }
    }

    private void printMove(ConstNode node) {
        Move move = node.getMove();
        if (move == null) {
            return;
        }
        GoPoint p = move.getPoint();
        String at = p == null ? "" : p.toString();
        GoColor c = move.getColor();
        int number = NodeUtil.getMoveNumber(node);
        String timeLeftAtt = "";
        double timeLeft = node.getTimeLeft(c);
        if (!Double.isNaN(timeLeft)) {
            timeLeftAtt = " timeleft=\"" + timeLeft + "\"";
        }
        if (c == GoColor.BLACK) {
            this.m_out.print("<Black number=\"" + number + "\" at=\"" + at + "\"" + timeLeftAtt + "/>\n");
        } else if (c == GoColor.WHITE) {
            this.m_out.print("<White number=\"" + number + "\" at=\"" + at + "\"" + timeLeftAtt + "/>\n");
        }
        int movesLeft = node.getMovesLeft(c);
        if (movesLeft >= 0) {
            if (c == GoColor.BLACK) {
                this.m_out.print("<SGF type=\"OB\"><Arg>" + movesLeft + "</Arg></SGF>\n");
            } else if (c == GoColor.WHITE) {
                this.m_out.print("<SGF type=\"OW\"><Arg>" + movesLeft + "</Arg></SGF>\n");
            }
        }
    }

    private void printNode(ConstNode node, boolean isRoot) {
        ConstNode child;
        boolean isEmpty;
        Map<GoPoint, String> labels;
        boolean hasMarkup;
        String overtime;
        TimeSettings timeSettings;
        Move move = node.getMove();
        String comment = node.getComment();
        SgfProperties sgfProps = NodeUtil.cleanSgfProps(node);
        String nameAtt = "";
        if (sgfProps.hasKey("N") && sgfProps.getNumberValues("N") > 0) {
            nameAtt = " name=\"" + XmlUtil.escapeAttr(sgfProps.getValue("N", 0)) + "\"";
            sgfProps.remove("N");
        }
        if (!(Double.isNaN(node.getTimeLeft(GoColor.BLACK)) || move != null && move.getColor() == GoColor.BLACK)) {
            sgfProps.add("BL", Double.toString(node.getTimeLeft(GoColor.BLACK)));
        }
        if (!(Double.isNaN(node.getTimeLeft(GoColor.WHITE)) || move != null && move.getColor() == GoColor.WHITE)) {
            sgfProps.add("WL", Double.toString(node.getTimeLeft(GoColor.WHITE)));
        }
        ConstGameInfo info = node.getGameInfoConst();
        if (isRoot && (timeSettings = info.getTimeSettings()) != null && (overtime = SgfUtil.getOvertime(timeSettings)) != null) {
            sgfProps.add("OT", overtime);
        }
        boolean bl = hasMarkup = (labels = node.getLabelsUnmodifiable()) != null && !labels.isEmpty();
        if (!hasMarkup) {
            for (MarkType type : EnumSet.allOf(MarkType.class)) {
                ConstPointList pointList = node.getMarkedConst(type);
                if (pointList == null || node.getMarkedConst(type).isEmpty()) continue;
                hasMarkup = true;
                break;
            }
        }
        boolean hasSetup = node.hasSetup() || node.getPlayer() != null;
        boolean hasMovesLeft = move != null && node.getMovesLeft(move.getColor()) != -1;
        boolean hasNonRootGameInfo = info != null && !isRoot;
        boolean isEmptyButMoveOrComment = sgfProps.isEmpty() && !hasSetup && !hasMarkup && !hasMovesLeft && !hasNonRootGameInfo;
        boolean needsNode = !isEmptyButMoveOrComment || !nameAtt.equals("") || move == null && comment != null;
        boolean bl2 = isEmpty = isEmptyButMoveOrComment && comment == null && move == null;
        if (isEmpty) {
            this.m_out.print("<Node" + nameAtt + "/>\n");
        } else {
            if (needsNode) {
                this.m_out.print("<Node" + nameAtt + ">\n");
            }
            this.printMove(node);
            this.printSetup(node);
            this.printMarkup(node);
            this.printElementWithParagraphs("Comment", comment);
            if (hasNonRootGameInfo) {
                this.putGameInfoSgf(info, sgfProps);
            }
            this.printSgfProperties(sgfProps);
            if (needsNode) {
                this.m_out.print("</Node>\n");
            }
        }
        ConstNode father = node.getFatherConst();
        if (father != null && father.getChildConst() == node) {
            int numberSiblings = father.getNumberChildren();
            for (int i = 1; i < numberSiblings; ++i) {
                this.m_out.print("<Variation>\n");
                this.printNode(father.getChildConst(i), false);
                this.m_out.print("</Variation>\n");
            }
        }
        if ((child = node.getChildConst()) != null) {
            this.printNode(child, false);
        }
    }

    private void printSgfProperties(ConstSgfProperties sgfProps) {
        for (String key : sgfProps.getKeys()) {
            this.m_out.print("<SGF type=\"" + key + "\">");
            int numberValues = sgfProps.getNumberValues(key);
            for (int i = 0; i < numberValues; ++i) {
                this.m_out.print("<Arg>" + XmlUtil.escapeText(sgfProps.getValue(key, i)) + "</Arg>");
            }
            this.m_out.print("</SGF>\n");
        }
    }

    private void printSetup(ConstNode node) {
        for (GoPoint p : node.getSetup(GoColor.BLACK)) {
            this.m_out.print("<AddBlack at=\"" + p + "\"/>\n");
        }
        for (GoPoint p : node.getSetup(GoColor.WHITE)) {
            this.m_out.print("<AddWhite at=\"" + p + "\"/>\n");
        }
        for (GoPoint p : node.getSetup(GoColor.EMPTY)) {
            this.m_out.print("<Delete at=\"" + p + "\"/>\n");
        }
        GoColor player = node.getPlayer();
        if (GoColor.BLACK.equals((Object)player)) {
            this.m_out.print("<SGF type=\"PL\"><Arg>B</Arg></SGF>\n");
        } else if (GoColor.WHITE.equals((Object)player)) {
            this.m_out.print("<SGF type=\"PL\"><Arg>W</Arg></SGF>\n");
        }
    }

    private void putGameInfoSgf(ConstGameInfo info, SgfProperties sgfProps) {
        this.putGameInfoSgf(info, sgfProps, "PB", StringInfoColor.NAME, GoColor.BLACK);
        this.putGameInfoSgf(info, sgfProps, "PW", StringInfoColor.NAME, GoColor.WHITE);
        this.putGameInfoSgf(info, sgfProps, "BR", StringInfoColor.RANK, GoColor.BLACK);
        this.putGameInfoSgf(info, sgfProps, "WR", StringInfoColor.RANK, GoColor.WHITE);
        this.putGameInfoSgf(info, sgfProps, "BT", StringInfoColor.TEAM, GoColor.BLACK);
        this.putGameInfoSgf(info, sgfProps, "WT", StringInfoColor.TEAM, GoColor.WHITE);
        this.putGameInfoSgf(info, sgfProps, "DT", StringInfo.DATE);
        this.putGameInfoSgf(info, sgfProps, "RE", StringInfo.RESULT);
        this.putGameInfoSgf(info, sgfProps, "RO", StringInfo.ROUND);
        this.putGameInfoSgf(info, sgfProps, "RU", StringInfo.RULES);
        this.putGameInfoSgf(info, sgfProps, "US", StringInfo.USER);
        this.putGameInfoSgf(info, sgfProps, "CP", StringInfo.COPYRIGHT);
        this.putGameInfoSgf(info, sgfProps, "AN", StringInfo.ANNOTATION);
        if (info.getHandicap() > 0) {
            this.putGameInfoSgf(sgfProps, "HA", Integer.toString(info.getHandicap()));
        }
        if (info.getKomi() != null) {
            this.putGameInfoSgf(sgfProps, "KM", info.getKomi().toString());
        }
        if (info.getTimeSettings() != null) {
            this.putGameInfoSgf(sgfProps, "TM", info.getTimeSettings().toString());
        }
    }

    private void putGameInfoSgf(SgfProperties sgfProps, String key, String value) {
        sgfProps.add(key, value);
    }

    private void putGameInfoSgf(ConstGameInfo info, SgfProperties sgfProps, String key, StringInfo type) {
        String value = info.get(type);
        if (value == null) {
            return;
        }
        sgfProps.add(key, value);
    }

    private void putGameInfoSgf(ConstGameInfo info, SgfProperties sgfProps, String key, StringInfoColor type, GoColor c) {
        String value = info.get(type, c);
        if (value == null) {
            return;
        }
        sgfProps.add(key, value);
    }

    private static String readLine(StringReader reader) {
        StringBuilder result;
        block3: {
            result = new StringBuilder();
            try {
                int c;
                while ((c = reader.read()) != -1) {
                    result.append((char)c);
                    if ((char)c != '\n') continue;
                    break;
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        return result.toString();
    }
}

