/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.boardpainter;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import net.sf.gogui.boardpainter.ConstField;
import net.sf.gogui.boardpainter.RadialGradientPaint;
import net.sf.gogui.go.GoColor;

public class Field
implements ConstField {
    private boolean m_crossHair;
    private boolean m_cursor;
    private boolean m_lastMoveMarker;
    private boolean m_mark;
    private boolean m_markCircle;
    private boolean m_markSquare;
    private boolean m_markTriangle;
    private boolean m_influenceSet;
    private boolean m_select;
    private static int s_cachedFontFieldSize;
    private int m_paintSizeBlack;
    private int m_paintSizeWhite;
    private int m_size;
    private double m_influence;
    private static final AlphaComposite COMPOSITE_4;
    private static final AlphaComposite COMPOSITE_5;
    private static final AlphaComposite COMPOSITE_6;
    private static final AlphaComposite COMPOSITE_7;
    private static final AlphaComposite COMPOSITE_8;
    private static final AlphaComposite COMPOSITE_95;
    private static final AlphaComposite COMPOSITE_97;
    private static final Stroke THICK_STROKE;
    private String m_label = "";
    private Color m_fieldColor;
    private GoColor m_territory = GoColor.EMPTY;
    private static final Color COLOR_INFLUENCE_BLACK;
    private static final Color COLOR_INFLUENCE_WHITE;
    private static final Color COLOR_LAST_MOVE;
    private static final Color COLOR_MARK;
    private static final Color COLOR_STONE_BLACK;
    private static final Color COLOR_STONE_BLACK_BRIGHT;
    private static final Color COLOR_STONE_WHITE;
    private static final Color COLOR_STONE_WHITE_BRIGHT;
    private static Font s_cachedFont;
    private GoColor m_color = GoColor.EMPTY;
    private GoColor m_ghostStone;
    private Graphics m_graphics;
    private Graphics2D m_graphics2D;
    private RadialGradientPaint m_paintBlack;
    private RadialGradientPaint m_paintWhite;

    public void clearInfluence() {
        this.m_influenceSet = false;
        this.m_influence = 0.0;
    }

    public void draw(Graphics graphics, int size, int x, int y, Image boardImage, int boardWidth) {
        if (!graphics.hitClip(x, y, size, size)) {
            return;
        }
        this.m_graphics = graphics.create(x, y, size, size);
        this.m_graphics2D = this.m_graphics instanceof Graphics2D ? (Graphics2D)this.m_graphics : null;
        this.m_size = size;
        if (this.m_fieldColor != null) {
            this.drawFieldColor();
        }
        if (this.m_territory != GoColor.EMPTY && this.m_graphics2D == null) {
            this.drawTerritoryGraphics();
        }
        if (this.m_color != GoColor.EMPTY) {
            this.drawStone(this.m_color, false);
        }
        if (this.m_ghostStone != null) {
            this.drawStone(this.m_ghostStone, true);
        }
        if (this.m_label != null && !this.m_label.equals("")) {
            this.drawLabel(x, y, graphics, boardImage, boardWidth);
        }
        if (this.m_territory != GoColor.EMPTY && this.m_graphics2D != null) {
            this.drawTerritoryGraphics2D();
        }
        if (this.m_influenceSet) {
            this.drawInfluence();
        }
        this.drawMarks();
        if (this.m_crossHair) {
            this.drawCrossHair();
        }
        if (this.m_lastMoveMarker) {
            this.drawLastMoveMarker();
        }
        if (this.m_select) {
            this.drawSelect();
        }
        if (this.m_cursor) {
            this.drawCursor();
        }
        this.m_graphics = null;
    }

    public GoColor getColor() {
        return this.m_color;
    }

    public boolean getCursor() {
        return this.m_cursor;
    }

    public boolean getCrossHair() {
        return this.m_crossHair;
    }

    public Color getFieldBackground() {
        return this.m_fieldColor;
    }

    public boolean getMark() {
        return this.m_mark;
    }

    public boolean getMarkCircle() {
        return this.m_markCircle;
    }

    public boolean getMarkSquare() {
        return this.m_markSquare;
    }

    public boolean getMarkTriangle() {
        return this.m_markTriangle;
    }

    public boolean getSelect() {
        return this.m_select;
    }

    public GoColor getGhostStone() {
        return this.m_ghostStone;
    }

    public static int getStoneMargin(int size) {
        return size / 17;
    }

    public String getLabel() {
        return this.m_label;
    }

    public GoColor getTerritory() {
        return this.m_territory;
    }

    public boolean isInfluenceSet() {
        return this.m_influenceSet;
    }

    public void setFieldBackground(Color color) {
        this.m_fieldColor = color;
    }

    public void setColor(GoColor color) {
        this.m_color = color;
    }

    public void setCrossHair(boolean crossHair) {
        this.m_crossHair = crossHair;
    }

    public void setCursor(boolean cursor) {
        this.m_cursor = cursor;
    }

    public void setInfluence(double value) {
        if (value > 1.0) {
            value = 1.0;
        } else if (value < -1.0) {
            value = -1.0;
        }
        this.m_influence = value;
        this.m_influenceSet = true;
    }

    public void setLastMoveMarker(boolean lastMoveMarker) {
        this.m_lastMoveMarker = lastMoveMarker;
    }

    public void setMark(boolean mark) {
        this.m_mark = mark;
    }

    public void setMarkCircle(boolean mark) {
        this.m_markCircle = mark;
    }

    public void setMarkSquare(boolean mark) {
        this.m_markSquare = mark;
    }

    public void setMarkTriangle(boolean mark) {
        this.m_markTriangle = mark;
    }

    public void setSelect(boolean select) {
        this.m_select = select;
    }

    public void setGhostStone(GoColor color) {
        this.m_ghostStone = color;
    }

    public void setLabel(String s) {
        this.m_label = s;
    }

    public void setTerritory(GoColor color) {
        assert (color != null);
        this.m_territory = color;
    }

    private void drawCircle(Color color) {
        this.m_graphics.setColor(color);
        int d = this.m_size * 4 / 10;
        int w = this.m_size - 2 * d;
        this.m_graphics.fillOval(d, d, w, w);
    }

    private void drawCrossHair() {
        this.setComposite(COMPOSITE_7);
        int d = this.m_size / 5;
        int center = this.m_size / 2;
        this.m_graphics.setColor(Color.red);
        this.m_graphics.drawLine(d, center, this.m_size - d, center);
        this.m_graphics.drawLine(center, d, center, this.m_size - d);
        this.m_graphics.setPaintMode();
    }

    private void drawCursor() {
        this.setComposite(COMPOSITE_7);
        int d = this.m_size / 6;
        int w = this.m_size;
        int d2 = 2 * d;
        this.m_graphics.setColor(COLOR_LAST_MOVE);
        Stroke oldStroke = null;
        if (this.m_graphics2D != null && this.m_size > 10) {
            oldStroke = this.m_graphics2D.getStroke();
            this.m_graphics2D.setStroke(THICK_STROKE);
        }
        this.m_graphics.drawLine(d, d, d2, d);
        this.m_graphics.drawLine(d, d, d, d2);
        this.m_graphics.drawLine(d, w - d2 - 1, d, w - d - 1);
        this.m_graphics.drawLine(d, w - d - 1, d2, w - d - 1);
        this.m_graphics.drawLine(w - d2 - 1, d, w - d - 1, d);
        this.m_graphics.drawLine(w - d - 1, d, w - d - 1, d2);
        this.m_graphics.drawLine(w - d - 1, w - d - 1, w - d - 1, w - d2 - 1);
        this.m_graphics.drawLine(w - d - 1, w - d - 1, w - d2 - 1, w - d - 1);
        if (oldStroke != null) {
            this.m_graphics2D.setStroke(oldStroke);
        }
        this.m_graphics.setPaintMode();
    }

    private void drawFieldColor() {
        this.setComposite(COMPOSITE_5);
        this.m_graphics.setColor(this.m_fieldColor);
        this.m_graphics.fillRect(0, 0, this.m_size, this.m_size);
        this.m_graphics.setPaintMode();
    }

    private void drawInfluence() {
        double d = Math.abs(this.m_influence);
        if (d < 0.01) {
            return;
        }
        this.setComposite(COMPOSITE_6);
        if (this.m_influence > 0.0) {
            this.m_graphics.setColor(COLOR_INFLUENCE_BLACK);
        } else {
            this.m_graphics.setColor(COLOR_INFLUENCE_WHITE);
        }
        int dd = (int)((double)this.m_size * (0.38 + (1.0 - d) * 0.62));
        int width = this.m_size - dd;
        this.m_graphics.fillRect(dd / 2, dd / 2, width, width);
    }

    private void drawLabel(int fieldX, int fieldY, Graphics boardGraphics, Image boardImage, int boardWidth) {
        this.setComposite(COMPOSITE_97);
        Field.setFont(this.m_graphics, this.m_size);
        FontMetrics fontMetrics = this.m_graphics.getFontMetrics();
        LineMetrics lineMetrics = fontMetrics.getLineMetrics(this.m_label, this.m_graphics);
        int width = fontMetrics.stringWidth(this.m_label);
        int height = fontMetrics.getHeight();
        int ascent = (int)lineMetrics.getAscent();
        int x = Math.max((this.m_size - width) / 2, 0);
        int y = (ascent + this.m_size) / 2;
        if (this.m_ghostStone == null) {
            if (this.m_color == GoColor.BLACK) {
                this.m_graphics.setColor(Color.white);
            } else {
                this.m_graphics.setColor(Color.black);
            }
        } else if (this.m_ghostStone == GoColor.BLACK) {
            this.m_graphics.setColor(Color.white);
        } else {
            this.m_graphics.setColor(Color.black);
        }
        Rectangle oldClip = this.m_graphics.getClipBounds();
        width = Math.min(width, (int)(0.95 * (double)this.m_size));
        this.m_graphics.setClip(x, y - ascent, width, height);
        if (this.m_color == GoColor.EMPTY && this.m_ghostStone == null) {
            Rectangle oldBoardClip = boardGraphics.getClipBounds();
            boardGraphics.setClip(fieldX + x, fieldY + y - ascent, width, height);
            boardGraphics.drawImage(boardImage, 0, 0, boardWidth, boardWidth, null);
            if (this.m_fieldColor != null) {
                this.drawFieldColor();
            }
            boardGraphics.setClip(oldBoardClip);
            this.m_graphics.setColor(Color.black);
        }
        this.m_graphics.drawString(this.m_label, x, y);
        this.m_graphics.setClip(oldClip);
    }

    private void drawLastMoveMarker() {
        this.setComposite(COMPOSITE_7);
        this.drawCircle(COLOR_LAST_MOVE);
        this.m_graphics.setPaintMode();
    }

    private void drawMarks() {
        this.setComposite(COMPOSITE_95);
        int d = this.m_size / 4;
        int width = this.m_size - 2 * d;
        this.m_graphics.setColor(COLOR_MARK);
        Stroke oldStroke = null;
        if (this.m_graphics2D != null && this.m_size > 10) {
            oldStroke = this.m_graphics2D.getStroke();
            this.m_graphics2D.setStroke(THICK_STROKE);
        }
        if (this.m_mark) {
            this.m_graphics.drawLine(d, d, d + width, d + width);
            this.m_graphics.drawLine(d, d + width, d + width, d);
        }
        if (this.m_markCircle) {
            this.m_graphics.drawOval(d, d, width - 1, width - 1);
        }
        if (this.m_markSquare) {
            this.m_graphics.drawRect(d, d, width - 1, width - 1);
        }
        if (this.m_markTriangle) {
            int height = (int)(0.866 * (double)width);
            int top = (int)(0.866 * (double)(width - height) / 2.0);
            int bottom = top + height - 1;
            this.m_graphics.drawLine(d, d + bottom, d + width / 2, d + top);
            this.m_graphics.drawLine(d + width / 2, d + top, d + width, d + bottom);
            this.m_graphics.drawLine(d + width, d + bottom, d, d + bottom);
        }
        if (oldStroke != null) {
            this.m_graphics2D.setStroke(oldStroke);
        }
        this.m_graphics.setPaintMode();
    }

    private void drawSelect() {
        this.setComposite(COMPOSITE_95);
        this.drawCircle(COLOR_MARK);
        this.m_graphics.setPaintMode();
    }

    private void drawStone(GoColor color, boolean isGhostStone) {
        if (color == GoColor.BLACK) {
            this.drawStone(color, COLOR_STONE_BLACK, COLOR_STONE_BLACK_BRIGHT, isGhostStone);
        } else if (color == GoColor.WHITE) {
            this.drawStone(color, COLOR_STONE_WHITE, COLOR_STONE_WHITE_BRIGHT, isGhostStone);
        }
    }

    private void drawStone(GoColor color, Color colorNormal, Color colorBright, boolean isGhostStone) {
        int margin = Field.getStoneMargin(this.m_size);
        if (this.m_graphics2D != null && this.m_size >= 7) {
            RadialGradientPaint paint = this.getPaint(color, this.m_size, colorNormal, colorBright);
            this.m_graphics2D.setPaint(paint);
        } else {
            this.m_graphics.setColor(colorNormal);
        }
        if (isGhostStone) {
            this.setComposite(COMPOSITE_8);
        }
        this.m_graphics.fillOval(margin, margin, this.m_size - 2 * margin, this.m_size - 2 * margin);
    }

    private void drawTerritoryGraphics() {
        if (this.m_territory == GoColor.BLACK) {
            this.m_graphics.setColor(Color.darkGray);
        } else {
            assert (this.m_territory == GoColor.WHITE);
            this.m_graphics.setColor(Color.lightGray);
        }
        this.m_graphics.fillRect(0, 0, this.m_size, this.m_size);
    }

    private void drawTerritoryGraphics2D() {
        this.setComposite(COMPOSITE_4);
        if (this.m_territory == GoColor.BLACK) {
            this.m_graphics2D.setColor(Color.darkGray);
        } else {
            assert (this.m_territory == GoColor.WHITE);
            this.m_graphics2D.setColor(Color.white);
        }
        this.m_graphics2D.fillRect(0, 0, this.m_size, this.m_size);
        this.m_graphics2D.setPaintMode();
    }

    private RadialGradientPaint getPaint(GoColor color, int size, Color colorNormal, Color colorBright) {
        int paintSize;
        RadialGradientPaint paint;
        if (color == GoColor.BLACK) {
            paint = this.m_paintBlack;
            paintSize = this.m_paintSizeBlack;
        } else {
            assert (color == GoColor.WHITE);
            paint = this.m_paintWhite;
            paintSize = this.m_paintSizeWhite;
        }
        if (size == paintSize && paint != null) {
            return paint;
        }
        Point2D.Double center = new Point2D.Double(0.43 * (double)size, 0.21 * (double)size);
        Point2D.Double radius1 = new Point2D.Double(0.47 * (double)size, -0.15 * (double)size);
        Point2D.Double radius2 = new Point2D.Double(0.08 * (double)size, 0.25 * (double)size);
        double focus = -0.4;
        paint = new RadialGradientPaint(center, radius1, radius2, focus, colorBright, colorNormal);
        if (color == GoColor.BLACK) {
            this.m_paintBlack = paint;
            this.m_paintSizeBlack = size;
        } else {
            this.m_paintWhite = paint;
            this.m_paintSizeWhite = size;
        }
        return paint;
    }

    private void setComposite(AlphaComposite composite) {
        if (this.m_graphics2D != null) {
            this.m_graphics2D.setComposite(composite);
        }
    }

    private static void setFont(Graphics graphics, int fieldSize) {
        if (s_cachedFont != null && s_cachedFontFieldSize == fieldSize) {
            graphics.setFont(s_cachedFont);
            return;
        }
        int fontSize = fieldSize < 29 ? (int)(0.45 * (double)fieldSize) : (fieldSize < 40 ? 13 : (int)(13.0 + 0.15 * (double)(fieldSize - 40)));
        s_cachedFont = new Font("Dialog", 0, fontSize);
        s_cachedFontFieldSize = fieldSize;
        graphics.setFont(s_cachedFont);
    }

    static {
        COMPOSITE_4 = AlphaComposite.getInstance(3, 0.4f);
        COMPOSITE_5 = AlphaComposite.getInstance(3, 0.5f);
        COMPOSITE_6 = AlphaComposite.getInstance(3, 0.6f);
        COMPOSITE_7 = AlphaComposite.getInstance(3, 0.7f);
        COMPOSITE_8 = AlphaComposite.getInstance(3, 0.8f);
        COMPOSITE_95 = AlphaComposite.getInstance(3, 0.95f);
        COMPOSITE_97 = AlphaComposite.getInstance(3, 0.97f);
        THICK_STROKE = new BasicStroke(2.0f, 1, 0);
        COLOR_INFLUENCE_BLACK = Color.gray;
        COLOR_INFLUENCE_WHITE = Color.white;
        COLOR_LAST_MOVE = Color.decode("#888888");
        COLOR_MARK = Color.decode("#4040ff");
        COLOR_STONE_BLACK = Color.decode("#3b3d3a");
        COLOR_STONE_BLACK_BRIGHT = Color.decode("#99998c");
        COLOR_STONE_WHITE = Color.decode("#d3d7cf");
        COLOR_STONE_WHITE_BRIGHT = Color.decode("#ffffff");
    }
}

