/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import net.sf.gogui.util.ObjectUtil;
import net.sf.gogui.util.Platform;

class RecentMenuItem
extends JMenuItem {
    private String m_label;
    private final String m_value;

    public RecentMenuItem(String label, String value, ActionListener listener) {
        this.setRecentMenuLabel(label);
        this.m_value = value;
        if (!ObjectUtil.equals(label, value)) {
            this.setToolTipText(value);
        }
        this.addActionListener(listener);
    }

    public String getRecentMenuLabel() {
        return this.m_label;
    }

    public String getRecentMenuValue() {
        return this.m_value;
    }

    public void setPosition(int i) {
        String mnemonic;
        String text;
        if (!Platform.isMac() && i < 9) {
            text = Integer.toString(i + 1) + ": " + this.m_label;
            mnemonic = Integer.toString(i + 1);
        } else if (!Platform.isMac() && i == 9) {
            text = "10: " + this.m_label;
            mnemonic = "0";
        } else {
            text = this.m_label;
            mnemonic = "";
        }
        this.setText(text);
        if (!mnemonic.equals("")) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(mnemonic);
            int code = keyStroke.getKeyCode();
            this.setMnemonic(code);
        }
    }

    public void setRecentMenuLabel(String label) {
        this.m_label = label;
    }
}

