/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.display;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpCallback;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpCommand;
import net.sf.gogui.gtp.GtpEngine;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpResponseFormatError;
import net.sf.gogui.gtp.GtpUtil;
import net.sf.gogui.gui.AnalyzeShow;
import net.sf.gogui.gui.GuiBoard;
import net.sf.gogui.gui.GuiBoardUtil;
import net.sf.gogui.gui.GuiUtil;
import net.sf.gogui.gui.LiveGfx;
import net.sf.gogui.gui.MessageDialogs;
import net.sf.gogui.gui.StatusBar;
import net.sf.gogui.util.LineReader;
import net.sf.gogui.util.StringUtil;

public class Display
extends GtpEngine
implements LiveGfx.Listener {
    private int m_size = 19;
    private final Board m_board;
    private GoColor m_color;
    private final GuiBoard m_guiBoard;
    private GoPoint m_fieldClicked;
    private final GtpClient m_gtp;
    private Move m_move;
    private final Object m_mutex = new Object();
    private JFrame m_frame;
    private final StatusBar m_statusBar;
    private final String m_name;
    private final MessageDialogs m_messageDialogs = new MessageDialogs();

    public Display(String program, boolean verbose) throws Exception {
        super(null);
        this.m_board = new Board(this.m_size);
        this.m_frame = new JFrame();
        this.m_frame.setDefaultCloseOperation(0);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                Display.this.closeFrame();
            }
        };
        this.m_frame.addWindowListener(windowAdapter);
        Container contentPane = this.m_frame.getContentPane();
        this.m_guiBoard = new GuiBoard(this.m_size);
        this.m_guiBoard.setListener(new GuiBoard.Listener(){

            public void contextMenu(GoPoint point, Component invoker, int x, int y) {
            }

            public void fieldClicked(GoPoint point, boolean modifiedSelect) {
                Display.this.cbFieldClicked(point, modifiedSelect);
            }
        });
        contentPane.add(this.m_guiBoard);
        this.m_statusBar = new StatusBar();
        this.m_statusBar.showMoveText(false);
        contentPane.add((Component)this.m_statusBar, "South");
        if (!StringUtil.isEmpty(program)) {
            GtpClient.IOCallback ioCallback = new GtpClient.IOCallback(){
                private final LineReader m_lineReader = new LineReader();
                private LiveGfx m_liveGfx = new LiveGfx(Display.this);

                public void receivedInvalidResponse(String s) {
                }

                public void receivedResponse(boolean error, String s) {
                }

                public void receivedStdErr(String s) {
                    this.m_lineReader.add(s);
                    while (this.m_lineReader.hasLines()) {
                        this.m_liveGfx.handleLine(this.m_lineReader.getLine());
                    }
                }

                public void sentCommand(String s) {
                }
            };
            this.m_gtp = new GtpClient(program, null, verbose, ioCallback);
            this.m_gtp.queryProtocolVersion();
            this.m_gtp.querySupportedCommands();
            this.m_guiBoard.setShowCursor(false);
            this.m_gtp.queryName();
            this.m_name = this.m_gtp.getLabel();
            String title = "gogui-display - " + this.m_name;
            this.m_frame.setTitle(title);
        } else {
            this.m_gtp = null;
            this.m_name = null;
            this.m_frame.setTitle("gogui-display");
        }
        this.registerCommands();
        GuiUtil.setGoIcon(this.m_frame);
        this.m_frame.pack();
        this.m_frame.setVisible(true);
    }

    public void close() {
        if (this.m_gtp != null) {
            this.m_gtp.close();
            this.m_gtp.waitForExit();
        }
        GuiUtil.invokeAndWait(new Runnable(){

            public void run() {
                if (Display.this.m_frame != null) {
                    Display.this.m_messageDialogs.showInfo(Display.this.m_frame, "GTP stream was closed", "", true);
                    Display.this.showStatus("GTP stream was closed");
                } else if (Display.this.m_gtp == null) {
                    System.exit(0);
                }
            }
        });
    }

    public void cmdForward(GtpCommand cmd) throws GtpError {
        this.send(cmd.getLine(), cmd.getResponse());
    }

    public void cmdName(GtpCommand cmd) {
        if (this.m_gtp == null) {
            cmd.setResponse("gogui-display");
        } else {
            cmd.setResponse(this.m_name);
        }
    }

    public void cmdQuit(GtpCommand cmd) throws GtpError {
        if (this.m_gtp != null) {
            this.send("quit", cmd.getResponse());
        }
        this.setQuit();
    }

    public void handleCommand(GtpCommand cmd) throws GtpError {
        this.showStatus(cmd.getLine());
        super.handleCommand(cmd);
    }

    public void interruptCommand() {
        if (this.m_gtp == null) {
            return;
        }
        try {
            if (this.m_gtp.isInterruptSupported()) {
                this.m_gtp.sendInterrupt();
            }
        }
        catch (GtpError e) {
            System.err.println(e);
        }
    }

    public void showLiveGfx(String text) {
        assert (SwingUtilities.isEventDispatchThread());
        this.m_guiBoard.clearAll();
        GuiBoardUtil.updateFromGoBoard(this.m_guiBoard, this.m_board, false, false);
        AnalyzeShow.showGfx(text, this.m_guiBoard, this.m_statusBar, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cbFieldClicked(GoPoint point, boolean modifiedSelect) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.m_board.getColor(point) != GoColor.EMPTY) {
            return;
        }
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_fieldClicked = modifiedSelect ? null : point;
            this.m_mutex.notifyAll();
        }
    }

    private void clearStatus() {
        this.m_statusBar.clear();
    }

    private void closeFrame() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.m_gtp == null) {
            if (!this.m_messageDialogs.showQuestion(this.m_frame, "Terminate gogui-display?", "", "Terminate", true)) {
                return;
            }
            System.exit(0);
        }
        this.m_frame.dispose();
        this.m_frame = null;
    }

    private void cmdBoardsize(GtpCommand cmd) throws GtpError {
        cmd.checkNuArg(1);
        int size = cmd.getIntArg(0, 1, 25);
        if (this.m_gtp != null) {
            String command = this.m_gtp.getCommandBoardsize(size);
            if (command != null) {
                this.send(command);
            }
            command = this.m_gtp.getCommandClearBoard(size);
            this.send(command);
        }
        this.m_size = size;
        GuiUtil.invokeAndWait(new Runnable(){

            public void run() {
                Display.this.m_board.init(Display.this.m_size);
                if (Display.this.m_guiBoard.getBoardSize() != Display.this.m_size) {
                    Display.this.m_guiBoard.initSize(Display.this.m_size);
                    Display.this.m_frame.pack();
                }
                Display.this.updateFromGoBoard();
            }
        });
    }

    private void cmdClearBoard(GtpCommand cmd) throws GtpError {
        cmd.checkArgNone();
        if (this.m_gtp != null) {
            String command = this.m_gtp.getCommandClearBoard(this.m_size);
            this.send(command);
        }
        GuiUtil.invokeAndWait(new Runnable(){

            public void run() {
                Display.this.m_board.clear();
                Display.this.updateFromGoBoard();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmdGenmove(GtpCommand cmd) throws GtpError {
        GoPoint point;
        GoColor color = cmd.getColorArg();
        if (this.m_gtp == null) {
            if (this.m_frame == null) {
                throw new GtpError("gogui-display terminated");
            }
            this.m_color = color;
            this.showStatus("Input move for " + (Object)((Object)this.m_color) + " (Ctrl-button and click for pass)");
            Object object = this.m_mutex;
            synchronized (object) {
                try {
                    this.m_mutex.wait();
                }
                catch (InterruptedException e) {
                    System.err.println("InterruptedException");
                }
                point = this.m_fieldClicked;
            }
            cmd.setResponse(GoPoint.toString(point));
        } else {
            String command = this.m_gtp.getCommandGenmove(color);
            StringBuilder response = cmd.getResponse();
            this.send(command, response);
            if (response.toString().trim().equalsIgnoreCase("resign")) {
                return;
            }
            try {
                point = GtpUtil.parsePoint(response.toString(), this.m_size);
            }
            catch (GtpResponseFormatError e) {
                throw new GtpError(e.getMessage());
            }
        }
        this.m_move = Move.get(color, point);
        GuiUtil.invokeAndWait(new Runnable(){

            public void run() {
                Display.this.m_board.play(Display.this.m_move);
                Display.this.updateFromGoBoard();
                if (Display.this.m_gtp == null) {
                    Display.this.clearStatus();
                }
            }
        });
    }

    private void cmdKomi(GtpCommand cmd) throws GtpError {
        if (this.m_gtp == null) {
            return;
        }
        this.send(cmd.getLine(), cmd.getResponse());
    }

    private void cmdPlaceFreeHandicap(GtpCommand cmd) throws GtpError {
        int n = cmd.getIntArg();
        ConstPointList stones = Board.getHandicapStones(this.m_size, n);
        if (stones == null) {
            throw new GtpError("Invalid number of handicap stones");
        }
        StringBuilder pointList = new StringBuilder(128);
        for (GoPoint p : stones) {
            this.play(GoColor.BLACK, p);
            if (pointList.length() > 0) {
                pointList.append(' ');
            }
            pointList.append(p);
        }
        cmd.setResponse(pointList.toString());
    }

    private void cmdPlay(GtpCommand cmd) throws GtpError {
        cmd.checkNuArg(2);
        GoColor color = cmd.getColorArg(0);
        GoPoint point = cmd.getPointArg(1, this.m_size);
        this.play(color, point);
    }

    private void cmdSetFreeHandicap(GtpCommand cmd) throws GtpError {
        for (int i = 0; i < cmd.getNuArg(); ++i) {
            this.play(GoColor.BLACK, cmd.getPointArg(i, this.m_size));
        }
    }

    private void cmdUndo(GtpCommand cmd) throws GtpError {
        cmd.checkArgNone();
        this.undo();
    }

    private void play(GoColor color, GoPoint point) throws GtpError {
        if (this.m_gtp != null) {
            String command = this.m_gtp.getCommandPlay(Move.get(color, point));
            this.send(command);
        }
        this.m_move = Move.get(color, point);
        GuiUtil.invokeAndWait(new Runnable(){

            public void run() {
                Display.this.m_board.play(Display.this.m_move);
                Display.this.updateFromGoBoard();
            }
        });
    }

    private void registerCommands() {
        if (this.m_gtp != null) {
            GtpCallback forwardCallback = new GtpCallback(){

                public void run(GtpCommand cmd) throws GtpError {
                    Display.this.cmdForward(cmd);
                }
            };
            ArrayList<String> commands = this.m_gtp.getSupportedCommands();
            for (String c : commands) {
                if (GtpUtil.isStateChangingCommand(c) || c.equals("help") || c.equals("known_command") || c.equals("komi") || c.equals("list_commands") || c.equals("protocol_version")) continue;
                this.register(c, forwardCallback);
            }
        }
        this.register("boardsize", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Display.this.cmdBoardsize(cmd);
            }
        });
        this.register("clear_board", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Display.this.cmdClearBoard(cmd);
            }
        });
        this.register("genmove", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Display.this.cmdGenmove(cmd);
            }
        });
        this.register("komi", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Display.this.cmdKomi(cmd);
            }
        });
        this.register("name", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Display.this.cmdName(cmd);
            }
        });
        this.register("place_free_handicap", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Display.this.cmdPlaceFreeHandicap(cmd);
            }
        });
        this.register("play", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Display.this.cmdPlay(cmd);
            }
        });
        this.register("quit", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Display.this.cmdQuit(cmd);
            }
        });
        this.register("set_free_handicap", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Display.this.cmdSetFreeHandicap(cmd);
            }
        });
        this.register("undo", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Display.this.cmdUndo(cmd);
            }
        });
        this.register("version", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Display.this.cmdVersion(cmd);
            }
        });
    }

    private void send(String cmd, StringBuilder response) throws GtpError {
        response.append(this.m_gtp.send(cmd));
    }

    private void send(String cmd) throws GtpError {
        this.m_gtp.send(cmd);
    }

    private void showStatus(final String text) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (Display.this.m_frame != null) {
                    Display.this.m_statusBar.setText(text);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            GuiUtil.invokeAndWait(runnable);
        }
    }

    private void undo() throws GtpError {
        if (this.m_gtp != null) {
            this.send("undo");
        }
        GuiUtil.invokeAndWait(new Runnable(){

            public void run() {
                Display.this.m_board.undo();
                Display.this.updateFromGoBoard();
            }
        });
    }

    private void updateFromGoBoard() {
        this.m_guiBoard.clearAll();
        GuiBoardUtil.updateFromGoBoard(this.m_guiBoard, this.m_board, true, false);
        this.m_statusBar.clear();
        this.m_statusBar.setToPlay(this.m_board.getToMove());
    }
}

