/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtil {
    public static String getExtension(File file) {
        String ext = null;
        String s = file.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1);
        }
        return ext;
    }

    public static String getRelativeURI(File fromFile, File toFile) {
        int j;
        assert (!fromFile.exists() || !fromFile.isDirectory());
        fromFile = fromFile.getAbsoluteFile().getParentFile();
        assert (fromFile != null);
        ArrayList<String> fromList = FileUtil.splitFile(fromFile);
        ArrayList<String> toList = FileUtil.splitFile(toFile);
        int fromSize = fromList.size();
        int toSize = toList.size();
        for (int i = 0; i < fromSize && i < toSize && fromList.get(i).equals(toList.get(i)); ++i) {
        }
        StringBuilder result = new StringBuilder();
        for (j = i; j < fromSize; ++j) {
            result.append("../");
        }
        for (j = i; j < toSize; ++j) {
            result.append(toList.get(j));
            if (j >= toSize - 1) continue;
            result.append('/');
        }
        return result.toString();
    }

    public static URI getURI(File file) {
        try {
            return new URI("file", "", file.toURI().getPath(), null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static boolean hasExtension(File f, String extension) {
        String ext = FileUtil.getExtension(f);
        if (ext == null) {
            return false;
        }
        return ext.equalsIgnoreCase(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> readStringListFromFile(File file) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        FileReader reader = new FileReader(file);
        BufferedReader in = new BufferedReader(reader);
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                result.add(line);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            in.close();
        }
    }

    public static String removeExtension(File file, String oldExtension) {
        String name = file.toString();
        if (FileUtil.hasExtension(file, oldExtension)) {
            int index = name.lastIndexOf(46);
            assert (index >= 0);
            return name.substring(0, index);
        }
        return name;
    }

    public static String replaceExtension(File file, String oldExtension, String newExtension) {
        String name = file.toString();
        if (FileUtil.hasExtension(file, oldExtension)) {
            int index = name.lastIndexOf(46);
            assert (index >= 0);
            return name.substring(0, index) + "." + newExtension;
        }
        return name + "." + newExtension;
    }

    public static String replaceExtension(String file, String oldExtension, String newExtension) {
        return FileUtil.replaceExtension(new File(file), oldExtension, newExtension);
    }

    private FileUtil() {
    }

    private static ArrayList<String> splitFile(File file) {
        ArrayList<String> list = new ArrayList<String>();
        file = file.getAbsoluteFile();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (file != null) {
            list.add(0, file.getName());
            file = file.getParentFile();
        }
        return list;
    }
}

