/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import net.sf.gogui.util.ErrorMessage;
import net.sf.gogui.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options {
    private final ArrayList<String> m_args = new ArrayList();
    private final Map<String, String> m_map = new TreeMap<String, String>();

    public Options(String[] args, String[] specs) throws ErrorMessage {
        for (String spec : specs) {
            if (spec.length() <= 0) continue;
            this.m_map.put(spec, null);
        }
        this.parseArgs(args);
    }

    public boolean contains(String option) {
        String value = this.get(option, null);
        return value != null;
    }

    public String get(String option) {
        return this.get(option, "");
    }

    public String get(String option, String defaultValue) {
        assert (this.isValidOption(option));
        String value = this.getValue(option);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public ArrayList<String> getArguments() {
        return this.m_args;
    }

    public void checkNoArguments() throws ErrorMessage {
        if (!this.m_args.isEmpty()) {
            throw new ErrorMessage("Command does not allow arguments that are not options");
        }
    }

    public double getDouble(String option) throws ErrorMessage {
        return this.getDouble(option, 0.0);
    }

    public double getDouble(String option, double defaultValue) throws ErrorMessage {
        String value = this.get(option, Double.toString(defaultValue));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new ErrorMessage("Option -" + option + " needs float value");
        }
    }

    public int getInteger(String option) throws ErrorMessage {
        return this.getInteger(option, 0);
    }

    public int getInteger(String option, int defaultValue) throws ErrorMessage {
        String value = this.get(option, Integer.toString(defaultValue));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ErrorMessage("Option -" + option + " needs integer value");
        }
    }

    public int getInteger(String option, int defaultValue, int min) throws ErrorMessage {
        int value = this.getInteger(option, defaultValue);
        if (value < min) {
            throw new ErrorMessage("Option -" + option + " must be greater than " + min);
        }
        return value;
    }

    public int getInteger(String option, int defaultValue, int min, int max) throws ErrorMessage {
        int value = this.getInteger(option, defaultValue);
        if (value < min || value > max) {
            throw new ErrorMessage("Option -" + option + " must be in [" + min + ".." + max + "]");
        }
        return value;
    }

    public long getLong(String option) throws ErrorMessage {
        return this.getLong(option, 0L);
    }

    public long getLong(String option, long defaultValue) throws ErrorMessage {
        String value = this.get(option, Long.toString(defaultValue));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new ErrorMessage("Option -" + option + " needs long integer value");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConfigOption() throws ErrorMessage {
        FileInputStream inputStream;
        if (!this.contains("config")) {
            return;
        }
        String filename = this.get("config");
        try {
            inputStream = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            throw new ErrorMessage("File not found: " + filename);
        }
        InputStreamReader reader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line;
            StringBuilder buffer = new StringBuilder(256);
            while ((line = bufferedReader.readLine()) != null) {
                buffer.append(line);
                buffer.append(' ');
            }
            this.parseArgs(StringUtil.splitArguments(buffer.toString()));
        }
        catch (IOException e) {
            StringUtil.printException(e);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                StringUtil.printException(e);
            }
        }
    }

    public static Options parse(String[] args, String[] specs) throws ErrorMessage {
        Options opt = new Options(args, specs);
        opt.handleConfigOption();
        return opt;
    }

    private String getSpec(String option) throws ErrorMessage {
        if (this.m_map.containsKey(option)) {
            return option;
        }
        if (this.m_map.containsKey(option + ":")) {
            return option + ":";
        }
        throw new ErrorMessage("Unknown option -" + option);
    }

    private String getValue(String option) {
        assert (this.isValidOption(option));
        if (this.m_map.containsKey(option)) {
            return this.m_map.get(option);
        }
        return this.m_map.get(option + ":");
    }

    private boolean isOptionKey(String s) {
        return s.length() > 0 && s.charAt(0) == '-';
    }

    private boolean isValidOption(String option) {
        return this.m_map.containsKey(option) || this.m_map.containsKey(option + ":");
    }

    private boolean needsValue(String spec) {
        return spec.length() > 0 && spec.substring(spec.length() - 1).equals(":");
    }

    private void parseArgs(String[] args) throws ErrorMessage {
        boolean stopParse = false;
        int n = 0;
        while (n < args.length) {
            String s = args[n];
            ++n;
            if (s.equals("--")) {
                stopParse = true;
                continue;
            }
            if (this.isOptionKey(s) && !stopParse) {
                String spec = this.getSpec(s.substring(1));
                if (this.needsValue(spec)) {
                    if (n >= args.length) {
                        throw new ErrorMessage("Option " + s + " needs value");
                    }
                    String value = args[n];
                    ++n;
                    this.m_map.put(spec, value);
                    continue;
                }
                this.m_map.put(spec, "1");
                continue;
            }
            this.m_args.add(s);
        }
    }
}

