/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.adapter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Locale;
import net.sf.gogui.game.BoardUpdater;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.gamefile.GameReader;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.BoardUtil;
import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.InvalidKomiException;
import net.sf.gogui.go.Komi;
import net.sf.gogui.go.Move;
import net.sf.gogui.go.PointList;
import net.sf.gogui.gtp.GtpCallback;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpClientBase;
import net.sf.gogui.gtp.GtpCommand;
import net.sf.gogui.gtp.GtpEngine;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpResponseFormatError;
import net.sf.gogui.gtp.GtpSynchronizer;
import net.sf.gogui.gtp.GtpUtil;
import net.sf.gogui.util.ErrorMessage;

public class Adapter
extends GtpEngine {
    private Board m_board;
    private final GtpCallback m_callbackForward = new GtpCallback(){

        public void run(GtpCommand cmd) throws GtpError {
            Adapter.this.cmdForward(cmd);
        }
    };
    private final GtpClientBase m_gtp;
    private final GtpSynchronizer m_synchronizer;
    private Komi m_komi;
    private TimeSettings m_timeSettings;

    public Adapter(String program, PrintStream log, String gtpFile, boolean verbose, boolean noScore, boolean version1, boolean fillPasses, boolean lowerCase, int size) throws Exception {
        super(log);
        if (program.equals("")) {
            throw new Exception("No program is set.");
        }
        this.m_gtp = new GtpClient(program, null, verbose, null);
        if (lowerCase) {
            this.m_gtp.setLowerCase();
        }
        this.m_synchronizer = new GtpSynchronizer(this.m_gtp, null, fillPasses);
        if (gtpFile != null) {
            this.sendGtpFile(gtpFile);
        }
        this.init(noScore, version1, size);
    }

    public Adapter(GtpClientBase gtp, PrintStream log, boolean noScore, boolean version1, boolean lowerCase, int size) throws GtpError {
        super(log);
        this.m_gtp = gtp;
        if (lowerCase) {
            this.m_gtp.setLowerCase();
        }
        this.m_synchronizer = new GtpSynchronizer(this.m_gtp, null, false);
        this.init(noScore, version1, size);
    }

    public void close() {
        this.m_gtp.close();
        this.m_gtp.waitForExit();
    }

    public void cmdBlack(GtpCommand cmd) throws GtpError {
        cmd.checkNuArg(1);
        this.play(GoColor.BLACK, this.getPointArg(cmd, 0));
    }

    public void cmdBoardsize(GtpCommand cmd) throws GtpError {
        cmd.checkNuArg(1);
        int size = cmd.getIntArg(0, 1, 25);
        this.m_board.init(size);
        this.synchronize();
    }

    public void cmdClearBoard(GtpCommand cmd) throws GtpError {
        cmd.checkArgNone();
        this.m_board.init(this.m_board.getSize());
        this.synchronize();
    }

    public void cmdForward(GtpCommand cmd) throws GtpError {
        this.send(cmd.getLine(), cmd.getResponse());
    }

    public void cmdGenmove(GtpCommand cmd) throws GtpError {
        GoColor c = cmd.getColorArg();
        this.cmdGenmove(c, cmd, this.m_gtp.getCommandGenmove(c));
    }

    public void cmdGenmoveCleanup(GtpCommand cmd) throws GtpError {
        GoColor c = cmd.getColorArg();
        this.cmdGenmove(c, cmd, "kgs-genmove_cleanup " + c.getUppercaseLetter());
    }

    public void cmdGenmoveBlack(GtpCommand cmd) throws GtpError {
        this.cmdGenmove(GoColor.BLACK, cmd, this.m_gtp.getCommandGenmove(GoColor.BLACK));
    }

    public void cmdGenmoveWhite(GtpCommand cmd) throws GtpError {
        this.cmdGenmove(GoColor.WHITE, cmd, this.m_gtp.getCommandGenmove(GoColor.WHITE));
    }

    public void cmdGGUndo(GtpCommand cmd) throws GtpError {
        cmd.checkNuArgLessEqual(1);
        int n = 1;
        if (cmd.getNuArg() == 1) {
            n = cmd.getIntArg(0, 1, this.m_board.getNumberMoves());
        }
        this.m_board.undo(n);
        this.synchronize();
    }

    public void cmdGoGuiAnalyzeCommands(GtpCommand cmd) throws GtpError {
        cmd.checkArgNone();
        String response = "string/Adapter ShowBoard/gogui-adapter-showboard\n";
        String command = null;
        if (this.m_gtp.isSupported("gogui-analyze_commands")) {
            command = "gogui-analyze_commands";
        } else if (this.m_gtp.isSupported("gogui_analyze_commands")) {
            command = "gogui_analyze_commands";
        }
        if (command != null) {
            response = response + this.send(command);
        }
        cmd.setResponse(response);
    }

    public void cmdAdapterShowBoard(GtpCommand cmd) throws GtpError {
        cmd.getResponse().append("\n");
        cmd.getResponse().append(BoardUtil.toString(this.m_board, true, false));
    }

    public void cmdKomi(GtpCommand cmd) throws GtpError {
        try {
            this.m_komi = Komi.parseKomi(cmd.getArg());
            this.synchronize();
        }
        catch (InvalidKomiException e) {
            throw new GtpError("invalid komi");
        }
    }

    public void cmdLoad(GtpCommand cmd) throws GtpError {
        cmd.checkNuArgLessEqual(2);
        File file = new File(cmd.getArg(0));
        int moveNumber = -1;
        if (cmd.getNuArg() == 2) {
            moveNumber = cmd.getIntArg(1);
        }
        try {
            GameReader reader = new GameReader(file);
            GameTree tree = reader.getTree();
            ConstNode node = tree.getRoot();
            int n = 0;
            while (true) {
                ConstNode child;
                if (node.getMove() != null) {
                    ++n;
                }
                if (moveNumber >= 0 && n == moveNumber - 1 || (child = node.getChildConst()) == null) break;
                node = child;
            }
            if (moveNumber >= 0 && n < moveNumber - 1) {
                throw new GtpError("invalid move number");
            }
            BoardUpdater boardUpdater = new BoardUpdater();
            boardUpdater.update(tree, node, this.m_board);
            this.m_komi = tree.getGameInfoConst(node).getKomi();
        }
        catch (ErrorMessage e) {
            throw new GtpError(e.getMessage());
        }
        this.synchronize();
    }

    public void cmdPlaceFreeHandicap(GtpCommand cmd) throws GtpError {
        ConstPointList stones;
        if (this.m_gtp.isSupported("place_free_handicap")) {
            String response = this.send(cmd.getLine());
            try {
                stones = GtpUtil.parsePointList(response, this.m_board.getSize());
            }
            catch (GtpResponseFormatError e) {
                throw new GtpError(e.getMessage());
            }
        } else {
            int n = cmd.getIntArg();
            stones = Board.getHandicapStones(this.m_board.getSize(), n);
            if (stones == null) {
                throw new GtpError("Invalid number of handicap stones");
            }
        }
        StringBuilder response = new StringBuilder(128);
        PointList points = new PointList();
        for (GoPoint p : stones) {
            points.add(p);
            if (response.length() > 0) {
                response.append(' ');
            }
            response.append(p);
        }
        this.m_board.setup(points, null, null);
        cmd.setResponse(response.toString());
        this.synchronize();
    }

    public void cmdPlay(GtpCommand cmd) throws GtpError {
        cmd.checkNuArg(2);
        GoColor color = cmd.getColorArg(0);
        GoPoint point = this.getPointArg(cmd, 1);
        if (point != null && this.m_board.getColor(point) != GoColor.EMPTY) {
            throw new GtpError("point is occupied");
        }
        this.play(color, point);
    }

    public void cmdProtocolVersion1(GtpCommand cmd) throws GtpError {
        cmd.checkArgNone();
        cmd.setResponse("1");
    }

    public void cmdQuit(GtpCommand cmd) throws GtpError {
        this.send("quit");
        super.cmdQuit(cmd);
    }

    public void cmdSetFreeHandicap(GtpCommand cmd) throws GtpError {
        PointList points = new PointList();
        for (int i = 0; i < cmd.getNuArg(); ++i) {
            points.add(this.getPointArg(cmd, i));
        }
        this.m_board.setup(points, null, null);
        this.synchronize();
    }

    public void cmdTimeSettings(GtpCommand cmd) throws GtpError {
        cmd.checkNuArg(3);
        long mainTime = (long)cmd.getIntArg(0, 0, Integer.MAX_VALUE) * 1000L;
        long byoyomiTime = (long)cmd.getIntArg(0, 0, Integer.MAX_VALUE) * 1000L;
        int byoyomiStones = cmd.getIntArg(0, 0, Integer.MAX_VALUE);
        this.m_timeSettings = byoyomiTime == 0L ? new TimeSettings(mainTime) : (byoyomiStones == 0 ? null : new TimeSettings(mainTime, byoyomiTime, byoyomiStones));
    }

    public void cmdUndo(GtpCommand cmd) throws GtpError {
        cmd.checkArgNone();
        this.m_board.undo();
        this.synchronize();
    }

    public void cmdWhite(GtpCommand cmd) throws GtpError {
        cmd.checkNuArg(1);
        this.play(GoColor.WHITE, this.getPointArg(cmd, 0));
    }

    public void interruptCommand() {
        try {
            if (this.m_gtp.isInterruptSupported()) {
                this.m_gtp.sendInterrupt();
            }
        }
        catch (GtpError e) {
            System.err.println(e);
        }
    }

    public void setName(String name) {
        if (name == null) {
            this.register("name", this.m_callbackForward);
            this.register("version", this.m_callbackForward);
            return;
        }
        int index = name.indexOf(58);
        if (index < 0) {
            super.setName(name);
            super.setVersion("");
        } else {
            super.setName(name.substring(0, index));
            super.setVersion(name.substring(index + 1));
        }
        this.register("name", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Adapter.this.cmdName(cmd);
            }
        });
        this.register("version", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Adapter.this.cmdVersion(cmd);
            }
        });
    }

    private void cmdGenmove(GoColor color, GtpCommand cmd, String command) throws GtpError {
        String response = this.send(command);
        if (response.toLowerCase(Locale.ENGLISH).trim().equals("resign")) {
            cmd.setResponse("resign");
            return;
        }
        try {
            GoPoint point = GtpUtil.parsePoint(response, this.m_board.getSize());
            this.m_board.play(color, point);
            this.m_synchronizer.updateAfterGenmove(this.m_board);
            cmd.setResponse(response);
        }
        catch (GtpResponseFormatError e) {
            throw new GtpError(e.getMessage());
        }
    }

    private GoPoint getPointArg(GtpCommand cmd, int i) throws GtpError {
        return cmd.getPointArg(i, this.m_board.getSize());
    }

    private void init(boolean noScore, boolean version1, int size) throws GtpError {
        this.m_gtp.queryProtocolVersion();
        this.m_gtp.querySupportedCommands();
        this.m_board = new Board(size);
        this.registerCommands(noScore, version1);
        this.synchronize();
    }

    private void play(GoColor color, GoPoint point) throws GtpError {
        Move move = Move.get(color, point);
        this.m_board.play(move);
        this.synchronize();
    }

    private void registerCommands(boolean noScore, boolean version1) {
        ArrayList<String> commands = this.m_gtp.getSupportedCommands();
        for (int i = 0; i < commands.size(); ++i) {
            String command = commands.get(i);
            if (GtpUtil.isStateChangingCommand(command)) continue;
            this.register(command, this.m_callbackForward);
        }
        if (this.m_gtp.isSupported("kgs-genmove_cleanup")) {
            this.register("kgs-genmove_cleanup", new GtpCallback(){

                public void run(GtpCommand cmd) throws GtpError {
                    Adapter.this.cmdGenmoveCleanup(cmd);
                }
            });
        }
        this.register("boardsize", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Adapter.this.cmdBoardsize(cmd);
            }
        });
        this.register("gogui-analyze_commands", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Adapter.this.cmdGoGuiAnalyzeCommands(cmd);
            }
        });
        this.register("gogui-adapter-showboard", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Adapter.this.cmdAdapterShowBoard(cmd);
            }
        });
        this.register("komi", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Adapter.this.cmdKomi(cmd);
            }
        });
        this.register("loadsgf", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Adapter.this.cmdLoad(cmd);
            }
        });
        this.register("loadxml", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Adapter.this.cmdLoad(cmd);
            }
        });
        this.setName(null);
        this.register("place_free_handicap", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Adapter.this.cmdPlaceFreeHandicap(cmd);
            }
        });
        if (version1) {
            this.register("protocol_version", new GtpCallback(){

                public void run(GtpCommand cmd) throws GtpError {
                    Adapter.this.cmdProtocolVersion1(cmd);
                }
            });
        }
        this.register("set_free_handicap", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Adapter.this.cmdSetFreeHandicap(cmd);
            }
        });
        this.register("time_settings", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Adapter.this.cmdTimeSettings(cmd);
            }
        });
        if (noScore) {
            this.unregister("final_score");
            this.unregister("final_status_list");
        }
        if (version1) {
            this.register("black", new GtpCallback(){

                public void run(GtpCommand cmd) throws GtpError {
                    Adapter.this.cmdBlack(cmd);
                }
            });
            this.register("genmove_black", new GtpCallback(){

                public void run(GtpCommand cmd) throws GtpError {
                    Adapter.this.cmdGenmoveBlack(cmd);
                }
            });
            this.register("genmove_white", new GtpCallback(){

                public void run(GtpCommand cmd) throws GtpError {
                    Adapter.this.cmdGenmoveWhite(cmd);
                }
            });
            this.register("help", new GtpCallback(){

                public void run(GtpCommand cmd) throws GtpError {
                    Adapter.this.cmdListCommands(cmd);
                }
            });
            this.unregister("list_commands");
            this.register("white", new GtpCallback(){

                public void run(GtpCommand cmd) throws GtpError {
                    Adapter.this.cmdWhite(cmd);
                }
            });
        } else {
            this.register("clear_board", new GtpCallback(){

                public void run(GtpCommand cmd) throws GtpError {
                    Adapter.this.cmdClearBoard(cmd);
                }
            });
            this.register("genmove", new GtpCallback(){

                public void run(GtpCommand cmd) throws GtpError {
                    Adapter.this.cmdGenmove(cmd);
                }
            });
            this.unregister("help");
            this.register("known_command", new GtpCallback(){

                public void run(GtpCommand cmd) throws GtpError {
                    Adapter.this.cmdKnownCommand(cmd);
                }
            });
            this.register("list_commands", new GtpCallback(){

                public void run(GtpCommand cmd) throws GtpError {
                    Adapter.this.cmdListCommands(cmd);
                }
            });
            this.register("play", new GtpCallback(){

                public void run(GtpCommand cmd) throws GtpError {
                    Adapter.this.cmdPlay(cmd);
                }
            });
        }
        this.register("undo", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Adapter.this.cmdUndo(cmd);
            }
        });
        this.register("gg-undo", new GtpCallback(){

            public void run(GtpCommand cmd) throws GtpError {
                Adapter.this.cmdGGUndo(cmd);
            }
        });
    }

    private String send(String cmd) throws GtpError {
        return this.m_gtp.send(cmd);
    }

    private void send(String cmd, StringBuilder response) throws GtpError {
        response.append(this.m_gtp.send(cmd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendGtpFile(String filename) {
        try {
            reader = new FileReader(new File(filename));
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found: " + filename);
            return;
        }
        in = new BufferedReader(reader);
        try {
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    if ((line = in.readLine()) == null) {
                        in.close();
                        return;
                    }
                    if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                    try {
                        cmd = new GtpCommand(line);
                        if (GtpUtil.isStateChangingCommand(cmd.getCommand())) {
                            System.err.println("Command " + cmd.getCommand() + " not allowed in GTP file");
                            return;
                        }
                        this.send(line);
                        continue;
                    }
                    catch (GtpError e) {
                        System.err.println("Sending commands aborted:" + e.getMessage());
                        return;
                    }
                    break;
                }
            }
            catch (IOException e) {
                System.err.println("Sending commands aborted:" + e.getMessage());
                return;
            }
            {
                ** while (true)
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException var4_7) {}
        }
    }

    private void synchronize() throws GtpError {
        this.m_synchronizer.synchronize(this.m_board, this.m_komi, this.m_timeSettings);
    }
}

