/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.go;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.gogui.go.BlackWhiteSet;
import net.sf.gogui.go.BoardConstants;
import net.sf.gogui.go.ConstBoard;
import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Marker;
import net.sf.gogui.go.Move;
import net.sf.gogui.go.PointList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Board
implements ConstBoard {
    private Marker m_mark;
    private int m_size;
    private final BlackWhiteSet<Integer> m_captured = new BlackWhiteSet<Integer>(0, 0);
    private final ArrayList<StackEntry> m_stack = new ArrayList(361);
    private final PointList m_checkKillStones = new PointList();
    private final PointList m_checkKillStack = new PointList();
    private GoColor[] m_color = new GoColor[625];
    private GoColor m_toMove;
    private GoColor m_setupPlayer;
    private BoardConstants m_constants;
    private GoPoint m_koPoint;
    private final BlackWhiteSet<PointList> m_setup = new BlackWhiteSet<PointList>(new PointList(), new PointList());
    private boolean m_isSetupHandicap;

    public Board(int boardSize) {
        this.init(boardSize);
    }

    @Override
    public boolean bothPassed() {
        int n = this.getNumberMoves();
        return n >= 2 && this.m_stack.get((int)(n - 1)).m_move.getPoint() == null && this.m_stack.get((int)(n - 2)).m_move.getPoint() == null;
    }

    @Override
    public boolean contains(GoPoint point) {
        return point.isOnBoard(this.getSize());
    }

    @Override
    public ConstPointList getAdjacent(GoPoint point) {
        return this.m_constants.getAdjacent(point);
    }

    @Override
    public int getCaptured(GoColor c) {
        return this.m_captured.get(c);
    }

    @Override
    public GoColor getColor(GoPoint p) {
        return this.m_color[p.getIndex()];
    }

    public static ConstPointList getHandicapStones(int size, int n) {
        return BoardConstants.get(size).getHandicapStones(n);
    }

    @Override
    public ConstPointList getKilled() {
        int n = this.getNumberMoves();
        assert (n > 0);
        return this.m_stack.get((int)(n - 1)).m_killed;
    }

    @Override
    public Move getLastMove() {
        int n = this.getNumberMoves();
        if (n == 0) {
            return null;
        }
        return this.m_stack.get((int)(n - 1)).m_move;
    }

    @Override
    public int getNumberMoves() {
        return this.m_stack.size();
    }

    @Override
    public Move getMove(int i) {
        return this.m_stack.get((int)i).m_move;
    }

    @Override
    public ConstPointList getSetup(GoColor c) {
        return this.m_setup.get(c);
    }

    @Override
    public GoColor getSetupPlayer() {
        return this.m_setupPlayer;
    }

    @Override
    public int getSize() {
        return this.m_size;
    }

    @Override
    public void getStones(GoPoint p, GoColor color, PointList stones) {
        assert (this.m_mark.isCleared());
        this.findStones(p, color, stones);
        this.m_mark.clear(stones);
    }

    @Override
    public ConstPointList getSuicide() {
        int n = this.getNumberMoves();
        assert (n > 0);
        return this.m_stack.get((int)(n - 1)).m_suicide;
    }

    @Override
    public GoColor getToMove() {
        return this.m_toMove;
    }

    public void init(int size) {
        this.m_size = size;
        this.m_mark = new Marker(this.m_size);
        this.m_constants = BoardConstants.get(size);
        this.clear();
    }

    @Override
    public boolean isCaptureOrSuicide(GoColor c, GoPoint p) {
        if (this.getColor(p) != GoColor.EMPTY) {
            return false;
        }
        this.play(c, p);
        boolean result = this.getKilled().size() > 0 || this.getSuicide().size() > 0;
        this.undo();
        return result;
    }

    @Override
    public boolean isHandicap(GoPoint point) {
        return this.m_constants.isHandicap(point);
    }

    @Override
    public boolean isKo(GoPoint point) {
        return point == this.m_koPoint;
    }

    @Override
    public boolean isModified() {
        return !this.m_stack.isEmpty() || this.m_setup.get(GoColor.BLACK).size() > 0 || this.m_setup.get(GoColor.WHITE).size() > 0 || this.m_toMove != GoColor.BLACK;
    }

    @Override
    public boolean isSetupHandicap() {
        return this.m_isSetupHandicap;
    }

    @Override
    public boolean isSuicide(GoColor c, GoPoint p) {
        if (this.getColor(p) != GoColor.EMPTY) {
            return false;
        }
        this.play(c, p);
        boolean result = this.getSuicide().size() > 0;
        this.undo();
        return result;
    }

    @Override
    public Iterator<GoPoint> iterator() {
        return new BoardIterator();
    }

    public void clear() {
        for (GoPoint p : this) {
            this.setColor(p, GoColor.EMPTY);
        }
        this.m_stack.clear();
        for (GoColor c : GoColor.BLACK_WHITE) {
            this.m_setup.get(c).clear();
            this.m_captured.set(c, 0);
        }
        this.m_toMove = GoColor.BLACK;
        this.m_koPoint = null;
        this.m_isSetupHandicap = false;
        this.m_setupPlayer = null;
    }

    public void play(GoColor color, GoPoint point) {
        this.play(Move.get(color, point));
    }

    public void play(Move move) {
        StackEntry entry = new StackEntry(move);
        entry.execute(this);
        this.m_stack.add(entry);
    }

    public void setToMove(GoColor toMove) {
        this.m_toMove = toMove;
    }

    public void setup(ConstPointList black, ConstPointList white, GoColor player) {
        this.clear();
        this.m_koPoint = null;
        this.m_setupPlayer = player;
        if (this.m_setupPlayer != null) {
            this.m_toMove = player;
        }
        for (GoColor c : GoColor.BLACK_WHITE) {
            ConstPointList stones;
            ConstPointList constPointList = stones = c == GoColor.BLACK ? black : white;
            if (stones == null) {
                this.m_setup.set(c, new PointList());
                continue;
            }
            for (GoPoint p : stones) {
                this.setColor(p, c);
            }
            this.m_setup.set(c, new PointList(stones));
        }
    }

    public void setupHandicap(ConstPointList points) {
        this.setup(points, null, GoColor.WHITE);
        this.m_isSetupHandicap = true;
    }

    public void undo() {
        int index = this.getNumberMoves() - 1;
        assert (index >= 0);
        this.m_stack.get(index).undo(this);
        this.m_stack.remove(index);
    }

    public void undo(int n) {
        assert (n >= 0);
        assert (n <= this.getNumberMoves());
        for (int i = 0; i < n; ++i) {
            this.undo();
        }
    }

    private boolean isSingleStoneSingleLib(GoPoint point, GoColor color) {
        if (this.getColor(point) != color) {
            return false;
        }
        int lib = 0;
        for (GoPoint adj : this.getAdjacent(point)) {
            GoColor adjColor = this.getColor(adj);
            if (!(adjColor == GoColor.EMPTY ? ++lib > 1 : adjColor.equals((Object)color))) continue;
            return false;
        }
        return true;
    }

    private void checkKill(GoPoint point, PointList killed) {
        assert (this.m_mark.isCleared());
        GoColor color = this.getColor(point);
        assert (color != GoColor.EMPTY);
        this.m_checkKillStack.clear();
        this.m_checkKillStack.add(point);
        this.m_mark.set(point);
        this.m_checkKillStones.clear();
        boolean isDead = true;
        block0: while (isDead && !this.m_checkKillStack.isEmpty()) {
            GoPoint p = this.m_checkKillStack.pop();
            assert (this.getColor(p) == color);
            this.m_checkKillStones.add(p);
            ConstPointList adjacent = this.getAdjacent(p);
            int nuAdjacent = adjacent.size();
            for (int i = 0; i < nuAdjacent; ++i) {
                GoPoint adj = adjacent.get(i);
                GoColor c = this.getColor(adj);
                if (c == GoColor.EMPTY) {
                    isDead = false;
                    continue block0;
                }
                if (this.m_mark.get(adj) || !c.equals((Object)color)) continue;
                this.m_checkKillStack.add(adj);
                this.m_mark.set(adj);
            }
        }
        if (isDead) {
            killed.addAll(this.m_checkKillStones);
            int nuKillStones = this.m_checkKillStones.size();
            for (int i = 0; i < nuKillStones; ++i) {
                this.setColor((GoPoint)this.m_checkKillStones.get(i), GoColor.EMPTY);
            }
        }
        this.m_mark.clear(this.m_checkKillStack);
        this.m_mark.clear(this.m_checkKillStones);
    }

    private void findStones(GoPoint p, GoColor color, PointList stones) {
        if (this.getColor(p) != color) {
            return;
        }
        if (this.m_mark.get(p)) {
            return;
        }
        this.m_mark.set(p);
        stones.add(p);
        for (GoPoint adj : this.getAdjacent(p)) {
            this.findStones(adj, color, stones);
        }
    }

    private void setColor(GoPoint p, GoColor c) {
        assert (p != null);
        this.m_color[p.getIndex()] = c;
    }

    private static class StackEntry {
        public final Move m_move;
        public GoPoint m_oldKoPoint;
        public GoColor m_oldColor;
        public GoColor m_oldToMove;
        public PointList m_killed;
        public PointList m_suicide;

        public StackEntry(Move move) {
            this.m_move = move;
        }

        public void execute(Board board) {
            GoPoint p = this.m_move.getPoint();
            GoColor c = this.m_move.getColor();
            GoColor otherColor = c.otherColor();
            this.m_killed = new PointList();
            this.m_suicide = new PointList();
            this.m_oldKoPoint = board.m_koPoint;
            board.m_koPoint = null;
            if (p != null) {
                this.m_oldColor = board.getColor(p);
                board.setColor(p, c);
                assert (c != GoColor.EMPTY);
                for (GoPoint adj : board.getAdjacent(p)) {
                    int killedSize = this.m_killed.size();
                    if (board.getColor(adj) == otherColor) {
                        board.checkKill(adj, this.m_killed);
                    }
                    if (this.m_killed.size() != killedSize + 1) continue;
                    board.m_koPoint = (GoPoint)this.m_killed.get(killedSize);
                }
                board.checkKill(p, this.m_suicide);
                if (board.m_koPoint != null && !board.isSingleStoneSingleLib(p, c)) {
                    board.m_koPoint = null;
                }
                board.m_captured.set(c, (Integer)board.m_captured.get(c) + this.m_suicide.size());
                board.m_captured.set(otherColor, (Integer)board.m_captured.get(otherColor) + this.m_killed.size());
            }
            this.m_oldToMove = board.m_toMove;
            board.m_toMove = otherColor;
        }

        protected void undo(Board board) {
            GoPoint p = this.m_move.getPoint();
            if (p != null) {
                GoColor c = this.m_move.getColor();
                GoColor otherColor = c.otherColor();
                for (GoPoint stone : this.m_suicide) {
                    board.setColor(stone, c);
                }
                board.setColor(p, this.m_oldColor);
                for (GoPoint stone : this.m_killed) {
                    board.setColor(stone, otherColor);
                }
                board.m_captured.set(c, (Integer)board.m_captured.get(c) - this.m_suicide.size());
                board.m_captured.set(otherColor, (Integer)board.m_captured.get(otherColor) - this.m_killed.size());
            }
            board.m_toMove = this.m_oldToMove;
            board.m_koPoint = this.m_oldKoPoint;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BoardIterator
    implements Iterator<GoPoint> {
        private final Iterator<GoPoint> m_iterator;

        public BoardIterator() {
            this.m_iterator = Board.this.m_constants.getPoints().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        @Override
        public GoPoint next() {
            return this.m_iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

