/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.tools.twogtp;

import java.util.ArrayList;
import net.sf.gogui.game.ConstGameTree;
import net.sf.gogui.game.ConstNode;
import net.sf.gogui.game.Game;
import net.sf.gogui.game.NodeUtil;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.BlackWhiteSet;
import net.sf.gogui.go.ConstBoard;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.InvalidKomiException;
import net.sf.gogui.go.Komi;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpCommand;
import net.sf.gogui.gtp.GtpEngine;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpResponseFormatError;
import net.sf.gogui.gtp.GtpUtil;
import net.sf.gogui.tools.twogtp.Compare;
import net.sf.gogui.tools.twogtp.Openings;
import net.sf.gogui.tools.twogtp.Program;
import net.sf.gogui.tools.twogtp.ResultFile;
import net.sf.gogui.util.ErrorMessage;
import net.sf.gogui.util.ObjectUtil;
import net.sf.gogui.util.Platform;
import net.sf.gogui.util.StringUtil;
import net.sf.gogui.version.Version;

public class TwoGtp
extends GtpEngine {
    private final boolean m_alternate;
    private boolean m_gameSaved;
    private boolean m_debugToComment;
    private int m_maxMoves = 1000;
    private int m_gameIndex;
    private boolean m_resigned;
    private final boolean m_verbose;
    private final int m_numberGames;
    private final int m_size;
    private final Komi m_komi;
    private Game m_game;
    private GoColor m_resignColor;
    private final Openings m_openings;
    private final Program m_black;
    private final Program m_white;
    private final Program m_referee;
    private final Program m_observer;
    private final ArrayList<Program> m_allPrograms;
    private final BlackWhiteSet<Double> m_realTime = new BlackWhiteSet<Double>(0.0, 0.0);
    private String m_openingFile;
    private final String m_filePrefix;
    private final ArrayList<ArrayList<Compare.Placement>> m_games = new ArrayList(100);
    private ResultFile m_resultFile;
    private final TimeSettings m_timeSettings;
    private ConstNode m_lastOpeningNode;
    private BlackWhiteSet<StringBuilder> m_debugToCommentBuffer = new BlackWhiteSet<StringBuilder>(new StringBuilder(), new StringBuilder());

    public TwoGtp(Program black, Program white, Program referee, String observer, int size, Komi komi, int numberGames, boolean alternate, String filePrefix, boolean verbose, Openings openings, TimeSettings timeSettings, ResultFile resultFile) throws Exception {
        super(null);
        assert (size > 0);
        assert (size <= 25);
        assert (komi != null);
        this.m_filePrefix = filePrefix;
        this.m_allPrograms = new ArrayList();
        this.m_black = black;
        this.m_allPrograms.add(this.m_black);
        this.m_white = white;
        this.m_allPrograms.add(this.m_white);
        this.m_referee = referee;
        if (this.m_referee != null) {
            this.m_allPrograms.add(this.m_referee);
        }
        if (observer.equals("")) {
            this.m_observer = null;
        } else {
            this.m_observer = new Program(observer, "Observer", "O", verbose);
            this.m_allPrograms.add(this.m_observer);
        }
        for (Program program : this.m_allPrograms) {
            program.setLabel(this.m_allPrograms);
        }
        this.m_size = size;
        this.m_komi = komi;
        this.m_alternate = alternate;
        this.m_numberGames = numberGames;
        this.m_openings = openings;
        this.m_verbose = verbose;
        this.m_timeSettings = timeSettings;
        this.m_resultFile = resultFile;
        this.initGame(size);
    }

    public void autoPlay() throws Exception {
        StringBuilder response = new StringBuilder(256);
        while (true) {
            try {
                block3: while (true) {
                    this.newGame(this.m_size);
                    while (true) {
                        if (this.gameOver()) continue block3;
                        response.setLength(0);
                        this.sendGenmove(this.getToMove(), response);
                    }
                    break;
                }
            }
            catch (GtpError e) {
                if (this.m_gameIndex != -1) {
                    this.handleEndOfGame(true, e.getMessage());
                    continue;
                }
                if (this.m_black.isProgramDead()) {
                    throw new ErrorMessage("Black program died");
                }
                if (this.m_white.isProgramDead()) {
                    throw new ErrorMessage("White program died");
                }
                return;
            }
            break;
        }
    }

    public void close() {
        for (Program program : this.m_allPrograms) {
            program.close();
        }
    }

    public void handleCommand(GtpCommand cmd) throws GtpError {
        String command = cmd.getCommand();
        if (command.equals("boardsize")) {
            this.cmdBoardSize(cmd);
        } else if (command.equals("clear_board")) {
            this.cmdClearBoard(cmd);
        } else if (command.equals("final_score")) {
            this.finalStatusCommand(cmd);
        } else if (command.equals("final_status")) {
            this.finalStatusCommand(cmd);
        } else if (command.equals("final_status_list")) {
            this.finalStatusCommand(cmd);
        } else if (!command.equals("gogui-interrupt")) {
            if (command.equals("gogui-title")) {
                cmd.setResponse(this.getTitle());
            } else if (command.equals("gogui-twogtp-black")) {
                this.twogtpColor(this.m_black, cmd);
            } else if (command.equals("gogui-twogtp-white")) {
                this.twogtpColor(this.m_white, cmd);
            } else if (command.equals("gogui-twogtp-referee")) {
                this.twogtpReferee(cmd);
            } else if (command.equals("gogui-twogtp-observer")) {
                this.twogtpObserver(cmd);
            } else if (command.equals("quit")) {
                this.close();
                this.setQuit();
            } else if (command.equals("play")) {
                this.cmdPlay(cmd);
            } else if (command.equals("undo")) {
                this.cmdUndo(cmd);
            } else if (command.equals("genmove")) {
                this.cmdGenmove(cmd);
            } else if (command.equals("komi")) {
                this.komi(cmd);
            } else if (command.equals("scoring_system")) {
                this.sendIfSupported(command, cmd.getLine());
            } else if (command.equals("name")) {
                cmd.setResponse("gogui-twogtp");
            } else if (command.equals("version")) {
                cmd.setResponse(Version.get());
            } else if (command.equals("protocol_version")) {
                cmd.setResponse("2");
            } else if (command.equals("list_commands")) {
                cmd.setResponse("boardsize\nclear_board\nfinal_score\nfinal_status\nfinal_status_list\ngenmove\ngogui-interrupt\ngogui-title\nkomi\nlist_commands\nname\nplay\nquit\nscoring_system\ntime_settings\ngogui-twogtp-black\ngogui-twogtp-observer\ngogui-twogtp-referee\ngogui-twogtp-white\nundo\nversion\n");
            } else {
                if (GtpUtil.isStateChangingCommand(command)) {
                    throw new GtpError("unknown command");
                }
                if (command.equals("time_settings")) {
                    this.sendIfSupported(command, cmd.getLine());
                } else {
                    boolean isExtCommandBlack = this.m_black.isSupported(command);
                    boolean isExtCommandWhite = this.m_white.isSupported(command);
                    boolean isExtCommandReferee = false;
                    if (this.m_referee != null) {
                        isExtCommandReferee = this.m_referee.isSupported(command);
                    }
                    boolean isExtCommandObserver = false;
                    if (this.m_observer != null) {
                        isExtCommandObserver = this.m_observer.isSupported(command);
                    }
                    if (isExtCommandBlack && !isExtCommandObserver && !isExtCommandWhite && !isExtCommandReferee) {
                        this.forward(this.m_black, cmd);
                    }
                    if (isExtCommandWhite && !isExtCommandObserver && !isExtCommandBlack && !isExtCommandReferee) {
                        this.forward(this.m_white, cmd);
                    }
                    if (isExtCommandReferee && !isExtCommandObserver && !isExtCommandBlack && !isExtCommandWhite) {
                        this.forward(this.m_referee, cmd);
                    }
                    if (isExtCommandObserver && !isExtCommandReferee && !isExtCommandBlack && !isExtCommandWhite) {
                        this.forward(this.m_observer, cmd);
                    }
                    if (!(isExtCommandReferee || isExtCommandBlack || isExtCommandObserver || isExtCommandWhite)) {
                        throw new GtpError("unknown command");
                    }
                    throw new GtpError("use gogui-twogtp-black/white/referee/observer");
                }
            }
        }
    }

    public void interruptCommand() {
        for (Program program : this.m_allPrograms) {
            program.interruptProgram();
        }
    }

    public void setDebugToComment(boolean enable) {
        this.m_black.setIOCallback(null);
        this.m_white.setIOCallback(null);
        this.m_debugToComment = enable;
        if (this.m_debugToComment) {
            this.m_black.setIOCallback(new GtpClient.IOCallback(){

                public void receivedInvalidResponse(String s) {
                }

                public void receivedResponse(boolean error, String s) {
                }

                public void receivedStdErr(String s) {
                    TwoGtp.this.appendDebugToCommentBuffer(GoColor.BLACK, s);
                }

                public void sentCommand(String s) {
                }
            });
            this.m_white.setIOCallback(new GtpClient.IOCallback(){

                public void receivedInvalidResponse(String s) {
                }

                public void receivedResponse(boolean error, String s) {
                }

                public void receivedStdErr(String s) {
                    TwoGtp.this.appendDebugToCommentBuffer(GoColor.WHITE, s);
                }

                public void sentCommand(String s) {
                }
            });
        }
    }

    public void setMaxMoves(int maxMoves) {
        this.m_maxMoves = maxMoves;
    }

    private synchronized void appendDebugToCommentBuffer(GoColor c, String s) {
        this.m_debugToCommentBuffer.get(c).append(s);
    }

    private void checkInconsistentState() throws GtpError {
        for (Program program : this.m_allPrograms) {
            if (!program.isOutOfSync()) continue;
            throw new GtpError("Inconsistent state");
        }
    }

    private synchronized void clearDebugToCommentBuffers() {
        this.m_debugToCommentBuffer.get(GoColor.BLACK).setLength(0);
        this.m_debugToCommentBuffer.get(GoColor.WHITE).setLength(0);
    }

    private void cmdBoardSize(GtpCommand cmd) throws GtpError {
        cmd.checkNuArg(1);
        int size = cmd.getIntArg(0, 1, 25);
        if (size != this.m_size) {
            throw new GtpError("Size must be " + this.m_size);
        }
    }

    private void cmdClearBoard(GtpCommand cmd) throws GtpError {
        cmd.checkArgNone();
        this.newGame(this.m_size);
    }

    private void cmdGenmove(GtpCommand cmd) throws GtpError {
        try {
            this.sendGenmove(cmd.getColorArg(), cmd.getResponse());
        }
        catch (ErrorMessage e) {
            throw new GtpError(e.getMessage());
        }
    }

    private void cmdPlay(GtpCommand cmd) throws GtpError {
        cmd.checkNuArg(2);
        this.checkInconsistentState();
        GoColor color = cmd.getColorArg(0);
        GoPoint point = cmd.getPointArg(1, this.m_size);
        Move move = Move.get(color, point);
        this.m_game.play(move);
        this.synchronize();
    }

    private void cmdUndo(GtpCommand cmd) throws GtpError {
        cmd.checkArgNone();
        int moveNumber = this.m_game.getMoveNumber();
        if (moveNumber == 0) {
            throw new GtpError("cannot undo");
        }
        this.m_game.gotoNode(this.getCurrentNode().getFatherConst());
        assert (this.m_game.getMoveNumber() == moveNumber - 1);
        this.synchronize();
    }

    private void finalStatusCommand(GtpCommand cmd) throws GtpError {
        this.checkInconsistentState();
        if (this.m_referee != null) {
            this.forward(this.m_referee, cmd);
        } else if (this.m_black.isSupported("final_status")) {
            this.forward(this.m_black, cmd);
        } else if (this.m_white.isSupported("final_status")) {
            this.forward(this.m_white, cmd);
        } else {
            throw new GtpError("neither player supports final_status");
        }
    }

    private void forward(Program program, GtpCommand cmd) throws GtpError {
        cmd.setResponse(program.send(cmd.getLine()));
    }

    private boolean gameOver() {
        return this.getBoard().bothPassed() || this.m_resigned;
    }

    private ConstBoard getBoard() {
        return this.m_game.getBoard();
    }

    private ConstNode getCurrentNode() {
        return this.m_game.getCurrentNode();
    }

    private synchronized String getDebugToCommentBuffer(GoColor color) {
        return this.m_debugToCommentBuffer.get(color).toString();
    }

    private GoColor getToMove() {
        return this.m_game.getToMove();
    }

    private ConstGameTree getTree() {
        return this.m_game.getTree();
    }

    private String getTitle() {
        StringBuilder buffer = new StringBuilder();
        String nameBlack = this.m_black.getLabel();
        String nameWhite = this.m_white.getLabel();
        if (this.isAlternated()) {
            String tmpName = nameBlack;
            nameBlack = nameWhite;
            nameWhite = tmpName;
        }
        buffer.append(nameWhite);
        buffer.append(" vs. ");
        buffer.append(nameBlack);
        buffer.append(" (B)");
        if (!this.m_filePrefix.equals("")) {
            buffer.append(" (");
            buffer.append(this.m_gameIndex + 1);
            buffer.append(')');
        }
        return buffer.toString();
    }

    private void handleEndOfGame(boolean error, String errorMessage) throws ErrorMessage {
        double realTimeWhite;
        double realTimeBlack;
        double cpuTimeWhite;
        double cpuTimeBlack;
        String resultReferee;
        String resultWhite;
        String resultBlack;
        block14: {
            if (this.m_resigned) {
                String result = this.m_resignColor == GoColor.BLACK ? "W" : "B";
                resultBlack = result = result + "+R";
                resultWhite = result;
                resultReferee = result;
            } else {
                resultBlack = this.m_black.getResult();
                resultWhite = this.m_white.getResult();
                resultReferee = "?";
                if (this.m_referee != null) {
                    resultReferee = this.m_referee.getResult();
                }
            }
            cpuTimeBlack = this.m_black.getAndClearCpuTime();
            cpuTimeWhite = this.m_white.getAndClearCpuTime();
            realTimeBlack = this.m_realTime.get(GoColor.BLACK);
            realTimeWhite = this.m_realTime.get(GoColor.WHITE);
            if (this.isAlternated()) {
                resultBlack = this.inverseResult(resultBlack);
                resultWhite = this.inverseResult(resultWhite);
                resultReferee = this.inverseResult(resultReferee);
                realTimeBlack = this.m_realTime.get(GoColor.WHITE);
                realTimeWhite = this.m_realTime.get(GoColor.BLACK);
            }
            if (this.m_black.isProgramDead() || this.m_white.isProgramDead()) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError();
                }
            }
        }
        String nameBlack = this.m_black.getLabel();
        String nameWhite = this.m_white.getLabel();
        String blackCommand = this.m_black.getProgramCommand();
        String whiteCommand = this.m_white.getProgramCommand();
        String blackVersion = this.m_black.getVersion();
        String whiteVersion = this.m_white.getVersion();
        if (this.isAlternated()) {
            nameBlack = this.m_white.getLabel();
            nameWhite = this.m_black.getLabel();
            blackCommand = this.m_white.getProgramCommand();
            whiteCommand = this.m_black.getProgramCommand();
            blackVersion = this.m_white.getVersion();
            whiteVersion = this.m_black.getVersion();
        }
        this.m_game.setPlayer(GoColor.BLACK, nameBlack);
        this.m_game.setPlayer(GoColor.WHITE, nameWhite);
        if (this.m_referee != null) {
            this.m_game.setResult(resultReferee);
        } else if (resultBlack.equals(resultWhite) && !resultBlack.equals("?")) {
            this.m_game.setResult(resultBlack);
        }
        String host = Platform.getHostInfo();
        StringBuilder comment = new StringBuilder();
        comment.append("Black command: ");
        comment.append(blackCommand);
        comment.append("\nWhite command: ");
        comment.append(whiteCommand);
        comment.append("\nBlack version: ");
        comment.append(blackVersion);
        comment.append("\nWhite version: ");
        comment.append(whiteVersion);
        if (this.m_openings != null) {
            comment.append("\nOpening: ");
            comment.append(this.m_openingFile);
        }
        comment.append("\nResult[Black]: ");
        comment.append(resultBlack);
        comment.append("\nResult[White]: ");
        comment.append(resultWhite);
        if (this.m_referee != null) {
            comment.append("\nReferee: ");
            comment.append(this.m_referee.getProgramCommand());
            comment.append("\nResult[Referee]: ");
            comment.append(resultReferee);
        }
        comment.append("\nHost: ");
        comment.append(host);
        comment.append("\nDate: ");
        comment.append(StringUtil.getDate());
        this.m_game.setComment(comment.toString(), this.getTree().getRootConst());
        int moveNumber = NodeUtil.getMoveNumber(this.getCurrentNode());
        if (this.m_resultFile != null) {
            this.m_resultFile.addResult(this.m_gameIndex, this.m_game, resultBlack, resultWhite, resultReferee, this.isAlternated(), moveNumber, error, errorMessage, realTimeBlack, realTimeWhite, cpuTimeBlack, cpuTimeWhite);
        }
    }

    private void initGame(int size) throws GtpError {
        this.m_game = new Game(size, this.m_komi, null, null, null);
        this.m_realTime.set(GoColor.BLACK, 0.0);
        this.m_realTime.set(GoColor.WHITE, 0.0);
        this.m_game.haltClock();
        this.m_resigned = false;
        if (this.m_openings != null) {
            int openingFileIndex = this.m_alternate ? this.m_gameIndex / 2 % this.m_openings.getNumber() : this.m_gameIndex % this.m_openings.getNumber();
            try {
                this.m_openings.loadFile(openingFileIndex);
            }
            catch (Exception e) {
                throw new GtpError(e.getMessage());
            }
            this.m_openingFile = this.m_openings.getFilename();
            if (this.m_verbose) {
                System.err.println("Loaded opening " + this.m_openingFile);
            }
            if (this.m_openings.getBoardSize() != size) {
                throw new GtpError("Wrong board size: " + this.m_openingFile);
            }
            this.m_game.init(this.m_openings.getTree());
            this.m_game.setKomi(this.m_komi);
            this.m_lastOpeningNode = NodeUtil.getLast(this.getTree().getRootConst());
        } else {
            this.m_lastOpeningNode = null;
        }
        this.synchronizeInit();
    }

    private String inverseResult(String result) {
        if (result.indexOf(66) >= 0) {
            return result.replaceAll("B", "W");
        }
        if (result.indexOf(87) >= 0) {
            return result.replaceAll("W", "B");
        }
        return result;
    }

    private boolean isAlternated() {
        return this.m_alternate && this.m_gameIndex % 2 != 0;
    }

    private boolean isInOpening() {
        if (this.m_lastOpeningNode == null) {
            return false;
        }
        for (ConstNode node = this.getCurrentNode().getChildConst(); node != null; node = node.getChildConst()) {
            if (node != this.m_lastOpeningNode) continue;
            return true;
        }
        return false;
    }

    private void komi(GtpCommand cmd) throws GtpError {
        String arg = cmd.getArg();
        try {
            Komi komi = Komi.parseKomi(arg);
            if (!ObjectUtil.equals(komi, this.m_komi)) {
                throw new GtpError("komi is fixed at " + this.m_komi);
            }
        }
        catch (InvalidKomiException e) {
            throw new GtpError("invalid komi: " + arg);
        }
    }

    private void newGame(int size) throws GtpError {
        if (this.m_resultFile != null) {
            this.m_gameIndex = this.m_resultFile.getNextGameIndex();
        } else {
            ++this.m_gameIndex;
            if (this.m_numberGames > 0 && this.m_gameIndex > this.m_numberGames) {
                this.m_gameIndex = -1;
            }
        }
        if (this.m_gameIndex == -1) {
            throw new GtpError("maximum number of games reached");
        }
        if (this.m_verbose) {
            System.err.println("============================================");
            System.err.println("Game " + this.m_gameIndex);
            System.err.println("============================================");
        }
        this.m_black.getAndClearCpuTime();
        this.m_white.getAndClearCpuTime();
        this.initGame(size);
        this.m_gameSaved = false;
        if (this.m_timeSettings != null) {
            this.sendIfSupported("time_settings", GtpUtil.getTimeSettingsCommand(this.m_timeSettings));
        }
    }

    private void sendGenmove(GoColor color, StringBuilder response) throws GtpError, ErrorMessage {
        this.checkInconsistentState();
        int moveNumber = this.m_game.getMoveNumber();
        if (this.m_maxMoves >= 0 && moveNumber > this.m_maxMoves) {
            throw new GtpError("move limit exceeded");
        }
        if (this.isInOpening()) {
            ConstNode child = this.getCurrentNode().getChildConst();
            Move move = child.getMove();
            if (move.getColor() != color) {
                throw new GtpError("next opening move is " + move);
            }
            this.m_game.gotoNode(child);
            this.synchronize();
            response.append(GoPoint.toString(move.getPoint()));
            return;
        }
        boolean exchangeColors = color == GoColor.BLACK && this.isAlternated() || color == GoColor.WHITE && !this.isAlternated();
        Program program = exchangeColors ? this.m_white : this.m_black;
        this.clearDebugToCommentBuffers();
        long timeMillis = System.currentTimeMillis();
        String responseGenmove = program.sendCommandGenmove(color);
        double time = (double)(System.currentTimeMillis() - timeMillis) / 1000.0;
        this.m_realTime.set(color, this.m_realTime.get(color) + time);
        if (responseGenmove.equalsIgnoreCase("resign")) {
            response.append("resign");
            this.m_resigned = true;
            this.m_resignColor = color;
        } else {
            ConstBoard board = this.getBoard();
            GoPoint point = null;
            try {
                point = GtpUtil.parsePoint(responseGenmove, board.getSize());
            }
            catch (GtpResponseFormatError e) {
                throw new GtpError(program.getLabel() + " played invalid move: " + responseGenmove);
            }
            Move move = Move.get(color, point);
            this.m_game.play(move);
            program.updateAfterGenmove(board);
            this.synchronize();
            response.append(GoPoint.toString(move.getPoint()));
            if (this.m_debugToComment) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.m_game.setComment(this.getDebugToCommentBuffer(color));
            }
        }
        if (this.gameOver() && !this.m_gameSaved) {
            this.handleEndOfGame(false, "");
            this.m_gameSaved = true;
        }
    }

    private void sendIfSupported(String cmd, String cmdLine) {
        for (Program program : this.m_allPrograms) {
            program.sendIfSupported(cmd, cmdLine);
        }
    }

    private void synchronize() throws GtpError {
        for (Program program : this.m_allPrograms) {
            program.synchronize(this.m_game);
        }
    }

    private void synchronizeInit() throws GtpError {
        for (Program program : this.m_allPrograms) {
            program.synchronizeInit(this.m_game);
        }
    }

    private void twogtpColor(Program program, GtpCommand cmd) throws GtpError {
        cmd.setResponse(program.send(cmd.getArgLine()));
    }

    private void twogtpObserver(GtpCommand cmd) throws GtpError {
        if (this.m_observer == null) {
            throw new GtpError("no observer enabled");
        }
        this.twogtpColor(this.m_observer, cmd);
    }

    private void twogtpReferee(GtpCommand cmd) throws GtpError {
        if (this.m_referee == null) {
            throw new GtpError("no referee enabled");
        }
        this.twogtpColor(this.m_referee, cmd);
    }
}

