/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.game;

import java.util.Timer;
import java.util.TimerTask;
import net.sf.gogui.game.ConstClock;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.BlackWhiteSet;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.util.StringUtil;

public final class Clock
implements ConstClock {
    private boolean m_isRunning = false;
    private long m_startTime;
    private GoColor m_toMove;
    private final BlackWhiteSet<TimeRecord> m_timeRecord = new BlackWhiteSet<TimeRecord>(new TimeRecord(), new TimeRecord());
    private TimeSettings m_timeSettings;
    private Listener m_listener;
    private Timer m_timer;
    private final TimeSource m_timeSource;

    public Clock() {
        this(new SystemTimeSource());
    }

    public Clock(TimeSource timeSource) {
        this.m_timeSource = timeSource;
        this.reset();
    }

    public int getMovesLeft(GoColor color) {
        assert (this.getUseByoyomi() && this.isInByoyomi(color));
        return this.getRecord((GoColor)color).m_movesLeft;
    }

    public long getTimeLeft(GoColor color) {
        assert (this.isInitialized());
        TimeRecord record = this.getRecord(color);
        long time = record.m_time;
        if (this.getUseByoyomi() && this.isInByoyomi(color)) {
            return this.getByoyomi() - time;
        }
        return this.getPreByoyomi() - time;
    }

    public TimeSettings getTimeSettings() {
        return this.m_timeSettings;
    }

    public String getTimeString(GoColor color) {
        assert (color.isBlackWhite());
        TimeRecord record = this.getRecord(color);
        long time = record.m_time;
        if (color.equals((Object)this.m_toMove)) {
            time += this.currentTimeMillis() - this.m_startTime;
        }
        if (this.isInitialized()) {
            time = record.m_isInByoyomi ? this.getByoyomi() - time : this.getPreByoyomi() - time;
        }
        int movesLeft = -1;
        if (this.isInitialized() && record.m_isInByoyomi) {
            movesLeft = record.m_movesLeft;
        }
        return Clock.getTimeString(time /= 1000L, movesLeft);
    }

    public static String getTimeString(double timeLeft, int movesLeft) {
        StringBuilder buffer = new StringBuilder(8);
        buffer.append(StringUtil.formatTime((long)timeLeft));
        if (movesLeft >= 0) {
            buffer.append('/');
            buffer.append(movesLeft);
        }
        return buffer.toString();
    }

    public GoColor getToMove() {
        return this.m_toMove;
    }

    public boolean getUseByoyomi() {
        return this.m_timeSettings.getUseByoyomi();
    }

    public void halt() {
        if (!this.m_isRunning) {
            return;
        }
        TimeRecord record = this.getRecord(this.m_toMove);
        long currentTime = this.currentTimeMillis();
        long time = currentTime - this.m_startTime;
        this.m_startTime = currentTime;
        record.m_time += time;
        this.m_isRunning = false;
        this.updateListener();
        this.stopTimer();
    }

    public boolean isInitialized() {
        return this.m_timeSettings != null;
    }

    public boolean isInByoyomi(GoColor color) {
        return this.getUseByoyomi() && this.getRecord((GoColor)color).m_isInByoyomi;
    }

    public boolean isRunning() {
        return this.m_isRunning;
    }

    public boolean lostOnTime(GoColor color) {
        if (!this.isInitialized()) {
            return false;
        }
        TimeRecord record = this.getRecord(color);
        long time = record.m_time;
        if (this.getUseByoyomi()) {
            return record.m_byoyomiExceeded;
        }
        return time > this.getPreByoyomi();
    }

    public static long parseTimeString(String s) {
        String[] a = s.split(":");
        if (a.length == 0 || a.length > 3) {
            return -1L;
        }
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        try {
            if (a.length == 3) {
                hours = Integer.parseInt(a[0]);
                minutes = Integer.parseInt(a[1]);
                seconds = Integer.parseInt(a[2]);
            } else if (a.length == 2) {
                minutes = Integer.parseInt(a[0]);
                seconds = Integer.parseInt(a[1]);
            } else {
                assert (a.length == 1);
                seconds = Integer.parseInt(a[0]);
            }
        }
        catch (NumberFormatException e) {
            return -1L;
        }
        if (minutes < 0 || minutes > 60 || seconds < 0 || seconds > 60) {
            return -1L;
        }
        return 1000L * ((long)seconds + (long)minutes * 60L + (long)hours * 3600L);
    }

    public void reset() {
        this.reset(GoColor.BLACK);
        this.reset(GoColor.WHITE);
        this.m_toMove = null;
        this.m_isRunning = false;
        this.updateListener();
    }

    public void reset(GoColor color) {
        TimeRecord timeRecord = this.getRecord(color);
        timeRecord.m_time = 0L;
        timeRecord.m_movesLeft = 0;
        timeRecord.m_isInByoyomi = false;
        timeRecord.m_byoyomiExceeded = false;
        if (this.isInitialized() && this.getPreByoyomi() == 0L) {
            assert (this.getByoyomiMoves() > 0);
            timeRecord.m_movesLeft = this.getByoyomiMoves();
            timeRecord.m_isInByoyomi = true;
        }
        this.updateListener();
    }

    public void resume() {
        if (this.m_isRunning) {
            return;
        }
        assert (this.m_toMove != null);
        this.m_startTime = this.currentTimeMillis();
        this.m_isRunning = true;
        this.startTimer();
    }

    public void setListener(Listener listener) {
        this.m_listener = listener;
    }

    public void setTimeSettings(TimeSettings settings) {
        this.m_timeSettings = settings;
    }

    public void setTimeLeft(GoColor color, long time, int movesLeft) {
        this.halt();
        boolean isInByoyomi = movesLeft >= 0;
        TimeRecord record = this.getRecord(color);
        if (isInByoyomi) {
            if (!this.m_timeSettings.getUseByoyomi()) {
                return;
            }
            record.m_isInByoyomi = isInByoyomi;
            record.m_time = this.getByoyomi() - time;
            record.m_movesLeft = movesLeft;
            record.m_byoyomiExceeded = time > 0L;
        } else {
            record.m_time = this.getPreByoyomi() - time;
            record.m_movesLeft = -1;
            record.m_byoyomiExceeded = false;
        }
        if (this.m_toMove != null) {
            this.startMove(this.m_toMove);
        }
        this.updateListener();
    }

    public void startMove(GoColor color) {
        assert (color.isBlackWhite());
        this.m_toMove = color;
        this.m_isRunning = true;
        this.m_startTime = this.currentTimeMillis();
        this.startTimer();
    }

    public void stopMove() {
        if (!this.m_isRunning) {
            return;
        }
        TimeRecord record = this.getRecord(this.m_toMove);
        long time = this.currentTimeMillis() - this.m_startTime;
        record.m_time += time;
        if (this.isInitialized() && this.getUseByoyomi()) {
            if (!record.m_isInByoyomi && record.m_time > this.getPreByoyomi()) {
                record.m_isInByoyomi = true;
                record.m_time -= this.getPreByoyomi();
                assert (this.getByoyomiMoves() > 0);
                record.m_movesLeft = this.getByoyomiMoves();
            }
            if (record.m_isInByoyomi) {
                if (record.m_time > this.getByoyomi()) {
                    record.m_byoyomiExceeded = true;
                }
                assert (record.m_movesLeft > 0);
                --record.m_movesLeft;
                if (record.m_movesLeft == 0) {
                    record.m_time = 0L;
                    assert (this.getByoyomiMoves() > 0);
                    record.m_movesLeft = this.getByoyomiMoves();
                }
            }
        }
        this.m_toMove = null;
        this.m_isRunning = false;
        this.updateListener();
    }

    private long currentTimeMillis() {
        return this.m_timeSource.currentTimeMillis();
    }

    private TimeRecord getRecord(GoColor c) {
        return this.m_timeRecord.get(c);
    }

    private long getByoyomi() {
        return this.m_timeSettings.getByoyomi();
    }

    private int getByoyomiMoves() {
        return this.m_timeSettings.getByoyomiMoves();
    }

    private long getPreByoyomi() {
        return this.m_timeSettings.getPreByoyomi();
    }

    private void startTimer() {
        if (this.m_timer == null && this.m_listener != null) {
            this.m_timer = new Timer();
            TimerTask task = new TimerTask(){

                public void run() {
                    Clock.this.updateListener();
                }
            };
            this.m_timer.scheduleAtFixedRate(task, 1000L, 1000L);
        }
    }

    private void stopTimer() {
        if (this.m_timer != null) {
            this.m_timer.cancel();
            this.m_timer = null;
        }
    }

    private void updateListener() {
        if (this.m_listener != null) {
            this.m_listener.clockChanged();
        }
    }

    private static class TimeRecord {
        public boolean m_isInByoyomi;
        public boolean m_byoyomiExceeded;
        public int m_movesLeft;
        public long m_time;

        private TimeRecord() {
        }
    }

    public static interface Listener {
        public void clockChanged();
    }

    public static final class SystemTimeSource
    implements TimeSource {
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    }

    public static interface TimeSource {
        public long currentTimeMillis();
    }
}

