/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.go;

import net.sf.gogui.go.Board;
import net.sf.gogui.go.ConstBoard;
import net.sf.gogui.go.ConstPointList;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;

public final class BoardUtil {
    public static final int NUMBER_ROTATIONS = 8;

    public static void copy(Board target, ConstBoard source) {
        target.init(source.getSize());
        ConstPointList setupBlack = source.getSetup(GoColor.BLACK);
        ConstPointList setupWhite = source.getSetup(GoColor.WHITE);
        GoColor setupPlayer = source.getSetupPlayer();
        if (setupBlack.size() > 0 || setupWhite.size() > 0) {
            if (source.isSetupHandicap()) {
                target.setupHandicap(setupBlack);
            } else {
                target.setup(setupBlack, setupWhite, setupPlayer);
            }
        }
        for (int i = 0; i < source.getNumberMoves(); ++i) {
            target.play(source.getMove(i));
        }
    }

    public static String toString(ConstBoard board) {
        return BoardUtil.toString(board, true, false);
    }

    public static String toString(ConstBoard board, boolean withGameInfo, boolean color) {
        StringBuilder s = new StringBuilder(1024);
        int size = board.getSize();
        String separator = System.getProperty("line.separator");
        assert (separator != null);
        BoardUtil.printXCoords(size, s, separator);
        String ansiStart = "\u001b[";
        for (int y = size - 1; y >= 0; --y) {
            BoardUtil.printYCoord(y, s, true);
            s.append(' ');
            for (int x = 0; x < size; ++x) {
                GoPoint point;
                GoColor c;
                if (x > 0) {
                    if (color) {
                        s.append(ansiStart);
                        s.append("43m");
                    }
                    s.append(' ');
                }
                if ((c = board.getColor(point = GoPoint.get(x, y))) == GoColor.BLACK) {
                    if (color) {
                        s.append(ansiStart);
                        s.append("0;30;43m");
                    }
                    s.append('X');
                    continue;
                }
                if (c == GoColor.WHITE) {
                    if (color) {
                        s.append(ansiStart);
                        s.append("1;37;43m");
                    }
                    s.append('O');
                    continue;
                }
                if (color) {
                    s.append(ansiStart);
                    s.append("1;30;43m");
                }
                if (board.isHandicap(point)) {
                    s.append('+');
                    continue;
                }
                s.append('.');
            }
            if (color) {
                s.append(ansiStart);
                s.append("0m");
            }
            s.append(' ');
            BoardUtil.printYCoord(y, s, false);
            if (withGameInfo) {
                BoardUtil.printGameInfo(board, s, y);
            }
            s.append(separator);
        }
        BoardUtil.printXCoords(size, s, separator);
        if (!withGameInfo) {
            BoardUtil.printToMove(board, s);
            s.append(separator);
        }
        return s.toString();
    }

    public static GoPoint rotate(int rotationMode, GoPoint point, int size) {
        assert (rotationMode < 8);
        if (point == null) {
            return null;
        }
        int x = point.getX();
        int y = point.getY();
        switch (rotationMode) {
            case 0: {
                return GoPoint.get(x, y);
            }
            case 1: {
                return GoPoint.get(size - x - 1, y);
            }
            case 2: {
                return GoPoint.get(x, size - y - 1);
            }
            case 3: {
                return GoPoint.get(y, x);
            }
            case 4: {
                return GoPoint.get(size - y - 1, x);
            }
            case 5: {
                return GoPoint.get(y, size - x - 1);
            }
            case 6: {
                return GoPoint.get(size - x - 1, size - y - 1);
            }
            case 7: {
                return GoPoint.get(size - y - 1, size - x - 1);
            }
        }
        return GoPoint.get(x, y);
    }

    private BoardUtil() {
    }

    private static void printGameInfo(ConstBoard board, StringBuilder s, int yIndex) {
        int moveNumber;
        int size = board.getSize();
        if (yIndex == size - 1) {
            s.append("  ");
            BoardUtil.printToMove(board, s);
        } else if (yIndex == size - 2) {
            s.append("  Prisoners: B ");
            s.append(board.getCaptured(GoColor.BLACK));
            s.append("  W ");
            s.append(board.getCaptured(GoColor.WHITE));
        } else if (yIndex <= size - 4 && (moveNumber = board.getNumberMoves() - yIndex - 1) >= 0) {
            s.append("  ");
            s.append(moveNumber + 1);
            s.append(' ');
            s.append(board.getMove(moveNumber));
        }
    }

    private static void printToMove(ConstBoard board, StringBuilder buffer) {
        buffer.append(board.getToMove().getCapitalizedName());
        buffer.append(" to play");
    }

    private static void printXCoords(int size, StringBuilder s, String separator) {
        s.append("   ");
        int x = 0;
        char c = 'A';
        while (x < size) {
            if (c == 'I') {
                c = (char)(c + 1);
            }
            s.append(c);
            s.append(' ');
            ++x;
            c = (char)(c + '\u0001');
        }
        s.append(separator);
    }

    private static void printYCoord(int y, StringBuilder s, boolean alignRight) {
        String string = Integer.toString(y + 1);
        if (alignRight && string.length() == 1) {
            s.append(' ');
        }
        s.append(string);
        if (!alignRight && string.length() == 1) {
            s.append(' ');
        }
    }
}

