/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtp;

import java.util.Locale;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.InvalidPointException;
import net.sf.gogui.go.PointList;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.util.StringUtil;

public class GtpCommand {
    private boolean m_hasId;
    private int m_id;
    private String m_line;
    private final String m_command;
    private final String[] m_arg;
    private final StringBuilder m_response;

    public GtpCommand(String line) {
        StringBuilder buffer = GtpCommand.preprocessLine(line);
        assert (!line.trim().equals(""));
        String[] array = StringUtil.splitArguments(buffer.toString());
        assert (array.length > 0);
        int commandIndex = 0;
        try {
            this.m_id = Integer.parseInt(array[0]);
            this.m_hasId = true;
            this.m_line = buffer.substring(array[0].length()).trim();
            commandIndex = 1;
        }
        catch (NumberFormatException e) {
            this.m_hasId = false;
            this.m_id = -1;
            this.m_line = buffer.toString();
        }
        this.m_response = new StringBuilder();
        if (commandIndex >= array.length) {
            this.m_command = "";
            this.m_arg = null;
            return;
        }
        this.m_command = array[commandIndex];
        int nuArg = array.length - commandIndex - 1;
        this.m_arg = new String[nuArg];
        for (int i = 0; i < nuArg; ++i) {
            this.m_arg[i] = array[commandIndex + i + 1];
        }
    }

    public void checkArgNone() throws GtpError {
        this.checkNuArg(0);
    }

    public void checkNuArg(int n) throws GtpError {
        if (this.getNuArg() != n) {
            if (n == 0) {
                throw new GtpError("no arguments allowed");
            }
            if (n == 1) {
                throw new GtpError("need argument");
            }
            throw new GtpError("need " + n + " arguments");
        }
    }

    public void checkNuArgLessEqual(int n) throws GtpError {
        if (this.getNuArg() > n) {
            throw new GtpError("too many arguments");
        }
    }

    public boolean hasId() {
        return this.m_hasId;
    }

    public String getArg() throws GtpError {
        this.checkNuArg(1);
        return this.getArg(0);
    }

    public String getArg(int i) throws GtpError {
        if (i >= this.getNuArg()) {
            throw new GtpError("missing argument " + (i + 1));
        }
        return this.m_arg[i];
    }

    public String getArgLine() {
        int pos = this.m_line.indexOf(this.m_command) + this.m_command.length();
        return this.m_line.substring(pos).trim();
    }

    public GoColor getColorArg() throws GtpError {
        this.checkNuArg(1);
        return this.getColorArg(0);
    }

    public GoColor getColorArg(int i) throws GtpError {
        String arg = this.getArg(i).toLowerCase(Locale.ENGLISH);
        if (arg.equals("b") || arg.equals("black")) {
            return GoColor.BLACK;
        }
        if (arg.equals("w") || arg.equals("white")) {
            return GoColor.WHITE;
        }
        throw new GtpError("argument " + (i + 1) + " must be black or white");
    }

    public String getCommand() {
        return this.m_command;
    }

    public double getDoubleArg() throws GtpError {
        this.checkNuArg(1);
        return this.getDoubleArg(0);
    }

    public double getDoubleArg(int i) throws GtpError {
        String arg = this.getArg(i);
        try {
            return Double.parseDouble(arg);
        }
        catch (NumberFormatException e) {
            throw new GtpError("argument " + (i + 1) + " must be float");
        }
    }

    public int getIntArg() throws GtpError {
        this.checkNuArg(1);
        return this.getIntArg(0);
    }

    public int getIntArg(int i) throws GtpError {
        String arg = this.getArg(i);
        try {
            return Integer.parseInt(arg);
        }
        catch (NumberFormatException e) {
            throw new GtpError("argument " + (i + 1) + " must be integer");
        }
    }

    public int getIntArg(int i, int min, int max) throws GtpError {
        int n = this.getIntArg(i);
        if (n < min) {
            throw new GtpError("argument " + (i + 1) + " must be greater/equal " + min);
        }
        if (n > max) {
            throw new GtpError("argument " + (i + 1) + " must be less/equal " + max);
        }
        return n;
    }

    public GoPoint getPointArg(int i, int boardSize) throws GtpError {
        try {
            return GoPoint.parsePoint(this.getArg(i), boardSize);
        }
        catch (InvalidPointException e) {
            throw new GtpError("argument " + (i + 1) + " is not a point");
        }
    }

    public PointList getPointListArg(int boardSize) throws GtpError {
        PointList pointList = new PointList();
        for (int i = 0; i < this.getNuArg(); ++i) {
            pointList.add(this.getPointArg(i, boardSize));
        }
        return pointList;
    }

    public String getLine() {
        return this.m_line;
    }

    public int getNuArg() {
        return this.m_arg.length;
    }

    public StringBuilder getResponse() {
        return this.m_response;
    }

    public int getId() {
        return this.m_id;
    }

    public boolean isQuit() {
        return this.m_line.trim().equals("quit");
    }

    public void setResponse(String response) {
        this.m_response.setLength(0);
        this.m_response.append(response);
    }

    private static StringBuilder preprocessLine(String line) {
        char c;
        int len = line.length();
        StringBuilder buffer = new StringBuilder(len);
        boolean wasLastSpace = false;
        for (int i = 0; i < len && (c = line.charAt(i)) != '#'; ++i) {
            if (Character.isISOControl(c)) continue;
            if (Character.isWhitespace(c)) {
                if (wasLastSpace) continue;
                buffer.append(' ');
                wasLastSpace = true;
                continue;
            }
            buffer.append(c);
            wasLastSpace = false;
        }
        return buffer;
    }
}

